<?php

use App\Http\Controllers\AddonController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\User\CartController;
use Illuminate\Support\Facades\Route;
use Modules\GlobalSetting\app\Http\Controllers\LanguageController;
use Modules\GlobalSetting\app\Http\Controllers\DbbackupController;
use App\Http\Controllers\AdminLoginController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BillingAddressController;
use App\Http\Controllers\BookController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\ProviderController;
use App\Http\Controllers\StaffController;
use Illuminate\Http\Request;
use Modules\Page\app\Http\Controllers\Api\PageController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\MollieController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\SocialiteController;
use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Auth;
use Modules\Categories\app\Http\Controllers\CategoriesController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ReviewController;
use Illuminate\Support\Facades\Artisan;
use Modules\GlobalSetting\app\Http\Controllers\SocialLinkController;
use App\Http\Controllers\ProviderSocialLinkController;
use Modules\GlobalSetting\app\Http\Controllers\admin\SocialMediaShareController;
use Modules\Shops\app\Http\Controllers\ShopsController;
use App\Http\Controllers\TranslationController;
use App\Http\Controllers\FrontendShopController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ProviderEarningController;
use App\Http\Controllers\WishlistController;

Route::group(['middleware' => 'setlocale'], function () {

    Route::get('/storage-link', function () {
        Artisan::call('storage:link');
        return redirect()->route('home');
    })->name('storage-link');

    Route::get('/storage-linkadmin', function () {
        Artisan::call('storage:link');
        return redirect()->route('login');
    })->name('storage-linkadmin');

    Route::get('db_backup', function () {

        Artisan::call('backup:run');

        dd("Backup done 1");
    });

    Route::get('/clear-cache', function () {
        clearCache();
        return "Cache cleared";
    });

    Route::group(['prefix' => 'user'], function () {
        Route::get('/login', [UserController::class, 'userLogin'])->name('userlogin');
        Route::get('/register', [UserController::class, 'userRegister'])->name('userregister');
        Route::get('/forgot-password', [UserController::class, 'userForgotPassword'])->name('userforgotpassword');
        Route::post('/userregister', [AuthController::class, 'register'])->name('userregister');
        Route::post('/booking/dispute', [BookingController::class, 'requestDispute'])->name('user.requestDispute');
    });
    Route::post('/validate-email', [UserController::class, 'validateEmail']);

    Route::get('auth/redirect/{provider}', [SocialiteController::class, 'redirectToProvider'])->name('auth.redirect');
    Route::get('auth/{provider}-callback', [SocialiteController::class, 'handleProviderCallback'])->name('auth.callback');
    Route::get('auth/{provider}/callback', [SocialiteController::class, 'handleProviderCallback']);

    Route::get('admin/login', function (Request $request) {
        if (Auth::check() && (Auth::user()->user_type == 1 || Auth::user()->user_type == 5)) {
            return redirect()->route('admin.dashboard');
        }
        return view('admin.login');
    })->name('login');

    Route::get('admin', function () {
        if (Auth::check() && (Auth::user()->user_type == 1 || Auth::user()->user_type == 5)) {
            return redirect()->route('admin.dashboard');
        }
        return view('admin.login');
    })->name('adminlogin');

    Route::post('/admin/login-process', [AdminLoginController::class, 'login']);
    Route::get('/admin/logout', [AdminLoginController::class, 'logout'])->name('admin.logout');

    Route::group(['prefix' => 'admin', 'middleware' => ['admin.auth', 'permission']], function () {
        Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
        Route::get('/setting/payment-settings', function () {
            return view('admin.payment-settings');
        })->name('admin.payment-settings');

        Route::get('/services', function () {
            return view('admin.services');
        })->name('admin.services');

        Route::get('/product', function () {
            return view('admin.product');
        })->name('admin.product');

        Route::get('/shops', function () {
            return view('admin.shops');
        })->name('admin.shops');

        Route::get('/addservice', [ServiceController::class, 'index'])->name('admin.addservice');

        Route::get('/addproduct', function () {
            return view('admin.addproduct');
        })->name('admin.addproduct');

        Route::get('/shops/{slug}', [ServiceController::class, 'showShopDetails'])->name('admin.shops.show');

        Route::get('/editservice/{id}', [ServiceController::class, 'editservice'])->name('editservice');
        Route::get('/setting/listwords/{id}', [LanguageController::class, 'listkeywords'])->name('listkeywords');

        Route::post('/savelangword', [LanguageController::class, 'savelangword'])->name('savelangword');
        Route::post('/savedbbackup', [DbbackupController::class, 'savelanguage'])->name('savedbbackup');
        Route::get('/setting/dbdownload/{id}', [DbbackupController::class, 'listkeywords'])->name('dbdownload');

        Route::get('/setting/language-settings', [LanguageController::class, 'languageSettings'])->name('admin.language-settings');

        Route::get('/setting/dbbackuplist', function () {
            return view('admin.db-settings');
        })->name('admin.db-settings');

        Route::get('/content/how-it-work', function () {
            return view('admin.how-it-work');
        })->name('admin.how-it-work');

        Route::get('/categories', function () {
            return view('admin.categories-settings');
        })->name('admin.categories');

        Route::get('/service/categories', [CategoriesController::class, 'servicecategories'])->name('admin.servicecategories');
        Route::get('/product/categories', [CategoriesController::class, 'productcategories'])->name('admin.productcategories');
        Route::get('/service/subcategories', [CategoriesController::class, 'serviceSubcategories'])->name('admin.servicesubcategories');
        Route::get('/product/subcategories', [CategoriesController::class, 'productSubcategories'])->name('admin.productsubcategories');
        Route::get('/form-categories', [AdminDashboardController::class, 'showFormCategories'])->name('admin.form-categories');
        Route::get('/setting/credential-settings', function () {
            return view('admin.credential-settings');
        })->name('admin.credential-settings');

        Route::get('/setting/subscription-package', function () {
            return view('admin.subscription-package');
        })->name('admin.subscription-package');

        Route::get('/content/faq', function () {
            return view('admin.faq-setting');
        })->name('admin.faq');

        Route::get('/transaction', function () {
            return view('admin.transaction');
        })->name('admin.transaction');

        Route::post('/bookings/update-payment-status', [TransactionCOntroller::class, 'updatePaymentStatus'])
        ->name('bookings.updatePaymentStatus');

        Route::get('/providertransaction', function () {
            return view('admin.providertransaction');
        })->name('admin.providertransaction');

        Route::get('/provider-payout', function () {
            return view('admin.providerrequest');
        })->name('admin.providerrequest');

        Route::get('/request-dispute', function () {
            return view('admin.request_dispute');
        })->name('admin.request.dispute');

        Route::get('/calendar',  [BookingController::class, 'calenderview'])->name('admin.calendar');

        Route::get('/reviews', function () {
            return view('admin.review_list');
        })->name('admin.reviews');

        Route::get('/staffs',  [StaffController::class, 'adminStaff'])->name('admin.staffs');

        Route::get('/setting/file-storage', function () {
            return view('admin.file-storage');
        })->name('admin.file-storage');

        Route::get('/addon-modules', function () {
            return view('admin.addon_modules_list');
        })->name('admin.addons');

        //social links
        Route::get('social-links', [SocialLinkController::class, 'socialLinks'])->name('admin.social-links');
        Route::post('store-social-link', [SocialLinkController::class, 'storeSocialLinks'])->name('admin.store-social-link');
        Route::post('get_social_links', [SocialLinkController::class, 'getSocialLinks'])->name('admin.get_social_links');
        Route::get('get_social_link/{id}', [SocialLinkController::class, 'getSocialLink'])->name('admin.get_social_link');
        Route::post('delete-social-link', [SocialLinkController::class, 'deleteSocialLink'])->name('admin.delete-social-link');

        // SocialMedia Share
        Route::get('social-media-shares', [SocialMediaShareController::class, 'index'])->name('admin.social-media-shares');
        Route::post('store-social-media-share', [SocialMediaShareController::class, 'store'])->name('admin.store-social-media-share');
        Route::post('get-social-media-shares', [SocialMediaShareController::class, 'getList'])->name('admin.get-social-media-shares');
        Route::get('get-social-media-share/{id}', [SocialMediaShareController::class, 'show'])->name('admin.get-social-media-share');
        Route::post('delete-social-media-share', [SocialMediaShareController::class, 'destroy'])->name('admin.delete-social-media-share');
    });

    Route::post('admin/set-category-id', function (Request $request) {
        $request->session()->put('category_id', $request->input('category_id'));
        return response()->json(['success' => true]);
    })->name('set.category.id');

    Route::group(['middleware' => ['auc']], function () {
        Route::get('/customer/dashboard', [CustomerController::class, 'index'])->name('user.dashboard');
        Route::get('/customer/myorders/products', [CustomerController::class, 'product_orders'])->name('customer.myorders.products');
        Route::get('/customer/myorders/product_order_list', [CustomerController::class, 'getOrders'])->name('myorders.order_list');
        Route::get('/customer/products/order-invoice/{order}', [CustomerController::class, 'showInvoice'])->name('customer.invoice.details');
        Route::get('/customer/invoice/download/{order}', [CustomerController::class, 'downloadInvoice'])->name('customer.invoice.download');
        //Cutomer Service Upcomming
        Route::get('/customer/booking/upcoming', [CustomerController::class, 'customerBookingUpcoming'])->name("customer.booking.upcoming");
        Route::post('/customer-booking-upcoming-list', [CustomerController::class, 'customerBookingUpcomingList'])->name("customer.booking.upcoming.list");
        Route::post('/customer-booking-upcoming-cancel', [CustomerController::class, 'customerBookingUpcomingCancel'])->name("customer.booking.upcoming.cancel");
        Route::post('/customer-booking-upcoming-refund', [CustomerController::class, 'customerBookingStatusRefund'])->name("customer.booking.upcoming.refund");
        //Cutomer Service Completed
        Route::get('/customer/booking/completed', [CustomerController::class, 'customerBookingCompleted'])->name("customer.booking.completed");
        Route::post('/customer-booking-completed-list', [CustomerController::class, 'customerBookingCompletedList'])->name("customer.booking.completed.list");
        //Cutomer Service Cancelled
        Route::get('/customer/booking/cancelled', [CustomerController::class, 'customerBookingCancelled'])->name("customer.booking.cancelled");
        Route::post('/customer-booking-cancelled-list', [CustomerController::class, 'customerBookingCancelledList'])->name("customer.booking.cancelled.list");
        Route::get('/customer/wishlist', [WishlistController::class, 'index'])->name('customer.wishlist');
        Route::get('/customer/wishlist/load', [WishlistController::class, 'load'])->name('customer.wishlist.load');
        // Wishlist
        Route::post('/wishlist/toggle', [WishlistController::class, 'toggle'])->name('wishlist.toggle');
        Route::delete('/customer/wishlist/clear', [WishlistController::class, 'clear'])->name('wishlist.clear');
        // Wallet
        Route::get('/customer/wallet', [WalletController::class, 'index'])->name('customer.wallet');
        Route::post('/customer/dashboard/transaction-report', [CustomerController::class, 'getStats'])->name('dashboard.stats');
        Route::get('/customer/myorders/delivery-tracking', [CustomerController::class, 'delivery_tracker'])->name('customer.myorders.delivery-tracking');
        Route::get('/customer/myorders/delivery_track_list', [CustomerController::class, 'getDeliveryTrack'])->name('customer.myorders.delivery_track_list');
        Route::get('/customer/myorders/delivery-tracking-detail/{id}', [CustomerController::class, 'viewDeliveryTrackDetail'])->name('customer.myorders.delivery_track_detail');
        Route::post('/customer/order/cancel', [CustomerController::class, 'cancelCustomerOrder'])->name('customer.order.cancel');
        Route::post('/customer/order/refund_initiate', [CustomerController::class, 'refundCancelCustomerOrder'])->name('customer.order.cancel');
        Route::get('/customer/invoice-list', [CustomerController::class, 'order_invoice_list'])->name('customer.order_invoice_list');
        Route::get('/customer/invoice_detail_list', [CustomerController::class, 'invoice_detail_list'])->name('customer.invoice_detail_list');
        Route::get('/customer/delete-account', [CustomerController::class, 'deleteAccount'])->name('customer.delete-account');
        //Customer Billing Address
        Route::get('/customer/billing-address', [BillingAddressController::class, 'index'])->name("customer.billing-address");
        Route::prefix('customer/billing-address')->group(function () {
            Route::post('/store', [BillingAddressController::class, 'store'])->name('store.billing-address');
            Route::get('/list', [BillingAddressController::class, 'list'])->name('list.billing-address');
            Route::get('/edit/{id}', [BillingAddressController::class, 'edit'])->name('edit.billing-address');
            Route::post('/delete', [BillingAddressController::class, 'delete'])->name('delete.billing-address');
            Route::post('/set-default', [BillingAddressController::class, 'setDefault'])->name('set-default.billing-address');
        });
        // Customer Review
        Route::get('/customer/reviews', [CustomerController::class, 'reviews'])->name('customer.reviews');
        Route::post('/customer/store-review', [ReviewController::class, 'storeCustomerReview'])->name('customer.review.store');
        Route::post('/customer/store-reply-review', [ReviewController::class, 'storeCustomerReply'])->name('customer.review.reply.store');
        Route::get('/customer/reviews-list', [ReviewController::class, 'customerReviewsList'])->name('customer.reviews.list');
        Route::post('/customer/delete-review', [ReviewController::class, 'deleteReview'])->name('customer.review.delete');
        // Customer Account Settings
        Route::get('/customer/account-settings', [CustomerController::class, 'accountSettings'])->name('customer.account-settings');
        Route::post('/customer/save-account-settings', [CustomerController::class, 'saveAccountSettings'])->name('customer.save-account-settings');
        Route::post('/customer/account-settings-default-status', [CustomerController::class, 'accountSettingsDefaultStatus'])->name('customer.account-settings-default-status');
    });

    Route::group(['middleware' => 'provider'], function () {
        //Vendor Product List
        Route::get('/vendor-booking-list', [CustomerController::class, 'vedorBookingList'])->name("vendor.booking.list");
        Route::get('/vendor-booking-list/data', [CustomerController::class, 'fetchVendorBookingsData'])->name('vendor.booking.list.data');
        Route::post('/vendor-booking/update-status/{bookingProduct}', [CustomerController::class, 'updateBookingProductStatus'])->name('vendor.booking.product.update_status');
        //Vendor Service List
        Route::get('/vendor/service-bookings', action: [CustomerController::class, 'indexService'])->name('vendor.service.index');
        Route::get('/vendor/service-bookings/data', [CustomerController::class, 'fetchData'])->name(name: 'vendor.service.data');
        Route::post('/vendor/service-bookings/update-status/{booking}', [CustomerController::class, 'updateStatus'])->name('vendor.service.update-status');

        // Social Links
        Route::get('/provider/social-links', [ProviderSocialLinkController::class, 'providerSocialLinkIndex'])
            ->name('provider.sociallinks.index');
        Route::get('/provider/get/social-links', [ProviderSocialLinkController::class, 'getSocialLinks'])
            ->name('provider.sociallinks.getSocialLinks');
        Route::post('/provider/social-links', [ProviderSocialLinkController::class, 'store'])
            ->name('provider.sociallinks.store');
        Route::put('/provider/social-links/{providerSocialLink}', [ProviderSocialLinkController::class, 'update'])
            ->name('provider.sociallinks.update');
        Route::delete('/provider/social-links/{providerSocialLink}', [ProviderSocialLinkController::class, 'destroy'])
            ->name('provider.sociallinks.destroy');
        Route::patch('/provider/social-links/{providerSocialLink}/toggle-status', [ProviderSocialLinkController::class, 'toggleStatus'])
            ->name('provider.sociallinks.toggle-status');
        Route::post('/provider/social-links/bulk-update', [ProviderSocialLinkController::class, 'bulkUpdate'])
            ->name('provider.sociallinks.bulkUpdate');
    });

    Route::get('/customer/products/get-booking-details', [CustomerController::class, 'getBookingDetails'])->name('get-booking-details');
    Route::get('/customer/products/get-order-details', [CustomerController::class, 'getOrderDetails'])->name('get-order-details');

    Route::get('/reviews/list', [ReviewController::class, 'frontendReviewsList'])->name('reviews.list');
    Route::get('/products', [ServiceController::class, 'productlist'])->name('allproducts');
    Route::get('/services', [ServiceController::class, 'servicelist'])->name('servicelists');

    Route::get('/languagedefault/{id}', [LanguageController::class, 'languagedefault'])->name('languagedefault');
    Route::get('/adminLanguagedefault/{id}', [LanguageController::class, 'adminLanguagedefault'])->name('adminLanguagedefault');
    Route::get('/lang/{file_name}', function () {
        return response()->file(resource_path('lang/' . request()->file_name));
    });
    Route::get('/user/translations', [TranslationController::class, 'getFileTranslations'])->name('translations');

    Route::post('/book', [BookController::class, 'book'])->name('book');
    Route::post('/booking-payment', [BookController::class, 'bookingpayment'])->name('bookingpayment');
    Route::post('/booking-success', [BookController::class, 'bookingsuccess'])->name('bookingsuccess');

    Route::get('/servicedetail/{slug}', [ServiceController::class, 'servicedetail'])->name('servicedetail');
    Route::get('/productdetail/{slug}', [ServiceController::class, 'productdetail'])->name('productdetail');

    Route::post('/userlogin', [UserController::class, 'login']);
    Route::post('/userregister', [UserController::class, 'register']);
    Route::post('/otp-settings', [UserController::class, 'getOtpSettings']);
    Route::post('/verify-otp', [UserController::class, 'verifyOtp']);
    Route::post('/user-update-password', [UserController::class, 'forgotPassword'])->name('forgotPassword');
    Route::get('reset-password', [UserController::class, 'showResetForm'])->name('password.reset');
    Route::get('logout', [UserController::class, 'logout'])->name('logout');
    Route::post('/user/delete-account', [UserController::class, 'deleteAccount']);
    Route::middleware(['auth'])->group(function () {});
    Route::post('/provider/register', [UserController::class, 'providerRegister'])->name('provider.register');
    Route::get('/customer/profile', [UserController::class, 'getProfileDetails'])->name('customer.profile')->middleware('auc');
    Route::get('/user/search', [UserController::class, 'getProfileDetailssearch'])->name('user.profilesearch')->middleware('auc');
    Route::get('/customer/change-password', [UserController::class, 'userSecuritySettings'])->name('customer.change-password')->middleware('track.device', 'auc');
    Route::get('/provider/security', [UserController::class, 'providerSecuritySettings'])->name('provider.security')->middleware('track.device', 'permission', 'provider');
    Route::post('/device/delete', [UserController::class, 'devideDelete'])->name('device.delete');
    Route::get('user/bookinglist', [BookingController::class, 'index'])->name('user.bookinglist')->middleware('auc');
    Route::post('/dispute/details', [BookingController::class, 'getDisputeDetails']);

    Route::get('/admin/profile', [AdminLoginController::class, 'getAdminDetails'])->name('admin.profile')->middleware('admin.auth');

    Route::get('/api/get-session-user-id', function () {
        $userId = session('user_id');
        if ($userId) {
            return response()->json(['user_id' => $userId]);
        } else {
            return response()->json(['user_id' => null]);
        }
    });
    Route::get('/admin/users', [UserController::class, 'index'])->name('admin.userlist')->middleware('admin.auth', 'permission');
    Route::get('/admin/providers', [UserController::class, 'index'])->name('admin.providerslist')->middleware('admin.auth', 'permission');
    Route::get('/admin/bookinglist', [BookingController::class, 'listindex'])->name('admin.bookinglist')->middleware('admin.auth', 'permission');
    Route::get('/admin/order/bookinglist', [BookingController::class, 'listOrderindex'])->name('admin.listOrderindex')->middleware('admin.auth', 'permission');

    Route::get('/provider/dashboard', function () {
        return view('provider.providerdashboard');
    })->name('provider.dashboard')->middleware('provider', 'permission');

    Route::get('/staff/dashboard', [StaffController::class, 'getdashboard'])->name('staff.dashboard')->middleware('provider', 'permission');
    Route::get('/provider/transaction', function () {
        return view('provider.providertransaction');
    })->name('provider.transaction')->middleware('provider', 'permission');

    Route::get('/provider/reviews', function () {
        return view('provider.review_list');
    })->name('provider.reviews')->middleware('provider', 'permission');

    Route::get('/user/walletsucess', [WalletController::class, 'walletsucess'])->name('user.walletsucess')->middleware('auc');

    Route::get('/user/provider', function () {
        return view('user-provider');
    })->name('user.provider');

    Route::get('/user/providerlist', function () {
        return view('user-providerlist');
    })->name('user.providerlist');

    Route::get('/user/providerdetails', function () {
        return view('user-providerdetails');
    })->name('user.providerdetails');

    Route::get('/user/transaction', function () {
        return view('user-transaction');
    })->name('user.transaction')->middleware('auc');

    Route::get('/user/providerlist', [UserController::class, 'userProviderList'])->name('user.providerlist');
    Route::get('/user/provider', [UserController::class, 'userProvider'])->name('user.provider');

    Route::get('/admin/user/view/{id}', [UserController::class, 'renderUserViewPage'])->name('user.viewdetails.page');
    Route::get('/admin/provider/view/{id}', [UserController::class, 'renderUserViewPage'])->name('provider.viewdetails.page');
    Route::get('/user/favourites', [UserController::class, 'getuserfavour'])->name('user.favourites')->middleware('auc');
    Route::post('admin/verify-provider', [UserController::class, 'verifyProvider'])->name('admin.verify.provider');

    Route::post('/admin/viewuserdata', [UserController::class, 'getuserviewdetails'])->name('admin.viewusers');

    Route::get('/', [PageController::class, 'pageBuilderApi'])->name('home');
    Route::get('/about-us', [PageController::class, 'pageBuilderApi'])->name('about-us');
    Route::get('/terms-conditions', [PageController::class, 'pageBuilderApi'])->name('terms.conditions');
    Route::get('/privacy-policy', [PageController::class, 'pageBuilderApi'])->name('privacy.policy');
    Route::get('/contact-us', [PageController::class, 'pageBuilderApi'])->name('contact-us');
    Route::get('/page-not-found', [PageController::class, 'pageBuilderApi'])->name('page.not.found');
    Route::get('/page-not-found', [PageController::class, 'pageBuilderApi'])->name('page.not.found');
    Route::get('/how-it-work', [PageController::class, 'pageBuilderApi'])->name('page.how.it.work');
    Route::get('/faq', [PageController::class, 'pageBuilderApi'])->name('page.faq');

    Route::get('/maintenance', function () {
        return view('user.partials.maintenance');
    })->name('maintenance');

    Route::post('handle-payment', [PaypalController::class, 'handlePayment'])->name('make.payment');
    Route::post('preparePayment', [MollieController::class, 'preparePayment'])->name('make.preparePayment');
    Route::get('sucesspayment', [MollieController::class, 'handleWebhookNotification'])->name('make.molliesucess');
    Route::post('molliepayment', [MollieController::class, 'molliepayment'])->name('molliepayment');
    Route::get('/mollie-payment-success', [MollieController::class, 'handleMolliepayment'])->name('make.molliepayment');
    Route::get('/payment-success-leads', [MollieController::class, 'handleMolliepaymentLeads'])->name('make.molliepayment.leads');
    Route::post('/walletPayment', [WalletController::class, 'leasdwalletPayment'])->name('leasdwalletPayment.leads');
    Route::get('/wallet-payment-success', [WalletController::class, 'leasdwalletPaymentSuccess'])->name('leasdwalletPayment.leads.Success');
    Route::post('handle-cod-payment', [PaypalController::class, 'handlecodPayment'])->name('make.codpayment');
    Route::post('handle-wallet-payment', [PaypalController::class, 'handleWalletPayment'])->name('make.walletpayment');
    Route::post('handleBankPayment', [PaypalController::class, 'handleBankPayment'])->name('makebank.bankpayment');
    Route::post('processpayment', [PaypalController::class, 'ProcessPayment'])->name('processpayment');
    Route::get('payment-success', [PaypalController::class, 'paymentSuccess'])->name('payment.success');
    Route::get('payment-failed', [PaypalController::class, 'paymentFailed'])->name('payment.failed');
    Route::get('/provider/paymentsuccess', [PaypalController::class, 'Successpayment'])->name('providerpayment.success');
    Route::get('/user/paymentsuccess', [PaypalController::class, 'UserSuccesspayment'])->name('userpayment.success');
    Route::post('stripecheckout', [StripeController::class, 'test'])->name('stripecheckout');
    Route::get('success', [StripeController::class, 'paymentSuccess'])->name('success');
    Route::get('/provider/subscriptionpaymentsuccess', [StripeController::class, 'subscriptionpaymentsuccess'])->name('provider.subscriptionsuccess');
    Route::get('checkout', [StripeController::class, 'checkout'])->name('checkout');
    Route::get('live_mobile', [StripeController::class, 'live_mobile'])->name('live_mobile');
    Route::post('stripepayment', [StripeController::class, 'stripepayment'])->name('stripepayment');
    Route::get('/user/stripepaymentsuccess', [StripeController::class, 'UserstripeSuccesspayment'])->name('userstripepayment.success');
    Route::get('/provider/profile', [UserController::class, 'getProfileDetails'])->name('provider.profile')->middleware('provider', 'permission');
    Route::get('/provider/bookinglist', [BookingController::class, 'providerindex'])->name('provider.bookinglist')->middleware('provider', 'permission');
    Route::get('/staff/bookinglist', [BookingController::class, 'staffindex'])->name('staff.bookinglist')->middleware('provider', 'permission');
    Route::get('/provider/calendar', [ProviderController::class, 'providerCalendarIndex'])->name('provider.calendar')->middleware('provider');
    Route::get('/staff/calendar', [StaffController::class, 'CalendarIndex'])->name('staff.calendar')->middleware('provider', 'permission');
    Route::get('/provider/subscription', [SubscriptionController::class, 'index'])->name('provider.subscription')->middleware('provider', 'permission');
    Route::get('/provider/subscriptionhistory', [SubscriptionController::class, 'historyindex'])->name('provider.subscriptionhistory')->middleware('provider', 'permission');
    Route::post('/getsubscriptionhistorylist', [SubscriptionController::class, 'getsubscriptionhistorylist'])->middleware('provider');
    Route::post('/set-session', function (Illuminate\Http\Request $request) {
        $existingData = session("{$request->type}.{$request->authid}.chat", []);
        // Add or update the specific key-value pair
        $existingData[$request->key] = $request->value;
        // Update the session with the modified data
        session()->put("{$request->type}.{$request->authid}.chat", $existingData);
        session()->put('fromurl', 'bookinglist');
        // session("$request->type.{$request->authUserId}.chat",[$request->key => $request->value]);
        return response()->json(['success' => true, 'message' => 'Session value set successfully!']);
    });
    Route::get('/provider/staff-list', function () {
        return view('provider.staff.staff_list');
    })->name('provider.staffs')->middleware('provider', 'permission');
    Route::get('/provider/add-staff', function () {
        return view('provider.staff.add-staff');
    })->name('provider.add_staffs')->middleware('provider', 'permission');
    Route::get('/provider/staff/{id}/edit', [UserController::class, 'getStaffDetails'])->name('provider.edit_staffs')->middleware('provider', 'permission');
    Route::post('/provider/staff/save', [UserController::class, 'saveProfileDetails'])
        ->name('provider.staffs.save')
        ->middleware('provider', 'permission');

    Route::get('/provider/payouts', function () {
        return view('provider.payouts.payout_list');
    })->name('provider.payouts')->middleware('provider', 'permission');

    Route::get('/vendor/products/order-invoice/{order}', [CustomerController::class, 'showProviderInvoice'])->name('vendor.invoice.details')->middleware('provider');
    Route::get('/vendor/invoice/download/{order}', [CustomerController::class, 'downloadVendorInvoice'])->name('vendor.invoice.download')->middleware('provider');

    Route::get('/provider/branch', [BranchController::class, 'branch'])->name('provider.branch')->middleware('provider', 'permission');
    Route::get('/provider/add-branch', [BranchController::class, 'addBranch'])->name('provider.addbranch')->middleware('provider', 'permission');
    Route::get('/provider/edit-branch/{id}', [BranchController::class, 'editBranch'])->name('provider.editbranch')->middleware('provider', 'permission');
    Route::post('/provider/save-branch-details', [BranchController::class, 'saveBranch'])->middleware('provider');
    Route::post('/provider/delete-branch', [BranchController::class, 'deleteBranch'])->middleware('provider');
    Route::post('/provider/get-branch-list', [BranchController::class, 'index'])->middleware('provider');
    Route::post('/provider/branch/check-unique', [BranchController::class, 'checkUnique'])->middleware('provider');
    Route::post('/provider/branch/check-limit', [BranchController::class, 'providerBranchLimit'])->middleware('provider');
    Route::post('/provider/staff/check-limit', [StaffController::class, 'providerStaffLimit'])->middleware('provider');

    Route::get('/get-countries', [BranchController::class, 'getCountries']);
    Route::get('/get-states', [BranchController::class, 'getStates']);
    Route::get('/get-cities', [BranchController::class, 'getCities']);

    Route::get('/admin/refund', function () {
        return view('admin.finance.userrequest');
    })->name('admin.refund')->middleware('admin.auth', 'permission');
    Route::get('/admin/subscriptionlist', function () {
        return view('admin.finance.subscriptionlist');
    })->name('admin.subscriptionlist')->middleware('admin.auth', 'permission');

    Route::post('/get-dispute-info', [BookingController::class, 'getDisputeInfo']);
    Route::get('/user/ticket', [TicketController::class, 'ticketindex'])->name('user.ticket')->middleware('auc');
    Route::get('/staff/ticket', [TicketController::class, 'ticketindex'])->name('staff.ticket')->middleware('provider');
    Route::get('/admin/tickets', [TicketController::class, 'ticketindex'])->name('admin.ticket')->middleware('admin.auth');
    Route::get('admin/ticket-details/{ticket_id}', [TicketController::class, 'ticketdetails'])->name('admin.ticketdetails')->middleware('admin.auth');
    Route::get('/staff/tickets', [TicketController::class, 'ticketindex'])->name('staff.tickets')->middleware('admin.auth', 'permission');
    Route::get('staff/ticketdetails/{ticket_id}', [TicketController::class, 'ticketdetails'])->name('staff.ticketdetails')->middleware('admin.auth', 'permission');
    Route::post('/store-ticket-id', [TicketController::class, 'storeTicketId'])->name('store.ticket.id');
    Route::get('user/ticket-details/{ticket_id}', [TicketController::class, 'ticketdetails'])->name('user.ticketdetails')->middleware('auc');
    Route::get('provider/ticket-details/{ticket_id}', [TicketController::class, 'ticketdetails'])->name('provider.ticketdetails')->middleware('provider');
    Route::get('staff/ticket-details/{ticket_id}', [TicketController::class, 'ticketdetails'])->name('staff.ticket_details')->middleware('provider');
    //New Ticket
    Route::prefix('customer/ticket')->name('customer.ticket.')->group(function () {
        Route::get('/', [TicketController::class, 'index'])->name('index');

        // API routes for AJAX calls
        Route::get('/list', [TicketController::class, 'list'])->name('list');
        Route::post('/store', [TicketController::class, 'stores'])->name('store');
        Route::get('/show/{id}', [TicketController::class, 'show'])->name('show');
        Route::put('/update/{id}', [TicketController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [TicketController::class, 'destroy'])->name('destroy');
        Route::post('/reply', [TicketController::class, 'reply'])->name('reply');
    });

    Route::get('/provider/ticket', [TicketController::class, 'indexVendor'])->name('indexVendorticket')->middleware('provider');
    //my booking
    Route::get('/user/booking/service-booking/{slug}', [BookController::class, 'serviceBooking'])->name('user.booking.location.service_booking')->middleware('auc');;
    Route::get('/user/booking/{slug}', [BookController::class, 'serviceIndexBooking'])->name('user.booking.service_booking')->middleware('auc');;
    Route::get('/user/product/booking/', [BookController::class, 'productIndexBooking'])->name('user.booking.product_booking')->middleware('auc');;
    Route::get('/get-branch-staff', [BookController::class, 'getStaffs']);
    Route::get('/get-branch-staff-info', [BookController::class, 'getInfo']);
    Route::get('/get-personal-info', [BookController::class, 'getPersonalInfo']);
    Route::post('/get-slot', [BookController::class, 'getSlot']);
    Route::post('/get-slots', [BookController::class, 'getSlots']);
    Route::post('/get-slot-info', [BookController::class, 'getSlotInfo']);
    Route::post('/get-payout', [BookController::class, 'getPayout']);
    Route::post('/user/payment', [BookController::class, 'payment']);
    Route::post('/user/product/payment', [BookController::class, 'productPayment']);
    Route::post('/user/product/calculate-summary', [BookController::class, 'calculateProductSummary']);
    Route::get('/service/booking-success', [BookController::class, 'productSuccess'])->name('service.success');
    Route::get('/product/booking-success', [BookController::class, 'productSuccessProduct'])->name('product.success');
    Route::get('/product-paypal-success', [BookController::class, 'productPaypalSuccess'])->name('product.paypal.success');
    Route::get('/paypal-payment-success', [BookController::class, 'paypalPaymentSuccess'])->name('paypal.payment.success');
    Route::get('/strip-payment-success', [BookController::class, 'stripPaymentSuccess'])->name('strip.payment.success');
    Route::get('/product-strip-payment-success', [BookController::class, 'productStripPaymentSuccess'])->name('product.strip.payment.success');
    Route::get('/payment-success-one', [BookController::class, 'successOne'])->name('payment.one');
    Route::get('/payment-success', [BookController::class, 'successTwo'])->name('payment.two');
    Route::get('/molliesucess/sucesspayment', [BookController::class, 'sucesspaymentMollie'])->name('make.sucesspayment.molliesucess');
    Route::get('/check-product-user', [BookController::class, 'checkProductUser'])->name('new-txt');
    Route::post('/get-customer', [StaffController::class, 'getCustomer']);
    Route::post('/get-staff-slot', [StaffController::class, 'getStaffSlot']);
    Route::post('/staff/payment', [StaffController::class, 'payment']);
    Route::post('/get-branch', [ProviderController::class, 'getBranchStaff']);
    Route::post('/get-customer-provider', [ProviderController::class, 'getCustomer']);
    Route::post('/fetch-staff-service', [ProviderController::class, 'fetchStaffService']);
    Route::post('/provider/calender/booking', [ProviderController::class, 'providerCalenderBooking']);
    Route::post('/leads/transaction-list', [TransactionController::class, 'leadsTransactionList']);

    Route::get('/set-password/{id}', [UserController::class, 'setPassword'])->name('set-password');
    Route::post('/update-password', [UserController::class, 'updatePassword']);
    Route::get('/get-staff', [ProviderController::class, 'getStaffDetails']);
    Route::post('/get/booking/details', [BookingController::class, 'getBookingDetails'])->name('user.getBookingDetails');

    Route::get('/clear', function () {
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        Artisan::call('config:clear');
        Artisan::call('optimize:clear');
        return redirect()->route('admin.addons');
    });

    Route::get('/reload/{module}', function (Request $request) {
        $module = $request->module;
        Artisan::call('module:enable ' . $module);
        return redirect()->route('admin.addons');
    });

    Route::get('/update-module/{module}', [AddonController::class, 'updateModule']);

    Route::get('/backup', [DbbackupController::class, 'backupDatabase'])->name('backup');
    Route::get('download-backup/{id}', [DbbackupController::class, 'downloadDatabaseBackup'])->name('download.backup');
    Route::post('/payment/update-banktransfer', [SubscriptionController::class, 'updateBankTransfer']);
    Route::post('/admin/verify-banktransfer-payment', [SubscriptionController::class, 'verifyBankTransferPayment'])->name('admin.verifyBankTransferPayment');

    // Frontend Shop Routes
    Route::get('/shops', [FrontendShopController::class, 'index'])->name('frontend.shops.index');
    Route::get('/shops/{slug}', [FrontendShopController::class, 'show'])->name('frontend.shops.show');
    Route::get('/shops-filters/filter', [FrontendShopController::class, 'getShops'])->name('frontend.shops.filter');
    Route::post('/provider/get-shop-list', [FrontendShopController::class, 'getShopList'])->name('frontend.getShopList');
    Route::post('/provider/get-shop-by-id', [FrontendShopController::class, 'getShopById'])
    ->name('provider.getShopById');

    Route::get('/blog', [BlogController::class, 'blogList'])->name('blogs.list');
    Route::get('/blog-details/{id}', [BlogController::class, 'blogDetail'])->name('blogs.detail');
    Route::post('/blog-review', [BlogController::class, 'storeReview'])->name('blogs.review.store');
    Route::get('/pages/{slug}', [PageController::class, 'getPage'])->name('pages');
    Route::post('/user/flag-change-language', [LanguageController::class, 'userFlagChangeLanguage'])->name('user.flag-change-language');
    Route::post('/user/reviews-list', [ReviewController::class, 'reviewsList'])->name('reviews.list');

    Route::get('/{slug}', [PageController::class, 'pageBuilderApi'])->name('dynamic.page');

    Route::prefix('/provider/shops')->name('provider.shops.')->group(function () {
        Route::middleware(['provider', 'permission'])->group(function () {
            Route::get('/', [ShopsController::class, 'index'])->name('index');
            Route::get('/create', [ShopsController::class, 'create'])->name('create');
            Route::post('/store', [ShopsController::class, 'store'])->name('store');

            Route::get('/edit/{shop:slug}', [ShopsController::class, 'edit'])->name('edit');
            Route::put('/update/{shop}', [ShopsController::class, 'update'])->name('update');
            Route::get('/view/{shop}', [ShopsController::class, 'show'])->name('view');
            Route::delete('/delete/{shop}', [ShopsController::class, 'destroy'])->name('destroy');
            Route::post('/{shop}/status', [ShopsController::class, 'updateStatus'])->name('updateStatus');
        });
        Route::get('/get-countries', [ShopsController::class, 'getCountries'])->name('get-countries');
        Route::post('/get-states', [ShopsController::class, 'getStates'])->name('get-states');
        Route::post('/get-cities', [ShopsController::class, 'getCities'])->name('get-cities');
        Route::post('/check-name', [ShopsController::class, 'checkName'])->name('check-name');
    });

    Route::post('/provider/product-ratings', [ReviewController::class, 'getProviderProductRatings'])->middleware('provider', 'permission');
    Route::post('/provider/product-ratings/reply', [ReviewController::class, 'addProviderProductRatingReply'])->middleware('provider', 'permission');
    Route::delete('/provider/product-ratings/{rating}', [ReviewController::class, 'deleteProviderProductRating'])->middleware('provider', 'permission');

    Route::prefix('user')->name('user.')->group(function () {
        Route::post('/cart/add', [CartController::class, 'addToCart'])->name('cart.add');
        Route::get('/cart', [CartController::class, 'viewCart'])->name('cart.view');
        Route::post('cart/remove', [CartController::class, 'removeFromCart'])->name('remove');
        Route::post('cart/update', [CartController::class, 'updateCart'])->name('update');
        Route::post('cart/empty', [CartController::class, 'emptyCart'])->name('empty');
    });

    Route::get('provider/earnings', [ProviderEarningController::class, 'sellerEarning'])->name('provider.earnings')->middleware('provider', 'permission');
    Route::get('provider/earning/list', [ProviderEarningController::class, 'sellerEarningList'])->name('seller.earningList');
    Route::get('/provider/delete-account', function () {
        return view('provider.delete_account');
    })->name('provider.delete.account')->middleware('provider');
    //enquiry
    Route::prefix('provider/enquiry')->middleware('provider')->group(function () {
        Route::get('/', [EnquiryController::class, 'index'])->name('provider.enquiry');
        Route::get('/list', [EnquiryController::class, 'providerEnquiries'])->name('provider.enquiry.list');
        Route::post('/delete', [EnquiryController::class, 'delete']);
        Route::post('/update-status', [EnquiryController::class, 'updateStatus']);
    });
    Route::post('/customer/store-enquiry', [EnquiryController::class, 'store']);

});
