@extends('frontend.theme_2.app')

@section('title', __('Wallet') . ' || ' . $companyName)

@push('styles')

<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')
	<div class="page-wrapper">
        <!-- Start Breadscrumb -->
        <div class="breadcrumb-bar">
            <div class="container">
                <div class="breadcrumb-item">
                    <nav aria-label="breadcrumb" class="page-breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                            <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                            <li class="breadcrumb-items active" aria-current="page">{{ __('Wallet') }}</li>
                        </ol>
                    </nav>
                    <h1 class="breadcrumb-title">{{ __('Wallet') }}</h1>
                </div>
            </div>
            <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
            <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
            <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
            <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
            <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
        </div>
        <!-- End Breadscrumb -->

        <!-- Start Content -->
        <div class="content">
            <div class="container">
                <!-- start row -->
                <div class="row">
                    @include('frontend.pages.customer.sidemenu')
                    <div class="col-xl-9 col-lg-8">
                        <div class="d-flex align-items-center justify-content-between">
                            <h4 class="mb-0">{{ __('Wallet') }}</h4>
                            <div id="reportrange" class="reportrange-picker d-flex align-items-center">
                                <i class="isax isax-calendar-edit fs-14 me-1"></i>
                                <span class="reportrange-picker-field">
                                    {{ \Carbon\Carbon::now()->startOfWeek()->format('j M y') }} - {{ \Carbon\Carbon::now()->endOfWeek()->format('j M y') }}
                                </span><i class="isax isax-arrow-down-14 ms-2"></i>
                            </div>
                        </div>
                        <hr>
                        <!-- start row -->
                        <div class="row row-gap-4 mb-4">
                            <div class="col-md-12 col-xl-12 d-flex">
                                <div class="card flex-fill mb-0">
                                    <div class="card-header py-3">
                                        <h5 class="mb-0">{{ __('Payment') }}</h5>
                                    </div>
                                    <div class="card-body">
                                        <form id="paymentForm">
                                            <div class="mb-3">
                                                <label class="form-label" for="amount">{{ __('add_amount') }}<span class="text-danger ms-1">*</span></label>
                                                <input type="text" class="form-control amount" id="amount" name="amount">
                                            </div>
                                            <div class="wallet-item-two">
                                                <label class="form-label">{{ __('Payment Type') }}</label>
                                                <ul class="mb-3 d-flex align-items-center justify-content-start flex-lg-nowrap flex-wrap gap-2" id="payment-options">
                                                    <li class="nav-item d-flex align-items-center gap-1">
                                                        <input type="radio" id="payment-paypal" name="paymentMethod" class="paymentMethod" value="paypal">
                                                        <label class="nav-link fs-14" for="payment-paypal">{{ __('paypal') }}</label>
                                                    </li>
                                                    <li class="nav-item d-flex align-items-center gap-1">
                                                        <input type="radio" id="payment-stripe" name="paymentMethod" class="paymentMethod" value="stripe">
                                                        <label class="nav-link fs-14" for="payment-stripe">{{ __('stripe') }}</label>
                                                    </li>
                                                </ul>
                                                <div class="payment-contents">
                                                    <div>
                                                        <a href="javascript:void(0);" class="btn btn-dark d-flex align-items-center justify-content-center add_wallet">{{ __('add_payment') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <!-- start row -->
                        <div class="row row-gap-4 mb-4">
                            <div class="col-lg-8">
                                <div class="card mb-0">
                                    <div class="card-header">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">{{ __('total_wallet_bookings') }}</h5>
                                            <div class="d-flex align-items-center">
                                                <span class="bg-primary p-2 d-flex align-items-center justify-content-center rounded me-2"></span>
                                                <p class="mb-0 fs-13">{{ __('Bookings') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div id="wallet_booking_chart"></div>
                                    </div>
                                </div>
                            </div><!-- end col -->
                            <div class="col-lg-4">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <span class="badge badge-xl p-2 badge-soft-success text-success d-inline-flex align-items-center justify-content-center me-2"><i class="isax isax-trend-up fs-24"></i></span>
                                            <div>
                                                <p class="fs-14 fw-semibold mb-1">{{ __('credited') }}</p>
                                                <h5 class="mb-0 total_amount">
                                                    <span class="currency"></span><span class="totalAmount"></span>
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <span class="badge badge-xl p-2 badge-soft-danger text-danger d-inline-flex align-items-center justify-content-center me-2"><i class="isax isax-trend-down fs-24"></i></span>
                                            <div>
                                                <p class="fs-14 fw-semibold mb-1">{{ __('debited') }}</p>
                                                <h5 class="mb-0 total_debit">
                                                    <span class="currency"></span><span class="totalAmountdebit"></span>
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb-0">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <span class="badge badge-xl p-2 badge-soft-secondary text-secondary d-inline-flex align-items-center justify-content-center me-2"><i class="isax isax-dollar-square4 fs-24"></i></span>
                                            <div>
                                                <p class="fs-14 fw-semibold mb-1">{{ __('available_balance') }}</p>
                                                <h5 class="mb-0 wallet_balance">
                                                    <span class="currency"></span><span class="balance"></span>
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="card mb-0">
                            <div class="card-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h5 class="mb-0">{{ __('Wallet Transactions') }}</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive table-nowrap">
                                    <div class="spinner-loader"></div>
                                    <table class="table border d-none real-label" id="walletHistoryTable" data-empty="{{ __('no_data_available') }}">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{ __('Amount') }}</th>
                                                <th>{{ __('Payment Type') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Transaction Date') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                </div>
            </div>
        </div>
        <!-- End Content -->
    </div>
@endsection

@push('plugins')
    <!-- Chart JS -->
    <script src="{{ asset('frontend/assets/plugins/apexchart/apexcharts.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/plugins/apexchart/chart-data.js') }}"></script>
@endpush
@push('scripts')
    <script src="{{ asset('frontend/assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/plugins/datatables/datatables.min.js') }}"></script>
	<script src="{{ asset('frontend/assets/js/custom/wallet.js') }}"></script>
@endpush
