<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>{{$companyName}}</title>

    <link rel="shortcut icon" type="image/x-icon" href="{{ $dynamicFavicon }}">

	@php
		$isRTL = isRTL(app()->getLocale());
	@endphp

    @if ($isRTL)
		<!-- Bootstrap CSS -->
		<link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.rtl.min.css') }}">
	@else
		<!-- Bootstrap CSS -->
		<link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.min.css') }}">
	@endif
	<!-- Iconsax CSS -->
	<link rel="stylesheet" href="{{ asset('frontend/assets/plugins/iconsax/iconsax.css') }}">

	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="{{ asset('frontend/assets/plugins/fontawesome/css/all.min.css') }}">

	@if ($isRTL)
		<!-- Main RTL CSS -->
		<link rel="stylesheet" href="{{ asset('frontend/assets/css/style-rtl.css') }}">
	@else
		<!-- Main CSS -->
		<link rel="stylesheet" href="{{ asset('frontend/assets/css/style.css') }}">
	@endif

	<!-- Custom Style CSS -->
	<link rel="stylesheet" href="{{ asset('frontend/assets/css/custom/custom-style.css') }}">
</head>

<body>
	<div class="main-wrapper">

		<div class="container">

			<div class="authentication-header">
			<div class="container">
				<div class="col-md-12">
					<div class="text-center">
					<img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo">
				</div>
			</div>
		</div>


		<div class="page-wrapper">
			<div class="content">
				<div class="maintenance">
					<div class="row ">
						<div class="col-md-6 d-flex justify-content-center align-items-center">
							<div class="maintenance-content">
								<div class="maintenance-title">
									{!! $maintenanceContent->value !!}
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="maintenance-img">
								<img src="/front/img/bg/maintenance.png" alt="img" class="img-fluid">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

    <!-- jQuery -->
	<script src="{{ asset('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

	<!-- Bootstrap Core JS -->
	<script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

	@if ($isRTL)
		<script src="{{ asset('frontend/assets/js/script-rtl.js') }}"></script>
	@else
		<script src="{{ asset('frontend/assets/js/script.js') }}"></script>
	@endif
</body>

</html>
