@extends('frontend.theme_2.app')

@section('title', 'Our Services')

@push('styles')
{{-- Corrected: Use the stylesheet for Bootstrap Datetimepicker, not Daterangepicker --}}
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css">
<link rel="stylesheet" href=" {{ asset('/frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')
<div class="page-wrapper content-widget">

    <div class="content">
        <div class="container">

            <div class="wizard">
                <div class="card bg-light mb-4">
                    <div class="card-body d-flex align-items-center justify-content-between flex-wrap gap-2">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <div class="avatar avatar-xl flex-shrink-0">
                                <div class="skeleton w-100 h-100"></div>
                                <img src="{{ $firstImage }}" class="img-fluid rounded real-label d-none" alt="service">
                            </div>
                            <div>
                                <div class="skeleton label-skeleton label-loader"></div>
                                <h6 class="mb-0 real-label d-none">
                                    {{ $service->source_name }}
                                    <span class="mt-2 d-flex align-items-center gap-2 fs-14 fw-normal text-body">
                                        <i class="fa-solid fa-star text-warning"></i>
                                        {{ $averageRating }} ({{ $ratingCount }} {{ __('reviews') }})
                                    </span>
                                </h6>
                            </div>
                        </div>
                        <div class="d-flex align-items-center justify-content-center fs-14 mb-1">
                            <div class="skeleton label-skeleton label-loader"></div>
                            <h6 class="d-flex align-items-center real-label d-none">
                                <span class="fw-normal fs-14 text-body me-1">{{ __('Price') }} :</span>
                                {{ $currecy_details->symbol }}{{ $service->source_price }}
                            </h6>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="row row-gap-3">
                            <div class="col-lg-4 col-md-12 d-xl-flex">
                                <div class="twitter-bs-wizard bg-light rounded card border-0 mb-0 flex-xl-fill">
                                    <div class="twitter-bs-wizard-nav card-body">
                                        @php
                                        $step = 1;
                                        @endphp
                                        <ul class="wizard-steps d-block border-0 mb-0" id="bokingwizard">
                                            @if ($additionalServicesCount !== '00')
                                            <li class="step active mb-4" data-step="{{ $step }}">
                                                <a href="javascript:void(0);" class="d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap text-start">
                                                    <div class="avatar bg-secondary flex-shrink-0">
                                                        <i class="isax isax-box"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1 fs-16">{{ __('Additional Services') }}</h6>
                                                        <p class="mb-0 fs-13 text-body">{{ __('Choose service') }}</p>
                                                    </div>
                                                </a>
                                            </li>
                                            @php $step++; @endphp
                                            @endif
                                            <li class="step mb-4 {{ $additionalServicesCount === '00' ? 'active' : '' }} datetime" data-step="{{ $step }}">
                                                <a href="javascript:void(0);" class="d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap text-start">
                                                    <div class="avatar bg-white border flex-shrink-0">
                                                        <i class="isax isax-clock text-body"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1 fs-16">{{ __('Date & Time') }}</h6>
                                                        <p class="mb-0 fs-13 text-body">{{ __('Pick date & time') }}</p>
                                                    </div>
                                                </a>
                                            </li>
                                            @php $step++; @endphp
                                            <li class="step mb-4 prinfo" data-step="{{ $step }}">
                                                <a href="javascript:void(0);" class="d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap text-start">
                                                    <div class="avatar bg-white border flex-shrink-0">
                                                        <i class="isax isax-user text-body"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1 fs-16">{{ __('Personal Information') }}</h6>
                                                        <p class="mb-0 fs-13 text-body">{{ __('Your Information') }}</p>
                                                    </div>
                                                </a>
                                            </li>
                                            @php $step++; @endphp
                                            <li class="step mb-4 payments" data-step="{{ $step }}">
                                                <a href="javascript:void(0);" class="d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap text-start">
                                                    <div class="avatar bg-white border flex-shrink-0">
                                                        <i class="isax isax-money text-body"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1 fs-16">{{ __('Payment') }}</h6>
                                                        <p class="mb-0 fs-13 text-body">{{ __('Secure checkout') }}</p>
                                                    </div>
                                                </a>
                                            </li>
                                            @php $step++; @endphp
                                            <li class="step" data-step="{{ $step }}">
                                                <a href="javascript:void(0);" class="d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap text-start">
                                                    <div class="avatar bg-white border flex-shrink-0">
                                                        <i class="isax isax-clipboard-tick text-body"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1 fs-16">{{ __('Confirmation') }}</h6>
                                                        <p class="mb-0 fs-13 text-body">{{ __('All Set') }}</p>
                                                    </div>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-8 col-md-12">
                                <div class="wizard-content">

                                    @if ($additionalServicesCount !== '00')
                                    <div class="tab active" data-step="1">
                                        <div class="card wizard-1-content mb-0 border-0">
                                            <div class="card-header d-flex align-items-center justify-content-between pt-0 mx-0">
                                                <h5 class="mb-0">{{ __('Select Additional Service') }}</h5>
                                                <div class="badge badge-soft-success">{{ __('Total') }} : {{ $additionalServicesCount }}</div>
                                            </div>
                                            <div class="card-body px-0">
                                                <form id="addService-form">
                                                    <div class="row row-gap-4">
                                                        @forelse ($additionalServices as $additionalService)
                                                        <div class="col-xl-6 col-lg-12 col-md-12">
                                                            <label class="booking-card card mb-0 h-100" for="additionalService_{{ $additionalService->id }}">
                                                                <input type="checkbox" name="additionalService_id[]" id="additionalService_{{ $additionalService->id }}" value="{{ $additionalService->id }}" class="d-none additionalService-radio">
                                                                <div class="card-body">
                                                                    <div class="d-flex align-items-center flex-lg-nowrap flex-wrap gap-2 mb-3">
                                                                        <div class="avatar avatar-xl flex-shrink-0">
                                                                            <img src="{{ $additionalService->image }}" class="img-fluid rounded" alt="service">
                                                                        </div>
                                                                        <div>
                                                                            <h6 class="mb-1 fs-16">{{ $additionalService->name }}</h6>
                                                                            <p class="fs-14 mb-0">{{ $additionalService->short_description ?? 'No description available.' }}</p>
                                                                        </div>
                                                                    </div>
                                                                    <div class="d-flex align-items-center justify-content-between gap-2">
                                                                        <p class="meta text-body mb-0 d-flex align-items-center gap-1 fs-14"><i class="isax isax-clock"></i>{{ $additionalService->duration }}</p>
                                                                        <p class="price text-dark mb-0 fw-semibold">{{ $currecy_details->symbol }}{{ $additionalService->price }}</p>
                                                                    </div>
                                                                </div>
                                                            </label>
                                                        </div>
                                                        @empty
                                                        <div class="col-12">
                                                            <p class="text-center fs-12 mt-5 fw-bold text-dark">{{ __('No additional services found at the moment. You can Continue further.') }}</p>
                                                        </div>
                                                        @endforelse
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-end mt-3">
                                            <a class="btn btn-md btn-secondary d-flex align-items-center gap-2 next" href="javascript:void(0);" id="addService-btns">{{ __('Next') }} <i class="isax isax-arrow-right-3"></i></a>
                                        </div>
                                    </div>
                                    @endif

                                    <!-- Date & Time -->
                                    <div class="tab {{ $additionalServicesCount === '00' ? 'active' : '' }}" data-step="2">
                                        <div class="card wizard-3-content rounded-0 border-0 mb-0">
                                            <div class="card-header d-flex align-items-center justify-content-between pt-0 mx-0">
                                                <h5 class="mb-0">{{ __('Select Date & Time') }}</h5>
                                            </div>
                                            <div class="card-body px-0">
                                                <form id="slot-form">
                                                    <input type="hidden" name="service_id" id="service_id" value="{{ $service->id }}">
                                                    <input type="hidden" name="subcategory_id" id="subcategory_id" value="{{ $service->source_subcategory }}">
                                                    <input type="hidden" name="category_id" id="category_id" value="{{ $service->source_category }}">
                                                    <input type="hidden" name="booking_date" id="selected_date" value="">
                                                    <input type="hidden" name="time_staus" id="time_staus">
                                                    <div class="row row-gap-4">
                                                        <!-- Calendar -->
                                                        <div class="col-xl-6 col-lg-12 col-md-12 d-flex">
                                                            <div class="booking-card card mb-0 shadow-sm flex-fill">
                                                                <div class="card-body">
                                                                    <div class="bookingDatepics"></div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Time Slots -->
                                                        <div class="col-xl-6 col-lg-12 col-md-12 d-flex">
                                                            <div class="booking-card card mb-0 shadow-sm flex-fill">
                                                                <div class="card-body">
                                                                    <h6 class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-4">
                                                                        {{ __('Select Time') }}
                                                                    </h6>

                                                                    <div class="time-pickers" id="slot-input">
                                                                        {{-- Loader skeleton --}}
                                                                        <div class="slotLoader-skaliaton">
                                                                            <div>
                                                                                <div class="skeleton chat-skeleton label-loader mb-2 mt-2"></div>
                                                                                <div class="skeleton chat2-skeleton label-loader"></div>
                                                                            </div>
                                                                        </div>
                                                                        {{-- No slot message --}}
                                                                        <p class="d-none real-label w-100 text-center mt-3">
                                                                            {{ __('No slots available at this moment') }}
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-end flex-wrap gap-2 mt-3">
                                            @if ($additionalServicesCount !== '00')
                                            <a href="javascript:void(0);" id="slot-prevs" class="btn btn-md btn-outline-light prev d-flex align-items-center gap-1"><i class="isax isax-arrow-left-2"></i>{{ __('Prev') }}</a>
                                            @endif
                                            <a href="javascript:void(0);" id="{{ $additionalServicesCount === '00' ? 'slot-btns-new' : 'slot-btns' }}" class="btn btn-md btn-secondary next d-flex align-items-center gap-1">{{ __('Next') }} <i class="isax isax-arrow-right-3"></i></a>
                                        </div>
                                    </div>
                                    <!-- //Date & Time -->

                                    <!-- Personal Information -->
                                    <div class="tab" data-step="3">
                                        <div class="card wizard-4-content border-0 rounded-0 mb-0">
                                            <div class="card-header d-flex align-items-center justify-content-between pt-0 mx-0">
                                                <h5 class="mb-0">{{ __('Add Personal Information') }}</h5>
                                            </div>
                                            <div class="card-body px-0">
                                                <div class="booking-card card mb-0">
                                                    <div class="card-body">
                                                        <form id="prinfo-form" data-is_required_text="{{ __('is_required') }}">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('First Name') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="first_name" id="booking_first_name" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('Last Name') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="last_name" id="booking_last_name" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('Email') }} <span class="text-danger">*</span></label>
                                                                    <input type="email" name="email" id="booking_email" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('Phone Number') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="phone_number" id="phone_number" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-12 mb-3">
                                                                    <label class="form-label">{{ __('Street Address') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="address" id="address" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-4 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('City') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="city" id="city" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-4 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('State') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="state" id="state" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-4 col-md-6 mb-3">
                                                                    <label class="form-label">{{ __('Postal Code') }} <span class="text-danger">*</span></label>
                                                                    <input type="text" name="postal" id="postal" class="form-control print-info">
                                                                </div>
                                                                <div class="col-lg-12 mb-3">
                                                                    <label class="form-label">{{ __('Add booking notes') }}</label>
                                                                    <textarea class="form-control" name="note" id="note" rows="4"></textarea>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <div class="mb-0">
                                                                        <h6 class="mb-1 fs-16">{{ __('Cancellation policy') }}</h6>
                                                                        <p class="mb-0 text-body fs-14">{{ __('Cancel for free anytime in advance, otherwise you will be charged 100% of the service price for not showing up.') }}</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-end flex-wrap gap-2 mt-3">
                                            <a href="javascript:void(0);" id="{{ $additionalServicesCount === '00' ? 'prinfo-prevs-new' : 'prinfo-prevs' }}" class="btn btn-md btn-outline-light prev d-flex align-items-center gap-1"><i class="isax isax-arrow-left-2"></i>{{ __('Prev') }}</a>
                                            <a href="javascript:void(0);" id="prinfo-btns" class="btn btn-md btn-secondary next d-flex align-items-center gap-1">{{ __('Next') }} <i class="isax isax-arrow-right-3"></i></a>
                                        </div>
                                    </div>
                                    <!-- //Personal Information -->

                                    <!-- Payment -->
                                    <div class="tab" data-step="4">
                                        <div class="card wizard-5-content border-0 rounded-0 mb-0">
                                            <div class="card-header d-flex align-items-center justify-content-between pt-0 mx-0">
                                                <h5 class="mb-0">{{ __('Payment') }}</h5>
                                            </div>
                                            <div class="card-body px-0">
                                                <form id="payment-form">
                                                    <div class="row row-gap-4">
                                                        <div class="col-xl-6 col-lg-12 col-md-12">
                                                            <div class="booking-card card h-100">
                                                                <div class="card-body">
                                                                    <h6 class="mb-4">{{ __('Payment Method') }}</h6>
                                                                    <div class="payment-radios" style="max-height: 450px; overflow-y: auto;">
                                                                        @if (isset($paymentInfo['stripe_status']) && $paymentInfo['stripe_status'] == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="stripePayment">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="stripe_status" name="payment_type" value="stripe" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="stripe_status">{{ __('Stripe') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('assets/img/payment-gateway/payment-gateway-02.svg') }}" alt="Stripe" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                        @if (isset($paymentInfo['paypal_status']) && $paymentInfo['paypal_status'] == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="paypalPayment">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="paypal_status" name="payment_type" value="paypal" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="paypal_status">{{ __('Paypal') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('assets/img/payment-gateway/payment-gateway-01.svg') }}" alt="Paypal" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                        @if (isset($paymentInfo['mollie_status']) && $paymentInfo['mollie_status'] == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="molliePayment">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="mollie_status" name="payment_type" value="mollie" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="mollie_status">{{ __('Mollie') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('front/img/icons/mollie.png') }}" style="height: 25px;" alt="Mollie" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                        @if (isset($paymentInfo['cod_status']) && $paymentInfo['cod_status'] == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="codPayment">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="cod_status" name="payment_type" value="cod" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="cod_status">{{ __('Cash on Delivery (COD)') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('front/img/icons/cod.png') }}" style="height: 30px;" alt="COD" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                        @if ($bankStatus == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="bank">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="bank_status" name="payment_type" value="bank" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="bank_status">{{ __('Bank Transfer') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('assets/img/payment-gateway/payment-gateway-14.svg') }}" alt="bank" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                        <!-- @if (isset($paymentInfo['wallet_status']) && $paymentInfo['wallet_status'] == 1)
                                                                        <div class="p-3 border rounded mb-3 payment-item" id="walletPayment">
                                                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                                                <div class="form-check">
                                                                                    <input type="radio" id="wallet_status" name="payment_type" value="wallet" class="form-check-input payment-radio">
                                                                                    <label class="form-check-label fs-14" for="wallet_status">{{ __('Wallet Amount') }}</label>
                                                                                </div>
                                                                                <img src="{{ asset('front/img/icons/digital-wallet.jpg') }}" style="height: 30px;" alt="wallet" class="img-fluid">
                                                                            </div>
                                                                        </div>
                                                                        <div id="wallet-meg"
                                                                            data-wallet_balance="{{ __('wallet_balance') }}"
                                                                            data-your_wallet_balance_is_sufficient="{{ __('your_wallet_balance_is_sufficient') }}"
                                                                            data-insufficient_wallet_balance="{{ __('insufficient_wallet_balance') }}"
                                                                            data-available_balance="{{ __('available_balance') }}"
                                                                            class="fw-bold mb-3">
                                                                        </div>
                                                                        @endif -->
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-6 col-lg-12 col-md-12">
                                                            <div class="booking-card card mb-0 bg-light border-0">
                                                                <div class="card-body">
                                                                    <h6 class="mb-4">{{ __('Booking Summary') }}</h6>
                                                                    <div class="d-flex align-items-center justify-content-between flex-lg-nowrap flex-wrap gap-lg-5 gap-2 mb-2">
                                                                        <h6 class="fw-normal mb-0 fs-14">{{ __('Date & Time') }}</h6>
                                                                        <p class="mb-0 fs-14 slot_day slot_time text-end"></p>
                                                                    </div>
                                                                    <div class="d-flex align-items-center justify-content-between flex-lg-nowrap flex-wrap gap-lg-5 gap-2 mb-3 pb-3 border-bottom">
                                                                        <h6 class="fw-normal mb-0 fs-14 ">{{ __('Duration') }}</h6>
                                                                        <p class=" mb-0 fs-14">{{ $service->duration }}/{{ $serviceDuration }}</p>
                                                                    </div>

                                                                    <div id="payout" data-sub_total="{{ __('sub_total') }}" data-additional_services_total="{{ __('additional_services_total') }}" data-tax="{{ __('tax') }}" data-total="{{ __('total') }}">
                                                                    </div>

                                                                    <input type="hidden" class="sub_amount" name="sub_amount" id="sub_amount">
                                                                    <input type="hidden" class="addService_amount" name="addService_amount" id="addService_amount">
                                                                    <input type="hidden" class="tax_amount" name="tax_amount" id="tax_amount">
                                                                    <input type="hidden" class="total_amount" name="total_amount" id="total_amount">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-end flex-wrap gap-2 mt-3">
                                            <a href="javascript:void(0);" id="{{ $additionalServicesCount === '00' ? 'cart-prevs-new' : 'cart-prevs' }}" class="btn btn-md btn-outline-light prev d-flex align-items-center gap-1"><i class="isax isax-arrow-left-2"></i>{{ __('Prev') }}</a>
                                            <button id="pay-btn" class="btn btn-md btn-secondary d-flex align-items-center gap-1 pay-btn">{{ __('Confirm & Pay') }}</button>
                                        </div>
                                    </div>
                                    <!-- //Payment -->

                                    <!-- Booking Confirmation -->
                                    <div class="tab" data-step="5">
                                        <div class="card wizard-6-content border-0 rounded-0">
                                            <div class="card-header d-flex align-items-center justify-content-between mx-0 pt-0">
                                                <h5 class="mb-0">{{ __('Booking Confirmation') }}</h5>
                                            </div>
                                            <div class="card-body px-0">
                                                <div class="text-center mb-5">
                                                    <i class="isax isax-tick-circle5 fs-48 text-success"></i>
                                                    <h2 class="mb-1">{{ __('Thank You!') }}</h2>
                                                    <p class="mb-3">{{ __('your_booking_is_successful_on') }} <span class="final-time"></span></p>
                                                    <div class="border rounded-pill d-inline-flex align-items-center justify-content-center">
                                                        <p class="d-flex align-items-center gap-2 px-3 py-2 fw-semibold">{{ __('Booking ID') }}: <span class="text-secondary final-booking-id"></span></p>
                                                    </div>
                                                </div>
                                                <div class="card bg-light border-0">
                                                    <div class="card-body">
                                                        <h5 class="mb-3 pb-3 border-bottom d-flex align-items-center gap-2"><i class="isax isax-box text-body"></i>{{ __('Order Summary') }}</h5>
                                                        <div class="mb-3 d-flex align-items-center justify-content-between gap-2 text-dark">
                                                            <p class="mb-0">{{ $service->source_name }}</p>
                                                            <span class="fw-semibold text-dark">{{ $currecy_details->symbol }}{{ $service->source_price }}</span>
                                                        </div>
                                                        <div class="additional-service-final-summary"></div>
                                                        <h6 class="mb-3 pb-3 border-bottom d-flex align-items-center justify-content-between gap-2 text-dark fw-bold fs-16">{{ __('sub_total') }} <span class="fw-bold text-dark">{{ $currecy_details->symbol }}<span class="final-sub"></span></span></h6>
                                                        <div class="d-flex align-items-center justify-content-between mb-2">
                                                            <h6 class="mb-0 fw-normal fs-14">{{ __('tax') }}</h6>
                                                            <h6 class="mb-0 fw-semibold">{{ $currecy_details->symbol }}<span class="final-tax"></span></h6>
                                                        </div>
                                                        <div class="d-flex align-items-center justify-content-between mb-0">
                                                            <h6 class="mb-0 fw-bold">{{ __('total') }}</h6>
                                                            <h6 class="mb-0 fw-bold">{{ $currecy_details->symbol }}<span class="final-total"></span></h6>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-center flex-wrap mt-3">
                                            <a href="{{ route('user.dashboard') }}" class="btn btn-md btn-secondary d-flex align-items-center gap-2"> <i class="isax isax-arrow-left-2"></i> {{ __('go_to_dashboard') }} </a>
                                        </div>
                                    </div>
                                    <!-- //Booking Confirmation -->

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if (module_view_exists('paymentgateway::model') && $PaymentGatewayStatus == 1)
@include('paymentgateway::model')
@endif
<div class="modal fade" id="bankTransferModal" tabindex="-1" aria-labelledby="bankTransferModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="bankTransferModalLabel">{{ __('Bank Transfer Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label fw-bold">{{ __('Bank Name') }}:</label>
                    <div class="form-control-plaintext">{{ $bankInfo['bank_name'] }}</div>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">{{ __('Account Number') }}:</label>
                    <div class="form-control-plaintext">{{ $bankInfo['account_number'] }}</div>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">{{ __('Branch Code') }}:</label>
                    <div class="form-control-plaintext">{{ $bankInfo['branch_code'] }}</div>
                </div>
                <form id="bankTransfer-form" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="payment_receipt" class="form-label">{{ __('Upload Payment Receipt') }}</label>
                        <input type="file" class="form-control border border-2" name="payment_receipt"
                            id="payment_receipt" accept="image/*,application/pdf" required>
                    </div>
                </form>
                <p class="text-muted small mt-2 mb-0">
                    {{ __('Please upload a valid image or PDF file as proof of payment. Ensure the transfer is completed before submitting.') }}
                </p>
            </div>

            <div class="modal-footer d-flex justify-content-between">
                <button type="button" class="btn btn-link" data-bs-dismiss="modal">← {{ __('Cancel') }}</button>
                <button type="submit" class="btn btn-primary" form="bankTransfer-form" id="submit-bank-payment">
                    {{ __('Pay Now') }}
                </button>
            </div>

        </div>
    </div>
</div>

<div class="xb-cursor tx-js-cursor">
    <div class="xb-cursor-wrapper">
        <div class="xb-cursor--follower xb-js-follower"></div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/moment.min.js') }}"></script>

<script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>

<script src="{{ asset('assets/js/booking.js') }}"></script>
@endpush