@extends('frontend.theme_2.app')

@section('title', 'Booking Success')

@section('content')

<div class="page-wrapper">

    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('thank_you') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('thank_you') }}</h1>
            </div>
        </div>
        {{-- Decorative Images --}}
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="container">
            <div class="text-center mb-5">
                <i class="isax isax-tick-circle5 fs-48 text-success"></i>
                <h2 class="mb-1">{{ __('thank_you') }} {{ $booking->first_name }} {{ $booking->last_name }}</h2>
                <p class="mb-3">{{ __('your_order_has_been_successfully_placed') }}</p>
                <div class="border rounded-pill d-inline-flex align-items-center justify-content-center">
                    <p class="d-flex align-items-center gap-2 px-3 py-2">{{ __('order_id') }}: <span class="text-secondary">{{ $booking->order_id }}</span></p>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-body">
                            <div>
                                <h5 class="mb-3 pb-3 border-bottom d-flex align-items-center gap-2"><i class="isax isax-box text-body"></i>{{ __('order_summary') }}</h5>

                                {{-- Loop through the products relationship --}}
                                @foreach($booking->products as $product)
                                <div class="mb-3 d-flex align-items-center justify-content-between gap-2 text-dark">
                                    <p class="mb-0">{{ $product->product_name }} <small class="text-body">X {{ $product->quantity }}</small></p>
                                    <span class="fw-semibold text-dark">{{ $currecy_details }}{{ number_format($product->subtotal, 2) }}</span>
                                </div>
                                @endforeach

                                <h6 class="mb-3 pb-3 border-bottom d-flex align-items-center justify-content-between gap-2 text-dark fw-semibold fs-16"> {{ __('Subtotal') }}
                                    <span class="fw-semibold text-dark">{{ $currecy_details }}{{ number_format($booking->service_amount, 2) }}</span>
                                </h6>
                                @if ($booking->total_coupon_discount_amount > 0)
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <p class="mb-0">{{ __('Coupon') }}</p>
                                    <p class="fw-semibold text-dark">- {{ $currecy_details }}{{ number_format($booking->total_coupon_discount_amount ?? 0, 2) }}</p>
                                </div>
                                @endif
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <p class="mb-0">{{ __('Tax') }}</p>
                                    <p class="fw-semibold text-dark">{{ $currecy_details }}{{ number_format($booking->amount_tax, 2) }}</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-0">
                                    <h6 class="mb-0 fw-bold">{{ __('Total') }}</h6>
                                    <h6 class="mb-0 fw-bold">{{ $currecy_details }}{{ number_format($booking->total_amount, 2) }}</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mb-0 bg-soft-secondary mt-5 rounded border-0 p-4">
                <div class="card-body">
                    <div class="text-center">
                        <div class="avatar avatar-lg bg-primary rounded-circle mb-2">
                            <i class="isax isax-trade text-white"></i>
                        </div>
                        <h2 class="mb-2">{{ __('product_order_success_title') }}</h2>
                        <p class="mb-0 text-body">{{ __('product_order_success_body') }}</p>
                    </div>
                    <div class="d-flex align-items-center gap-2 mt-4 flex-wrap justify-content-center">
                        <a href="{{ route('user.dashboard') }}" class="btn btn-md btn-secondary">{{ __('back_to_dashboard') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection