@extends('frontend.theme_2.app')

@section('title', 'Cart & Checkout')

@section('content')

<div class="page-wrapper">

    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Cart') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('Cart') }}</h1>
            </div>
        </div>
        {{-- Decorative Images --}}
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>

    <div class="content" id="cart-section">
        <div class="container">
            <div class="row row-gap-3">
                <div class="col-lg-8">
                    <h5 class="mb-4">{{ __('Cart Summary') }}</h5>
                    <div class="card cart-item">
                        <div class="card-body pt-0">
                            <div class="table-responsive" id="cart-wrap">
                                <table class="table align-middle mb-0">
                                    <thead class="bg-white">
                                        <tr>
                                            <th>{{ ucfirst(__('Product')) }}</th>
                                            <th>{{ ucfirst(__('price')) }}</th>
                                            <th>{{ ucfirst(__('quantity')) }}</th>
                                            <th>{{ ucfirst(__('subtotal')) }}</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cartData as $item)
                                        <tr class="cart-product-row"
                                            data-cart-key="{{ $item['cart_key'] }}"
                                            data-price="{{ $item['price'] }}" data-product-id="{{ $item['product']->id ?? '' }}">
                                            <td>
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="avatar avatar-xl flex-shrink-0">
                                                        <img src="{{ $item['image'] }}" alt="{{ $item['product']->source_name }}" class="rounded img-fluid">
                                                    </div>
                                                    <div>
                                                        <p class="text-muted product-name mb-1" data-product_name="{{ $item['product']->source_name ?? '' }}">
                                                            {{ ucfirst($item['product']->source_name ?? '') }}
                                                        </p>
                                                        <small class="text-muted d-flex">
                                                            @if ($item['size'])
                                                            <span class="me-2">{{ __('size') }}: {{ $item['size'] ?? '' }}</span> |
                                                            @endif
                                                            @if ($item['color'])
                                                            {{ __('color') }}: <span class="checkout-product-color-code ms-2" style="background-color: {{ $item['color'] }};"></span>
                                                            @endif
                                                        </small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><h6 class="fs-16 mb-0">{{ $currecy_details ?? '$' }}{{ $item['price'] }}</h6></td>
                                            <td>
                                                <div class="quantity-control-checkout bg-light d-flex align-items-center justify-content-between border rounded gap-2">
                                                    <a href="javascript:void(0);" class="minus-btn">-</a>
                                                    <input type="number" class="quantity-input" value="{{ $item['quantity'] }}" data-cart-key="{{ $item['cart_key'] }}" min="1" aria-label="Quantity">
                                                    <a href="javascript:void(0);" class="add-btn">+</a>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="fs-16 mb-0 text-end row-subtotal">{{ $currecy_details ?? '$' }}{{ $item['subtotal'] }}</h6>
                                            </td>
                                            <td>
                                                <a href="javascript:void(0);" class="btn-icon delete-item"
                                                    data-cart-key="{{ $item['cart_key'] }}">
                                                    <i class="isax isax-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center py-4">{{ __('cart_empty_info') }}</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="row row-gap-3 mt-4">
                        <div class="col-12">
                            <div class="d-flex align-items-end justify-content-end gap-3 flex-wrap flex-lg-nowrap">
                                <button type="button" id="empty-cart-btn" class="btn btn-md btn-white" @if(empty($cartData)) disabled @endif>{{ __('Empty Cart') }}</button>
                                <button type="button" id="update-cart-btn" class="btn btn-md btn-secondary" @if(empty($cartData)) disabled @endif>{{ __('Update Cart') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="mb-3 pb-3 border-bottom">{{ __('Cart Totals') }}</h5>
                            <div class="d-flex align-items-center justify-content-between mb-3 pb-3 border-bottom">
                                <p class="mb-0 text-body">{{ __('Subtotal') }}</p>
                                <p class="text-body" id="cart-subtotal">{{ $currecy_details ?? '$' }}{{ $totalPrice }}</p>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <h6 class="mb-0 fw-bold">{{ __('Total') }}</h6>
                                <h6 class="mb-0 fw-bold" id="cart-total">{{ $currecy_details ?? '$' }}{{ $totalPrice }}</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between">
                                @auth
                                <a href="#" id="proceedCheckout"
                                    class="btn btn-secondary w-100 @if(empty($cartData)) disabled @endif">
                                    {{ __('Proceed to Checkout') }}
                                </a>
                                @endauth

                                @guest
                                <button type="button"
                                    class="btn btn-secondary w-100 @if(empty($cartData)) disabled @endif"
                                    data-bs-toggle="modal" data-bs-target="#loginRequiredModal">
                                    {{ __('Proceed to Checkout') }}
                                </button>
                                @endguest
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="content" id="checkout-section" style="display: none;">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h5 class="mb-0">{{ __('Billing Details') }}</h5>
                        <div class="d-flex align-items-center gap-2">
                            <a href="javascript:void(0);" class="btn btn-sm fs-14 btn-dark" id="add_address">{{ __('Add Address') }}</a>
                            <a href="javascript:void(0);" class="btn btn-sm fs-14 btn-dark" id="back_to_cart">{{ __('back_to_cart') }}</a>
                        </div>
                    </div>
                    <div class="row row-gap-3 billing_address_container" data-is_empty="{{ isset($billingAddresses) && $billingAddresses->isNotEmpty() ? 'false' : 'true' }}">
                        @if (isset($billingAddresses) && $billingAddresses->isNotEmpty())
                            @foreach ($billingAddresses as $address)
                                <div class="col-lg-6 col-md-6 d-flex">
                                    <div class="card mb-0 flex-fill order-card {{ $address->is_default == 1 ? 'active' : '' }}"
                                        data-address-type="{{ $address->name ?? '' }}"
                                        data-email="{{ $address->email ?? '' }}"
                                        data-phone="{{ $address->phone_number ?? '' }}"
                                        data-address="{{
                                            ($address->address_line_one ?? '') . ', ' .
                                            ($address->address_line_two ? $address->address_line_two . ', ' : '') .
                                            ($address->city_name ?? '') . ', ' .
                                            ($address->state_name ?? '') . ', ' .
                                            ($address->country_name ?? '') . ', ' .
                                            ($address->zipcode ?? '')
                                        }}"
                                        data-city_name="{{ $address->city_name ?? '' }}"
                                        data-state_name="{{ $address->state_name ?? '' }}"
                                        data-country_name="{{ $address->country_name ?? '' }}"
                                        data-zipcode="{{ $address->zipcode ?? '' }}">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between gap-2 mb-3 pb-3 border-bottom">
                                                <h6 class="mb-0">{{ $address->name ?? '' }}</h6>
                                                <div class="form-check">
                                                    <input type="radio" name="billing_address" class="form-check-input" {{ $address->is_default == 1 ? 'checked' : '' }}>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <p class="mb-2 fw-semibold fs-14">{{ __('address_type') }} <span class="fw-normal">: {{ $address->name ?? '' }}</span></p>
                                                <p class="mb-2 fw-semibold fs-14">{{ __('email') }} <span class="fw-normal">: {{ $address->email ?? '' }}</span></p>
                                                <p class="mb-2 fw-semibold fs-14">{{ __('phone') }} <span class="fw-normal">: {{ $address->phone_number ?? '' }}</span></p>
                                                <p class="mb-2 fw-semibold fs-14">{{ __('address') }}
                                                    <span class="fw-normal">:
                                                        {{
                                                            ($address->address_line_one ?? '') . ', ' .
                                                            ($address->address_line_two ? $address->address_line_two . ', ' : '')  .
                                                            ($address->city_name ?? '') . ', ' .
                                                            ($address->state_name ?? '') . ', ' .
                                                            ($address->country_name ?? '') . ', ' .
                                                            ($address->zipcode ?? '')
                                                        }}
                                                    </span>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <p class="mb-0 fs-14 text-center">{{ __('no_billing_address_found') }}</p>
                        @endif
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card mb-0">
                        <div class="card-body">
                            @php
                                $walletTotalAmount = isset($walletTotalAmount) && $walletTotalAmount > 0 ? $walletTotalAmount : 0.00;
                            @endphp
                            <h5 class="mb-3 pb-3 border-bottom">{{ __('Your Order') }}</h5>
                            <div id="checkout-order-summary" data-wallet_amount="{{ $walletTotalAmount }}">
                            </div>
                            <div class="d-flex align-items-center justify-content-between border-bottom border-top py-4 my-4">
                                <h6 class="mb-0 fw-bold">{{ __('Subtotal') }}</h6>
                                <h6 class="mb-0 fw-bold" id="checkout-subtotal">{{ $currecy_details }}0.00</h6>
                            </div>
                            <h6 class="mb-3">{{ __('Payment Method') }}</h6>
                            <div class="mb-4 pb-4 border-bottom">
                                @if (isset($paymentInfo['stripe_status']) && $paymentInfo['stripe_status'] == 1)
                                <div class="form-check mb-2">
                                    <input type="radio" id="payment-stripe" name="payment_method" value="stripe" class="form-check-input">
                                    <label class="form-check-label text-body" for="payment-stripe">{{ __('Stripe') }}</label>
                                </div>
                                @endif
                                @if (isset($paymentInfo['paypal_status']) && $paymentInfo['paypal_status'] == 1)
                                <div class="form-check mb-2">
                                    <input type="radio" id="payment-paypal" name="payment_method" value="paypal" class="form-check-input">
                                    <label class="form-check-label text-body" for="payment-paypal">{{ __('Paypal') }}</label>
                                </div>
                                @endif
                                @if (isset($paymentInfo['cod_status']) && $paymentInfo['cod_status'] == 1)
                                <div class="form-check mb-2">
                                    <input type="radio" id="payment-cash" name="payment_method" value="cod" class="form-check-input">
                                    <label class="form-check-label text-body" for="payment-cash">{{ __('Cash on Delivery') }}</label>
                                </div>
                                @endif
                                @if (isset($paymentInfo['wallet_status']) && $paymentInfo['wallet_status'] == 1)
                                <div class="form-check mb-2">
                                    <input type="radio" id="payment-wallet" name="payment_method" value="wallet" class="form-check-input" {{ $walletTotalAmount <= 0 ? 'disabled' : '' }}>
                                    <label class="form-check-label text-body" for="payment-wallet">{{ __('Wallet') }} ({{ $currecy_details . $walletTotalAmount }}) <span class="wallet_message"></span> </label>
                                </div>
                                @endif
                                @if (isset($paymentInfo['bank_status']) && $paymentInfo['bank_status'] == 1)
                                <div class="form-check mb-2">
                                    <input type="radio" id="payment-bank" name="payment_method" value="bank" class="form-check-input">
                                    <label class="form-check-label text-body" for="payment-bank">{{ __('Bank') }}</label>
                                </div>
                                @endif
                            </div>
                            <h5 class="mb-3">{{ __('Coupon') }}</h5>
                            <div class="border-bottom mb-3 pb-4">
                                <div class="d-flex align-items-center justify-content-between gap-2 flex-nowrap w-10 flex-wrap">
                                    <div class="input-group input-group-sm input-group-flat">
                                        <span class="input-group-text">
                                            <i class="ti ti-tags text-dark"></i>
                                        </span>
                                        <input type="text" class="form-control form-control-md" id="coupon_code" name="coupon_code" placeholder="{{ __('enter_coupon_code') }}">
                                    </div>
                                    <input type="hidden" name="total_coupon_discount_amount" id="total_coupon_discount_amount">
                                    <a href="javascript:void(0);" class="btn btn-md btn-dark" id="coupon_btn">{{ __('apply') }}</a>
                                    <a href="javascript:void(0);" class="btn btn-md btn-danger d-none" id="coupon_remove_btn">{{ __('remove') }}</a>
                                </div>
                            </div>
                            <div id="checkout-discount-container">
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-4">
                                <h6 class="mb-0 fw-bold ">{{ __('Total') }}</h6>
                                <h6 class="mb-0 fw-bold" id="checkout-total">{{ $currecy_details }}0.00</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between">
                                <a href="javascript:void(0);" id="confirmPaymentBtn" class="btn btn-secondary w-100">{{ __('Pay Now') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="bankTransferModal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title fw-bold" id="bankTransferModalLabel">{{ __('Bank Transfer Details') }}</h6>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <div class="modal-body">
                <div class="mb-0">
                    <div class="mb-3">
                        <label class="form-label fw-bold">{{ __('Bank Name') }}:</label>
                        <div class="form-control-plaintext">{{ $bankInfo['bank_name'] ?? 'N/A' }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">{{ __('Account Number') }}:</label>
                        <div class="form-control-plaintext">{{ $bankInfo['account_number'] ?? 'N/A' }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">{{ __('Branch Code') }}:</label>
                        <div class="form-control-plaintext">{{ $bankInfo['branch_code'] ?? 'N/A' }}</div>
                    </div>
                    <form id="bankTransfer-form" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label for="payment_receipt" class="form-label">{{ __('Upload Payment Receipt') }}</label>
                            <input type="file" class="form-control border border-2" name="payment_receipt"
                                id="payment_receipt" accept="image/*,application/pdf" required>
                        </div>
                    </form>
                    <p class="text-muted small mt-2 mb-0">
                        {{ __('Please upload a valid image or PDF file as proof of payment. Ensure the transfer is completed before submitting.') }}
                    </p>
                </div>
            </div>
            <div class="modal-footer">
                <div class="d-flex align-items-center justify-content-end">
                    <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-secondary" form="bankTransfer-form" id="submit-bank-payment">{{ __('Pay Now') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Login Required Modal -->
<div class="modal fade" id="loginRequiredModal" tabindex="-1" aria-labelledby="loginRequiredModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="loginRequiredModalLabel">{{ __('Login Required') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('Close') }}"></button>
            </div>
            <div class="modal-body text-center">
                <p>{{ __('Please login to proceed to checkout.') }}</p>
            </div>
            <div class="modal-footer justify-content-center">
                <a href="/user/login" class="btn btn-primary">
                    {{ __('Login') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="remove_cart_modal">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center">
                <form class="delete-form">
                    <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                    <h6 class="mb-1">{{ __('are_you_sure') }}</h6>
                    <p class="mb-3">{{ __('remove_cart_empty_info') }}</p>
                    <div class="d-flex align-items-center justify-content-center">
                        <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-danger w-100">{{ __('yes_remove_it') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="remove_all_cart_modal">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center">
                <form class="delete-form">
                    <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                    <h6 class="mb-1">{{ __('are_you_sure') }}</h6>
                    <p class="mb-3">{{ __('remove_all_item_cart_empty_info') }}</p>
                    <div class="d-flex align-items-center justify-content-center">
                        <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-danger w-100">{{ __('yes_remove_it') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@auth
<!-- Start Add/Edit Modal -->
<div id="billing_address_modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_billing_address') }}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="billingAddressForm">
                <input type="hidden" name="id" id="id">
                <div class="modal-body p-4">
                    <!-- start row -->
                    <div class="row row-gap-3">
                        <div class="col-md-12">
                            <div class="mb-0">
                                <label class="form-label">{{ __('name') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="name" id="name">
                                <span class="text-danger error-text" id="name_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('email') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="email" id="email">
                                <span class="text-danger error-text" id="email_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('phone_number') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control phone_number" name="phone_number" id="phone_number">
                                <input type="hidden" class="form-control international_phone_number" name="international_phone_number" id="international_phone_number">
                                <span class="text-danger error-text" id="phone_number_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('address_line_1') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="address_line_one" id="address_line_one">
                                <span class="text-danger error-text" id="address_line_one_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('address_line_2') }}</label>
                                <input type="text" class="form-control" name="address_line_two" id="address_line_two">
                                <span class="text-danger error-text" id="address_line_two_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('country') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="country_id" id="country_id">
                                    <option value="">{{ __('Select') }}</option>
                                    @if (isset($countries) && !empty($countries))
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <span class="text-danger error-text" id="country_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('state') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="state_id" id="state_id">
                                </select>
                                <span class="text-danger error-text" id="state_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('city') }}<span class="text-danger ms-1">*</span></label>
                                <select class="form-control select2" name="city_id" id="city_id">
                                </select>
                                <span class="text-danger error-text" id="city_error"></span>
                            </div>
                        </div><!-- end col -->
                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="form-label">{{ __('ZIP Code') }}<span class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control" name="zipcode" id="zipcode">
                                <span class="text-danger error-text" id="zipcode_error"></span>
                            </div>
                        </div><!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-between gap-1">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="" name="is_default" id="is_default">
                        <label class="form-check-label" for="is_default">{{ __('mark_as_default') }}</label>
                    </div>
                    <div>
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                        <button type="submit" class="btn btn-secondary submitbtn">{{ __('add_address') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Add/Edit Modal -->

<!-- Start Delete Modal  -->
<div class="modal fade" id="delete_address_modal">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center position-relative z-1 p-0">
                <form id="deleteBillingAddressForm">
                    <input type="hidden" name="delete_id" id="delete_id">
                    <div class="modal-body">
                        <div class="d-flex align-items-center justify-content-center">
                            <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                        </div>
                        <div class="text-center">
                            <h6 class="mb-1">{{ __('Are you Sure') }}</h6>
                            <p class="mb-3">{{ __('billing_address_delete_confirm') }}</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-center">
                            <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                            <button type="submit" class="btn btn-danger">{{ __('Delete') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Delete Modal  -->
@endauth

@endsection

@auth
@push('styles')
    <!-- Mobile CSS-->
    <link rel="stylesheet" href="{{ asset('front/plugins/intltelinput/css/intlTelInput.css') }}">
@endpush

@push('plugins')
    <!-- Mobile Input -->
    <script src="{{ asset('front/plugins/intltelinput/js/intlTelInput.js') }}"></script>
@endpush
@endauth

@push('scripts')
<script src="{{ asset('assets/js/product-booking.js') }}"></script>
@endpush