@extends('frontend.theme_2.app')

@section('title', __('Profile') . ' || ' . $companyName)

@push('styles')
    <!-- Mobile CSS-->
    <link rel="stylesheet" href="{{ asset('front/plugins/intltelinput/css/intlTelInput.css') }}">
@endpush

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Profile') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('Profile') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">
            <!-- start row -->
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div>
                        <h4 class="mb-0">{{ __('Profile') }}</h4>
                    </div>
                    <hr>
                    <div class="card mb-0">
                        <form id="userProfileForm">
                            <div class="card-body">
                                <h6 class="mb-4">{{ __('basic_information') }}</h6>
                                <input type="hidden" name="id" id="id" value="{{ $data->id ?? ''}}">
                                <!-- start row -->
                                <div class="row row-gap-3 mb-4">
                                    <div class="col-lg-12">
                                        <label class="form-label" for="profile_image">{{ __('Profile Image') }}</label>
                                        <div class="profile-image-wrap d-flex align-items-center">
                                            <div class="profile-image avatar avatar-xxl rounded-circle bg-light me-2">
                                                <img src="{{ $data->userDetails->profile_image ?? asset('assets/img/profile-default.png') }}" alt="user" class="img-fluid rounded-circle profileImagePreview">
                                            </div>
                                            <div class="d-inline-flex flex-column align-items-start">
                                                <div class="d-flex align-items-center">
                                                    <div class="drag-upload-btn btn btn-sm btn-dark position-relative mb-2 me-2">
                                                        {{ __('change_image') }}
                                                        <input type="file" class="form-control image-sign" name="profile_image" id="profile_image">
                                                    </div>
                                                </div>
                                                <span class="text-gray-9 fs-14">{{__('image_size_note')}}</span>
                                            </div>
                                            <span class="text-danger error-text" id="profile_image_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('first_name')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control" id="user_first_name" name="first_name"
                                                value="{{ $data->userDetails->first_name ?? ''}}">
                                            <span class="text-danger error-text" id="user_first_name_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('last_name')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control" id="user_last_name" name="last_name"
                                                value="{{ $data->userDetails->last_name ?? ''}}">
                                            <span class="text-danger error-text" id="user_last_name_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('email')}}<span class="text-danger"> *</span></label>
                                            <input type="email" class="form-control" id="user_email" name="email"
                                                value="{{ $data->email ?? ''}}">
                                            <span class="text-danger error-text" id="user_email_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('user_name')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control" id="user_name" name="user_name"
                                                value="{{ $data->name ?? ''}}">
                                            <span class="text-danger error-text" id="user_name_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('phone_number')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control user_phone_number" id="phone_number"
                                                name="phone_number" value="{{ $data->phone_number ?? '' }}">
                                            <input type="hidden" id="international_phone_number"
                                                name="international_phone_number">
                                            <span class="text-danger error-text" id="phone_number_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('gender')}}<span class="text-danger">
                                                *</span></label>
                                            <select class="form-control select2" id="gender" name="gender">
                                                <option value="">{{__('select_gender')}}</option>
                                                <option value="male" {{ ($data->userDetails->gender ?? '') == 'male' ? 'selected' : '' }}>{{__('male')}}</option>
                                                <option value="female" {{ ($data->userDetails->gender ?? '') == 'female' ? 'selected' : '' }}>{{__('female')}}</option>
                                                <option value="other" {{ ($data->userDetails->gender ?? '') == 'other' ? 'selected' : '' }}>{{__('other')}}</option>
                                            </select>
                                            <span class="text-danger error-text" id="gender_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6 d-none">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('date_of_birth')}}<span class="text-danger">
                                                *</span></label>
                                            <div class=" input-icon position-relative">
                                                <input type="date" class="form-control" id="dob" name="dob"
                                                    placeholder="dd-mm-yyyy"
                                                    max="{{ date('Y-m-d', strtotime('-1 day')) }}"
                                                    value="{{ $data->userDetails->dob ?? ''}}">
                                            </div>
                                            <span class="text-danger error-text" id="dob_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-12">
                                        <div class="mb-0">
                                            <label class="form-label d-block">{{__('your_bio')}}</label>
                                            <textarea class="form-control" id="bio" name="bio"
                                                rows="5">{{ $data->userDetails->bio ?? ''}}</textarea>
                                            <span class="text-danger error-text" id="bio_error" maxlength="255"></span>
                                        </div>
                                    </div><!-- end col -->
                                </div>
                                <!-- end row -->
                                <h6 class="mb-4">{{ __('address_information') }}</h6>
                                <!-- start row -->
                                <div class="row row-gap-3 pb-4 mb-4 border-bottom">
                                    <div class="col-lg-12">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('address')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control" id="address" name="address"
                                                value="{{ $data->userDetails->address ?? ''}}" maxlength="150">
                                            <span class="text-danger error-text" id="address_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('country')}}<span class="text-danger">
                                                *</span></label>
                                            <select class="form-control select2" id="country" name="country"
                                                data-placeholder="{{__('select_country')}}"
                                                data-country="{{ $data->userDetails->country ?? ''}}">
                                            </select>
                                            <span class="text-danger error-text" id="country_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('state')}}<span class="text-danger">
                                                *</span></label>
                                            <select class="form-control select2" id="state" name="state"
                                                data-placeholder="{{__('select_state')}}"
                                                data-state="{{ $data->userDetails->state ?? ''}}">
                                            </select>
                                            <span class="text-danger error-text" id="state_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('city')}}<span class="text-danger">
                                                *</span></label>
                                            <select class="form-control select2" id="city" name="city"
                                                data-placeholder="{{__('select_city')}}"
                                                data-city="{{ $data->userDetails->city ?? ''}}">
                                            </select>
                                            <span class="text-danger error-text" id="city_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                    <div class="col-lg-6">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('postal_code')}}<span class="text-danger">
                                                *</span></label>
                                            <input type="text" class="form-control" id="postal_code" name="postal_code"
                                                value="{{ $data->userDetails->postal_code ?? ''}}">
                                            <span class="text-danger error-text" id="postal_code_error"></span>
                                        </div>
                                    </div><!-- end col -->
                                </div>
                                <!-- end row -->
                                <div class="d-flex align-items-center justify-content-end">
                                    <button type="submit" class="btn btn-secondary" id="saveProfile" data-save="{{ __('save_changes') }}">{{__('save_changes')}}</button>
                                </div>
                            </div><!-- end card body -->
                        </form>
                    </div><!-- end card -->
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->
</div>

@endsection

@push('plugins')
    <!-- Mobile Input -->
    <script src="{{ asset('front/plugins/intltelinput/js/intlTelInput.js') }}"></script>
@endpush

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/customer-profile.js') }}"></script>
@endpush