@extends('frontend.provider.app')

@section('title', 'Manage Staff')

@section('content')
<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('manage_staff')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('manage_staff')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')
                <div class="col-xl-9 col-lg-8">

                    <input type="hidden" id="parent_id" value="{{ Auth::user()->id }}">
                    <div id="has_permission" data-delete="1" data-edit="1" data-visible="1"></div>

                    <!-- Page Header -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{__('manage_staff')}}</h4>
                        <div class="d-flex align-items-center flex-wrap gap-2">
                            <a href="{{ route('provider.add_staffs') }}" class="btn btn-md btn-secondary d-inline-flex align-items-center"><i class="isax isax-add-circle me-1"></i>{{__('Add Staff')}}</a>
                        </div>
                    </div>
                    <!-- End Page Header -->

                    <!-- row start -->
                    <div class="row row-gap-4" id="staffCardsRow">

                    </div>
                    <!-- row end -->

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Start Delete Modal  -->
<div class="modal fade" id="del-staff">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-body text-center position-relative z-1 p-0">
                <form>
                    <div class="modal-body">
                        <div class="d-flex align-items-center justify-content-center">
                            <span class="delete-icon rounded-circle mb-3"><i class="isax isax-trash fs-16"></i></span>
                        </div>
                        <div class="text-center">
                            <h6 class="mb-1">A{{__('are_you_sure')}}</h6>
                            <p class="mb-3">{{__('do you want to delete')}}</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-center">
                            <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                            <button type="button" class="btn btn-danger" id="confirm_staff_delete">{{__('Delete')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Delete Modal  -->

@endsection

@push('scripts')
<script src="{{ asset('front/js/staff.js') }}"></script>
@endpush