<div class="card">
	<div class="card-body">
		<div class="sub-header">
			<h5 class="mb-0">{{ __('Basic Information')}}</h5>
		</div>
		<div class="row align-items-center g-3">
			<div class="col-lg-12 col-md-12">
				<div class="profile-image-wrap">
					<div class="profile-image avatar avatar-xxxl rounded-circle bg-light">
						<img id="profilePreview"
							src="{{ (isset($staff['profile_image']) && !empty($staff['profile_image'])) ? $staff['profile_image'] : asset('assets/img/user-default.jpg') }}"
							alt="Preview"
							class="avatar avatar-xxl rounded-circle" />
					</div>
					<input type="file" id="upload-profile1" name="profile_image" class="upload-profile" accept="image/*" aria-label="Upload profile image">
					<label for="upload-profile1" class="edit-icon" aria-label="Change profile picture">
						<i class="isax isax-camera" aria-hidden="true"></i>
					</label>
				</div>
			</div>

			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{ __('shop')}} <span class="text-danger ms-1">*</span></label>
				<select class="select" id="shop_id" name="shop_id">
					<option value="" {{ !isset($staff) || empty($staff['branch_id']) ? 'selected' : '' }} disabled>Select</option>
					<!-- Options will be populated via JavaScript -->
				</select>
				<div class="text-danger small mt-1" id="shop_id_error"></div>
				@if(isset($staff['branch_id']) && !empty($staff['branch_id']))
					<input type="hidden" id="selected_shop_id" value="{{ $staff['branch_id'] }}">
				@endif
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('Staff Id')}} <span class="text-danger ms-1">*</span></label>
				<input type="text"
					class="form-control"
					id="user_name"
					name="user_name"
					value="{{ old('user_name', isset($staff['user_name']) ? $staff['user_name'] : '') }}"
					placeholder="Enter Staff ID">
				<div class="text-danger small mt-1" id="user_name_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('first_name')}}<span class="text-danger ms-1">*</span></label>
				<input type="text"
					class="form-control"
					id="first_name"
					name="first_name"
					value="{{ old('first_name', isset($staff['first_name']) ? $staff['first_name'] : '') }}"
					placeholder="Enter First Name">
				<div class="text-danger small mt-1" id="first_name_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('last_name')}}<span class="text-danger ms-1">*</span></label>
				<input type="text"
					class="form-control"
					id="last_name"
					name="last_name"
					value="{{ old('last_name', isset($staff['last_name']) ? $staff['last_name'] : '') }}"
					placeholder="Enter Last Name">
				<div class="text-danger small mt-1" id="last_name_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('email')}}<span class="text-danger ms-1">*</span></label>
				<input type="email"
					class="form-control"
					id="email"
					name="email"
					value="{{ old('email', isset($staff['email']) ? $staff['email'] : '') }}"
					placeholder="Enter Email Address">
				<div class="text-danger small mt-1" id="email_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('Phone Number')}}<span class="text-danger ms-1">*</span></label>
				<input type="text"
					class="form-control staff_phone_number"
					id="phone_number"
					value="{{ old('phone_number', isset($staff['phone_number']) ? $staff['phone_number'] : '') }}"
					placeholder="Enter Phone Number">
				<input type="hidden"
					id="intl_phone_number"
					name="international_phone_number"
					value="{{ old('international_phone_number', isset($staff['phone_number']) ? $staff['phone_number'] : '') }}">
				<div class="text-danger small mt-1" id="phone_number_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('joining_date')}}<span class="text-danger ms-1">*</span></label>
				<input type="date"
					class="form-control"
					id="dob"
					name="dob"
					value="{{ old('dob', isset($staff['dob']) ? $staff['dob'] : '') }}"
					placeholder="Enter Joining Date">
				<div class="text-danger small mt-1" id="dob_error"></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<label class="form-label">{{__('designation')}}<span class="text-danger ms-1">*</span></label>
				<select class="select" id="role_id" name="role_id">
					<option value="" {{ !isset($staff) || empty($staff['role_id']) ? 'selected' : '' }} disabled>Select</option>
					<!-- Options will be populated via JavaScript -->
				</select>
				<div class="text-danger small mt-1" id="role_id_error"></div>
			</div>
		</div>
	</div>
</div> <!-- end card -->

<div class="card">
	<div class="card-body">
		<div class="sub-header">
			<h5 class="mb-0">{{__('address_information')}}</h5>
		</div>
		<div class="row align-items-center g-3">
			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('address_line_1')}} <span class="text-danger ms-1">*</span></label>
					<input type="text"
						class="form-control"
						id="address"
						name="address"
						value="{{ old('address', isset($staff['address']) ? $staff['address'] : '') }}"
						placeholder="Enter Address Line 1">
					<div class="text-danger small mt-1" id="address_error"></div>
				</div>
			</div><!-- end col -->
			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('address_line_2')}}</label>
					<input type="text"
						class="form-control"
						name="address_line_2"
						value="{{ old('address_line_2', isset($staff['address_line_2']) ? $staff['address_line_2'] : '') }}"
						placeholder="Enter Address Line 2 (Optional)">
					<div class="text-danger small mt-1" id="address_line_2_error"></div>
				</div>
			</div><!-- end col -->
			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('country')}}<span class="text-danger ms-1">*</span></label>
					<select class="select selects country w-100" id="country" name="country" style="width: 100% !important;">
						<option value="" {{ !isset($staff) || empty($staff['country_id']) ? 'selected' : '' }} disabled>Select Country</option>
						<!-- Options will be populated via JavaScript -->
					</select>
					<div class="text-danger small mt-1" id="country_error"></div>
					@if(isset($staff['country_id']) && !empty($staff['country_id']))
					<input type="hidden" id="selected_country_id" value="{{ $staff['country_id'] }}">
					@endif
				</div>
			</div><!-- end col -->

			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('state')}}<span class="text-danger ms-1">*</span></label>
					<select class="select selects state w-100" id="state" name="state" style="width: 100% !important;">
						<option value="" {{ !isset($staff) || empty($staff['state_id']) ? 'selected' : '' }} disabled>Select State</option>
						<!-- Options will be populated via JavaScript -->
					</select>
					<div class="text-danger small mt-1" id="state_error"></div>
					@if(isset($staff['state_id']) && !empty($staff['state_id']))
					<input type="hidden" id="selected_state_id" value="{{ $staff['state_id'] }}">
					@endif
				</div>
			</div><!-- end col -->

			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('city')}}<span class="text-danger ms-1">*</span></label>
					<select class="select selects city w-100" id="city" name="city" style="width: 100% !important;">
						<option value="" {{ !isset($staff) || empty($staff['city_id']) ? 'selected' : '' }} disabled>Select City</option>
						<!-- Options will be populated via JavaScript -->
					</select>
					<div class="text-danger small mt-1" id="city_error"></div>
					@if(isset($staff['city_id']) && !empty($staff['city_id']))
					<input type="hidden" id="selected_city_id" value="{{ $staff['city_id'] }}">
					@endif
				</div>
			</div><!-- end col -->

			<div class="col-lg-6">
				<div class="mb-0">
					<label class="form-label">{{__('postal_code')}}<span class="text-danger ms-1">*</span></label>
					<input type="text"
						class="form-control"
						id="postal_code"
						name="postal_code"
						value="{{ old('postal_code', isset($staff['postal_code']) ? $staff['postal_code'] : '') }}"
						placeholder="Enter Postal Code">
					<div class="text-danger small mt-1" id="postal_code_error"></div>
				</div>
			</div><!-- end col -->
		</div>
	</div>
</div> <!-- end card -->

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function() {
    // Check if we have pre-selected location IDs
    const countryId = $('#selected_country_id').val();
    const stateId = $('#selected_state_id').val();
    const cityId = $('#selected_city_id').val();

    const selectedShopId = $('#selected_shop_id').val();
    const shopDropdown = $('#shop_id');
    if (selectedShopId) {
        $.ajax({
            url: "/provider/get-shop-by-id",
            type: "POST",
            data: {
                shop_id: selectedShopId
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
            },
            dataType: "json",
            success: function (response) {
                if (response.success && response.data) {
                    shopDropdown.append(
                        `<option value="${response.data.id}" selected>${response.data.shop_name}</option>`
                    );
                }
            },
            error: function (error) {
                toastr.error(error.responseJSON?.message || "Failed to load shop");
            }
        });
    }

    // If we have country ID, pre-select it after countries are loaded
    if (countryId) {
        const checkCountriesLoaded = setInterval(function() {
            if (cachedCountries && cachedCountries.length > 0) {
                clearInterval(checkCountriesLoaded);
                getCountries(countryId);

                // If we have state ID, pre-select it after states are loaded
                if (stateId) {
                    const checkStatesLoaded = setInterval(function() {
                        if (cachedStates && cachedStates.length > 0) {
                            clearInterval(checkStatesLoaded);
                            getStates(countryId, stateId);

                            // If we have city ID, pre-select it after cities are loaded
                            if (cityId) {
                                const checkCitiesLoaded = setInterval(function() {
                                    if (cachedCities && cachedCities.length > 0) {
                                        clearInterval(checkCitiesLoaded);
                                        getCities(stateId, cityId);
                                    }
                                }, 100);
                            }
                        }
                    }, 100);
                }
            }
        }, 100);
    }
});

</script>