{{-- resources/views/provider/staff/partials/form-availability.blade.php --}}

<div class="card">
	<div class="card-body">
		<div class="sub-header">
			<h5 class="mb-0">{{ __('availability') }}</h5>
		</div>
		<div class="accordion available-accordion" id="accordiontime">

			{{-- All Days accordion item --}}
			<div class="accordion-item">
				<div class="accordion-header d-flex justify-content-between align-items-center">
					<button class="accordion-button fw-semibold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapse" aria-expanded="false" aria-controls="time-collapse">
						{{ __('all_days') }}
					</button>
					<div class="form-check form-switch ms-3">
						<input class="form-check-input" type="checkbox" role="switch" id="all-days-switch" data-day="all">
					</div>
				</div>
				<div id="time-collapse" class="accordion-collapse collapse" data-bs-parent="#accordiontime">
					<div class="accordion-body">
						<div class="row g-3">
							<div class="col-md-6">
								<label class="form-label">{{ __('start_time') }} <span class="text-danger">*</span></label>
								<div class="input-icon input-icon-end position-relative">
									<input type="time" class="form-control" id="all_start" name="all_start">
									<span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
								</div>
							</div>
							<div class="col-md-6">
								<label class="form-label">{{ __('end_time') }} <span class="text-danger">*</span></label>
								<div class="input-icon input-icon-end position-relative">
									<input type="time" class="form-control" id="all_end" name="all_end">
									<span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			@php
			$weekdays = [
			'monday' => 'One',
			'tuesday' => 'Two',
			'wednesday' => 'Three',
			'thursday' => 'Four',
			'friday' => 'Five',
			'saturday' => 'Six',
			'sunday' => 'Seven'
			];
			@endphp

			@foreach($weekdays as $day => $collapseId)
			{{-- {{ ucfirst($day) }} accordion item --}}
			<div class="accordion-item">
				<div class="accordion-header d-flex justify-content-between align-items-center">
					<button class="accordion-button fw-semibold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapse{{ $collapseId }}" aria-expanded="false" aria-controls="time-collapse{{ $collapseId }}">
						{{ ucfirst($day) }}
					</button>
					<div class="form-check form-switch ms-3">
						<input class="form-check-input" type="checkbox" role="switch" id="{{ $day }}-switch" data-day="{{ $day }}">
					</div>
				</div>
				<div id="time-collapse{{ $collapseId }}" class="accordion-collapse collapse" data-bs-parent="#accordiontime">
					<div class="accordion-body">
						<div class="row g-3">
							<div class="col-md-6">
								<label class="form-label">{{ __('start_time') }} <span class="text-danger">*</span></label>
								<div class="input-icon input-icon-end position-relative">
									<input type="time" class="form-control" id="{{ $day }}_start" name="{{ $day }}_start">
								</div>
							</div>
							<div class="col-md-6">
								<label class="form-label">{{ __('end_time') }} <span class="text-danger">*</span></label>
								<div class="input-icon input-icon-end position-relative">
									<input type="time" class="form-control" id="{{ $day }}_end" name="{{ $day }}_end">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			@endforeach

		</div>
	</div>
</div>

{{-- Hidden input to store the final availability data --}}
<input type="hidden" name="working_days" id="working_days_input">

<script>
	document.addEventListener('DOMContentLoaded', function() {
		@if(isset($staff))

		const staffWorkingDays = @json(json_decode($staff['working_days'], true));
		let workingDays = {};

		// Parse the working days JSON string
		if (typeof staffWorkingDays === 'string') {
			try {
				workingDays = JSON.parse(staffWorkingDays);
			} catch (e) {
				console.error('Error parsing working_days:', e);
				workingDays = {};
			}
		} else {
			workingDays = staffWorkingDays || {};
		}
		@else
		// Create scenario - no existing data
		const workingDays = {};
		@endif

		// Days array for iteration
		const days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];

		// Initialize the form based on staff data or for create scenario
		function initializeAvailabilityForm() {
			// Set up each day
			days.forEach(day => {
				const daySwitch = document.getElementById(`${day}-switch`);
				const startInput = document.getElementById(`${day}_start`);
				const endInput = document.getElementById(`${day}_end`);
				const collapseElement = document.querySelector(`#time-collapse${getDayCollapseId(day)}`);

				if (workingDays[day]) {
					// Enable the switch and set times for update scenario
					daySwitch.checked = true;
					startInput.value = workingDays[day].start || '';
					endInput.value = workingDays[day].end || '';

					// Show the collapse
					if (collapseElement) {
						collapseElement.classList.add('show');
						// Update the accordion button to expanded state
						const accordionButton = collapseElement.previousElementSibling.querySelector('.accordion-button');
						if (accordionButton) {
							accordionButton.classList.remove('collapsed');
							accordionButton.setAttribute('aria-expanded', 'true');
						}
					}
				} else {
					// Disable the switch for create scenario or days not set
					daySwitch.checked = false;
					startInput.value = '';
					endInput.value = '';

					// Hide the collapse
					if (collapseElement) {
						collapseElement.classList.remove('show');
						// Update the accordion button to collapsed state
						const accordionButton = collapseElement.previousElementSibling.querySelector('.accordion-button');
						if (accordionButton) {
							accordionButton.classList.add('collapsed');
							accordionButton.setAttribute('aria-expanded', 'false');
						}
					}
				}
			});

			// Set up event listeners
			setupEventListeners();

			// Update hidden input with initial data
			updateHiddenInput();
		}

		// Get the collapse ID suffix for each day
		function getDayCollapseId(day) {
			const collapseIds = {
				'monday': 'One',
				'tuesday': 'Two',
				'wednesday': 'Three',
				'thursday': 'Four',
				'friday': 'Five',
				'saturday': 'Six',
				'sunday': 'Seven'
			};
			return collapseIds[day] || '';
		}

		// Set up event listeners for switches and all days functionality
		function setupEventListeners() {
			// Individual day switches
			days.forEach(day => {
				const daySwitch = document.getElementById(`${day}-switch`);
				const collapseElement = document.querySelector(`#time-collapse${getDayCollapseId(day)}`);
				const startInput = document.getElementById(`${day}_start`);
				const endInput = document.getElementById(`${day}_end`);

				daySwitch.addEventListener('change', function() {
					if (this.checked) {
						// Show the collapse when switch is enabled
						if (collapseElement) {
							const bsCollapse = new bootstrap.Collapse(collapseElement, {
								show: true
							});
						}
					} else {
						// Hide the collapse and clear times when switch is disabled
						if (collapseElement) {
							const bsCollapse = bootstrap.Collapse.getInstance(collapseElement);
							if (bsCollapse) {
								bsCollapse.hide();
							} else {
								// If no bootstrap instance, manually hide
								collapseElement.classList.remove('show');
							}
						}

						// Clear the time inputs
						startInput.value = '';
						endInput.value = '';
					}
					updateHiddenInput();
				});

				// Update hidden input when times change
				[startInput, endInput].forEach(input => {
					input.addEventListener('change', updateHiddenInput);
				});
			});

			// All days switch functionality
			const allDaysSwitch = document.getElementById('all-days-switch');
			const allDaysCollapse = document.querySelector('#time-collapse');

			allDaysSwitch.addEventListener('change', function() {
				if (this.checked) {
					// Show the all days collapse
					if (allDaysCollapse) {
						const bsCollapse = new bootstrap.Collapse(allDaysCollapse, {
							show: true
						});
					}
				} else {
					// Hide the all days collapse and clear inputs
					if (allDaysCollapse) {
						const bsCollapse = bootstrap.Collapse.getInstance(allDaysCollapse);
						if (bsCollapse) {
							bsCollapse.hide();
						} else {
							// If no bootstrap instance, manually hide
							allDaysCollapse.classList.remove('show');
						}
					}
					document.getElementById('all_start').value = '';
					document.getElementById('all_end').value = '';
				}
			});

			// Apply all days times to individual days
			const allStartInput = document.getElementById('all_start');
			const allEndInput = document.getElementById('all_end');

			[allStartInput, allEndInput].forEach(input => {
				input.addEventListener('change', function() {
					if (allDaysSwitch.checked) {
						applyAllDaysToIndividualDays();
					}
				});
			});
		}

		// Apply all days times to individual days
		function applyAllDaysToIndividualDays() {
			const allStart = document.getElementById('all_start').value;
			const allEnd = document.getElementById('all_end').value;

			if (allStart || allEnd) {
				days.forEach(day => {
					const daySwitch = document.getElementById(`${day}-switch`);
					const startInput = document.getElementById(`${day}_start`);
					const endInput = document.getElementById(`${day}_end`);
					const collapseElement = document.querySelector(`#time-collapse${getDayCollapseId(day)}`);

					// Enable the day switch
					daySwitch.checked = true;

					// Set the times
					if (allStart) startInput.value = allStart;
					if (allEnd) endInput.value = allEnd;

					// Show the collapse
					if (collapseElement && !collapseElement.classList.contains('show')) {
						const bsCollapse = new bootstrap.Collapse(collapseElement, {
							show: true
						});
					}
				});

				// Update hidden input after applying all days
				updateHiddenInput();
			}
		}

		// Update the hidden input with current availability data
		function updateHiddenInput() {
			const availabilityData = {};

			days.forEach(day => {
				const daySwitch = document.getElementById(`${day}-switch`);
				const startInput = document.getElementById(`${day}_start`);
				const endInput = document.getElementById(`${day}_end`);

				if (daySwitch.checked && startInput.value && endInput.value) {
					availabilityData[day] = {
						start: startInput.value,
						end: endInput.value
					};
				}
			});

			// Update the hidden input with JSON string
			const hiddenInput = document.getElementById('working_days_input');
			if (hiddenInput) {
				hiddenInput.value = JSON.stringify(availabilityData);
			}
		}

		// Validate form before submission
		function validateAvailabilityForm() {
			const hiddenInput = document.getElementById('working_days_input');
			const workingDaysData = hiddenInput ? hiddenInput.value : '{}';

			try {
				const parsedData = JSON.parse(workingDaysData);
				const hasAnyDay = Object.keys(parsedData).length > 0;

				if (!hasAnyDay) {
					toastr.error('Please select at least one working day with start and end times.');
					return false;
				}

				// Validate time logic for each enabled day
				for (const day in parsedData) {
					const startTime = parsedData[day].start;
					const endTime = parsedData[day].end;

					if (startTime && endTime && startTime >= endTime) {
						alert(`${day.charAt(0).toUpperCase() + day.slice(1)}: End time must be after start time.`);
						return false;
					}
				}

				return true;
			} catch (e) {
				console.error('Error validating availability data:', e);
				alert('There was an error with the availability data. Please check your entries.');
				return false;
			}
		}

		// Initialize the form when page loads
		initializeAvailabilityForm();

		// Add form validation to the parent form
		const parentForm = document.querySelector('form');
		if (parentForm) {
			parentForm.addEventListener('submit', function(e) {
				if (!validateAvailabilityForm()) {
					e.preventDefault();
					return false;
				}
			});
		}

		// Expose functions globally for external use
		window.getAvailabilityData = function() {
			const hiddenInput = document.getElementById('working_days_input');
			return hiddenInput ? hiddenInput.value : '{}';
		};

		window.setAvailabilityData = function(data) {
			if (typeof data === 'string') {
				try {
					workingDays = JSON.parse(data);
				} catch (e) {
					console.error('Error parsing provided data:', e);
					return;
				}
			} else {
				workingDays = data;
			}
			initializeAvailabilityForm();
		};
	});
</script>
