@extends('frontend.provider.app')

@section('title', __('edit_staff'))

@section('content')
<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items"><a href="{{ route('provider.staffs') }}">{{ __('manage_staff') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('edit_staff')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('edit_staff')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>

    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <a href="{{ route('provider.staffs') }}" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4">
                        <i class="isax isax-arrow-left me-1"></i>{{__('back_to_staff')}}
                    </a>

                    <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard mb-4">
                        <li class="nav-item"><a class="nav-link active" id="info-tab" href="#info-content">{{__('information')}}</a></li>
                        <li class="nav-item"><a class="nav-link" id="avail-tab" href="#avail-content">{{__('availability')}}</a></li>
                    </ul>

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <form id="providerEditStaffForm"
                        method="POST"
                        enctype="multipart/form-data"
                        novalidate>
                        @csrf
                        <input type="hidden" name="id" value="{{ $staff['id'] }}">
                        <input type="hidden" name="parent_id" value="{{ Auth::user()->id }}">
                        <div class="form-wizard-content active" id="info-content">
                            @include('provider.staff.partials.form-information', ['staff' => $staff])

                            <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <a href="{{ route('provider.staffs') }}" class="btn btn-white d-flex align-items-center">{{__('Cancel')}}</a>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">
                                    {{__('Continue')}}<i class="isax isax-arrow-right-3 ms-2"></i>
                                </button>
                            </div>
                        </div>

                        <div class="form-wizard-content" id="avail-content">
                            @include('provider.staff.partials.form-availability', ['staff' => $staff])

                            <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center">
                                    <i class="isax isax-arrow-left-2 me-2"></i>{{__('Back')}}
                                </button>
                                <button type="submit" class="btn btn-secondary d-flex align-items-center">{{__('update_staff')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.body.setAttribute('data-provider', 'provider.edit_staff');
    });
    $(document).on("submit", "#providerEditStaffForm", function(e) {
        e.preventDefault(); // stop normal form submission

        let form = $(this);
        let formData = new FormData(this);
        let roleId = $("#role_id").val();
        formData.append("role_id", roleId); // support file uploads
        let url = '/provider/staff/save';

        $.ajax({
            url: url,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                // Optionally show loader or disable button
                form.find("button[type=submit]").prop("disabled", true).text("Updating...");
            },
            success: function(response) {
                if (response.code === 200) {
                    // Show success message
                    toastr.success(response.message);
                    form.find("button[type=submit]").prop("disabled", true).text("Updated");

                    // redirect or reload
                    setTimeout(() => {
                        window.location.href = "{{ route('provider.staffs') }}";
                    }, 500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    // Validation errors
                    let errors = xhr.responseJSON.errors;
                    let messages = Object.values(errors).flat().join("<br>");
                    toastr.error(messages);
                } else {
                    toastr.error(messages);
                }
            },
            complete: function() {
                form.find("button[type=submit]").prop("disabled", false).text("Update Staff");
            }
        });
    });
</script>
<script src="{{ asset('front/js/staff.js') }}"></script>
@endpush