@extends('frontend.provider.app')

@section('title', __('add_new_staff'))

@section('content')
<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items"><a href="{{ route('provider.staffs') }}">{{ __('manage_staff') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('add_new_staff')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('add_new_staff')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <a href="{{ route('provider.staffs') }}" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i class="isax isax-arrow-left me-1"></i>{{__('back_to_staff')}}</a>

                    <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard mb-4">
                        <li class="nav-item"><a class="nav-link active" id="info-tab" href="#info-content">{{__('information')}}</a></li>
                        <li class="nav-item"><a class="nav-link" id="avail-tab" href="#avail-content">{{__('availability')}}</a></li>
                    </ul>

                     @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form id="providerAddStaffForm" action="javascript:void(0);" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" id="parent_id" value="{{ Auth::user()->id }}">
                        <div class="form-wizard-content active" id="info-content">
                            @include('provider.staff.partials.form-information')
                             <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <a href="{{ route('provider.staffs') }}" class="btn btn-white d-flex align-items-center">{{__('Cancel')}}</a>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">{{__('Continue')}}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content" id="avail-content">
                           @include('provider.staff.partials.form-availability')
                           <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>{{__('Back')}}</button>
                                <button type="submit" class="btn btn-secondary d-flex align-items-center">{{__('Add Staff')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.body.setAttribute('data-provider', 'provider.staff.add');
});
</script>
<script src="{{ asset('front/js/staff.js') }}"></script>
@endpush
