@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('social_profiles')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('social_profiles')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <div>
                            <h4 class="mb-0">{{ __('social_profiles') }}</h4>
                            <p class="text-muted mb-0">{{ __('manage_social_profiles_description') }}</p>
                        </div>
                    </div>

                    <!-- Social Links Section -->
                    <div class="row">
                        <div class="col-12">
                            <form action="{{ route('provider.sociallinks.bulkUpdate') }}" method="POST">
                                @csrf
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">{{ __('social_profiles') }}</h5>
                                    </div>
                                    <div class="card-body">
                                        @foreach ($socialLinks as $index => $socialLink)
                                            @php
                                                $link = $providerSocialLinks->firstWhere('social_link_id', $socialLink->id);
                                            @endphp
                                            <div class="row align-items-center mb-3">
                                                <div class="col-md-4">
                                                    <label class="form-label">{{ __('platform') }}</label>
                                                    <input type="text" class="form-control" value="{{ $socialLink->platform_name }}" disabled>
                                                    <input type="hidden" name="profiles[{{ $index }}][social_link_id]" value="{{ $socialLink->id }}">
                                                    @if (isset($link->id))
                                                        <input type="hidden" name="profiles[{{ $index }}][id]" value="{{ $link->id }}">
                                                    @endif
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label">{{ __('url') }}</label>
                                                    <input type="url" name="profiles[{{ $index }}][link]"
                                                        class="form-control" placeholder="{{ __('url_placeholder') }}"
                                                        value="{{ isset($link->link) ? $link->link : '' }}">
                                                </div>

                                                <div class="col-md-2 d-flex align-items-center mt-4">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" type="checkbox"
                                                            name="profiles[{{ $index }}][status]"
                                                            {{ isset($link->status) && $link->status ? 'checked' : '' }}>
                                                        <label class="form-check-label">{{ __('active') }}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach

                                        <div class="d-flex justify-content-end mt-4">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="isax isax-tick-circle me-2"></i>{{ __('save_changes') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- End Social Links Section -->
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('/front/js/social-link.js') }}"></script>
@endpush