<div class="card">
    <div class="card-body">
        <div class="sub-header">
            <h5 class="mb-0">{{ __('Basic Information')}}</h5>
        </div>
        <div class="row g-3">
            <div class="col-lg-6">
                <label class="form-label">{{ __('shop_title')}} <span class="text-danger">*</span></label>
                <input type="text" name="shop_name" id="shop_name" class="form-control" value="{{ old('shop_name', $shop->shop_name ?? '') }}" required>
                <span class="invalid-feedback" id="shop_name_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{ __('owner_name')}} <span class="text-danger">*</span></label>
                <input type="text" name="owner_name" id="owner_name" class="form-control" value="{{ old('owner_name', $shop->owner_name ?? '') }}" required>
                <span class="invalid-feedback" id="owner_name_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{ __('mobile_number')}} <span class="text-danger">*</span></label>
                <input type="text" name="phone" id="phone" class="form-control" value="{{ old('phone', $shop->phone ?? '') }}" required>
                <span class="invalid-feedback" id="phone_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{ __('email')}} <span class="text-danger">*</span></label>
                <input type="email" name="email" id="email" class="form-control" value="{{ old('email', $shop->email ?? '') }}" required>
                <span class="invalid-feedback" id="email_error"></span>
            </div>
            <div class="col-lg-12">
                <label class="form-label">{{ __('Description')}} <span class="text-danger">*</span></label>
                <textarea id="description" name="description" class="form-control" required>{{ old('description', $shop->description ?? '') }}</textarea>
                <span class="invalid-feedback" id="description_error"></span>
            </div>
            <div class="col-lg-6">
                <div class="d-flex align-items-center gap-3">
                    <label class="form-label me-2 mb-0">{{__('is_shop_under_tax')}} <span class="text-danger">*</span></label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="tax_status" id="tax_yes" value="1" {{ old('tax_status', $shop->tax_status ?? 1) == 1 ? 'checked' : '' }}>
                        <label class="form-check-label" for="tax_yes">{{__('Yes')}}</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="tax_status" id="tax_no" value="0" {{ old('tax_status', $shop->tax_status ?? 1) == 0 ? 'checked' : '' }}>
                        <label class="form-check-label" for="tax_no">{{__('no')}}</label>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 {{ old('tax_status', $shop->tax_status ?? 1) == 0 ? 'd-none' : '' }}" id="tax-number-field">
                <label class="form-label">{{__('tax_number')}} <span class="text-danger">*</span></label>
                <input type="text" name="tax_number" id="tax_number" class="form-control" value="{{ old('tax_number', $shop->tax_number ?? '') }}" required>
                <span class="invalid-feedback" id="tax_number_error"></span>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="sub-header">
            <h5 class="mb-0">{{__('address_information')}}</h5>
        </div>
        <div class="row g-3">
            <div class="col-12">
                <label class="form-label">{{__('address')}} <span class="text-danger">*</span></label>
                <input type="text" name="address" id="address" class="form-control" value="{{ old('address', $shop->address ?? '') }}" required>
                <span class="invalid-feedback" id="address_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{__('country')}} <span class="text-danger">*</span></label>
                <select class="form-control searchable-select" name="country" id="country" required>
                    <option value="">{{__('select_country')}}</option>
                    @foreach($countries as $country)
                    <option value="{{ $country->id }}" {{ old('country', $shop->country ?? '') == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                    @endforeach
                </select>
                <span class="invalid-feedback" id="country_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{__('state')}} <span class="text-danger">*</span></label>
                <select class="form-control searchable-select" name="state" id="state" required>
                    <option value="">Select a State</option>
                    @foreach($states as $state)
                    <option value="{{ $state->id }}" {{ old('state', $shop->state ?? '') == $state->id ? 'selected' : '' }}>
                        {{ $state->name }}
                    </option>
                    @endforeach
                </select>
                <span class="invalid-feedback" id="state_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{__('city')}} <span class="text-danger">*</span></label>
                <select class="form-control searchable-select" name="city" id="city" required>
                    @foreach($cities as $city)
                    <option value="{{ $city->id }}" {{ old('city', $shop->city ?? '') == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
                    @endforeach
                </select>
                <span class="invalid-feedback" id="city_error"></span>
            </div>
            <div class="col-lg-6">
                <label class="form-label">{{__('postal_code')}} <span class="text-danger">*</span></label>
                <input type="text" name="zip_code" id="zip_code" class="form-control" value="{{ old('zip_code', $shop->zip_code ?? '') }}" required>
                <span class="invalid-feedback" id="zip_code_error"></span>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="sub-header">
            <h5 class="mb-0">{{__('Gallery')}}</h5>
        </div>
        <h6 class="mb-3">{{__('shop_logo')}} <span class="text-danger">*</span></h6>
        <div class="file-upload w-100 d-flex align-items-center justify-content-center flex-column mb-3">
             <img src="{{ asset('assets/img/icons/upload.svg') }}" class="img-fluid mb-3" alt="upload">
             <p class="mb-0">{{__('rag and drop or')}} <span class="text-secondary">{{__('browse')}}</span></p>
             <input type="file" name="shop_logo" id="shop-logo-upload" accept="image/*">
        </div>
        <div class="avatar-preview mb-3 {{ isset($shop->shop_logo) ? '' : 'd-none' }}">
            <img id="shop-logo-preview-img" src="{{ isset($shop->shop_logo) ? asset('storage/' . $shop->shop_logo) : '#' }}" alt="Shop Logo Preview" width="200" height="200" class="object-fit-cover rounded" />
        </div>
        <span class="invalid-feedback" id="shop_logo_error"></span>


        <h6 class="mb-3">{{__('shop_images')}}</h6><p>{{__('recommended')}}</p>
        <div class="file-upload w-100 d-flex align-items-center justify-content-center flex-column mb-3">
            <img src="{{ asset('assets/img/icons/upload.svg') }}" class="img-fluid mb-3" alt="upload">
            <p class="mb-0">Drag & Drop or <span class="text-secondary">{{__('browse')}}</span></p>
            <input type="file" name="gallery[]" id="gallery-upload" accept="image/*" multiple>
        </div>

        <div class="d-flex align-items-center gap-3 flex-wrap" id="gallery-preview-container">
            @if(isset($shop->gallery) && is_array($shop->gallery))
                @foreach($shop->gallery as $image)
                    <div class="gallery-item existing-image" data-path="{{ $image }}">
                        <img src="{{ asset('storage/' . $image) }}" alt="Img" class="gallery-thumbnail rounded">
                        <button type="button" class="btn btn-sm btn-danger remove-gallery-item-btn">&times;</button>
                    </div>
                @endforeach
            @endif
        </div>

        <div id="removed-images-container"></div>
    </div>
</div>