<div class="card">
    <div class="card-body">
        <div class="sub-header">
            <h5 class="mb-0">{{ __('availability') }}</h5>
        </div>
        <div class="accordion available-accordion">
             <div class="accordion-item">
                <div class="accordion-header d-flex justify-content-between align-items-center">
                    <button class="accordion-button fw-semibold collapsed" type="button" disabled>
                       {{ __('all_days') }}
                    </button>
                    <div class="form-check form-switch ms-3">
                        <input class="form-check-input" type="checkbox" role="switch" id="all-days-switch">
                    </div>
                </div>
            </div>

            @php
                $days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
                // Use the passed-in variable, or an empty array for the create form
                $availability = $shopWorkingDays ?? [];
            @endphp

            @foreach($days as $day)
                @php
                    $isChecked = isset($availability[strtolower($day)]);
                    $startTime = $isChecked ? $availability[strtolower($day)]['start_time'] : '';
                    $endTime = $isChecked ? $availability[strtolower($day)]['end_time'] : '';
                @endphp
                <div class="accordion-item">
                    <div class="accordion-header d-flex justify-content-between align-items-center">
                        <button class="accordion-button fw-semibold {{ $isChecked ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapse-{{$day}}">
                            {{ ucfirst($day) }}
                        </button>
                        <div class="form-check form-switch ms-3">
                            <input class="form-check-input day-switch" type="checkbox" name="availability[{{$day}}][status]" role="switch" data-day="{{$day}}" {{ $isChecked ? 'checked' : '' }}>
                        </div>
                    </div>
                    <div id="time-collapse-{{$day}}" class="accordion-collapse collapse {{ $isChecked ? 'show' : '' }}">
                        <div class="accordion-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('start_time') }}</label>
                                    <input type="time" name="availability[{{$day}}][start_time]" class="form-control time-input" value="{{ $startTime }}" data-day="{{$day}}" {{ $isChecked ? '' : 'disabled' }}>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('end_time') }}</label>
                                    <input type="time" name="availability[{{$day}}][end_time]" class="form-control time-input" value="{{ $endTime }}" data-day="{{$day}}" {{ $isChecked ? '' : 'disabled' }}>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>