@extends('frontend.provider.app')

@section('title', 'Manage Shops')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('manage_shops') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('manage_shops') }}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>

    <div class="content">
        <div class="container">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{ __('manage_shops') }}</h4>
                        <a href="{{ route('provider.shops.create') }}" class="btn btn-secondary d-inline-flex align-items-center"><i class="isax isax-add-circle me-2"></i>Add Shop</a>
                    </div>

                    <ul class="nav nav-tabs nav-solid-primary wishlist-tab mb-4">
                        <li class="nav-item"><a class="nav-link active" href="#active-shop" data-bs-toggle="tab">{{ __('Active') }}</a></li>
                        <li class="nav-item"><a class="nav-link" href="#inactive-shop" data-bs-toggle="tab">{{ __('Inactive') }}</a></li>
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="active-shop">
                            <div class="row row-gap-4 justify-content-center">
                                @forelse($activeShops as $shop)
                                    @include('provider.shops.partials.shop-card', ['shop' => $shop, 'isActive' => true])
                                @empty
                                    <p class="text-center col-12">{{ __('no_active_shops') }}</p>
                                @endforelse
                            </div>
                            <div class="mt-4">{{ $activeShops->links('pagination::bootstrap-5') }}</div>
                        </div>

                        <div class="tab-pane fade" id="inactive-shop">
                            <div class="row row-gap-4 justify-content-center">
                                @forelse($inactiveShops as $shop)
                                    @include('provider.shops.partials.shop-card', ['shop' => $shop, 'isActive' => false])
                                @empty
                                    <p class="text-center col-12">{{ __('no_active_shops') }}</p>
                                @endforelse
                            </div>
                            <div class="mt-4">{{ $inactiveShops->links('pagination::bootstrap-5') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@foreach($activeShops->merge($inactiveShops) as $shop)
    @include('provider.shops.partials.status-modal', ['shop' => $shop, 'newStatus' => 0, 'modalId' => 'inactive_modal_'.$shop->id, 'actionText' => 'Inactive'])
    @include('provider.shops.partials.status-modal', ['shop' => $shop, 'newStatus' => 1, 'modalId' => 'active_modal_'.$shop->id, 'actionText' => 'Active'])
    @include('provider.shops.partials.delete-modal', ['shop' => $shop])
@endforeach

@endsection

@push('scripts')
<script src="{{ asset('front/js/shop-index.js') }}"></script>
@endpush
