@extends('frontend.provider.app')

@section('title', 'Add New Shop')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items"><a href="{{ route('provider.shops.index') }}">{{ __('manage_shops') }}</a></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('add_shop') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('add_new_shop') }}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>

    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <a href="{{ route('provider.shops.index') }}" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i class="isax isax-arrow-left me-1"></i>{{ __('Back') }}</a>

                    <div class="d-flex justify-content-between mb-4">
                        <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard">
                            <li class="nav-item"><a class="nav-link active" id="info-tab" href="javascript:void(0);">{{ __('information') }}</a></li>
                            <li class="nav-item"><a class="nav-link" id="avail-tab" href="javascript:void(0);">{{ __('availability') }}</a></li>
                        </ul>
                    </div>

                    @if ($errors->any())
                    <div class="alert alert-danger" id="form-errors">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    <div class="alert alert-danger d-none" id="validation-errors"></div>


                    <form id="create-shop-form" class="shop-form" action="{{ route('provider.shops.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="description" id="description-input">

                        <div class="form-wizard-content active" id="info-content">
                            @include('provider.shops.partials.form-information')
                            <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <a href="{{ route('provider.shops.index') }}" class="btn btn-white d-flex align-items-center">{{ __('Cancel') }}</a>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center" id="next-btn">{{ __('Continue') }}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content" id="avail-content">
                            @include('provider.shops.partials.form-availability')
                            <div class="d-flex align-items-center justify-content-end gap-3 mt-4">
                                <button type="button" class="btn btn-white prev-btn d-flex align-items-center" id="prev-btn"><i class="isax isax-arrow-left-2 me-2"></i>{{ __('Back') }}</button>
                                <button type="submit" class="btn btn-secondary d-flex align-items-center">{{ __('add_shop') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('front/js/shop.js') }}"></script>
@endpush