@extends('frontend.provider.app')

@section('title', __('manage_reviews'))

@section('content')
<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('manage_reviews')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('manage_reviews')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')
                <div class="col-xl-9 col-lg-8">

                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{ __('product_reviews_ratings') }}</h4>
                    </div>

                    <div id="ratings-container"></div>

                    <div id="loader" class="text-center py-4" style="display: none;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">{{ __('loading') }}</span>
                        </div>
                    </div>

                    <div id="no-ratings-message" class="card card-body text-center" style="display: none;">
                        <p class="mb-0">{{ __('no_reviews_message') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="add-reply-modal" tabindex="-1" aria-labelledby="addReplyLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="add-reply-form">
                <div class="modal-header">
                    <h5 class="modal-title" id="addReplyLabel">{{ __('add_your_reply') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="parent_id" id="reply-parent-id">
                    <div class="mb-3">
                        <label for="reply-text" class="form-label">{{ __('your_reply') }}</label>
                        <textarea class="form-control" name="reply_text" id="reply-text" rows="5" required placeholder="{{ __('write_your_response') }}"></textarea>
                        <div class="invalid-feedback" id="reply-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('submit_reply') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="delete-rating-modal" tabindex="-1" aria-labelledby="deleteRatingLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="delete-rating-form">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteRatingLabel">{{ __('delete_review') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="delete-rating-id">
                    <p>{{ __('delete_review_confirmation') }}</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-danger">{{ __('delete_review') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('front/js/review.js') }}"></script>
@endpush
