@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            {{-- Breadcrumb content --}}
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Dashboard') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('Dashboard') }}</h1>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')
                <div class="col-xl-9 col-lg-8">

                    <!-- Page Header -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{ __('Dashboard') }}</h4>
                    </div>
                    <!-- End Page Header -->

                    <!-- Summary Cards -->
                    <div class="row justify-content-center">
                        <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
                            <div class="dashboard-item w-100">
                                <div class="summary-loader"></div>
                                <div class="avatar avatar-lg bg-soft-pink text-pink mb-2"> <i class="isax isax-money-send5 fs-24"></i> </div>
                                <div class="d-flex align-items-center justify-content-between flex-wrap gap-2" style="visibility: hidden;">
                                    <div>
                                        <h6 class="mb-1 fs-16 fw-medium text-body">{{__('Completed Bookings')}}</h6>
                                        <h3 class="d-inline-flex align-items-center flex-wrap mb-0"><span id="completed-bookings-count">0</span> <span id="completed-bookings-percentage" class="badge badge-xs badge-soft-success d-inline-flex align-items-center mx-1"><i class="isax isax-trend-up me-1"></i>0%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
                            <div class="dashboard-item w-100">
                                <div class="summary-loader"></div>
                                <div class="avatar avatar-lg bg-soft-orange text-orange mb-2"> <i class="isax isax-box fs-24"></i> </div>
                                <div class="d-flex align-items-center justify-content-between flex-wrap gap-2" style="visibility: hidden;">
                                    <div>
                                        <h6 class="mb-1 fs-16 fw-medium text-body">{{__('Total Sales')}}</h6>
                                        <h3 class="d-inline-flex align-items-center flex-wrap mb-0"><span id="total-sales-count">0</span> <span id="total-sales-percentage" class="badge badge-xs badge-soft-success d-inline-flex align-items-center mx-1"><i class="isax isax-trend-up me-1"></i>0%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
                            <div class="dashboard-item w-100">
                                <div class="summary-loader"></div>
                                <div class="avatar avatar-lg bg-soft-cyan text-cyan mb-2"> <i class="isax isax-dollar-circle fs-24"></i> </div>
                                <div class="d-flex align-items-center justify-content-between flex-wrap gap-2" style="visibility: hidden;">
                                    <div>
                                        <h6 class="mb-1 fs-16 fw-medium text-body">{{__('Total_Earnings')}}</h6>
                                        <h3 class="d-inline-flex align-items-center flex-wrap mb-0"><span id="total-earnings-amount">$0</span> <span id="total-earnings-percentage" class="badge badge-xs badge-soft-success d-inline-flex align-items-center mx-1"><i class="isax isax-trend-up me-1"></i>0%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-7">
                            <div class="card">
                                <div class="card-body pb-0">
                                    <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2 mb-0">
                                        <h5 class="mb-0">{{__('Total Bookings')}}</h5>
                                        <p class="fs-13 d-inline-flex align-items-center"><i class="fa-solid fa-square fs-12 text-primary me-1"></i>{{__('Bookings')}}</p>
                                    </div>
                                    <div id="booking-chart">
                                        <div class="chart-loader"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5">
                            <div class="card" id="highly-booked">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{__('Highly Booked Categories')}}</h5>
                                    </div>
                                    <div id="highly-booked-categories">
                                        @for ($i = 0; $i < 4; $i++)<div class="d-flex align-items-center justify-content-between gap-2 mb-3 skeleton-loader">
                                            <div class="placeholder-glow w-100"><span class="placeholder col-12"></span></div>
                                    </div>@endfor
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        <div class="card" id="recent-bookings">
                            <div class="card-body pb-1">
                                <div class="sub-header">
                                    <h5 class="mb-0">{{__('Recently Selled Products')}}</h5>
                                </div>
                                <div id="recently-selled-products">
                                    @for ($i = 0; $i < 3; $i++)<div class="d-flex align-items-center justify-content-between gap-2 mb-3 skeleton-loader">
                                        <div class="d-flex align-items-center overflow-hidden placeholder-glow"><span class="placeholder avatar avatar-lg flex-shrink-0 me-2"></span>
                                            <div class="flex-grow-1 overflow-hidden"><span class="placeholder col-8"></span><span class="placeholder col-5"></span></div>
                                        </div>
                                        <div class="placeholder-glow"><span class="placeholder col-12"></span></div>
                                </div>@endfor
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card" id="recent-bookings">
                        <div class="card-body pb-1">
                            <div class="sub-header">
                                <h5 class="mb-0">{{__('Recently Booking Services')}}</h5>
                            </div>
                            <div id="recently-booked-services">
                                @for ($i = 0; $i < 3; $i++)<div class="d-flex align-items-center justify-content-between gap-2 mb-3 skeleton-loader">
                                    <div class="d-flex align-items-center overflow-hidden placeholder-glow"><span class="placeholder avatar avatar-lg flex-shrink-0 me-2"></span>
                                        <div class="flex-grow-1 overflow-hidden"><span class="placeholder col-8"></span><span class="placeholder col-5"></span></div>
                                    </div>
                                    <div class="placeholder-glow text-end"><span class="placeholder col-12"></span></div>
                            </div>@endfor
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card mb-0">
            <div class="card-body">
                <div class="sub-header">
                    <h5 class="mb-0">{{__('total_transactions')}}</h5>
                </div>
                <div class="table-responsive table-nowrap">
                    <table class="table border mb-0">
                        <thead>
                            <tr>
                                <th>{{__('invoice_id')}}</th>
                                <th>{{__('Customer')}}</th>
                                <th>{{__('Description')}}</th>
                                <th>{{__('amount_paid')}}</th>
                                <th>{{__('Payment Method')}}</th>
                                <th>{{__('payment_date')}}</th>
                            </tr>
                        </thead>
                        <tbody id="transactions-table-body">
                            @for ($i = 0; $i < 5; $i++)
                                <tr class="skeleton-loader">
                                <td class="placeholder-glow"><span class="placeholder col-8"></span></td>
                                <td class="placeholder-glow"><span class="placeholder col-12"></span></td>
                                <td class="placeholder-glow"><span class="placeholder col-10"></span></td>
                                <td class="placeholder-glow"><span class="placeholder col-6"></span></td>
                                <td class="placeholder-glow"><span class="placeholder col-7"></span></td>
                                <td class="placeholder-glow"><span class="placeholder col-9"></span></td>
                                </tr>
                                @endfor
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/plugins/apexchart/apexcharts.min.js') }}"></script>
<script src="{{ asset('front/js/provider-dashboard.js') }}"></script>
<script src="{{ asset('assets/plugins/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('assets/plugins/apexchart/chart-data.js') }}"></script>
@endpush