@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('Settings')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('Change Password')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">

            <!-- start row -->
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5>{{__('Change Password')}}</h5>
                    </div>
                    <hr>
                    <!-- Change Password Section -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <!-- start row -->
                            <form id="changePasswordForm" method="post" class="mb-4 pb-4 border-bottom">
                                <input type="hidden" name="id" id="id" value="{{ $data }}">
                                <div class="row row-gap-3">
                                    <div class="col-md-4">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('Current Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-input" name="current_password" id="current_password" placeholder="**********">
                                                <span class="input-group-text toggle-password">
                                                    <i class="isax isax-eye-slash text-dark ti ti-eye-off"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="current_password_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('New Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-inputs" name="new_password" id="new_password" placeholder="**********">
                                                <span class="input-group-text toggle-passwords">
                                                    <i class="isax isax-eye-slash text-dark ti ti-eye-off"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="new_password_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-0">
                                            <label class="form-label">{{__('Confirm Password')}}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text">
                                                    <i class="isax isax-lock text-dark"></i>
                                                </span>
                                                <input type="password" class="form-control pass-inputa" name="confirm_password" id="confirm_password" placeholder="**********">
                                                <span class="input-group-text toggle-passworda">
                                                    <i class="isax isax-eye-slash text-dark ti ti-eye-off"></i>
                                                </span>
                                            </div>
                                            <span class="text-danger error-text" id="confirm_password_error"></span>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <!-- end row -->

                            <div class="d-flex align-items-center justify-content-end">
                                <a href="javascript:void(0);" class="btn btn-light me-2">{{__('Cancel')}}</a>
                                <button class="btn btn-secondary" id="change_password" type="submit" form="changePasswordForm">{{__("Save Changes")}}</button>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div>
            </div>
            <!-- /Page Wrapper -->
        </div>
    </div>
</div>

@endsection