@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">

    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('provider.dashboard') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('manage_service') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('manage_service') }}</h1>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <div>
                            <h4 class="mb-0">{{ __('my_service') }}</h4>
                            <p class="text-muted mb-0">{{ __('manage_active_inactive_service') }}</p>
                        </div>
                        <button class="btn btn-secondary d-inline-flex align-items-center" id="providerAddService">
                            <i class="isax isax-add-circle me-2"></i>{{ __('add_service') }}
                            <input type="hidden" name="auth_id" id="auth_id" value="{{ $userId }}">
                        </button>
                    </div>
                    <div class="d-flex justify-content-between flex-wrap gap-3 mb-4">
                        <ul class="nav nav-tabs nav-solid-primary wishlist-tab">
                            <li class="nav-item"><a class="nav-link active" href="#active-product" data-bs-toggle="tab" data-status="active">{{ __('active') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="#inactive-product" data-bs-toggle="tab" data-status="inactive">{{ __('inactive') }}</a></li>
                        </ul>
                        <div>
                            <select class="form-select" id="shop-filter">
                                <option value="">{{ __('all_shops') }}</option>
                                @foreach($shopList as $shop)
                                <option value="{{ $shop->id }}">{{ $shop->shop_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="active-product">
                            <div id="active-product-list" class="row row-gap-4 justify-content-center">
                                <div class="col-12 text-center p-5" id="active-loader">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">{{ __('loading') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="inactive-product">
                            <div id="inactive-product-list" class="row row-gap-4 justify-content-center">
                                <div class="col-12 text-center p-5" id="inactive-loader">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">{{ __('loading') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="delete-modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form>
                <div class="modal-body text-center">
                    <span class="delete-icon">
                        <i class="ti ti-trash-x"></i>
                    </span>
                    <h4>{{ __('confirm_deletion') }}</h4>
                    <p>{{ __('delete_confirmation_message') }}</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('cancel') }}</a>
                        <button type="submit" class="btn btn-danger" id="confirmDelete">{{ __('yes_delete') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="no_sub" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="warning-icon mx-auto mb-4">
                        <i class="ti ti-alert-circle"></i>
                    </span>
                    <h4 class="mb-1">{{ __('no_active_subscription') }}</h4>
                    <p class="text-muted">
                        {{ __('no_subscription_message') }}
                    </p>
                    <a href="{{ route('provider.subscription') }}" class="btn btn-linear-primary">{{ __('get_subscription') }}</a>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" class="btn btn-outline-secondary">{{ __('close') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="sub_count_end" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="warning-icon mx-auto fs-2 mb-4">
                        <i class="ti ti-alert-circle"></i>
                    </span>
                    <h4 class="mb-1">{{ __('service_limit_reached') }}</h4>
                    <p class="text-muted">
                        {{ __('service_limit_message') }}
                    </p>
                    <a href="{{ route('provider.subscription') }}" class="btn btn-linear-primary">{{ __('renew_subscription') }}</a>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" class="btn btn-outline-secondary text-end">{{ __('close') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="sub_end" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="warning-icon mx-auto fs-2 mb-4">
                        <i class="ti ti-alert-circle"></i>
                    </span>
                    <h4 class="mb-1">{{ __('subscription_ended') }}</h4>
                    <p class="text-muted">
                        {{ __('subscription_ended_message') }}
                    </p>
                    <a href="{{ route('provider.subscription') }}" class="btn btn-linear-primary">{{ __('renew_subscription') }}</a>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" class="btn btn-outline-secondary text-end">{{ __('close') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection