@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">

    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="index.html">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('edit_service') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('edit_service') }}</h1>
            </div>
        </div>
        <img src="{{ asset('/frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="container">

            <div class="row">

                <div class="col-xl-10 mx-auto">

                    <a href="{{ route('provider.service') }}" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i class="isax isax-arrow-left me-1"></i>{{ __('back_to_services') }}</a>

                    <div class="d-flex justify-content-between mb-4">
                        <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard">
                            <li class="nav-item"><a class="nav-link active" href="javascript:void(0);">{{ __('information') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('availability') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('location') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('gallery') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('seo') }}</a></li>
                        </ul>
                    </div>

                    <form id="edit-service-form">
                        <input type="hidden" name="userLangId" id="userLangId" value="{{ $userLangId }}">
                        {{-- This is crucial for the update action --}}
                        <input type="hidden" name="id" id="id" value="{{ $service->id }}">

                        <div class="form-wizard-content active">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('service_information') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('service_title') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="service_name" id="service_name" class="form-control" value="{{ $service->source_name }}" required>
                                        </div>
                                         <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('product_code') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="product_code" id="product_code" class="form-control" value="{{ $service->source_code }}" required>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('shop') }} <span class="text-danger">*</span></label>
                                            <select class="form-select" name="shop_id" id="shop_id" required>
                                                <option value="">{{ __('select_shop') }}</option>
                                                @foreach ($shopList as $shop)
                                                <option value="{{ $shop->id }}" {{ $service->shop_id == $shop->id ? 'selected' : '' }}>{{ $shop->shop_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('category') }} <span class="text-danger">*</span></label>
                                            <select class="select categoryProviderSelect form-select" name="category" id="category" required>
                                                <option value="">{{ __('select_category') }}</option>
                                                @foreach ($categoriesLang as $category)
                                                <option value="{{ $category->id }}" {{ $service->source_category == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('sub_category') }} <span class="text-danger">*</span></label>
                                            <select class="select subcategories form-select" name="sub_category" id="sub_category" data-selected-id="{{ $service->source_subcategory }}" required>
                                                @foreach($subcategories as $subcategory)
                                                <option value="{{ $subcategory->id }}" {{ $service->source_subcategory == $subcategory->id ? 'selected' : '' }}>{{ $subcategory->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('price') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="service_price" id="service_price" class="form-control" value="{{ $service->source_price }}" required>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label" for="price_type">{{ __('price_type') }}
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select name="price_type" id="price_type" class="form-control field-input" required>
                                                    <option value="">{{ __('select_price_type') }}</option>
                                                    <option value="fixed" {{ $service->price_type == 'fixed' ? 'selected' : '' }}>{{ __('fixed') }}</option>
                                                    <option value="hourly" {{ $service->price_type == 'hourly' ? 'selected' : '' }}>{{ __('hourly') }}</option>
                                                    <option value="minute" {{ $service->price_type == 'minute' ? 'selected' : '' }}>{{ __('minutes') }}</option>
                                                    <option value="squre-metter" {{ $service->price_type == 'squre-metter' ? 'selected' : '' }}>{{ __('square_meter') }}</option>
                                                    <option value="square-feet" {{ $service->price_type == 'square-feet' ? 'selected' : '' }}>{{ __('square_feet') }}</option>
                                                </select>
                                            </div>
                                        </div>
                                        @php
                                        $duration_parts = explode(':', $service->duration);
                                        $hours = $duration_parts[0] ?? '0';
                                        $minutes = $duration_parts[1] ?? '0';
                                        @endphp
                                        <div class="col-xl-3 col-md-6">
                                            <div class="mb-3 hours-section" style="display: none;">
                                                <label class="form-label">{{ __('add_duration_hours') }}
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" name="duration_hours" id="hours_select" class="form-control" value="{{ $hours }}" maxlength="2">
                                            </div>
                                            <div class="mb-3 minutes-section" style="display: none;">
                                                <label class="form-label">{{ __('add_minutes') }}
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select id="minutes_select" name="duration_minute" class="form-control">
                                                    <option value="">{{ __('select_minutes') }}</option>
                                                    @for ($minute = 0; $minute < 60; $minute +=5)
                                                        <option value="{{ $minute }}" {{ $minutes == $minute ? 'selected' : ''}}>
                                                        {{ str_pad($minute, 2, '0', STR_PAD_LEFT) }} {{ __('minute') }}{{ $minute != 1 ? 's' : '' }}
                                                        </option>
                                                        @endfor
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('description') }}</label>
                                            <textarea name="description" id="description" class="form-control" rows="5">{{ $service->source_description }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header d-flex justify-content-between align-items-center">
                                        <h5 class="mb-0">{{ __('additional_service') }}</h5>
                                        <a href="javascript:void(0);" class="btn btn-primary btn-sm" id="add-additional-service-btn">
                                            <i class="isax isax-add-circle me-1"></i> {{ __('add_service') }}
                                        </a>
                                    </div>
                                    <div id="additional-services-container" class="mt-3">
                                        @foreach($service->variations as $variation)
                                        <div class="row align-items-center g-3 additional-service-row mb-3">
                                            <div class="col-xl-4 col-lg-6">
                                                <label class="form-label">{{ __('service_title') }}</label>
                                                <input type="text" name="add_name[]" class="form-control" value="{{ $variation->name }}">
                                            </div>
                                            <div class="col-xl-3 col-lg-6">
                                                <label class="form-label">{{ __('price') }}</label>
                                                <input type="text" name="add_price[]" class="form-control" value="{{ $variation->price }}">
                                            </div>
                                            <div class="col-xl-3 col-lg-6">
                                                <label class="form-label">{{ __('duration_hrs') }}</label>
                                                <input type="text" name="add_duration[]" class="form-control" value="{{ $variation->duration }}">
                                            </div>
                                            <div class="col-xl-2 col-lg-6 text-end">
                                                <label class="form-label d-block">&nbsp;</label>
                                                <a href="javascript:void(0);" class="btn btn-icon btn-light-danger rounded fs-16 flex-shrink-0 remove-service-row"><i class="isax isax-trash"></i></a>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <a class="btn btn-white d-flex align-items-center" href="#">{{ __('cancel') }}</a>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('availability') }}</h5>
                                    </div>
                                    <div class="accordion available-accordion">
                                        <div class="col-xl-12 col-md-6" id="slotData">
                                            <div class="mb-3 p-1" style="margin-top: 10px;">
                                                @foreach (['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
                                                @php
                                                $isAvailable = isset($availability[$day]);
                                                @endphp
                                                <div class="mb-4" id="{{ strtolower($day) }}Data">
                                                    <div class="d-flex gap-2 mb-2">
                                                        <input type="checkbox" name="day_checkbox[]" id="{{ strtolower($day) }}_checkbox" value="{{ $day }}" {{ $isAvailable ? 'checked' : '' }}>
                                                        <h6 style="margin-top: 5.2px;">{{ __(strtolower($day)) }}</h6>
                                                        <a class="add-time-btn" style="margin-top: 0px; cursor: pointer;">
                                                            <i class="ti ti-plus me-2 fw-bold" style="font-size: 15px;"></i>
                                                        </a>
                                                    </div>
                                                    <div id="slotinputs">
                                                        @if($isAvailable)
                                                        @foreach($availability[$day] as $slot)
                                                        <div class="d-flex gap-3 mt-2 additional-time">
                                                            <input type="time" class="form-control start_time" name="start_time[{{ $day }}][]" value="{{ $slot->start_time }}" required>
                                                            <input type="time" class="form-control end_time" name="end_time[{{ $day }}][]" value="{{ $slot->end_time }}" readonly>
                                                            <a class="p-1 rounded-0 remove-time-btn" style="margin-top: 5px; cursor: pointer;">
                                                                <i class="ti ti-trash me-2 fw-bold fs-4"></i>
                                                            </a>
                                                        </div>
                                                        @endforeach
                                                        @endif
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('location') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('address') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="address" id="address" class="form-control" value="{{ $service->address }}" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('country') }} <span class="text-danger">*</span></label>
                                            <select class="select" id="country" name="country" data-selected-id="{{ $service->country }}" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('state') }} <span class="text-danger">*</span></label>
                                            <select class="select" id="state" name="state" data-selected-id="{{ $service->state }}" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('city') }} <span class="text-danger">*</span></label>
                                            <select class="select" id="city" name="city" data-selected-id="{{ $service->city }}" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('postal_code') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="pincode" id="pincode" class="form-control" value="{{ $service->pincode }}" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('gallery') }}</h5>
                                    </div>
                                    <div class="mb-3">
                                        <h6 class="mb-3">{{ __('service_images') }}</h6>
                                        <div class="file-upload w-100 d-flex align-items-center justify-content-center flex-column mb-3">
                                            <p class="mb-0">{{ __('drag_drop_or_browse_more') }}</p>
                                            <input type="file" name="service_images[]" id="service_images" accept="image/*" multiple>
                                        </div>
                                        <h6 class="fs-16 fw-medium mb-2">{{ __('image_previews') }}</h6>
                                        <div id="image_preview_container" class="d-flex align-items-center gap-3 flex-wrap">
                                            @foreach($service->productImages as $image)
                                            <div class="text-center gallery-preview-item" data-id="{{ $image->id }}">
                                                <div class="gallery-upload-img mb-2">
                                                    <img src="{{ asset('storage/' . $image->source_Values) }}" alt="Service Image">
                                                    <span class="trash-icon d-flex align-items-center justify-content-center gallery-trash-existing"><i class="isax isax-close-circle5"></i></span>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                        <input type="hidden" name="deleted_images" id="deleted_images">
                                    </div>
                                    <div>
                                        <div>
                                            <h6 class="mb-3">{{ __('service_video') }}</h6>
                                            <label class="form-label">{{ __('video_link') }}</label>
                                            <input type="text" name="service_video" id="service_video" class="form-control" value="{{ $video_link }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('seo') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('meta_title') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="seo_title" id="seo_title" class="form-control" value="{{ $service->seo_title }}" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('meta_keywords') }} <span class="text-danger">*</span></label>
                                            <input class="input-tags form-control" name="seo_tag" id="seo_tag" type="text" data-role="tagsinput" value="{{ $service->tags }}" required>
                                        </div>
                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('meta_description') }} <span class="text-danger">*</span></label>
                                            <textarea name="seo_description" id="seo_description" class="form-control" rows="4" required>{{ $service->seo_description }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button" class="btn btn-secondary" id="submit_service_btn">{{ __('update_service') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="provider_service_success_modal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="success-icon mx-auto mb-4">
                        <i class="ti ti-check"></i>
                    </span>
                    <h4 class="mb-1">{{ __('service_updated_successfully') }}</h4>
                    <p>{{ __('service_under_review_message') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
    // --- INITIALIZATIONS ---
    if ($('.select').length > 0) {
        $('.select').select2({
            minimumResultsForSearch: -1,
            width: '100%'
        });
    }

    // --- JQUERY VALIDATE SETUP ---
    var form = $("#edit-service-form");
    form.validate({
        errorElement: 'span',
        errorClass: 'error',
        ignore: ":hidden",
        errorPlacement: function(error, element) {
            if (element.parent('.input-group').length || element.hasClass('select')) {
                error.insertAfter(element.next('span.select2'));
            } else {
                error.insertAfter(element);
            }
        },
        rules: {
            service_price: {
                required: true,
                number: true
            },
            pincode: {
                required: true,
                number: true
            }
        },
        messages: {
            service_name: "Please enter a service title.",
            shop_id: "Please select a shop.",
            category: "Please select a category.",
            sub_category: "Please select a sub category.",
            service_price: {
                required: "Please enter a price.",
                number: "Please enter a valid number."
            },
            duration_hours: {
                required: "Please enter a duration.",
                number: "Please enter a valid number."
            },
            duration_minute: "Please select minutes.",
            product_code: "Please enter the product code.",
            address: "Please enter an address.",
            country: "Please select a country.",
            state: "Please select a state.",
            city: "Please select a city.",
            pincode: "Please enter a valid postal code.",
            seo_title: "Please enter a meta title.",
            seo_tag: "Please enter meta keywords.",
            seo_description: "Please enter a meta description."
        }
    });

    // --- INITIAL DATA POPULATION ---
    $('#price_type').trigger('change');

    // --- BULLETPROOF WIZARD NAVIGATION LOGIC ---
    // Initialize current step
    let currentStep = 0;
    const totalSteps = 5;

    // Step names for debugging
    const stepNames = ['Information', 'Availability', 'Location', 'Gallery', 'SEO'];

    // Function to activate specific step
    function activateStep(stepIndex) {
        // Ensure step is within bounds
        if (stepIndex < 0 || stepIndex >= totalSteps) {
            console.log('Step out of bounds:', stepIndex);
            return false;
        }

        // Remove active from all tabs and contents
        $('.add-wizard .nav-link').removeClass('active');
        $('.form-wizard-content').removeClass('active');

        // Add active to specific step
        $('.add-wizard .nav-link').eq(stepIndex).addClass('active');
        $('.form-wizard-content').eq(stepIndex).addClass('active');

        // Update current step
        currentStep = stepIndex;

        console.log('Activated step:', stepIndex, stepNames[stepIndex]);
        return true;
    }

    // Next button handler
    $('.next-btn').off('click').on('click', function(e) {
        e.preventDefault();

        var currentStepElement = $('.form-wizard-content').eq(currentStep);
        var isValid = true;

        // Validate current step
        currentStepElement.find('input[required], select[required], textarea[required]').each(function() {
            if ($(this).is(':visible')) {
                if (!$(this).valid()) {
                    isValid = false;
                }
            }
        });

        if (isValid && currentStep < totalSteps - 1) {
            activateStep(currentStep + 1);
        } else if (!isValid) {
            console.log('Validation failed for step:', currentStep, stepNames[currentStep]);
        } else {
            console.log('Already at last step');
        }
    });

    // Previous button handler
    $('.prev-btn').off('click').on('click', function(e) {
        e.preventDefault();

        // Get the actual current step from DOM instead of relying on variable
        const actualCurrentStep = $('.form-wizard-content.active').index();

        // Use the DOM value if there's a mismatch
        if (actualCurrentStep !== currentStep && actualCurrentStep >= 0) {
            currentStep = actualCurrentStep;
            console.log('Corrected currentStep to:', currentStep);
        }

        if (currentStep > 0) {
            activateStep(currentStep - 1);
        } else {
            console.log('Already at first step, cannot go back');
        }
    });

    // Initialize - ensure we start at step 0
    activateStep(0);

    // Debug function - call this in console to check current state
    window.debugWizard = function() {
        console.log('=== WIZARD DEBUG ===');
        console.log('Current Step Variable:', currentStep);
        console.log('Current Step Name:', stepNames[currentStep]);

        $('.add-wizard .nav-link').each(function(index) {
            console.log(`Tab ${index}:`, $(this).text().trim(), $(this).hasClass('active') ? '(ACTIVE)' : '');
        });

        $('.form-wizard-content').each(function(index) {
            const header = $(this).find('.sub-header h5').text().trim() || 'No header';
            console.log(`Content ${index}:`, header, $(this).hasClass('active') ? '(ACTIVE)' : '');
        });
    };

    // Alternative approach using direct element references
    function activateStepByElement(direction) {
        const allTabs = $('.add-wizard .nav-link');
        const allContents = $('.form-wizard-content');
        const activeTab = $('.add-wizard .nav-link.active');
        const activeContent = $('.form-wizard-content.active');

        let targetTab, targetContent;

        if (direction === 'next') {
            targetTab = activeTab.closest('li').next().find('.nav-link');
            targetContent = activeContent.next('.form-wizard-content');
        } else {
            targetTab = activeTab.closest('li').prev().find('.nav-link');
            targetContent = activeContent.prev('.form-wizard-content');
        }

        if (targetTab.length && targetContent.length) {
            // Remove active from current
            activeTab.removeClass('active');
            activeContent.removeClass('active');

            // Add active to target
            targetTab.addClass('active');
            targetContent.addClass('active');

            // Update step counter
            currentStep = allTabs.index(targetTab);

            console.log('Element-based navigation to step:', currentStep);
            return true;
        }
        return false;
    }

    // Fallback handlers using element-based approach
    window.nextStepFallback = function() {
        return activateStepByElement('next');
    };

    window.prevStepFallback = function() {
        return activateStepByElement('prev');
    };

    // --- DURATION FIELDS VISIBILITY LOGIC ---
    $('#price_type').on('change', function() {
        const type = $(this).val();
        const hoursSection = $('.hours-section');
        const minutesSection = $('.minutes-section');
        const hoursInput = $('#hours_select');
        const minutesInput = $('#minutes_select');

        hoursSection.hide();
        minutesSection.hide();
        hoursInput.prop('required', false);
        minutesInput.prop('required', false);

        if (type === 'minute') {
            minutesSection.show();
            minutesInput.prop('required', true);
        } else if (type) {
            hoursSection.show();
            hoursInput.prop('required', true);
        }
    });

    // --- CATEGORY & SUBCATEGORY LOGIC ---
    $(".categoryProviderSelect").on("change", function() {
        const categoryId = $(this).val();
        if (categoryId) {
            // On edit, when user changes category, clear the selected subcategory
            fetchSubcategories(categoryId);
        } else {
            $(".subcategories").html('<option value="">Select Sub Category</option>').trigger('change');
        }
    });

    function fetchSubcategories(categoryId, selectedSubcategoryId = null) {
        $.ajax({
            url: "/api/get-register-subcategories",
            type: "POST",
            data: {
                category_id: categoryId,
                language_code: $('#userLangId').val()
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
            },
            success: function(data) {
                let subcategoriesHtml = '<option value="">Select Sub Category</option>';
                data.forEach((subcategory) => {
                    subcategoriesHtml += `<option value="${subcategory.id}">${subcategory.name}</option>`;
                });
                const subCatSelect = $(".subcategories");
                subCatSelect.html(subcategoriesHtml);
                // If a selected ID is passed, select it. Used for initial page load.
                let preSelectedId = selectedSubcategoryId || subCatSelect.data('selected-id');
                if (preSelectedId) {
                    subCatSelect.val(preSelectedId);
                }
                subCatSelect.trigger('change.select2');
            },
            error: function(xhr, status, error) {
                console.error('Error fetching subcategories:', error);
                toastr.error('Failed to load subcategories. Please try again.');
            }
        });
    }

    // --- ADDITIONAL SERVICES & AVAILABILITY LOGIC ---
    $('#add-additional-service-btn').on('click', function() {
        const newServiceRow = `<div class="row align-items-center g-3 additional-service-row mb-3">
            <div class="col-xl-4 col-lg-6">
                <label class="form-label">Service Title</label>
                <input type="text" name="add_name[]" class="form-control">
            </div>
            <div class="col-xl-3 col-lg-6">
                <label class="form-label">Price</label>
                <input type="text" name="add_price[]" class="form-control">
            </div>
            <div class="col-xl-3 col-lg-6">
                <label class="form-label">Duration(hrs)</label>
                <input type="text" name="add_duration[]" class="form-control">
            </div>
            <div class="col-xl-2 col-lg-6 text-end">
                <label class="form-label d-block">&nbsp;</label>
                <a href="javascript:void(0);" class="btn btn-icon btn-light-danger rounded fs-16 flex-shrink-0 remove-service-row">
                    <i class="isax isax-trash"></i>
                </a>
            </div>
        </div>`;
        $('#additional-services-container').append(newServiceRow);
    });

    $(document).on('click', '.remove-service-row', function() {
        $(this).closest('.additional-service-row').remove();
    });

    // Day checkbox handler
    $(document).on("change", "input[name='day_checkbox[]']", function() {
        const checkbox = $(this);
        const container = checkbox.closest(".mb-4");
        const dayCapitalized = checkbox.val(); // e.g., "Monday"

        if (checkbox.is(":checked") && container.find('.additional-time').length === 0) {
            const initialTimeInput = `<div class="d-flex gap-3 mt-2 additional-time">
                <input type="time" class="form-control start_time" name="start_time[${dayCapitalized}][]" required>
                <input type="time" class="form-control end_time" name="end_time[${dayCapitalized}][]" readonly>
                <a class="p-1 rounded-0 remove-time-btn" style="margin-top: 5px; cursor: pointer;">
                    <i class="ti ti-trash me-2 fw-bold fs-4"></i>
                </a>
            </div>`;
            container.find("#slotinputs").append(initialTimeInput);
        } else if (!checkbox.is(":checked")) {
            container.find("#slotinputs").empty();
        }
    });

    // Add time slot button
    $(document).on("click", ".add-time-btn", function() {
        const container = $(this).closest(".mb-4");
        const dayCapitalized = container.find('input[type="checkbox"]').val();
        const isChecked = container.find('input[type="checkbox"]').is(":checked");

        if (!isChecked) {
            toastr.info("Please select the day first to add time slots.");
            return;
        }

        const newTimeInput = `<div class="d-flex gap-3 mt-2 additional-time">
            <input type="time" class="form-control start_time" name="start_time[${dayCapitalized}][]" required>
            <input type="time" class="form-control end_time" name="end_time[${dayCapitalized}][]" readonly>
            <a class="p-1 rounded-0 remove-time-btn" style="margin-top: 5px; cursor: pointer;">
                <i class="ti ti-trash me-2 fw-bold fs-4"></i>
            </a>
        </div>`;
        container.find("#slotinputs").append(newTimeInput);
    });

    // Remove time slot
    $(document).on("click", ".remove-time-btn", function() {
        $(this).closest(".additional-time").remove();
    });

    // Start time change handler - calculate end time
    $(document).on("change", ".start_time", function() {
        const startTimeInput = $(this);
        const endTimeInput = startTimeInput.siblings('.end_time');
        const startTime = startTimeInput.val();

        if (startTime) {
            // Add 1 hour to start time as default duration
            const [hours, minutes] = startTime.split(':');
            let endHour = parseInt(hours) + 1;
            if (endHour >= 24) endHour = 23;

            const endTime = `${endHour.toString().padStart(2, '0')}:${minutes}`;
            endTimeInput.val(endTime);
        }
    });

    // --- LOCATION DROPDOWNS LOGIC (WITH PRE-POPULATION) ---
    let cachedCountries = [],
        cachedStates = [],
        cachedCities = [];
    let selectedCountryId = $('#country').data('selected-id');
    let selectedStateId = $('#state').data('selected-id');
    let selectedCityId = $('#city').data('selected-id');

    // Load location data
    $.when(
        $.getJSON("/countries.json"),
        $.getJSON("/states.json"),
        $.getJSON("/cities.json")
    ).done(function(countriesData, statesData, citiesData) {
        cachedCountries = countriesData[0].countries;
        cachedStates = statesData[0].states;
        cachedCities = citiesData[0].cities;

        const countrySelect = $("#country").empty().append('<option value="">Select Country</option>');
        $.each(cachedCountries, (i, country) => {
            countrySelect.append($('<option>', {
                value: country.id,
                text: country.name
            }));
        });

        if (selectedCountryId) {
            countrySelect.val(selectedCountryId).trigger('change');
        }
    }).fail(function() {
        console.error('Failed to load location data');
        toastr.error('Failed to load location data. Please refresh the page.');
    });

    // Country change handler
    $('#country').on('change', function() {
        const countryId = $(this).val();
        const states = cachedStates.filter(state => state.country_id == countryId);
        const stateSelect = $('#state').empty().append('<option value="">Select State</option>');

        $.each(states, (i, state) => {
            stateSelect.append($('<option>', {
                value: state.id,
                text: state.name
            }));
        });

        if (selectedStateId && countryId) {
            stateSelect.val(selectedStateId).trigger('change');
            selectedStateId = null;
        } else {
            $('#city').empty().append('<option value="">Select City</option>').trigger('change');
        }

        stateSelect.trigger('change.select2');
    });

    // State change handler
    $('#state').on('change', function() {
        const stateId = $(this).val();
        const cities = cachedCities.filter(city => city.state_id == stateId);
        const citySelect = $('#city').empty().append('<option value="">Select City</option>');

        $.each(cities, (i, city) => {
            citySelect.append($('<option>', {
                value: city.id,
                text: city.name
            }));
        });

        if (selectedCityId && stateId) {
            citySelect.val(selectedCityId).trigger('change.select2');
            selectedCityId = null;
        }

        citySelect.trigger('change.select2');
    });

    // --- GALLERY IMAGE LOGIC (WITH DELETE HANDLING) ---
    let selectedFiles = new DataTransfer();
    let deletedImageIds = [];

    // File input change handler
    $('#service_images').on('change', function(event) {
        const files = Array.from(event.target.files);

        files.forEach(file => {
            // Validate file type
            if (!file.type.startsWith('image/')) {
                toastr.error(`${file.name} is not a valid image file.`);
                return;
            }

            // Validate file size (e.g., max 5MB)
            if (file.size > 5 * 1024 * 1024) {
                toastr.error(`${file.name} is too large. Maximum file size is 5MB.`);
                return;
            }

            selectedFiles.items.add(file);
            previewNewImage(file);
        });

        this.files = selectedFiles.files;
    });

    function previewNewImage(file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewHtml = `<div class="text-center gallery-preview-item">
                <div class="gallery-upload-img mb-2">
                    <img src="${e.target.result}" alt="${file.name}" style="max-width: 150px; max-height: 150px; object-fit: cover;">
                    <span class="trash-icon d-flex align-items-center justify-content-center gallery-trash-new" data-name="${file.name}">
                        <i class="isax isax-close-circle5"></i>
                    </span>
                </div>
            </div>`;
            $('#image_preview_container').append(previewHtml);
        };
        reader.readAsDataURL(file);
    }

    // Remove new image
    $(document).on('click', '.gallery-trash-new', function() {
        const fileName = $(this).data('name');
        $(this).closest('.gallery-preview-item').remove();

        const newFiles = new DataTransfer();
        Array.from(selectedFiles.files)
            .filter(file => file.name !== fileName)
            .forEach(file => newFiles.items.add(file));

        selectedFiles = newFiles;
        $('#service_images')[0].files = selectedFiles.files;
    });

    // Remove existing image
    $(document).on('click', '.gallery-trash-existing', function() {
        const previewItem = $(this).closest('.gallery-preview-item');
        const imageId = previewItem.data('id');

        if (imageId) {
            deletedImageIds.push(imageId);
            $('#deleted_images').val(JSON.stringify(deletedImageIds));
            previewItem.remove();
        }
    });

    // --- FINAL SUBMISSION ---
    $("#submit_service_btn").on("click", function(event) {
        event.preventDefault();

        // Validate entire form
        if (!form.valid()) {
            toastr.error("Please fill all required fields in every section.");
            return false;
        }

        // Prepare form data
        let finalFormData = new FormData(form[0]);

        // Remove existing file input data and add selected files
        finalFormData.delete('service_images[]');
        for (let i = 0; i < selectedFiles.files.length; i++) {
            finalFormData.append("service_images[]", selectedFiles.files[i]);
        }

        // Prepare availability data
        let dayCheckbox = [],
            startTimeData = {},
            endTimeData = {};

        $('input[name="day_checkbox[]"]:checked').each(function() {
            const day = $(this).val();
            dayCheckbox.push(day);
            startTimeData[day] = [];
            endTimeData[day] = [];

            $(`input[name="start_time[${day}][]"]`).each(function(index) {
                const startTime = $(this).val();
                const endTime = $(`input[name="end_time[${day}][]"]`).eq(index).val();

                if (startTime && endTime) {
                    startTimeData[day].push(startTime);
                    endTimeData[day].push(endTime);
                }
            });
        });

        finalFormData.append("day_checkbox", JSON.stringify(dayCheckbox));
        finalFormData.append("start_time", JSON.stringify(startTimeData));
        finalFormData.append("end_time", JSON.stringify(endTimeData));

        // Submit form
        $.ajax({
            url: "/provider/service/update",
            method: "POST",
            data: finalFormData,
            dataType: "json",
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr("content")
            },
            beforeSend: function() {
                $("#submit_service_btn").attr("disabled", true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');
            },
            success: function(response) {
                $("#submit_service_btn").removeAttr("disabled").html('Update Service');

                if (response.code === 200) {
                    toastr.success(response.message || 'Service updated successfully!');
                    setTimeout(function() {
                        if (response.redirect_url) {
                            window.location.href = response.redirect_url;
                        } else {
                            window.location.reload();
                        }
                    }, 2000);
                } else {
                    toastr.error(response.message || "An error occurred while updating the service.");
                }
            },
            error: function(xhr) {
                $("#submit_service_btn").removeAttr("disabled").html('Update Service');

                let errorMsg = "An error occurred. Please try again.";

                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        errorMsg = xhr.responseJSON.message;
                    } else if (xhr.responseJSON.errors) {
                        // Handle validation errors
                        const errors = Object.values(xhr.responseJSON.errors).flat();
                        errorMsg = errors.join('<br>');
                    }
                }

                toastr.error(errorMsg);
                console.error('Submission error:', xhr);
            }
        });
    });

    // --- ADDITIONAL HELPER FUNCTIONS ---

    // Function to reset form to initial state
    window.resetForm = function() {
        form[0].reset();
        selectedFiles = new DataTransfer();
        deletedImageIds = [];
        $('#image_preview_container').empty();
        $('.additional-service-row').remove();
        $('.additional-time').remove();
        $('input[name="day_checkbox[]"]').prop('checked', false);
        activateStep(0);
        toastr.info('Form has been reset.');
    };

    // Function to validate specific step
    window.validateStep = function(stepIndex) {
        const stepElement = $('.form-wizard-content').eq(stepIndex);
        let isValid = true;

        stepElement.find('input[required], select[required], textarea[required]').each(function() {
            if ($(this).is(':visible')) {
                if (!$(this).valid()) {
                    isValid = false;
                }
            }
        });

        console.log(`Step ${stepIndex} (${stepNames[stepIndex]}) validation:`, isValid ? 'PASSED' : 'FAILED');
        return isValid;
    };

    // Auto-save functionality (optional)
    let autoSaveTimer;
    function startAutoSave() {
        clearTimeout(autoSaveTimer);
        autoSaveTimer = setTimeout(function() {
            // Auto-save logic here if needed
            console.log('Auto-save triggered');
        }, 30000); // 30 seconds
    }

    // Trigger auto-save on form changes
    form.on('change', 'input, select, textarea', function() {
        startAutoSave();
    });

});
</script>
@endpush