@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('add_new_service') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('add_new_service') }}</h1>
            </div>
        </div>
        <img src="{{ asset('/frontend/assets/img/elements/element-01.svg') }}" alt="elements"
            class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-02.svg') }}" alt="elements"
            class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-03.svg') }}" alt="elements"
            class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-04.svg') }}" alt="elements"
            class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('/frontend/assets/img/elements/element-05.svg') }}" alt="elements"
            class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="container">

            <div class="row">

                <div class="col-xl-10 mx-auto">

                    <a href="/provider/service" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i
                            class="isax isax-arrow-left me-1"></i>{{ __('back_to_services') }}</a>

                    <div class="d-flex justify-content-between mb-4">
                        <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard">
                            <li class="nav-item"><a class="nav-link active" href="javascript:void(0);">{{ __('information') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('availability') }}</a></li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('location') }}</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('gallery') }}</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="javascript:void(0);">{{ __('seo') }}</a></li>
                        </ul>
                    </div>

                    <form id="add-service-form">
                        <input type="hidden" name="userLangId" id="userLangId" value="{{ $userLangId }}">
                        <input type="hidden" name="id" id="id" readonly>

                        <div class="form-wizard-content active">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('service_information') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('service_title') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="service_name" id="service_name"
                                                class="form-control" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('product_code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="product_code" id="product_code"
                                                class="form-control" required>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('shop') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select" name="shop_id" id="shop_id" required>
                                                <option value="">{{ __('select_shop') }}</option>
                                                @foreach ($shopList as $shop)
                                                <option value="{{ $shop->id }}">{{ $shop->shop_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('category') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="select categoryProviderSelect form-select" name="category"
                                                id="category" required>
                                                <option value="">{{ __('select_category') }}</option>
                                                @foreach ($categoriesLang as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-4 col-md-6">
                                            <label class="form-label">{{ __('sub_category') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="select subcategories form-select" name="sub_category"
                                                id="sub_category" required>
                                                <option value="">{{ __('select_sub_category') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('price') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="service_price" id="service_price"
                                                class="form-control" required>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <label class="form-label" for="price_type">{{ __('price_type') }}
                                                <span class="text-danger">*</span>
                                            </label>
                                            <select name="price_type" id="price_type" class="form-control field-input"
                                                required>
                                                <option value="">{{ __('select_price_type') }}</option>
                                                <option value="fixed">{{ __('fixed') }}</option>
                                                <option value="hourly">{{ __('hourly') }}</option>
                                                <option value="minute">{{ __('minutes') }}</option>
                                                <option value="squre-metter">{{ __('square_meter') }}</option>
                                                <option value="square-feet">{{ __('square_feet') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-3 col-md-6">
                                            <div class="mb-3 hours-section" style="display: none;">
                                                <label class="form-label">{{ __('add_duration_hours') }}
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" name="duration_hours" id="hours_select"
                                                    class="form-control" value="1" maxlength="2">
                                            </div>
                                            <div class="mb-3 minutes-section" style="display: none;">
                                                <label class="form-label">{{ __('add_minutes') }}
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select id="minutes_select" name="duration_minute" class="form-control">
                                                    <option value="">{{ __('select_minutes') }}</option>
                                                    @for ($minute = 0; $minute < 60; $minute +=5) <option
                                                        value="{{ $minute }}">
                                                        {{ str_pad($minute, 2, '0', STR_PAD_LEFT) }}
                                                        {{ __('minute') }}{{ $minute != 1 ? 's' : '' }}
                                                        </option>
                                                        @endfor
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('description') }}</label>
                                            <textarea name="description" id="description" class="form-control"
                                                rows="5"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header d-flex justify-content-between align-items-center">
                                        <h5 class="mb-0">{{ __('additional_service') }}</h5>
                                        <a href="javascript:void(0);" class="btn btn-primary btn-sm"
                                            id="add-additional-service-btn">
                                            <i class="isax isax-add-circle me-1"></i> {{ __('add_service') }}
                                        </a>
                                    </div>
                                    <div id="additional-services-container" class="mt-3">
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <a class="btn btn-white d-flex align-items-center"
                                    href="javascript:void(0);">{{ __('cancel') }}</a>
                                <button type="button"
                                    class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i
                                        class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('availability') }}</h5>
                                    </div>
                                    <div class="accordion available-accordion">
                                        <div class="col-xl-12 col-md-6" id="slotData">
                                            <div class="mb-3 p-1" style="margin-top: 10px;">
                                                @foreach (['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
                                                'Saturday', 'Sunday'] as $day)
                                                <div class="mb-4" id="{{ strtolower($day) }}Data">
                                                    <div class="d-flex gap-2 mb-2">
                                                        <input type="checkbox" name="day_checkbox[]"
                                                            id="{{ strtolower($day) }}_checkbox" value="{{ $day }}">
                                                        <h6 style="margin-top: 5.2px;">
                                                            {{ __(strtolower($day)) }}
                                                        </h6>
                                                        <a class="add-time-btn"
                                                            style="margin-top: 0px; cursor: pointer;">
                                                            <i class="ti ti-plus me-2 fw-bold"
                                                                style="font-size: 15px;"></i>
                                                        </a>
                                                    </div>
                                                    <div id="slotinputs">
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i
                                        class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button"
                                    class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i
                                        class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('location') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('address') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="address" id="address" class="form-control"
                                                required>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('country') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="select" id="country" name="country" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('state') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="select" id="state" name="state" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('city') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="select" id="city" name="city" required></select>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('postal_code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="pincode" id="pincode" class="form-control"
                                                required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i
                                        class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button"
                                    class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i
                                        class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('gallery') }}</h5>
                                    </div>
                                    <div class="mb-3">
                                        <h6 class="mb-3">{{ __('service_images') }} <span class="text-danger">*</span>
                                        </h6>
                                        <div
                                            class="file-upload w-100 d-flex align-items-center justify-content-center flex-column mb-3">
                                            <p class="mb-0">{{ __('drag_drop_or_browse') }}</p>
                                            <input type="file" name="service_images[]" id="service_images"
                                                accept="image/*" multiple required>
                                        </div>
                                        <h6 class="fs-16 fw-medium mb-2">{{ __('image_previews') }}</h6>
                                        <div id="image_preview_container"
                                            class="d-flex align-items-center gap-3 flex-wrap">
                                        </div>
                                    </div>
                                    <div>
                                        <div>
                                            <h6 class="mb-3">{{ __('service_video') }}</h6>
                                            <label class="form-label">{{ __('video_link') }}</label>
                                            <input type="text" name="service_video" id="service_video"
                                                class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i
                                        class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button"
                                    class="btn btn-secondary next-btn d-inline-flex align-items-center">{{ __('continue') }}<i
                                        class="isax isax-arrow-right-3 ms-2"></i></button>
                            </div>
                        </div>

                        <div class="form-wizard-content">
                            <div class="card">
                                <div class="card-body">
                                    <div class="sub-header">
                                        <h5 class="mb-0">{{ __('seo') }}</h5>
                                    </div>
                                    <div class="row align-items-center g-3">
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('meta_title') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" name="seo_title" id="seo_title" class="form-control"
                                                required>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <label class="form-label">{{ __('meta_keywords') }} <span
                                                    class="text-danger">*</span></label>
                                            <input class="input-tags form-control" name="seo_tag" id="seo_tag"
                                                type="text" data-role="tagsinput" required>
                                        </div>
                                        <div class="col-lg-12">
                                            <label class="form-label">{{ __('meta_description') }} <span
                                                    class="text-danger">*</span></label>
                                            <textarea name="seo_description" id="seo_description" class="form-control"
                                                rows="4" required></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i
                                        class="isax isax-arrow-left-2 me-2"></i>{{ __('back') }}</button>
                                <button type="button" class="btn btn-secondary"
                                    id="submit_service_btn">{{ __('add_service') }}</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="provider_service_success_modal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="mb-4">
                    <span class="success-icon mx-auto mb-4">
                        <i class="ti ti-check"></i>
                    </span>
                    <h4 class="mb-1">{{ __('service_created_successfully') }}</h4>
                    <p>{{ __('service_under_review_message') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // --- INITIALIZATIONS ---
    if ($('.select').length > 0) {
        $('.select').select2({
            minimumResultsForSearch: -1,
            width: '100%'
        });
    }

    // --- JQUERY VALIDATE SETUP ---
    var form = $("#add-service-form");
    form.validate({
        errorElement: 'span',
        errorClass: 'error',
        ignore: ":hidden", // Ignore hidden fields for validation
        errorPlacement: function(error, element) {
            if (element.parent('.input-group').length || element.hasClass('select')) {
                error.insertAfter(element.next('span.select2'));
            } else {
                error.insertAfter(element);
            }
        },
        rules: {
            service_price: {
                required: true,
                number: true
            },
            pincode: {
                required: true,
                number: true
            },
            'service_images[]': {
                required: true
            }
        },
        messages: {
            service_name: "Please enter a service title.",
            shop_id: "Please select a shop.",
            category: "Please select a category.",
            sub_category: "Please select a sub category.",
            service_price: {
                required: "Please enter a price.",
                number: "Please enter a valid number."
            },
            duration_hours: {
                required: "Please enter a duration.",
                number: "Please enter a valid number."
            },
            duration_minute: "Please select minutes.",
            product_code: "Please enter the product code.",
            address: "Please enter an address.",
            country: "Please select a country.",
            state: "Please select a state.",
            city: "Please select a city.",
            pincode: "Please enter a valid postal code.",
            'service_images[]': "Please upload at least one service image.",
            seo_title: "Please enter a meta title.",
            seo_tag: "Please enter meta keywords.",
            seo_description: "Please enter a meta description."
        }
    });

    // --- DURATION FIELDS VISIBILITY LOGIC ---
    $('#price_type').on('change', function() {
        const type = $(this).val();
        const hoursSection = $('.hours-section');
        const minutesSection = $('.minutes-section');
        const hoursInput = $('#hours_select');
        const minutesInput = $('#minutes_select');

        hoursSection.hide();
        minutesSection.hide();
        hoursInput.prop('required', false).val('');
        minutesInput.prop('required', false).val('');

        if (type === 'minute') {
            minutesSection.show();
            minutesInput.prop('required', true);
        } else if (type) {
            hoursSection.show();
            hoursInput.prop('required', true).val('1');
        }
    });


    // Bulletproof wizard navigation - tracks current step explicitly
// Bulletproof wizard navigation - tracks current step explicitly
    $(document).ready(function() {
        // Initialize current step
        let currentStep = 0;
        const totalSteps = 5;

        // Step names for debugging
        const stepNames = ['Information', 'Availability', 'Location', 'Gallery', 'SEO'];

        // Function to activate specific step
        function activateStep(stepIndex) {

            // Ensure step is within bounds
            if (stepIndex < 0 || stepIndex >= totalSteps) {
                console.log('Step out of bounds:', stepIndex);
                return false;
            }

            // Remove active from all tabs and contents
            $('.add-wizard .nav-link').removeClass('active');
            $('.form-wizard-content').removeClass('active');

            // Add active to specific step
            $('.add-wizard .nav-link').eq(stepIndex).addClass('active');
            $('.form-wizard-content').eq(stepIndex).addClass('active');

            // Update current step
            currentStep = stepIndex;

            return true;
        }

        // Next button handler
        $('.next-btn').off('click').on('click', function(e) {
            e.preventDefault();

            var currentStepElement = $('.form-wizard-content').eq(currentStep);
            var isValid = true;

            // Validate current step
            currentStepElement.find('input[required], select[required], textarea[required]').each(function() {
                if ($(this).is(':visible')) {
                    if (!$(this).valid()) {
                        isValid = false;
                    }
                }
            });

            if (isValid && currentStep < totalSteps - 1) {
                activateStep(currentStep + 1);
            } else if (!isValid) {
                console.log('Validation failed for step:', currentStep);
            }
        });

        // Previous button handler
        $('.prev-btn').off('click').on('click', function(e) {
            e.preventDefault();

            // Get the actual current step from DOM instead of relying on variable
            const actualCurrentStep = $('.form-wizard-content.active').index();

            // Use the DOM value if there's a mismatch
            if (actualCurrentStep !== currentStep && actualCurrentStep >= 0) {
                currentStep = actualCurrentStep;
                console.log('Corrected currentStep to:', currentStep);
            }

            if (currentStep > 0) {
                activateStep(currentStep - 1);
            } else {
                console.log('Already at first step, cannot go back');
            }
        });

        // Initialize - ensure we start at step 0
        activateStep(0);

        // Debug function - call this in console to check current state
        window.debugWizard = function() {

            $('.add-wizard .nav-link').each(function(index) {
                console.log(`Tab ${index}:`, $(this).text().trim(), $(this).hasClass('active') ? '(ACTIVE)' : '');
            });

            $('.form-wizard-content').each(function(index) {
                const header = $(this).find('.sub-header h5').text().trim() || 'No header';
                console.log(`Content ${index}:`, header, $(this).hasClass('active') ? '(ACTIVE)' : '');
            });
        };

        // Alternative approach if the above still doesn't work
        // This uses direct element references instead of index-based selection
        function activateStepByElement(direction) {
            const allTabs = $('.add-wizard .nav-link');
            const allContents = $('.form-wizard-content');
            const activeTab = $('.add-wizard .nav-link.active');
            const activeContent = $('.form-wizard-content.active');

            let targetTab, targetContent;

            if (direction === 'next') {
                targetTab = activeTab.closest('li').next().find('.nav-link');
                targetContent = activeContent.next('.form-wizard-content');
            } else {
                targetTab = activeTab.closest('li').prev().find('.nav-link');
                targetContent = activeContent.prev('.form-wizard-content');
            }

            if (targetTab.length && targetContent.length) {
                // Remove active from current
                activeTab.removeClass('active');
                activeContent.removeClass('active');

                // Add active to target
                targetTab.addClass('active');
                targetContent.addClass('active');

                // Update step counter
                currentStep = allTabs.index(targetTab);

                console.log('Element-based navigation to step:', currentStep);
                return true;
            }
            return false;
        }

        // Fallback handlers using element-based approach
        window.nextStepFallback = function() {
            return activateStepByElement('next');
        };

        window.prevStepFallback = function() {
            return activateStepByElement('prev');
        };
    });

    // --- CATEGORY & SUBCATEGORY LOGIC ---
    $(".categoryProviderSelect").on("change", function() {
        const categoryId = $(this).val();
        if (categoryId) {
            fetchSubcategories(categoryId);
        } else {
            $(".subcategories").html('<option value="">Select Sub Category</option>').trigger('change');
        }
    });

    function fetchSubcategories(categoryId) {
        $.ajax({
            url: "/api/get-register-subcategories",
            type: "POST",
            data: {
                category_id: categoryId,
                language_code: $('body').data('lang')
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
            },
            success: function(data) {
                let subcategoriesHtml = '<option value="">Select Sub Category</option>';
                data.forEach((subcategory) => {
                    subcategoriesHtml +=
                        `<option value="${subcategory.id}">${subcategory.name}</option>`;
                });
                $(".subcategories").html(subcategoriesHtml).trigger('change');
            },
            error: function() {
                toastr.error("Failed to fetch subcategories.");
            }
        });
    }

    // --- ADDITIONAL SERVICES LOGIC ---
    $('#add-additional-service-btn').on('click', function() {
        const newServiceRow = `
                <div class="row align-items-center g-3 additional-service-row mb-3">
                    <div class="col-xl-4 col-lg-6">
                        <label class="form-label">Service Title</label>
                        <input type="text" name="add_name[]" class="form-control">
                    </div>
                    <div class="col-xl-3 col-lg-6">
                        <label class="form-label">Price</label>
                        <input type="text" name="add_price[]" class="form-control">
                    </div>
                    <div class="col-xl-3 col-lg-6">
                        <label class="form-label">Duration(hrs)</label>
                        <input type="text" name="add_duration[]" class="form-control">
                    </div>
                    <div class="col-xl-2 col-lg-6 text-end">
                        <label class="form-label d-block">&nbsp;</label>
                        <a href="javascript:void(0);" class="btn btn-icon btn-light-danger rounded fs-16 flex-shrink-0 remove-service-row"><i class="isax isax-trash"></i></a>
                    </div>
                </div>`;
        $('#additional-services-container').append(newServiceRow);
    });

    $(document).on('click', '.remove-service-row', function() {
        $(this).closest('.additional-service-row').remove();
    });

    // --- AVAILABILITY / SLOTS LOGIC ---
    $(document).on("change", "input[name='day_checkbox[]']", function() {
        const checkbox = $(this);
        const container = checkbox.closest(".mb-4");
        const day = container.attr("id").replace("Data", "");

        if (checkbox.is(":checked") && container.find('.additional-time').length === 0) {
            const initialTimeInput = `
                    <div class="d-flex gap-3 mt-2 additional-time">
                        <input type="time" class="form-control start_time" name="start_time[${day}][]" required>
                        <input type="time" class="form-control end_time" name="end_time[${day}][]" readonly>
                        <a class="p-1 rounded-0 remove-time-btn" style="margin-top: 5px; cursor: pointer;">
                            <i class="ti ti-trash me-2 fw-bold fs-4"></i>
                        </a>
                    </div>
                `;
            container.find("#slotinputs").append(initialTimeInput);
        } else if (!checkbox.is(":checked")) {
            container.find("#slotinputs").empty();
        }
    });

    $(document).on("click", ".add-time-btn", function() {
        const container = $(this).closest(".mb-4");
        const day = container.attr("id").replace("Data", "");
        const isChecked = container.find('input[type="checkbox"]').is(":checked");

        if (!isChecked) {
            toastr.info("Please select the day first to add time slots.");
            return;
        }

        const newTimeInput = `
                <div class="d-flex gap-3 mt-2 additional-time">
                    <input type="time" class="form-control start_time" name="start_time[${day}][]" required>
                    <input type="time" class="form-control end_time" name="end_time[${day}][]" readonly>
                    <a class="p-1 rounded-0 remove-time-btn" style="margin-top: 5px; cursor: pointer;">
                        <i class="ti ti-trash me-2 fw-bold fs-4"></i>
                    </a>
                </div>
            `;
        container.find("#slotinputs").append(newTimeInput);
    });

    $(document).on("click", ".remove-time-btn", function() {
        $(this).closest(".additional-time").remove();
    });

    $(document).on("change", ".start_time", function() {
        const startTimeInput = $(this);
        const selectedHours = $("#hours_select").val();
        const selectedMinutes = $("#minutes_select").val();
        const startTime = startTimeInput.val();
        const timeSlotDiv = startTimeInput.closest(".d-flex");
        const endTimeInput = timeSlotDiv.find(".end_time");

        if (!startTime) {
            endTimeInput.val("");
            return;
        }

        if (!selectedHours && !selectedMinutes) {
            toastr.error("Please set a service duration in the 'Information' tab first.");
            startTimeInput.val("");
            endTimeInput.val("");
            return;
        }

        if ((selectedHours || selectedMinutes) && startTime) {
            const [startHour, startMinute] = startTime.split(":").map(Number);
            let endHour = startHour;
            let endMinute = startMinute;

            if (selectedHours) {
                endHour += parseInt(selectedHours);
            }
            if (selectedMinutes) {
                endMinute += parseInt(selectedMinutes);
            }

            endHour += Math.floor(endMinute / 60);
            endMinute = endMinute % 60;
            endHour = endHour % 24;

            const formattedEndTime =
                `${endHour.toString().padStart(2, "0")}:${endMinute.toString().padStart(2, "0")}`;
            endTimeInput.val(formattedEndTime);
        } else {
            endTimeInput.val("");
            return;
        }

        const currentStartTime = startTimeInput.val();
        const currentEndTime = endTimeInput.val();
        const dayContainer = startTimeInput.closest(".mb-4");
        let isOverlapping = false;

        if (!currentStartTime || !currentEndTime) return;

        dayContainer.find(".additional-time").each(function() {
            const otherSlot = $(this);
            if (otherSlot.is(timeSlotDiv)) {
                return;
            }

            const existingStartTime = otherSlot.find(".start_time").val();
            const existingEndTime = otherSlot.find(".end_time").val();

            if (existingStartTime && existingEndTime) {
                if (currentStartTime < existingEndTime && existingStartTime < currentEndTime) {
                    isOverlapping = true;
                    return false;
                }
            }
        });

        if (isOverlapping) {
            toastr.error(
                "The selected time overlaps with another slot. Please select a different time.");
            startTimeInput.val("");
            endTimeInput.val("");
            startTimeInput.focus();
        }
    });

    // --- LOCATION DROPDOWNS LOGIC ---
    let cachedCountries = [],
        cachedStates = [],
        cachedCities = [];
    $.when(
        $.getJSON("/countries.json"),
        $.getJSON("/states.json"),
        $.getJSON("/cities.json")
    ).done(function(countriesData, statesData, citiesData) {
        cachedCountries = countriesData[0].countries;
        cachedStates = statesData[0].states;
        cachedCities = citiesData[0].cities;
        populateCountries();
    });

    function populateCountries() {
        const countrySelect = $("#country");
        countrySelect.empty().append('<option value="">Select Country</option>');
        $.each(cachedCountries, (i, country) => {
            countrySelect.append($('<option>', {
                value: country.id,
                text: country.name
            }));
        });
    }
    $('#country').on('change', function() {
        const states = cachedStates.filter(state => state.country_id == $(this).val());
        const stateSelect = $('#state').empty().append('<option value="">Select State</option>');
        $.each(states, (i, state) => {
            stateSelect.append($('<option>', {
                value: state.id,
                text: state.name
            }));
        });
        $('#city').empty().append('<option value="">Select City</option>').trigger('change');
        stateSelect.trigger('change');
    });
    $('#state').on('change', function() {
        const cities = cachedCities.filter(city => city.state_id == $(this).val());
        const citySelect = $('#city').empty().append('<option value="">Select City</option>');
        $.each(cities, (i, city) => {
            citySelect.append($('<option>', {
                value: city.id,
                text: city.name
            }));
        });
        citySelect.trigger('change');
    });

    // --- GALLERY IMAGE UPLOAD & PREVIEW ---
    let selectedFiles = new DataTransfer();
    $('#service_images').on('change', function(event) {
        Array.from(event.target.files).forEach(file => {
            selectedFiles.items.add(file);
            previewImage(file);
        });
        this.files = selectedFiles.files;
        $(this).valid(); // Re-validate the file input
    });

    function previewImage(file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewHtml = `
                    <div class="text-center gallery-preview-item">
                        <div class="gallery-upload-img mb-2">
                            <img src="${e.target.result}" alt="${file.name}">
                            <span class="trash-icon d-flex align-items-center justify-content-center gallery-trash" data-name="${file.name}"><i class="isax isax-close-circle5"></i></span>
                        </div>
                    </div>`;
            $('#image_preview_container').append(previewHtml);
        };
        reader.readAsDataURL(file);
    }
    $(document).on('click', '.gallery-trash', function() {
        const fileName = $(this).data('name');
        $(this).closest('.gallery-preview-item').remove();
        const newFiles = new DataTransfer();
        Array.from(selectedFiles.files)
            .filter(file => file.name !== fileName)
            .forEach(file => newFiles.items.add(file));
        selectedFiles = newFiles;
        $('#service_images')[0].files = selectedFiles.files;
        $('#service_images').valid(); // Re-validate the file input
    });

    // --- FINAL SUBMISSION ---
$("#submit_service_btn").on("click", function(event) {
    event.preventDefault();

    // Validate form first
    // Re-validate dynamically added fields manually
    let allValid = true;
    form.find('input[required], select[required], textarea[required]').each(function() {
        if ($(this).is(':visible') && !$(this).valid()) {
            allValid = false;
        }
    });

    if (!allValid) {
        toastr.error("Please fill all the required fields in every section.");
        return false;
    }

    // Prepare FormData
    let finalFormData = new FormData(form[0]);

    // Handle service images
    finalFormData.delete('service_images[]');
    for (let i = 0; i < selectedFiles.files.length; i++) {
        finalFormData.append("service_images[]", selectedFiles.files[i]);
    }

    // Prepare availability data
    let dayCheckbox = [];
    let startTimeData = {};
    let endTimeData = {};

    $('input[name="day_checkbox[]"]:checked').each(function() {
        const day = $(this).val();
        dayCheckbox.push(day);
        const dayKeyForSelector = day.toLowerCase();

        startTimeData[day] = [];
        endTimeData[day] = [];

        $(`input[name="start_time[${dayKeyForSelector}][]"]`).each(function(index) {
            const startTime = $(this).val();
            const endTime = $(`input[name="end_time[${dayKeyForSelector}][]"]`).eq(index).val();

            if (startTime && endTime) {
                startTimeData[day].push(startTime);
                endTimeData[day].push(endTime);
            } else {
                // Show error if any slot is empty
                $(this).after('<span class="error">Start and end time required</span>');
                allValid = false;
            }
        });
    });

    if (!allValid) {
        toastr.error("Please fix highlighted errors before submitting.");
        return false;
    }

    finalFormData.append("day_checkbox", JSON.stringify(dayCheckbox));
    finalFormData.append("start_time", JSON.stringify(startTimeData));
    finalFormData.append("end_time", JSON.stringify(endTimeData));
    if ($('#service_images')[0].files.length === 0) {
        if ($('#service_images').next('span.error').length === 0) {
            $('#service_images').after('<span class="error">Please upload at least one service image.</span>');
        }
        $('#service_images').focus();
        return false;
    } else {
        $('#service_images').next('span.error').remove();
    }

    ['#address', '#country', '#state', '#city', '#pincode'].forEach(function(selector) {
        const field = $(selector);
        if (!field.val()) {
            if (field.next('span.error').length === 0) {
                let msg = field.attr('id') === 'pincode' ? 'Please enter a valid postal code.' :
                        'This field is required.';
                field.after(`<span class="error">${msg}</span>`);
            }
            allValid = false;
        } else {
            field.next('span.error').remove();
        }
    });

    // Submit via AJAX
    $.ajax({
        url: "/provider/service/save",
        method: "POST",
        data: finalFormData,
        dataType: "json",
        contentType: false,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr("content")
        },
        beforeSend: function() {
            $("#submit_service_btn").attr("disabled", true).html(
                '<span class="spinner-border spinner-border-sm"></span> Loading...');
        },
        success: function(response) {
            $("#submit_service_btn").removeAttr("disabled").html('Add Service');
            if (response.code === 200) {
                toastr.success(response.message || "Service added successfully.");
                setTimeout(function() {
                    window.location.href = response.redirect_url;
                }, 2000);
            } else {
                toastr.error(response.message || "An unknown error occurred.");
            }
        },
        error: function(xhr) {
            $("#submit_service_btn").removeAttr("disabled").html('Add Service');
            let errorMsg = "An error occurred. Please try again.";
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMsg = xhr.responseJSON.message;
            }
            toastr.error(errorMsg);
        }
    });
});

});
</script>
@endpush