@extends('frontend.provider.app')

@push('styles')
    <!-- Mobile CSS-->
    <link rel="stylesheet" href="{{ asset('front/plugins/intltelinput/css/intlTelInput.css') }}">
@endpush

@section('content')

<!-- Start Breadscrumb -->
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{ __('profile_settings') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ __('profile_settings') }}</h1>
        </div>
    </div>
</div>
<!-- End Breadscrumb -->

<!-- Start Content -->
<div class="content">
    <div class="container">
        <!-- start row -->
        <div class="row">
            <!-- Sidebar Menu -->
            @include('provider.partials.sidebar')

            <div class="col-xl-9 col-lg-8">
                <!-- Page Header -->
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                    <h4 class="mb-0">{{__('profile_settings')}}</h4>
                </div>
                <!-- End Page Header -->

                <!-- Profile settings content -->
                <div class="card mb-0">
                    <div class="card-body">
                        <form id="providerProfileForm">
                            <h6 class="mb-4">{{__('profile_picture')}}</h6>
                            <input type="hidden" name="id" id="id" value="{{ $data->id ?? ''}}">

                            <!-- Profile Image Section -->
                            <div class="row row-gap-3 mb-4">
                                <div class="col-lg-12">
                                    <label class="form-label">{{__('profile_picture')}}</label>
                                    <div class="profile-image-wrap d-flex align-items-center gap-3">
                                        <div class="profile-image avatar avatar-xxl rounded-circle bg-light">
                                            <img src="{{ $data->userDetails->profile_image ?? asset('assets/img/profile-default.png') }}"
                                                alt="user" class="img-fluid rounded-circle profileImagePreview">
                                        </div>
                                        <div class="d-inline-flex flex-column align-items-start">
                                            <div class="d-flex align-items-center">
                                                <div class="drag-upload-btn btn btn-sm btn-dark position-relative mb-2 me-2">
                                                    {{ __('change_image') }}
                                                    <input type="file" class="form-control image-sign" name="profile_image" id="profile_image" multiple="">
                                                </div>
                                            </div>
                                            <span class="text-gray-9 fs-14">{{(__('image_size_note'))}}</span>
                                            <span class="text-danger error-text" id="profile_image_error"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h6 class="mb-4 border-top pt-4">{{__('general_information')}}</h6>
                            <!-- Basic Information -->
                            <div class="row row-gap-3 mb-4">
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('first_name')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" name="first_name" id="first_name"
                                            value="{{ $data->userDetails->first_name ?? ''}}">
                                        <span class="text-danger error-text" id="first_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('last_name')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="last_name" name="last_name"
                                            value="{{ $data->userDetails->last_name ?? ''}}">
                                        <span class="text-danger error-text" id="last_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('email')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" name="email" id="email"
                                            value="{{ $data->email ?? ''}}">
                                        <span class="text-danger error-text" id="email_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('phone_number')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control provider_phone_number"
                                            name="phone_number" id="phone_number"
                                            value="{{ $data->phone_number ?? ''}}">
                                        <input type="hidden" id="provider_phone_number" name="international_phone_number">
                                        <span class="text-danger error-text" id="phone_number_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('user_name')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" name="user_name" id="user_name"
                                            value="{{ $data->name ?? ''}}">
                                        <span class="text-danger error-text" id="user_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('gender')}}<span class="text-danger"> *</span></label>
                                        <select class="form-control select2" id="gender" name="gender">
                                            <option value="">{{__('select_gender')}}</option>
                                            <option value="male" {{ ($data->userDetails->gender ?? '') == 'male' ? 'selected' : '' }}>{{__('male')}}</option>
                                            <option value="female" {{ ($data->userDetails->gender ?? '') == 'female' ? 'selected' : '' }}>{{__('female')}}</option>
                                        </select>
                                        <span class="text-danger error-text" id="gender_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('date_of_birth')}}<span class="text-danger"> *</span></label>
                                        <input type="date" class="form-control" name="dob" id="dob"
                                            placeholder="dd-mm-yyyy"
                                            max="{{ date('Y-m-d', strtotime('-1 day')) }}"
                                            value="{{ $data->userDetails->dob ?? ''}}">
                                        <span class="text-danger error-text" id="dob_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('language')}}</label>
                                        <input class="input-tags form-control" type="text" data-role="tagsinput"
                                            name="language" id="language"
                                            value="{{ $data->userDetails->language ?? ''}}">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('your_bio')}}</label>
                                        <textarea class="form-control" rows="4" name="bio"
                                            id="bio">{{ $data->userDetails->bio ?? ''}}</textarea>
                                        <span class="text-danger error-text" id="bio_error"></span>
                                    </div>
                                </div>
                            </div>

                            <h6 class="mb-4 border-top pt-4">{{__('address_information')}}</h6>
                            <!-- Address Information -->
                            <div class="row row-gap-3 mb-4">
                                <div class="col-lg-12">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('address')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            value="{{ $data->userDetails->address ?? ''}}">
                                        <span class="text-danger error-text" id="address_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('country')}}<span class="text-danger"> *</span></label>
                                        <select class="form-control searchable-select" id="country" name="country"
                                            data-placeholder="{{__('select_country')}}"
                                            data-country="{{ $data->userDetails->country ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="country_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('state')}}<span class="text-danger"> *</span></label>
                                        <select class="form-control searchable-select" id="state" name="state"
                                            data-placeholder="{{__('select_state')}}"
                                            data-state="{{ $data->userDetails->state ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="state_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('city')}}<span class="text-danger"> *</span></label>
                                        <select class="form-control searchable-select" id="city" name="city"
                                            data-placeholder="{{__('select_city')}}"
                                            data-city="{{ $data->userDetails->city ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="city_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('postal_code')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="postal_code" name="postal_code"
                                            value="{{ $data->userDetails->postal_code ?? ''}}">
                                        <span class="text-danger error-text" id="postal_code_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6 d-none">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('currency_code')}}<span class="text-danger"> *</span></label>
                                        <select class="select form-control select2" id="currency_code"
                                            name="currency_code" data-placeholder="Select Currency Code">
                                            @if ($currencyDetails)
                                            @foreach ($currencyDetails as $currency)
                                            <option value="{{ $currency->code }}" {{ ($data->userDetails->currency_code ?? '') == $currency->code ? 'selected' : '' }}>{{ $currency->code }}
                                            </option>
                                            @endforeach
                                            @endif
                                        </select>
                                        <span class="text-danger error-text" id="currency_code_error"></span>
                                    </div>
                                </div>
                            </div>

                            @if (Auth::check() && Auth::user()->sub_service_type == 'company')
                            <h6 class="mb-4 border-top pt-4">{{__('company_information')}}</h6>
                            <!-- Company Information -->
                            <div class="row row-gap-3 mb-4">
                                <div class="col-lg-12">
                                    <label class="form-label">{{__('company_image')}}</label>
                                    <div class="profile-image-wrap d-flex align-items-center gap-3">
                                        <div class="profile-image avatar avatar-xxl rounded-circle bg-light">
                                            <img src="{{ $data->userDetails->company_image ?? asset('assets/img/default-image.png') }}"
                                                alt="user" class="img-fluid rounded-circle" id="companyImagePreview">
                                        </div>
                                        <div class="d-inline-flex flex-column align-items-start">
                                            <div class="d-flex align-items-center">
                                                <div class="drag-upload-btn btn btn-sm btn-dark position-relative mb-2 me-2">
                                                    {{ __('change_image') }}
                                                    <input type="file" class="form-control image-sign" name="company_image" id="company_image" multiple="">
                                                </div>
                                            </div>
                                            <span class="text-gray-9 fs-14">{{__('image_size_note')}}</span>
                                            <span class="text-danger error-text" id="company_image_error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('company_name')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="company_name" name="company_name"
                                            value="{{ $data->userDetails->company_name ?? ''}}">
                                        <span class="text-danger error-text" id="company_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('company_website')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="company_website"
                                            name="company_website"
                                            value="{{ $data->userDetails->company_website ?? ''}}">
                                        <span class="text-danger error-text" id="company_website_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="mb-0">
                                        <label class="form-label">{{__('company_address')}}<span class="text-danger"> *</span></label>
                                        <input type="text" class="form-control" id="company_address"
                                            name="company_address"
                                            value="{{ $data->userDetails->company_address ?? ''}}">
                                        <span class="text-danger error-text" id="company_address_error"></span>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <h6 class="mb-4 border-top pt-4">{{__('account_information')}}</h6>
                            <!-- Account Information -->
                            <div class="row row-gap-3 mb-4">
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="account_name">{{__('account_name')}} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="account_name" id="account_name"
                                            value="{{ $data->additionalSettings['account_settings']['account_name'] ?? '' }}">
                                        <span class="text-danger error-text" id="account_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="account_number">{{__('account_number')}} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="account_number" id="account_number"
                                            value="{{ $data->additionalSettings['account_settings']['account_number'] ?? '' }}">
                                        <span class="text-danger error-text" id="account_number_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="iban_account">{{__('iban_account')}} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="iban_account" id="iban_account"
                                            value="{{ $data->additionalSettings['account_settings']['iban_account'] ?? '' }}">
                                        <span class="text-danger error-text" id="iban_account_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="bank_name">{{__('bank_name')}} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="bank_name" id="bank_name"
                                            value="{{ $data->additionalSettings['account_settings']['bank_name'] ?? '' }}">
                                        <span class="text-danger error-text" id="bank_name_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="bank_address">{{__('address')}}</label>
                                        <input type="text" class="form-control" name="bank_address" id="bank_address"
                                            value="{{ $data->additionalSettings['account_settings']['bank_address'] ?? '' }}">
                                        <span class="text-danger error-text" id="bank_address_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="ifsc_code">{{__('ifsc_code')}}</label>
                                        <input type="text" class="form-control" name="ifsc_code" id="ifsc_code"
                                            value="{{ $data->additionalSettings['account_settings']['ifsc_code'] ?? '' }}">
                                        <span class="text-danger error-text" id="ifsc_code_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="sort_code">{{__('sort_code')}}</label>
                                        <input type="text" class="form-control" name="sort_code" id="sort_code"
                                            value="{{ $data->additionalSettings['account_settings']['sort_code'] ?? '' }}">
                                        <span class="text-danger error-text" id="sort_code_error"></span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="routing_number">{{__('routing_number')}}</label>
                                        <input type="text" class="form-control" name="routing_number" id="routing_number"
                                            value="{{ $data->additionalSettings['account_settings']['routing_number'] ?? '' }}">
                                        <span class="text-danger error-text" id="routing_number_error"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-end">
                                <button type="submit" class="btn btn-secondary" id="save_provider" data-save="{{ __('save_changes') }}">{{__('save_changes')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Content -->

@endsection