@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('earning_payout')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('earning_payout')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->
    <!-- Start Content -->
    <div class="content">
        <div class="container">

            <!-- start row -->
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8 mb-4">

                    <!-- Page Header -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{__('earning_history')}}</h4>
                        <div class="d-flex align-items-center flex-wrap gap-2">
                        </div>
                    </div>
                    <!-- End Page Header -->

                    <!-- Earnings Summary Cards -->
                    <div class="row justify-content-center mb-4">

                        <!-- Tab Navigation -->
                        <div class="mb-4">
                            <ul class="nav nav-tabs nav-solid-primary wishlist-tab">
                                <li class="nav-item"><a class="nav-link active" href="#solid-tab1" data-bs-toggle="tab">{{__('Services')}}</a></li>
                                <li class="nav-item"><a class="nav-link" href="#solid-tab2" data-bs-toggle="tab">{{__('products')}}</a></li>
                            </ul>
                        </div>

                        <!-- Earnings Table -->
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex align-items-center justify-content-between flex-wrap gap-4">
                                    <h5 class="mb-0">{{__('total_payments')}}</h5>
                                    <div class="d-flex align-items-center flex-wrap gap-3">
                                        <div class="">
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text">
                                                    <i class="isax isax-search-normal-1 text-dark"></i>
                                                </span>
                                                <input type="text" class="form-control form-control-sm" placeholder="Search">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="tab-content">
                                    <div class="tab-pane show active" id="solid-tab1">
                                        <div class="table-responsive table-nowrap">
                                            <table class="table mb-0 border border-bottom-0 datatable table-nowrap no-pagination">
                                                <thead>
                                                    <tr>
                                                        <th>{{__('invoice_id')}}</th>
                                                        <th>{{__('Customer')}}</th>
                                                        <th>{{__('Service')}}</th>
                                                        <th>{{__('Amount')}}</th>
                                                        <th>{{__('Payment Methods')}}</th>
                                                        <th>{{__('payment_date')}}</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="solid-tab2">
                                        <div class="table-responsive table-nowrap">
                                            <table class="table mb-0 border border-bottom-0 datatable table-nowrap no-pagination">
                                                <thead>
                                                    <tr>
                                                        <th>{{__('invoice_id')}}</th>
                                                        <th>{{__('Customer')}}</th>
                                                        <th>{{__('Product')}}</th>
                                                        <th>{{__('Amount')}}</th>
                                                        <th>{{__('Payment Methods')}}</th>
                                                        <th>{{__('payment_date')}}</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
        </div>
        <!-- End Content -->
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/provider-earning.js') }}"></script>
@endpush