<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-4">Shipping</h4>
        <div class="row g-3">
            <div class="col-md-12">
                <label for="international_shipping" class="form-label">International Shipping Details</label>
                <textarea id="international_shipping" name="international_shipping" rows="3" class="form-control">{{ old('international_shipping', $product->international_shipping) }}</textarea>
                <span id="international_shipping_error" class="invalid-feedback d-block"></span>
            </div>
            <div class="col-md-12">
                <label for="domestic_shipping" class="form-label">Domestic Shipping Details</label>
                <textarea id="domestic_shipping" name="domestic_shipping" rows="3" class="form-control">{{ old('domestic_shipping', $product->domestic_shipping) }}</textarea>
                <span id="domestic_shipping_error" class="invalid-feedback d-block"></span>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-4">SEO (Search Engine Optimization)</h4>
        <div class="row g-3">
            <div class="col-12">
                <label for="meta_title" class="form-label">Meta Title</label>
                <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title', $product->seo_title) }}" class="form-control" placeholder="Title for search engine results">
                <span id="meta_title_error" class="invalid-feedback d-block"></span>
            </div>
            <div class="col-12">
                <label for="meta_description" class="form-label">Meta Description</label>
                <textarea id="meta_description" name="meta_description" rows="3" class="form-control" placeholder="Short description for search results">{{ old('meta_description', $product->seo_description) }}</textarea>
                <span id="meta_description_error" class="invalid-feedback d-block"></span>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
         <h4 class="card-title mb-4">Status</h4>
        <div class="row">
            <div class="col-md-4">
                <label for="status" class="form-label">Product Status <span class="text-danger">*</span></label>
                <select id="status" name="status" class="form-select">
                    <option value="active" {{ old('status', $product->status) == 'active' ? 'selected' : '' }}>Active (Published)</option>
                    <option value="draft" {{ old('status', $product->status) == 'draft' ? 'selected' : '' }}>Draft</option>
                </select>
                <span id="status_error" class="invalid-feedback d-block"></span>
            </div>
        </div>
    </div>
</div>