@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('edit_product') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('edit_product') }}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="page-title">{{ __('edit_product') }}</h4>
                        <a href="{{ route('provider.product') }}" class="btn btn-white btn-sm d-inline-flex align-items-center">
                            <i class="isax isax-arrow-left me-1"></i>{{ __('back_to_products') }}
                        </a>
                    </div>

                    <form id="product-form" action="{{ route('provider.product.update', $product->id) }}" method="POST" enctype="multipart/form-data" autocomplete="off" novalidate>
                        @csrf
                        @method('PUT')

                        <input type="hidden" id="slug" name="slug" value="{{ old('slug', $product->slug) }}">
                        <input type="hidden" name="removed_gallery_images" id="removed_gallery_images">

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('product_information') }}</h4>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="product_name" class="form-label">{{ __('product_name') }} <span class="text-danger">*</span></label>
                                        <input type="text" id="product_name" name="product_name" value="{{ old('product_name', $product->source_name) }}" class="form-control">
                                        <span id="product_name_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="product_code" class="form-label">{{ __('product_code') }} <span class="text-danger">*</span></label>
                                        <input type="text" id="product_code" name="product_code" value="{{ old('product_code', $product->source_code) }}" class="form-control">
                                        <span id="product_code_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="category_id" class="form-label">{{ __('category') }} <span class="text-danger">*</span></label>
                                        <select id="category_id" name="category_id" class="form-select">
                                            @foreach ($categoriesProduct as $category)
                                            <option value="{{ $category->id }}" {{ old('category_id', $product->source_category) == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        <span id="category_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sub_category_id" class="form-label">{{ __('sub_category') }} <span class="text-danger">*</span></label>
                                        <select name="sub_category_id" id="sub_category_id" class="form-select" {{ !$product->source_category ? 'disabled' : '' }}>
                                            {{-- Populated by JS --}}
                                        </select>
                                        <span id="sub_category_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="shop_id" class="form-label">{{ __('shop') }} <span class="text-danger">*</span></label>
                                        <select id="shop_id" name="shop_id" class="form-select">
                                            @foreach ($shopList as $shop)
                                            <option value="{{ $shop->id }}" {{ old('shop_id', $product->shop_id) == $shop->id ? 'selected' : '' }}>
                                                {{ $shop->shop_name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        <span id="shop_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-12">
                                        <label for="shot_description" class="form-label">{{ __('short_description') }} <span class="text-danger">*</span></label>
                                        <textarea id="shot_description" name="shot_description" rows="3" class="form-control">{{ old('shot_description', $product->shot_description) }}</textarea>
                                        <span id="shot_description_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="form-label">{{ __('full_description') }} <span class="text-danger">*</span></label>
                                        <textarea id="description" name="description" rows="5" class="form-control">{{ old('description', $product->source_description) }}</textarea>
                                        <span id="description_error" class="invalid-feedback d-block"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('product_gallery') }}</h4>
                                <div class="mb-3">
                                    <label class="form-label">{{ __('existing_images') }}</label>
                                    <div id="existing-gallery-container" class="mt-1 d-flex flex-wrap gap-3">
                                        @forelse($product->productImages as $image)
                                            <div class="position-relative existing-gallery-image">
                                                <img src="{{ asset('storage/' . $image->source_Values) }}" class="rounded border" style="height: 96px; width: 96px; object-fit: cover;">
                                                <button type="button" data-path="{{ $image->source_Values }}" class="btn-close bg-white rounded-circle position-absolute top-0 end-0 m-1 border delete-gallery-img" data-id="{{ $image->id }}" title="{{ __('remove_image') }}"></button>
                                            </div>
                                        @empty
                                            <p class="text-muted">{{ __('no_existing_images') }}</p>
                                        @endforelse
                                    </div>
                                </div>
                                <hr>
                                <label for="multi-image-upload" class="form-label">{{ __('add_more_images') }}</label>
                                <input type="file" id="multi-image-upload" name="product_images[]" multiple class="form-control" accept="image/*">
                                <span id="product_images_error" class="invalid-feedback d-block"></span>
                                <div id="multi-image-preview-container" class="mt-3 d-flex flex-wrap gap-3"></div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('pricing_stock_variations') }}</h4>
                                @php
                                    $hasVariations = $product->variations && count($product->variations) > 0;
                                @endphp
                                <div class="row g-3">
                                    <div class="col-lg-12">
                                        <label class="form-label">{{ __('product_type') }} <span class="text-danger">*</span></label>
                                        <div class="d-flex align-items-center flex-wrap gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="product_type" id="single_product_type" value="single" {{ !$hasVariations ? 'checked' : '' }}>
                                                <label class="form-check-label" for="single_product_type">{{ __('single_product') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="product_type" id="variable_product_type" value="variable" {{ $hasVariations ? 'checked' : '' }}>
                                                <label class="form-check-label" for="variable_product_type">{{ __('variable_product') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="single-product-content" class="mt-4" style="{{ $hasVariations ? 'display: none;' : '' }}">
                                    <div class="alert alert-info">{{ __('single_product_note') }}</div>
                                    <div class="row g-3 mt-2">
                                        <div class="col-md-6">
                                            <label for="price" class="form-label">{{ __('base_price') }} <span class="text-danger">*</span></label>
                                            <input type="number" id="price" name="price" value="{{ old('price', $product->source_price) }}" class="form-control">
                                            <span id="price_error" class="invalid-feedback d-block"></span>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="stock" class="form-label">{{ __('base_stock_quantity') }} <span class="text-danger">*</span></label>
                                            <input type="number" id="stock" name="stock" value="{{ old('stock', $product->source_stock) }}" class="form-control">
                                            <span id="stock_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </div>
                                <div id="variable-product-content" class="mt-4" style="{{ !$hasVariations ? 'display: none;' : '' }}">
                                    <h5 class="mb-3">{{ __('product_variations') }}</h5>
                                    <div id="variations-container"></div>
                                    <button type="button" id="add-variation-btn" class="btn btn-outline-primary mt-3">
                                        <i class="ti ti-plus me-2"></i>{{ __('add_new_variation') }}
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('specifications') }}</h4>
                                <div id="specification-wrapper" class="row g-3">
                                    @foreach($product->specifications as $spec)
                                        <div class="col-md-3 mb-3 spec-row"><label class="form-label">{{ __('label') }}</label><input type="text" name="specification_label[]" class="form-control" value="{{ $spec['label'] ?? '' }}"></div>
                                        <div class="col-md-8 mb-3 spec-row"><label class="form-label">{{ __('description') }}</label><input type="text" name="specification_description[]" class="form-control" value="{{ $spec['description'] ?? '' }}"></div>
                                        <div class="col-md-1 mb-3 spec-row d-flex align-items-end"><button type="button" class="btn btn-danger remove-spec-btn"><i class="fa-solid fa-trash"></i></button></div>
                                    @endforeach
                                </div>
                                <div class="mt-3">
                                    <button type="button" id="add-specification" class="btn btn-primary">{{ __('add_specification') }}</button>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('shipping') }}</h4>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label for="international_shipping" class="form-label">{{ __('international_shipping') }}</label>
                                        <textarea id="international_shipping" name="international_shipping" rows="3" class="form-control">{{ old('international_shipping', $product->international_shipping) }}</textarea>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="domestic_shipping" class="form-label">{{ __('domestic_shipping') }}</label>
                                        <textarea id="domestic_shipping" name="domestic_shipping" rows="3" class="form-control">{{ old('domestic_shipping', $product->domestic_shipping) }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('seo_title') }}</h4>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="meta_title" class="form-label">{{ __('meta_title') }}</label>
                                        <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title', $product->seo_title) }}" class="form-control">
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="form-label">{{ __('meta_description') }}</label>
                                        <textarea id="meta_description" name="meta_description" rows="3" class="form-control">{{ old('meta_description', $product->seo_description) }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('status') }}</h4>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="status" class="form-label">{{ __('product_status') }} <span class="text-danger">*</span></label>
                                        <select id="status" name="status" class="form-select">
                                            <option value="active" {{ old('status', $product->status) == 'active' ? 'selected' : '' }}>{{ __('active_status') }}</option>
                                            <option value="draft" {{ old('status', $product->status) == 'draft' ? 'selected' : '' }}>{{ __('draft_status') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="status" class="form-label">{{ __('feature') }} <span class="text-danger">*</span></label>
                                       <select id="feature" name="feature" class="form-select">
                                            <option value="1">{{ __('active') }}</option>
                                            <option value="0">{{ __('inactive') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('provider.product') }}" class="btn btn-light">{{ __('cancel') }}</a>
                            <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('update_product') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {

    // ===================================================================
    // === INITIAL DATA SETUP ============================================
    // ===================================================================
    const existingVariations = @json($product->variations ?? []);
    const storageBaseUrl = @json(asset('storage'));
    const existingSubCategoryId = @json($product->source_subcategory);
    const variationsContainer = $("#variations-container");
    let variationCounter = existingVariations.length > 0 ? Math.max(...existingVariations.map(v => v.id)) : 0;

    // ===================================================================
    // === CLIENT-SIDE VALIDATION ========================================
    // ===================================================================
    function validateForm() {
        let isValid = true;
        $('.invalid-feedback').text('');

        const showError = (id, message) => {
            $('#' + id + '_error').text(message);
            isValid = false;
        };

        if (!$('#product_name').val()) showError('product_name', 'Product Name is required.');
        if (!$('#product_code').val()) showError('product_code', 'Product Code (SKU) is required.');
        if (!$('#category_id').val()) showError('category_id', 'Category is required.');
        if (!$('#sub_category_id').val()) showError('sub_category_id', 'Sub Category is required.');
        if (!$('#shop_id').val()) showError('shop_id', 'Shop is required.');
        if (!$('#shot_description').val()) showError('shot_description', 'Short Description is required.');
        if (!$('#description').val()) showError('description', 'Full Description is required.');

        if ($('.existing-gallery-image').length === 0 && $('#multi-image-upload')[0].files.length === 0) {
            showError('product_images', 'At least one gallery image is required.');
        }

        if ($('input[name="product_type"]:checked').val() === 'single') {
             if (!$('#price').val()) showError('price', 'Base Price is required.');
             if (!$('#stock').val()) showError('stock', 'Base Stock is required.');
        } else {
            if ($('.variation-card').length === 0) {
                showToast('error', 'If product type is "Variable", you must add at least one variation.');
                isValid = false;
            }
            $('.variation-card').each(function() {
                const card = $(this);
                const hasExistingImages = card.find('.existing-variation-image').length > 0;
                const hasNewImages = card.data('files') && card.data('files').length > 0;
                if (!hasExistingImages && !hasNewImages) {
                    card.find('.variation-image-input').after('<span class="invalid-feedback d-block">At least one image is required for this variation.</span>');
                    isValid = false;
                }
            });
        }

        return isValid;
    }

    // ===================================================================
    // === CORE FORM SUBMISSION ==========================================
    // ===================================================================
    $("#product-form").on("submit", function(event) {
        event.preventDefault();

        if (!validateForm()) {
           showToast('error', 'Please fill out all required fields.');
            return;
        }

        $('.variation-card').each(function() {
            const card = $(this);
            if (card.data('files')) {
                const fileInput = card.find('.variation-image-input')[0];
                const files = card.data('files');
                const dataTransfer = new DataTransfer();
                files.forEach(file => dataTransfer.items.add(file));
                fileInput.files = dataTransfer.files;
            }
        });

        const formData = new FormData(this);

        if (deletedGalleryImageIds.length > 0) {
            formData.append('deleted_gallery_image_ids', JSON.stringify(deletedGalleryImageIds));
        }

        $.ajax({
            url: $(this).attr('action'),
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            beforeSend: () => $("#submit-btn").prop("disabled", true).html('<span class="spinner-border spinner-border-sm"></span> Updating...'),
            success: function(response) {
                showToast('success', response.message || "Product updated successfully!");
                if (response.redirectUrl) window.location.href = response.redirectUrl;
            },
            error: function(jqXHR) {
                let errorMessage = "An unexpected error occurred.";
                if (jqXHR.status === 422) {
                     const errors = jqXHR.responseJSON.errors;
                     $.each(errors, (key, value) => {
                         $("#" + key.replace(/\./g, "_") + "_error").text(value[0]);
                     });
                     errorMessage = "Please correct the form errors.";
                }
                showToast('error', errorMessage);
            },
            complete: () => $("#submit-btn").prop("disabled", false).text("Update Product")
        });
    });

    // ===================================================================
    // === DYNAMIC VARIATIONS LOGIC ======================================
    // ===================================================================
    function addSizePriceRow(container, varIndexKey, data = {}) {
        const sizeTemplate = `
         <div class="size-price-row row g-2 align-items-center mb-2">
             <div class="col-sm-3"><input type="text" name="variations[${varIndexKey}][sizes][]" class="form-control form-control-sm" placeholder="e.g., M" value="${data.size || ''}"></div>
             <div class="col-sm-3"><input type="number" name="variations[${varIndexKey}][prices][]" class="form-control form-control-sm" placeholder="Price" value="${data.price || ''}"></div>
             <div class="col-sm-3"><input type="number" name="variations[${varIndexKey}][stocks][]" class="form-control form-control-sm" placeholder="Stock" value="${data.stock || ''}"></div>
             <div class="col-sm-3 text-end"><button type="button" class="btn-close remove-size-btn"></button></div>
         </div>`;
        container.append(sizeTemplate);
    }

    function createVariationCard(data = null) {
        variationCounter++;
        const varIndexKey = data ? data.id : `new_${variationCounter}`;
        const template = `
         <div class="variation-card card card-body mb-3 position-relative" id="variation-${varIndexKey}">
             <button type="button" class="btn-close remove-variation-btn position-absolute top-0 end-0 mt-2 me-2" title="Remove Variation"></button>
             ${data ? `<input type="hidden" name="variations[${varIndexKey}][id]" value="${data.id}"><input type="hidden" name="variations[${varIndexKey}][removed_images]" class="removed-images-input">` : ''}
             <div class="row g-3">
                 <div class="col-12">
                     <label class="form-label mb-2">Variation Images</label>
                     <div class="image-preview-container d-flex flex-wrap gap-2 p-2 border rounded bg-light w-100" style="min-height: 96px;"></div>
                     <div class="mt-2">
                          <input type="file" name="variations[${varIndexKey}][images][]" class="variation-image-input form-control form-control-sm" multiple accept="image/*">
                     </div>
                 </div>
                 <div class="col-md-6">
                     <label class="form-label mb-2">Color</label>
                     <input type="color" name="variations[${varIndexKey}][color]" value="${data?.color || '#FFFFFF'}" class="form-control form-control-color" style="height: 38px; width: 100px;">
                 </div>
             </div>
             <hr class="my-3">
             <div>
                 <h6 class="fw-semibold mb-3">Sizes, Prices & Stock</h6>
                 <div class="size-price-container"></div>
                 <button type="button" class="add-size-btn btn btn-sm btn-link p-0 mt-2">+ Add Size</button>
             </div>
         </div>`;

        const card = $(template);
        card.data('files', []);
        const sizeContainer = card.find(".size-price-container");

        if (data?.images?.length) {
            data.images.forEach(url => {
                const wrapper = `
                 <div class="position-relative existing-variation-image">
                     <img src="${storageBaseUrl}/${url}" class="rounded border" style="height: 80px; width: 80px; object-fit: cover;">
                     <button type="button" data-url="${url}" class="btn-close bg-white rounded-circle position-absolute top-0 end-0 m-1 border remove-existing-image" title="Remove Image"></button>
                 </div>`;
                card.find(".image-preview-container").append(wrapper);
            });
        }
        if (data?.data?.length) {
            data.data.forEach(d => addSizePriceRow(sizeContainer, varIndexKey, d));
        } else {
            addSizePriceRow(sizeContainer, varIndexKey);
        }
        variationsContainer.append(card);
    }

    $("#add-variation-btn").on("click", () => createVariationCard());
    variationsContainer.on("click", ".remove-variation-btn", function() { $(this).closest(".variation-card").remove(); });
    variationsContainer.on("click", ".add-size-btn", function() {
        const card = $(this).closest(".variation-card");
        const nameAttr = card.find("input").first().attr("name");
        const varIndexKey = nameAttr.match(/variations\[(.*?)\]/)[1];
        addSizePriceRow(card.find(".size-price-container"), varIndexKey);
    });
    variationsContainer.on("click", ".remove-size-btn", function() { $(this).closest(".size-price-row").remove(); });

    variationsContainer.on("click", ".remove-existing-image", function() {
        const wrapper = $(this).closest('.existing-variation-image');
        const url = $(this).data('url');
        const hiddenInput = wrapper.closest('.variation-card').find('.removed-images-input');
        const currentRemoved = hiddenInput.val().split(',').filter(Boolean);
        if (!currentRemoved.includes(url)) currentRemoved.push(url);
        hiddenInput.val(currentRemoved.join(','));
        wrapper.remove();
    });

    function renderVariationPreviews(card) {
        const previewContainer = card.find(".image-preview-container");
        previewContainer.find(".new-image-preview").remove();
        const files = card.data('files');
        files.forEach((file, index) => {
            const reader = new FileReader();
            reader.onload = (e) => {
                const previewWrapper = $(`
                    <div class="position-relative new-image-preview">
                        <img src="${e.target.result}" class="rounded border" style="height: 80px; width: 80px; object-fit: cover;">
                        <button type="button" class="btn-close bg-white rounded-circle position-absolute top-0 end-0 m-1 border delete-var-img" style="font-size: 0.6rem;"></button>
                    </div>`);
                previewWrapper.data('index', index);
                previewContainer.append(previewWrapper);
            };
            reader.readAsDataURL(file);
        });
    }

    variationsContainer.on("change", ".variation-image-input", function() {
        const card = $(this).closest('.variation-card');
        let existingFiles = card.data('files');
        card.data('files', existingFiles.concat(Array.from(this.files)));
        renderVariationPreviews(card);
        $(this).val('');
    });

    variationsContainer.on("click", ".delete-var-img", function() {
        const card = $(this).closest('.variation-card');
        let files = card.data('files');
        files.splice($(this).parent().data('index'), 1);
        card.data('files', files);
        renderVariationPreviews(card);
    });

    // ===================================================================
    // === OTHER HELPERS AND INITIALIZERS ================================
    // ===================================================================
    $("#product_name").on("input", function() {
        $("#slug").val($(this).val().toLowerCase().trim().replace(/\s+/g, "-").replace(/[^\w\-]+/g, "").replace(/\-\-+/g, "-"));
    });

    $('input[name="product_type"]').on('change', function() {
        $('#variable-product-content').toggle(this.value === 'variable');
        $('#single-product-content').toggle(this.value === 'single');
    });

    $("#multi-image-upload").on("change", function() {
        const previewContainer = $("#multi-image-preview-container").empty();
        if (this.files) {
            $.each(this.files, (i, file) => {
                previewContainer.append($("<img>", { src: URL.createObjectURL(file), class: "rounded border", style: "height: 96px; width: 96px; object-fit: cover;" }));
            });
        }
    });

    let deletedGalleryImageIds = [];

    $('#existing-gallery-container').on('click', '.delete-gallery-img', function() {
        const wrapper = $(this).closest('.existing-gallery-image');
        const path = $(this).data('path');
        const hiddenInput = $('#removed_gallery_images');
        const currentRemoved = hiddenInput.val().split(',').filter(Boolean);
        const imageId = $(this).data('id');
        if (imageId && !deletedGalleryImageIds.includes(imageId)) deletedGalleryImageIds.push(imageId);
        if(!currentRemoved.includes(path)) currentRemoved.push(path);
        hiddenInput.val(currentRemoved.join(','));
        wrapper.remove();
    });

    function fetchSubcategories(categoryId, selectedSubId = null) {
        const subcategoriesDropdown = $("#sub_category_id");
        subcategoriesDropdown.html('<option value="">Loading...</option>').prop("disabled", true);
        $.ajax({
            url: "/api/get-register-subcategories",
            type: "POST",
            data: { category_id: categoryId },
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr("content") },
            success: function(data) {
                let html = '<option value="">Select Sub Category</option>';
                data.forEach(sub => {
                    html += `<option value="${sub.id}" ${sub.id == selectedSubId ? 'selected' : ''}>${sub.name}</option>`;
                });
                subcategoriesDropdown.html(html).prop("disabled", false);
            },
            error: () => subcategoriesDropdown.html('<option value="">Failed to load</option>')
        });
    }

    $("#category_id").on("change", function() { fetchSubcategories($(this).val()); });

    $("#add-specification").on("click", function() {
        let html = `
        <div class="col-md-3 mb-3 spec-row"><label class="form-label">Label</label><input type="text" name="specification_label[]" class="form-control" placeholder="e.g. Material"></div>
        <div class="col-md-8 mb-3 spec-row"><label class="form-label">Description</label><input type="text" name="specification_description[]" class="form-control" placeholder="e.g. 100% Cotton"></div>
        <div class="col-md-1 mb-3 spec-row d-flex align-items-end"><button type="button" class="btn btn-danger remove-spec-btn">X</button></div>`;
        $("#specification-wrapper").append(html);
    });

    $('#specification-wrapper').on('click', '.remove-spec-btn', function() {
        const parent = $(this).closest('.spec-row');
        parent.prev().prev().remove();
        parent.prev().remove();
        parent.remove();
    });

    // --- INITIALIZATION CALLS ---
    if ($('#category_id').val()) {
        fetchSubcategories($('#category_id').val(), existingSubCategoryId);
    }
    existingVariations.forEach(v => createVariationCard(v));
});
</script>
@endpush