@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('add_new_product') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('add_new_product') }}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-xl-10 mx-auto">
                    <a href="{{ route('provider.product') }}" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i class="isax isax-arrow-left me-1"></i>{{ __('back_to_products') }}</a>

                    {{-- Form starts here --}}
                    <form id="product-form" enctype="multipart/form-data" autocomplete="off" novalidate>
                        @csrf
                        <input type="hidden" id="slug" name="slug"> {{-- Slug is auto-generated and hidden --}}

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('product_information') }}</h4>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="product_name" class="form-label">{{ __('product_name') }} <span class="text-danger">*</span></label>
                                        <input type="text" id="product_name" name="product_name" placeholder="{{ __('product_name_placeholder') }}" class="form-control">
                                        <span id="product_name_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="product_code" class="form-label">{{ __('product_code') }} <span class="text-danger">*</span></label>
                                        <input type="text" id="product_code" name="product_code" placeholder="{{ __('product_code_placeholder') }}" class="form-control">
                                        <span id="product_code_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="category_id" class="form-label">{{ __('category') }} <span class="text-danger">*</span></label>
                                        <select id="category_id" name="category_id" class="form-select categoryProviderSelect searchable-select">
                                            <option value="">{{ __('select_category') }}</option>
                                            @foreach ($categoriesProduct as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        <span id="category_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sub_category_id" class="form-label">{{ __('sub_category') }} <span class="text-danger">*</span></label>
                                        <select name="sub_category_id" id="sub_category_id" class="form-select subcategories searchable-select" disabled>
                                            <option value="">{{ __('select_sub_category') }}</option>
                                        </select>
                                        <span id="sub_category_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="shop_id" class="form-label">{{ __('shop') }} <span class="text-danger">*</span></label>
                                        <select id="shop_id" name="shop_id" class="form-select searchable-select">
                                            <option value="">{{ __('select_shop') }}</option>
                                            @foreach ($shopList as $shop)
                                            <option value="{{ $shop->id }}">{{ $shop->shop_name }}</option>
                                            @endforeach
                                        </select>
                                        <span id="shop_id_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-12">
                                        <label for="shot_description" class="form-label">{{ __('short_description') }} <span class="text-danger">*</span></label>
                                        <textarea id="shot_description" name="shot_description" rows="3" placeholder="{{ __('short_description_placeholder') }}" class="form-control"></textarea>
                                        <span id="shot_description_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="form-label">{{ __('full_description') }} <span class="text-danger">*</span></label>
                                        <textarea id="description" name="description" rows="5" class="form-control" placeholder="{{ __('full_description_placeholder') }}"></textarea>
                                        <span id="description_error" class="invalid-feedback d-block"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('product_gallery') }}</h4>
                                <label for="multi-image-upload" class="form-label">{{ __('product_gallery_instruction') }} <span class="text-danger">*</span></label>
                                <input type="file" id="multi-image-upload" name="product_images[]" multiple class="form-control">
                                <span id="product_images_error" class="invalid-feedback d-block"></span>
                                <div id="multi-image-preview-container" class="mt-3 d-flex flex-wrap gap-3"></div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('pricing_stock_variations') }}</h4>
                                <div class="row g-3">
                                    <div class="col-lg-12">
                                        <label class="form-label">{{ __('product_type') }} <span class="text-danger">*</span></label>
                                        <div class="d-flex align-items-center flex-wrap gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="product_type" id="single_product_type" value="single" checked>
                                                <label class="form-check-label" for="single_product_type">{{ __('single_product') }}</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="product_type" id="variable_product_type" value="variable">
                                                <label class="form-check-label" for="variable_product_type">{{ __('variable_product') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="single-product-content" class="mt-4">
                                    <div class="alert alert-info">{{ __('single_product_note') }}</div>
                                    <div class="row g-3 mt-2">
                                        <div class="col-md-6">
                                            <label for="price" class="form-label">{{ __('base_price') }} <span class="text-danger">*</span></label>
                                            <input type="number" id="price" name="price" placeholder="0.00" class="form-control">
                                            <span id="price_error" class="invalid-feedback d-block"></span>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="stock" class="form-label">{{ __('base_stock_quantity') }} <span class="text-danger">*</span></label>
                                            <input type="number" id="stock" name="stock" placeholder="0" class="form-control">
                                            <span id="stock_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </div>
                                <div id="variable-product-content" class="mt-4" style="display: none;">
                                    <div id="variations-container"></div>
                                    <button type="button" id="add-variation-btn" class="btn btn-outline-primary mt-3">
                                        <i class="ti ti-plus me-2"></i>{{ __('add_variation') }}
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('shipping') }}</h4>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label for="international_shipping" class="form-label">{{ __('international_shipping') }}</label>
                                        <textarea id="international_shipping" name="international_shipping" rows="3" class="form-control"></textarea>
                                        <span id="international_shipping_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="domestic_shipping" class="form-label">{{ __('domestic_shipping') }}</label>
                                        <textarea id="domestic_shipping" name="domestic_shipping" rows="3" class="form-control"></textarea>
                                        <span id="domestic_shipping_error" class="invalid-feedback d-block"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('specifications') }}</h4>
                                <div id="specification-wrapper" class="row g-3">
                                </div>
                                <div class="mt-3">
                                    <button type="button" id="add-specification" class="btn btn-primary">{{ __('add_specification') }}</button>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('seo_title') }}</h4>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="meta_title" class="form-label">{{ __('meta_title') }}</label>
                                        <input type="text" id="meta_title" name="meta_title" class="form-control" placeholder="{{ __('meta_title_placeholder') }}">
                                        <span id="meta_title_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="form-label">{{ __('meta_description') }}</label>
                                        <textarea id="meta_description" name="meta_description" rows="3" class="form-control" placeholder="{{ __('meta_description_placeholder') }}"></textarea>
                                        <span id="meta_description_error" class="invalid-feedback d-block"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title mb-4">{{ __('status') }}</h4>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="status" class="form-label">{{ __('product_status') }} <span class="text-danger">*</span></label>
                                        <select id="status" name="status" class="form-select">
                                            <option value="active">{{ __('active_status') }}</option>
                                            <option value="draft">{{ __('draft_status') }}</option>
                                        </select>
                                        <span id="status_error" class="invalid-feedback d-block"></span>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="status" class="form-label">{{ __('feature') }} <span class="text-danger">*</span></label>
                                       <select id="feature" name="feature" class="form-select">
                                            <option value="1">{{ __('active') }}</option>
                                            <option value="0">{{ __('inactive') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('provider.product') }}" class="btn btn-light">{{ __('cancel') }}</a>
                            <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('save_product') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script src="{{ asset('front/js/product/create.js') }}"></script>
@endpush