@extends('frontend.provider.app')

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">

                    <div class="service-wizard mb-4">
                        <ul class="d-flex align-items-center flex-wrap row-gap-2" id="progressbar">
                            <li class="active me-2">
                                <span class="me-2"><i class="ti ti-info-circle"></i></span>
                                <h6>General</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-photo"></i></span>
                                <h6>Galley</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-versions"></i></span>
                                <h6>Variations</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-packages"></i></span>
                                <h6>Inventory</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-shield"></i></span>
                                <h6>SEO</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-truck"></i></span>
                                <h6>Shipping</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-list-details"></i></span>
                                <h6>Specification</h6>
                            </li>
                            <li class="me-2">
                                <span class="me-2"><i class="ti ti-toggle-right"></i></span>
                                <h6>Status</h6>
                            </li>
                        </ul>
                    </div>

                    <form id="product-form" enctype="multipart/form-data" autocomplete="off">
                        @csrf
                        <div class="card">
                            <div class="card-body">
                                <fieldset id="first-section" class="tab-content">
                                    <h4 class="mb-3 ">Service Information</h4>
                                    <div class="row g-3">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="product_name" class="form-label">Product Name <span class="text-danger">*</span></label>
                                                <input type="text" id="product_name" name="product_name" placeholder="e.g. Wireless Mouse" class="form-control">
                                                <span id="product_name_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="slug" class="form-label">Slug <span class="text-danger">*</span></label>
                                                <input type="text" id="slug" name="slug" placeholder="Auto-generated from product name" class="form-control" readonly>
                                                <span id="slug_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="product_code" class="form-label">Product Code <span class="text-danger">*</span></label>
                                                <input type="text" id="product_code" name="product_code" placeholder="e.g. SKU-12345" class="form-control">
                                                <span id="product_code_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="category_id" class="form-label">
                                                    Category <span class="text-danger">*</span>
                                                </label>
                                                <select id="category_id" name="category_id" class="form-select categoryProviderSelect">
                                                    <option value="">{{ __('Select Category') }}</option>
                                                    @foreach ($categoriesProduct as $category)
                                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                                    @endforeach
                                                </select>
                                                <span id="category_id_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="sub_category_id" class="form-label">
                                                    Sub Category <span class="text-danger">*</span>
                                                </label>
                                                <select name="sub_category_id" id="sub_category_id" class="form-select subcategories" disabled>
                                                    <option value="">{{ __('Select Sub Category') }}</option>
                                                </select>
                                                <span id="sub_category_id_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="shop_id" class="form-label">Shop <span class="text-danger">*</span></label>
                                                <select id="shop_id" name="shop_id" class="form-select">
                                                    <option value="">{{ __('Select Shop') }}</option>
                                                    @foreach ($shopList as $shop)
                                                    <option value="{{ $shop->id }}">{{ $shop->shop_name }}</option>
                                                    @endforeach
                                                </select>
                                                <span id="shop_id_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="shot_description" class="form-label">Shot Description <span class="text-danger">*</span></label>
                                                <input id="shot_description" name="shot_description" rows="5" placeholder="Enter Shot Description..." class="form-control">
                                                <span id="shot_description_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                                                <textarea id="description" name="description" rows="5" placeholder="Start typing..." class="form-control"></textarea>
                                                <span id="description_error" class="invalid-feedback d-block"></span>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset id="second-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3 ">Galley</h4>
                                    <div class="row g-4">
                                        <div class="col-md-12">
                                            <label for="product_images" class="form-label">Additional Product Images</label>
                                            <input type="file" id="multi-image-upload" name="product_images[]" multiple class="form-control">
                                            <span id="product_images_error" class="invalid-feedback d-block"></span>
                                            <div id="multi-image-preview-container" class="mt-3 d-flex flex-wrap gap-3"></div>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset id="seventh-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3 ">Variations</h4>
                                    <div id="variations-container"></div>
                                    <button type="button" id="add-variation-btn" class="btn btn-outline-primary mt-3">
                                        <i class="ti ti-plus me-2"></i>Add Variation
                                    </button>
                                </fieldset>

                                <fieldset id="third-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3 ">Inventory</h4>
                                    <div class="alert alert-info">Note: This price and stock will be used if no variations are added. If variations with their own prices are created, this will be ignored.</div>
                                    <div class="row g-3 mt-2">
                                        <div class="col-md-6">
                                            <label for="price" class="form-label">Base Price ($) <span class="text-danger">*</span></label>
                                            <input type="number" id="price" name="price" placeholder="0.00" class="form-control">
                                            <span id="price_error" class="invalid-feedback d-block"></span>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="stock" class="form-label">Base Stock Quantity <span class="text-danger">*</span></label>
                                            <input type="number" id="stock" name="stock" placeholder="0" class="form-control">
                                            <span id="stock_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset id="fourth-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3 ">SEO</h4>
                                    <div class="row g-3">
                                        <div class="col-12">
                                            <label for="meta_title" class="form-label">Meta Title</label>
                                            <input type="text" id="meta_title" name="meta_title" class="form-control">
                                            <span id="meta_title_error" class="invalid-feedback d-block"></span>
                                        </div>
                                        <div class="col-12">
                                            <label for="meta_description" class="form-label">Meta Description</label>
                                            <textarea id="meta_description" name="meta_description" rows="3" class="form-control"></textarea>
                                            <span id="meta_description_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset id="fifth-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3">Shipping & Delivery</h4>

                                    <div class="row g-3 mt-3">
                                        <div class="col-md-12">
                                            <label for="international_shipping" class="form-label">International Shipping</label>
                                            <textarea id="international_shipping" name="international_shipping" rows="3" class="form-control"></textarea>
                                            <span id="international_shipping_error" class="invalid-feedback d-block"></span>
                                        </div>

                                        <div class="col-md-12">
                                            <label for="domestic_shipping" class="form-label">Domestic Shipping</label>
                                            <textarea id="domestic_shipping" name="domestic_shipping" rows="3" class="form-control"></textarea>
                                            <span id="domestic_shipping_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </fieldset>

                                <fieldset id="sixth-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3">Shipping & Delivery</h4>

                                    <div id="specification-wrapper" class="row g-3">
                                        <!-- Dynamic fields will be appended here -->
                                    </div>

                                    <div class="mt-3">
                                        <button type="button" id="add-specification" class="btn btn-primary">
                                            Add Specification
                                        </button>
                                    </div>
                                </fieldset>

                                <fieldset id="seventh-section" class="tab-content" style="display: none;">
                                    <h4 class="mb-3 ">Status</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="status" class="form-label">Product Status <span class="text-danger">*</span></label>
                                            <select id="status" name="status" class="form-select">
                                                <option value="active">Active</option>
                                                <option value="draft">Draft</option>
                                            </select>
                                            <span id="status_error" class="invalid-feedback d-block"></span>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="card-footer bg-white d-flex justify-content-end gap-2">
                                <button type="button" id="prev-btn" class="btn btn-light" style="display: none;">Previous</button>
                                <button type="button" id="next-btn" class="btn btn-primary">Next</button>
                                <button type="submit" id="submit-btn" class="btn btn-primary" style="display: none;">Save Product</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $("#description").summernote({
            height: 300,
        });
        function showToast(type, message) {
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": "5000" // 5 seconds
        };
        toastr[type](message);
    }
    });
    $(function() {
        // ===================================================================
        // === CORE FORM SUBMISSION LOGIC (AJAX) ===========================
        // ===================================================================

        $("#product-form").on("submit", function(event) {
            // Prevent the default browser submission
            event.preventDefault();

            const form = this;
            const formData = new FormData(form);

            $.ajax({
                url: "/provider/product/store", // Replace with your actual store route
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    Accept: "application/json",
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                beforeSend: function() {
                    $("#submit-btn").prop("disabled", true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Saving...');
                },
                success: function(response) {
                    Swal.fire({
                        icon: "success",
                        title: "Product Saved!",
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false,
                    }).then(() => {
                        if (response.redirectUrl) {
                            window.location.href = response.redirectUrl;
                        }
                    });
                },
                error: function(jqXHR) {
                    let errorMessage = "An unexpected error occurred. Please try again.";
                    // Error handling for backend validation still exists, which is good practice.
                    if (jqXHR.status === 422) {
                        const errors = jqXHR.responseJSON.errors;
                        $('span[id$="_error"]').text("");
                        $.each(errors, function(key, value) {
                            const sanitizedKey = key.replace(/\./g, "_").replace(/\[/g, "_").replace(/\]/g, "");
                            $("#" + sanitizedKey + "_error").text(value[0]);
                        });
                        errorMessage = "Please correct the form errors and try again.";
                    }
                    Swal.fire({
                        icon: "error",
                        title: "Oops...",
                        text: errorMessage,
                    });
                },
                complete: function() {
                    $("#submit-btn").prop("disabled", false).text("Save Product");
                },
            });
        });

        // --- Tab Navigation ---
        const wizardItems = $("#progressbar li");
        const contents = $(".tab-content");
        const prevBtn = $("#prev-btn");
        const nextBtn = $("#next-btn");
        const submitBtn = $("#submit-btn");
        let currentTabIndex = 0;
        const totalTabs = wizardItems.length;

        function updateWizard(targetIndex) {
            wizardItems.removeClass("active");
            wizardItems.slice(0, targetIndex + 1).addClass("active");

            contents.hide();
            contents.eq(targetIndex).show();

            prevBtn.toggle(targetIndex > 0);
            nextBtn.toggle(targetIndex < totalTabs - 1);
            submitBtn.toggle(targetIndex === totalTabs - 1);

            currentTabIndex = targetIndex;
        }

        // The validation check is removed from the next button
        nextBtn.on("click", function() {
            if (currentTabIndex < totalTabs - 1) {
                updateWizard(currentTabIndex + 1);
            }
        });

        prevBtn.on("click", () => currentTabIndex > 0 && updateWizard(currentTabIndex - 1));
        updateWizard(0);

        // ===================================================================
        // === HELPER SCRIPTS (Previews, Slug, etc.) =========================
        // ===================================================================

        $("#thumbnail-upload").on("change", function(event) {
            if (event.target.files && event.target.files[0]) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    $("#thumbnail-preview").attr("src", e.target.result).removeClass("d-none");
                    $("#thumbnail-placeholder").addClass("d-none");
                };
                reader.readAsDataURL(event.target.files[0]);
            }
        });

        $("#multi-image-upload").on("change", function() {
            const previewContainer = $("#multi-image-preview-container").empty();
            if (this.files) {
                $.each(this.files, (i, file) => {
                    previewContainer.append(
                        $("<img>", {
                            src: URL.createObjectURL(file),
                            class: "rounded border",
                            style: "height: 96px; width: 96px; object-fit: cover;"
                        })
                    );
                });
            }
        });

        $("#product_name").on("input", function() {
            const slug = $(this).val().toLowerCase().trim()
                .replace(/\s+/g, "-")
                .replace(/[^\w\-]+/g, "")
                .replace(/\-\-+/g, "-");
            $("#slug").val(slug);
        });

        // ===================================================================
        // === DYNAMIC PRODUCT VARIATIONS LOGIC ==============================
        // ===================================================================
        const variationsContainer = $("#variations-container");
        let variationIndex = 0;

        $("#add-variation-btn").on("click", function() {
            variationIndex++;
            const template = `
        <div class="variation-card card card-body mb-3 position-relative" id="variation-${variationIndex}">
            <button type="button" class="btn-close remove-variation-btn position-absolute top-0 end-0 mt-2 me-2" aria-label="Close"></button>
            <div class="row g-3">
                <div class="col-12">
                    <label class="form-label mb-2">Variation Images</label>
                    <div class="image-preview-container d-flex flex-wrap gap-2 p-2 border rounded bg-light w-100" style="min-height: 96px;">
                        <span class="placeholder-text text-muted small align-self-center ms-2">Image previews here</span>
                    </div>
                    <div class="mt-2">
                         <input type="file" id="file-input-${variationIndex}" name="variations[${variationIndex}][images][]" class="variation-image-input form-control form-control-sm" multiple/>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label mb-2">Color</label>
                    <input type="color" name="variations[${variationIndex}][color]" value="#000000" class="form-control form-control-color" style="height: 38px; width: 100px;">
                </div>
            </div>
            <hr class="my-3">
            <div>
                <h6 class="fw-semibold mb-3">Sizes, Prices & Stock</h6>
                <div class="size-price-container"></div>
                <button type="button" class="add-size-btn btn btn-sm btn-link p-0 mt-2">+ Add Size</button>
            </div>
        </div>`;
            $(template).appendTo(variationsContainer).find(".add-size-btn").click();
        });

        variationsContainer.on("click", ".remove-variation-btn", function() {
            $(this).closest(".variation-card").remove();
        });
        variationsContainer.on("click", ".remove-size-btn", function() {
            $(this).closest(".size-price-row").remove();
        });

        variationsContainer.on("change", ".variation-image-input", function() {
            const previewContainer = $(this).closest(".variation-card").find(".image-preview-container").empty();
            if (this.files && this.files.length > 0) {
                $.each(this.files, (i, file) => {
                    const reader = new FileReader();
                    reader.onload = (e) =>
                        previewContainer.append(
                            $("<img>", {
                                src: e.target.result,
                                class: "rounded border",
                                style: "height: 80px; width: 80px; object-fit: cover;"
                            })
                        );
                    reader.readAsDataURL(file);
                });
            }
        });

        variationsContainer.on("click", ".add-size-btn", function() {
            const container = $(this).prev(".size-price-container");
            const vIndex = $(this).closest(".variation-card").attr("id").split("-")[1];
            const sizeTemplate = `
        <div class="size-price-row row g-2 align-items-center mb-2">
            <div class="col-sm-3">
                <input type="text" name="variations[${vIndex}][sizes][]" class="form-control form-control-sm" placeholder="e.g., M">
            </div>
             <div class="col-sm-3">
                <input type="number" name="variations[${vIndex}][prices][]" class="form-control form-control-sm" placeholder="Price">
            </div>
             <div class="col-sm-3">
                <input type="number" name="variations[${vIndex}][stocks][]" class="form-control form-control-sm" placeholder="Stock">
            </div>
            <div class="col-sm-3 text-end">
                <button type="button" class="btn-close remove-size-btn" aria-label="Remove Size"></button>
            </div>
        </div>`;
            container.append(sizeTemplate);
        });
    });

    $(document).on("change", "#category_id", function() {
        const categoryId = $(this).val();
        const subcategoriesDropdown = $(".subcategories");

        if (categoryId) {
            var langCode = $("body").data("lang");

            $.ajax({
                url: "/api/get-register-subcategories",
                type: "POST",
                data: {
                    category_id: categoryId,
                    language_code: langCode
                },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function(data) {
                    let subcategoriesHtml = '<option value="">' + ($("body").data("translate-select-sub-category") ?? "Select Sub Category") + '</option>';

                    data.forEach((subcategory) => {
                        subcategoriesHtml += `<option value="${subcategory.id}">${subcategory.name}</option>`;
                    });

                    subcategoriesDropdown.html(subcategoriesHtml).prop("disabled", false);
                },
                error: function(xhr) {
                    const errorMessage =
                        xhr.responseJSON && xhr.responseJSON.error ?
                        xhr.responseJSON.error :
                        "Failed to fetch subcategories. Please try again.";
                    showToast('error', errorMessage);

                    subcategoriesDropdown.html('<option value="">Select Sub Category</option>').prop("disabled", true);
                },
            });
        } else {
            subcategoriesDropdown.html('<option value="">Select Sub Category</option>').prop("disabled", true);
        }
    });

    $(document).ready(function() {
        $("#add-specification").on("click", function() {
            let html = `
            <div class="col-md-3 mb-3">
                <label class="form-label">Label</label>
                <input type="text" name="specification_label[]" class="form-control" placeholder="Enter label">
            </div>
            <div class="col-md-9 mb-3">
                <label class="form-label">Description</label>
                <input type="text" name="specification_description[]" class="form-control" placeholder="Enter description">
            </div>
        `;
            $("#specification-wrapper").append(html);
        });
    });
</script>
@endpush