@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('earning_payout')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('withdraw_amount')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">

            <!-- start row -->
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">

                    <!-- Header Section -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 mb-4">
                        <div class="skeleton label-skeleton label-loader"></div>
                        <h4 class="d-none real-label">{{__('withdraw_amount')}}</h4>
                        <div class="d-flex align-items-center flex-wrap row-gap-3">

                            <div class="skeleton label-skeleton label-loader"></div>
                            <button class="btn btn-secondary d-flex justify-content-center align-items-center d-none real-label"
                                style="display: none" data-bs-toggle="modal" id="send_request" data-bs-target="#request_amount">
                                <i class="ti ti-help-circle me-2"></i>{{__('withdraw_amount')}}
                            </button>
                        </div>
                    </div>

                    <!-- Main Content Row -->
                    <div class="row">
                        <!-- Left Column - Chart -->
                        <div class="col-lg-8">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <h5 class="mb-0">{{ __('total_withdraws') }}</h5>
                                        <div class="d-flex align-items-center">
                                            <span class="badge bg-warning text-white me-2">
                                                <i class="ti ti-chart-line me-1"></i>{{ __('Withdraw') }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <!-- Chart container - you can integrate your existing chart here -->
                                    <div id="withdraw_chart" style="height: 190px;">

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column - Summary Cards -->
                        <div class="col-lg-4">
                            <!-- Credited Card -->
                            <div class="card mb-4">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <span class="badge badge-xl p-2 badge-soft-success text-success d-inline-flex align-items-center justify-content-center me-2">
                                            <i class="ti ti-trending-up fs-24"></i>
                                        </span>
                                        <div>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="fs-14 fw-semibold mb-1 d-none real-label">{{ __('Last Payout') }}</p>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <h5 class="mb-0 d-none real-label"><span class="counter available_amount" id="last_payout"></span></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Available Balance Card -->
                            <div class="card mb-0">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <span class="badge badge-xl p-2 badge-soft-secondary text-secondary d-inline-flex align-items-center justify-content-center me-2">
                                            <i class="ti ti-wallet fs-24"></i>
                                        </span>
                                        <div>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="fs-14 fw-semibold mb-1 d-none real-label">{{ __('Available Amount') }}</p>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <h5 class="mb-0 d-none real-label"><span class="counter available_amount"></span></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Withdrawals Table -->
                    <div class="card mb-0 mt-4">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                                <h5 class="mb-0">{{ __('total_withdraws') }}</h5>
                                <div class="d-flex align-items-center flex-wrap gap-3">
                                    <div class="">
                                        <div class="input-group input-group-flat">
                                            <span class="input-group-text">
                                                <i class="ti ti-search text-dark"></i>
                                            </span>
                                            <input type="text" class="form-control form-control-sm" placeholder="{{ __('Search') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Tab Navigation -->
                            <ul class="nav nav-tabs nav-solid-primary wishlist-tab mb-4" id="payoutTab" role="tablist">
                                <li class="nav-item">
                                    <button class="nav-link active"
                                        id="payoutRequest"
                                        data-bs-toggle="tab"
                                        data-bs-target="#payout-request"
                                        type="button"
                                        role="tab"
                                        aria-controls="payout-request"
                                        aria-selected="true">
                                        {{ __('payout_request') }}
                                    </button>
                                </li>
                                <li class="nav-item">
                                    <button class="nav-link"
                                        id="payoutHistory"
                                        data-bs-toggle="tab"
                                        data-bs-target="#payout-history"
                                        type="button"
                                        role="tab"
                                        aria-controls="payout-history"
                                        aria-selected="false">
                                        {{ __('payout_history') }}
                                    </button>
                                </li>
                            </ul>


                            <!-- Tab Content -->
                            <div class="tab-content" id="payoutTabContent">
                                <div class="tab-pane fade show active" id="payout-request" role="tabpanel">
                                    <div class="table-responsive table-nowrap">
                                        <table class="table border d-none real-label" id="payoutRequestTable" data-empty="{{ __('no_data_available') }}">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('Transaction Id') }}</th>
                                                    <th>{{ __('requested_date') }}</th>
                                                    <th>{{ __('amount_paid') }}</th>
                                                    <th>{{ __('Payment Methods') }}</th>
                                                    <th>{{ __('Status') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Dynamic content will be loaded here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="payout-history" role="tabpanel">
                                    <div class="table-responsive table-nowrap">
                                        <table class="table border d-none" id="payoutHistoryTable" data-empty="{{ __('no_data_available') }}">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>{{ __('Payout Date') }}</th>
                                                    <th>{{ __('Total Amount') }}</th>
                                                    <th>{{ __('Processed Amount') }}</th>
                                                    <th>{{ __('Payment Method') }}</th>
                                                    <th>{{ __('Status') }}</th>
                                                    <th>{{ __('Payment Processed') }}</th>
                                                    <th>{{ __('Payment Proof') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Dynamic content will be loaded here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Loading Table -->
                            <table id="loader-table" class="table table-striped table-bordered">
                                <thead class="table-dark">
                                    <tr>
                                        <th>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="d-none real-label"></p>
                                        </th>
                                        <th>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="d-none real-label"></p>
                                        </th>
                                        <th>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="d-none real-label"></p>
                                        </th>
                                        <th>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="d-none real-label"></p>
                                        </th>
                                        <th>
                                            <div class="skeleton label-skeleton label-loader"></div>
                                            <p class="d-none real-label"></p>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @for ($i = 0; $i < 8; $i++)
                                        <tr>
                                        <td>
                                            <div class="skeleton data-skeleton data-loader"></div>
                                            <p class="d-none real-data"></p>
                                        </td>
                                        <td>
                                            <div class="skeleton data-skeleton data-loader"></div>
                                            <p class="d-none real-data"></p>
                                        </td>
                                        <td>
                                            <div class="skeleton data-skeleton data-loader"></div>
                                            <p class="d-none real-data"></p>
                                        </td>
                                        <td>
                                            <div class="skeleton data-skeleton data-loader"></div>
                                            <p class="d-none real-data"></p>
                                        </td>
                                        <td>
                                            <div class="skeleton data-skeleton data-loader"></div>
                                            <p class="d-none real-data"></p>
                                        </td>
                                        </tr>
                                        @endfor
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>

            </div>

        </div>
    </div>
    <!-- End Content -->
</div>

<!-- Set Payout Modal -->
<div class="modal fade wallet-modal" id="set-payout" data-bs-backdrop="static" data-bs-keyboard="false"
    tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between border-0">
                <h5>{{ __('Set Your Payouts') }}</h5>
                <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ti ti-circle-x-filled fs-20"></i>
                </a>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="bank-selection">
                            <input type="radio" value="1" id="rolelink" class="payout_type" name="attachment">
                            <label for="rolelink">
                                <img src="{{ asset('front/img/icons/paypal.svg') }}" alt="Paypal">
                                <span class="role-check"><i class="fa-solid fa-circle-check"></i></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="bank-selection">
                            <input type="radio" value="2" id="rolelink1" class="payout_type" name="attachment">
                            <label for="rolelink1">
                                <img src="{{ asset('front/img/icons/stripe.svg') }}" alt="Stripe">
                                <span class="role-check"><i class="fa-solid fa-circle-check"></i></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="bank-selection">
                            <input type="radio" value="4" id="rolelink2" class="payout_type" name="attachment">
                            <label for="rolelink2">
                                <img src="{{ asset('front/img/icons/bank-transfer.svg') }}" alt="Bank Transfer">
                                <span class="role-check"><i class="fa-solid fa-circle-check"></i></span>
                            </label>
                        </div>
                    </div>
                </div>
                <form id="payoutForm">
                    <input type="hidden" id="provider_id" name="provider_id" value="{{ Auth::id() }}">
                    <input type="hidden" id="payout_type" name="payout_type" value="1">
                    <input type="hidden" id="id" name="id" value="">

                    <div id="paypalContainer" style="display: none">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Paypal ID') }}</label>
                                    <input type="text" id="paypal_id" name="paypal_id" class="form-control">
                                    <span class="error-text text-danger" id="paypal_id_error" data-required="{{ __('paypal_id_required') }}"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="stripeContainer" style="display: none">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Stripe ID') }}</label>
                                    <input type="text" id="stripe_id" name="stripe_id" class="form-control">
                                    <span class="error-text text-danger" id="stripe_id_error" data-required="{{ __('stripe_id_required') }}"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="bankContainer" style="display: none">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Account Holder Name') }}</label>
                                    <input type="text" id="holder_name" name="holder_name" class="form-control">
                                    <span class="error-text text-danger" id="holder_name_error" data-required="{{ __('holder_name_required') }}"></span>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Bank Name') }}</label>
                                    <input type="text" id="bank_name" name="bank_name" class="form-control">
                                    <span class="error-text text-danger" id="bank_name_error" data-required="{{ __('bank_name_required') }}"></span>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Account Number') }}</label>
                                    <input type="text" id="account_number" name="account_number" class="form-control">
                                    <span class="error-text text-danger" id="account_number_error" data-required="{{ __('account_number_required') }}"></span>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('IFSC Code') }}</label>
                                    <input type="text" id="ifsc" name="ifsc" class="form-control">
                                    <span class="error-text text-danger" id="ifsc_error" data-required="{{ __('ifsc_required') }}"></span>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn bg-gray" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="submit" class="btn btn-dark" id="payout_save_btn" data-save="{{ __('Save') }}">{{ __('Save') }}</button>
            </div>
            </form>
        </div>
    </div>
</div>

<!-- Request Amount Modal -->
<div class="modal fade wallet-modal" id="request_amount" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="requestForm">
                <div class="modal-header">
                    <h6 class="text-dark modal-title fw-bold">{{ __('withdraw_amount') }}</h6>
                    <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="isax isax-close-circle"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Available Balance -->
                    <div class="mb-3 d-none">
                        <label class="form-label">{{ __('available_balance') }}</label>
                        <input type="text" class="form-control available_amount" id="available_balance" value="" readonly>
                    </div>

                    <!-- Withdrawal Amount -->
                    <div class="mb-3">
                        <label class="form-label">{{ __('withdraw_amount') }} <span class="text-danger ms-1">*</span></label>
                        <input type="text" name="amount" id="withdraw_amount_input" class="form-control">
                        <span class="fs-14 d-inline-flex align-items-center">
                            <i class="isax isax-info-circle me-1"></i>
                            {{ __('minimum_withdraw_amount') }}
                        </span>
                        <span class="error-text text-danger" id="withdraw_amount_error"></span>
                    </div>

                    <!-- Payment Type -->
                    <div class="wallet-item-two">
                        <label class="form-label">{{ __('Payment Type') }}</label>
                        <ul class="mb-3 d-flex align-items-center flex-lg-nowrap flex-wrap gap-2" id="payment-options">
                            <li class="nav-item d-flex align-items-center gap-1 me-4">
                                <input type="radio" id="payment-credit" name="pay-tab" checked>
                                <label class="nav-link fs-14" for="payment-credit">{{ __('Credit / Debit Card') }}</label>
                            </li>
                            <li class="nav-item d-flex align-items-center gap-1 me-4">
                                <input type="radio" id="payment-paypal" name="pay-tab">
                                <label class="nav-link fs-14" for="payment-paypal">{{ __('PayPal') }}</label>
                            </li>
                            <li class="nav-item d-flex align-items-center gap-1">
                                <input type="radio" id="payment-stripe" name="pay-tab">
                                <label class="nav-link fs-14" for="payment-stripe">{{ __('stripe') }}</label>
                            </li>
                        </ul>

                        <!-- Credit/Debit Card -->
                        <div class="payment-contents">
                            <div class="payment-content" id="payment-content-credit">
                                <div class="row row-gap-3">
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="cardHolderName">{{ __('card_holder') }} <span class="text-danger ms-1">*</span></label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-user text-dark"></i></span>
                                                <input type="text" class="form-control" name="card_holder_name" id="cardHolderName">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="cardNumber">{{ __('card_number') }} <span class="text-danger ms-1">*</span></label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-card text-dark"></i></span>
                                                <input type="text" class="form-control" name="card_number" id="cardNumber">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="expiryDate">
                                                {{ __('Expiry Date') }}
                                                <span class="text-danger ms-1">*</span>
                                            </label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-calendar fs-16 text-dark"></i></span>
                                                <input type="text" class="form-control yearmonthpicker" name="expiry_date" id="expiryDate">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="cvv">{{ __('CVV') }} <span class="text-danger ms-1">*</span></label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-password-check text-dark"></i></span>
                                                <input type="text" class="form-control" name="cvv" id="cvv">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- PayPal -->
                            <div class="payment-content d-none mb-3" id="payment-content-paypal">
                                <div class="row row-gap-3">
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="paypalEmail">{{ __('email') }}</label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-sms text-dark"></i></span>
                                                <input type="text" class="form-control" name="paypal_email" id="paypalEmail">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="paypalPassword">{{ __('Password') }}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text"><i class="isax isax-lock text-dark"></i></span>
                                                <input type="password" class="form-control pass-input" name="paypal_password" id="paypalPassword">
                                                <span class="input-group-text toggle-password">
                                                    <i class="isax isax-eye-slash text-dark"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Stripe -->
                            <div class="payment-content d-none mb-3" id="payment-content-stripe">
                                <div class="row row-gap-2">
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="stripeEmail">{{ __('email') }}</label>
                                            <div class="input-group input-group-flat">
                                                <span class="input-group-text"><i class="isax isax-sms text-dark"></i></span>
                                                <input type="text" class="form-control" name="stripe_email" id="stripeEmail">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="checkout-item-04 mb-0">
                                            <label class="form-label" for="stripePassword">{{ __('Password') }}</label>
                                            <div class="input-group input-group-flat pass-group">
                                                <span class="input-group-text"><i class="isax isax-lock text-dark"></i></span>
                                                <input type="password" class="form-control pass-input" name="stripe_password" id="stripePassword">
                                                <span class="input-group-text toggle-password">
                                                    <i class="isax isax-eye-slash text-dark"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-secondary" id="requestSendBtn">{{ __('withdraw') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection