@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('enquiry')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('enquiry')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">

            <!-- start row -->
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">

                    <!-- Page Header -->
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 mb-4">
                        <h4 class="mb-0">{{ __('enquiry') }}</h4>
                        <div class="d-flex align-items-center flex-wrap gap-2">
                        </div>
                    </div>
                    <!-- End Page Header -->
                    <!-- Earnings Table -->
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive table-nowrap" id="enquiryTableWrapper">
                                <table class="table mb-0 border border-bottom-0 datatable table-nowrap no-pagination"
                                    id="enquiryTable" data-empty="{{ __('no_enquiries_found') }}">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>{{ __('customer_name') }}</th>
                                            <th>{{ __('email') }}</th>
                                            <th>{{ __('phone') }}</th>
                                            <th>{{ __('message') }}</th>
                                            <th>{{ __('enquiry_date') }}</th>
                                            <th>{{ __('status') }}</th>
                                            <th>{{ __('action') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- End Content -->
        <div class="modal fade" id="delete_enquiry_modal">
            <div class="modal-dialog modal-dialog-centered">
                <form id="delete_enquiry_form">
                    <div class="modal-content">
                        <div class="modal-body text-center">
                            <span class="delete-icon"><i class="isax isax-trash fs-16"></i></span>
                            <input type="hidden" name="id" id="id">
                            <h6 class="mb-1">{{ __('delete_enquiry') }}</h6>
                            <p class="mb-3">{{ __('delete_enquiry_confirmation') }}</p>
                            <div class="d-flex align-items-center justify-content-center">
                                <button type="button" class="btn btn-light w-100 me-2"
                                    data-bs-dismiss="modal">{{ __('cancel') }}</button>
                                <button type="button" id="confirm-delete-btn" class="btn btn-danger w-100">{{ __('delete') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="modal fade" id="edit_enquiry_modal">
            <div class="modal-dialog modal-dialog-centered  modal-lg">
                <div class="modal-content">
                    <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                        <h4 class="modal-title">{{ __('view_enquiry')}}</h4>
                        <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i
                                class="ti ti-circle-x-filled fs-20"></i></a>
                    </div>
                    <form id="editEnquiryForm">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" name="id" id="id" class="form-control id">

                                    <div class="mb-3">
                                        <label class="form-label">{{ __('status') }}</label><span class="text-danger">
                                            *</span>
                                        <select name="status" id="status" class="form-control validate-input">
                                            <option value="inprogress">{{ __('in_progress') }}</option>
                                            <option value="complete">{{ __('complete') }}</option>
                                        </select>
                                        <span class="text-danger error-text" id="status_error"></span>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">{{ __('Comments') }}</label><span class="text-danger">
                                            *</span>
                                        <textarea name="comments" id="comments" class="form-control validate-input" rows="4"
                                            placeholder="{{ __('enter_comments') }}"></textarea>
                                        <span class="text-danger error-text" id="comments_error"></span>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <a href="#" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('cancel')}}</a>
                            <button type="submit" class="btn btn-primary edit_enquiry_btn">{{ __('update')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/provider-enquiry.js') }}"></script>
@endpush
