@extends('frontend.provider.app')

@section('content')
<!-- Start Breadscrumb -->
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items"><a href="{{ url('/') }}">{{ __('Home') }}</a></li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{ __('settings') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ __('Delete Account') }}</h1>
        </div>
    </div>
</div>
<!-- End Breadscrumb -->

<div class="content mb-4">
    <div class="container">
        <div class="row">
            @include('provider.partials.sidebar')

            <div class="col-xl-9 col-lg-8">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <h5>{{ __('Delete Account') }}</h5>
                </div>
                <hr>

                <div class="card mb-4">
                    <div class="card-body">
                        <h6 class="mb-4">{{ __('Delete your Account') }}</h6>
                        <p>{{ __('delete_account_info') }}</p>

                        <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#del-account">
                            {{ __('Delete Account') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Start delete account -->
<div id="del-account" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Delete Account') }}</h5>
                <button type="button" class="btn-close btn-close-modal custom-btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <form id="deleteAccountForm" autocomplete="off">
                <div class="modal-body p-4">
                    <p class="fs-14">{{ __('delete_account_confirm') }}</p>
                    <div class="mb-0">
                        <label for="password" class="form-label">{{__('Password')}}</label>
                        <div class="input-group input-group-flat pass-group">
                            <span class="input-group-text">
                                <i class="isax isax-lock text-dark"></i>
                            </span>
                            <input type="password" class="form-control pass-input" name="password" id="password" placeholder="**********">
                            <span class="input-group-text toggle-password ">
                                <i class="isax isax-eye-slash text-dark"></i>
                            </span>
                        </div>
                        <span class="text-danger error-text" id="password_error"></span>
                    </div>
                </div>
                <div class="modal-footer d-flex align-items-center justify-content-end gap-1">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                <button type="submit" class="btn btn-secondary" id="deleteAccountBtn"
                    data-id="{{ Auth::id() }}"
                    data-delete="{{ __('Delete Account') }}"
                    data-password_required="{{ __('password_required') }}">{{ __('Delete Account') }}
                </button>
            </div>
            </form>
        </div>
    </div>
</div>
<!-- End delete account -->

{{-- <!-- Delete Account -->
<div class="modal fade custom-modal" id="del-account">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                <h5 class="modal-title">{{ __('Delete Account') }}</h5>
                <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i
                        class="ti ti-circle-x-filled fs-20"></i></a>
            </div>
            <form id="deleteAccountForm">
                <div class="modal-body">
                    <p class="mb-3">{{ __('delete_account_confirm') }}</p>
                    <div class="mb-0">
                        <label class="form-label">{{ __('Password') }}</label>
                        <div class="pass-group">
                            <input type="password" class="form-control pass-input" name="password" id="password"
                                placeholder="*************">
                            <span class="toggle-password feather-eye-off"></span>
                        </div>
                        <span class="error-text text-danger" id="password_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-light me-2"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                    <button type="submit" class="btn btn-dark" id="deleteAccountBtn" data-id="{{ Auth::id() }}"
                        data-delete="{{ __('Delete Account') }}"
                        data-password_required="{{ __('password_required') }}">{{ __('Delete Account') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- /Delete Account --> --}}

@endsection