@extends('provider.provider')

@section('title', 'Add New Staff')

@section('content')
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{$data['submenu'] ??  __('Add New Staff') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{$data['header'] ??  __('Add New Staff') }}</h1>
        </div>
    </div>
    <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>

<!-- Page Wrapper -->
<div class="content mb-4">
    <div class="container">
        <div class="row">
            <a href="manage-staffs.html" class="btn btn-white btn-sm d-inline-flex align-items-center mb-4"><i class="isax isax-arrow-left me-1"></i>Back to Staffs</a>

            <div class="d-flex justify-content-between mb-4">
                <ul class="nav nav-tabs nav-solid-primary wishlist-tab add-wizard">
                    <li class="nav-item"><a class="nav-link active" href="javascript:void(0);">Information</a></li>
                    <li class="nav-item"><a class="nav-link" href="javascript:void(0);">Availability</a></li>
                </ul>
            </div>
            <form id="providerAddStaffForm" action="/api/save-profile-details" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="form-wizard-content active" id="information_form">

                    <div class="card">
                        <div class="card-body">
                            <div class="sub-header">
                                <h5 class="mb-0">Basic Information</h5>
                            </div>
                            <div class="row align-items-center g-3">
                                <div class="col-lg-12 col-md-12">
                                    <div class="profile-image-wrap">
                                        <div class="profile-image avatar avatar-xxxl rounded-circle bg-light">
                                            <span class="avatar avatar-xxl rounded-circle">
                                                <i class="isax isax-image text-dark" aria-hidden="true"></i>
                                            </span>
                                        </div>
                                        <input type="file" id="upload-profile1" class="upload-profile" accept="image/*" aria-label="Upload profile image">
                                        <label for="upload-profile1" class="edit-icon" aria-label="Change profile picture">
                                            <i class="isax isax-camera" aria-hidden="true"></i>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Shop <span class="text-danger ms-1">*</span></label>
                                    <select class="select" id="shop_id" name="shop_id">
                                        <option>Select</option>
                                        <option>Mec Repair Services</option>
                                        <option>Mark Ward Hub</option>
                                        <option>The Delta Solutions</option>
                                        <option>Hade Corp Print</option>
                                    </select>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Staff ID <span class="text-danger ms-1">*</span></label>
                                    <input type="text" id="user_name" name="user_name" class="form-control">
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">First Name <span class="text-danger ms-1">*</span></label>
                                    <input type="text" class="form-control" name="first_name" id="first_name">
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Last Name <span class="text-danger ms-1">*</span></label>
                                    <input type="text" class="form-control" name="last_name" id="last_name">
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Email <span class="text-danger ms-1">*</span></label>
                                    <input type="email" class="form-control" name="email" id="email">
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Phone Number<span class="text-danger ms-1">*</span></label>
                                    <div class="input-icon input-icon-start position-relative">
                                        <span class="input-icon-addon text-dark"><i class="isax isax-call"></i></span>
                                        <input type="tel" id="phone_number" name="phone_number" class="form-control phone-input staff_phone_number" placeholder="Phone Number">
                                        <input type="hidden" id="intl_phone_number" name="intl_phone_number">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Joining Date<span class="text-danger ms-1">*</span></label>
                                    <div class="input-group input-group-flat">
                                        <input type="text" class="form-control ps-2 datetimepicker" placeholder="dd/mm/yyyy">
                                        <span class="input-group-text">
                                            <i class="isax isax-calendar fs-16 text-dark"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <label class="form-label">Designation<span class="text-danger ms-1">*</span></label>
                                    <select class="select" id="role_id" name="role_id">
                                        <option>Select</option>
                                        <option>Store Manager</option>
                                        <option>Supervisor</option>
                                        <option>Sales Associate</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end card -->

                    <div class="card">
                        <div class="card-body">
                            <div class="sub-header">
                                <h5 class="mb-0">Address Information</h5>
                            </div>
                            <div class="row align-items-center g-3">
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="addressLine1">Address Line 1</label>
                                        <input type="text" id="address_line_1" name="address_line_1" class="form-control">
                                    </div>
                                </div><!-- end col -->
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="addressLine2">Address Line 2</label>
                                        <input type="text" id="address_line_2" name="address_line_2" class="form-control">
                                    </div>
                                </div><!-- end col -->
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="country">Country <span class="text-danger ms-1">*</span></label>
                                        <select class="select country" id="country" name="country">
                                            <option disabled selected>Select</option>
                                        </select>
                                    </div>
                                </div><!-- end col -->
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="state">State <span class="text-danger ms-1">*</span></label>
                                        <select class="select state" id="state" name="state">
                                            <option disabled selected>Select</option>
                                        </select>
                                    </div>
                                </div><!-- end col -->
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="city">City <span class="text-danger ms-1">*</span></label>
                                        <select class="select city" id="city" name="city">
                                            <option disabled selected>Select</option>
                                        </select>
                                    </div>
                                </div><!-- end col -->
                                <div class="col-lg-6">
                                    <div class="mb-0">
                                        <label class="form-label" for="postal_code">Postal Code <span class="text-danger ms-1">*</span></label>
                                        <input type="text" id="postal_code" name="postal_code" class="form-control">
                                    </div>
                                </div><!-- end col -->
                            </div>
                        </div>
                    </div> <!-- end card -->

                    <div class="d-flex align-items-center justify-content-end gap-3">
                        <a class="btn btn-white d-flex align-items-center" href="javascript:void(0);">Cancel</a>
                        <button type="button" class="btn btn-secondary next-btn d-inline-flex align-items-center" id="info_continue_btn">Continue<i class="isax isax-arrow-right-3 ms-2"></i></button>
                    </div>

                </div>

                <div class="form-wizard-content" id="availability_form">

                    <div class="card">
                        <div class="card-body">
                            <div class="sub-header">
                                <h5 class="mb-0">Availability</h5>
                            </div>
                            <div class="accordion available-accordion">

                                <!-- accordion item -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button disabled" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapse" aria-expanded="false" aria-controls="time-collapse">
                                            All Days
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch">
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapse" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item show">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseOne" aria-expanded="false" aria-controls="time-collapseOne">
                                            Monday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="monday" checked>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="monday_start" name="monday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="monday_end" name="monday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button disabled" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseTwo" aria-expanded="false" aria-controls="time-collapseTwo">
                                            Tuesday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="tuesday">
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseTwo" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="tuesday_start" name="tuesday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="tuesday_end" name="tuesday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item show">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseThree" aria-expanded="false" aria-controls="time-collapseThree">
                                            Wednesday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="wednesday" checked>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="wednesday_start" name="wednesday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="wednesday_end" name="wednesday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button disabled" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseFour" aria-expanded="false" aria-controls="time-collapseFour">
                                            Thursday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="thursday">
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseFour" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="thursday_start" name="thursday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="thursday_end" name="thursday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item show">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseFive" aria-expanded="false" aria-controls="time-collapseFive">
                                            Friday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="friday">
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseFive" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="friday_start" name="friday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="friday_end" name="friday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item show">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseSix" aria-expanded="false" aria-controls="time-collapseSix">
                                            Saturday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="saturday" checked>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseSix" class="accordion-collapse collapse" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="saturday_start" name="saturday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="saturday_end" name="saturday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                                <!-- accordion item -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button disabled" type="button" data-bs-toggle="collapse" data-bs-target="#time-collapseSeven" aria-expanded="false" aria-controls="time-collapseSeven">
                                            Sunday
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" role="switch" data-day="sunday">
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="time-collapseSeven" class="accordion-collapse collapse show" data-bs-parent="#accordiontime">
                                        <div class="accordion-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Start Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="sunday_start" name="sunday_start" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">End Time <span class="text-danger ms-1">*</span></label>
                                                    <div class="input-icon input-icon-end position-relative">
                                                        <input type="text" id="sunday_end" name="sunday_end" class="form-control timepicker">
                                                        <span class="input-icon-addon text-dark"><i class="isax isax-clock"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end accordion item -->

                            </div>
                        </div>
                    </div> <!-- end card -->

                    <div class="d-flex align-items-center justify-content-end gap-3">
                        <button type="button" class="btn btn-white prev-btn d-inline-flex align-items-center"><i class="isax isax-arrow-left-2 me-2"></i>Back</button>
                        <button type="submit" class="btn btn-secondary d-inline-flex align-items-center" id="staff_save_btn">Add Staff</button>
                    </div>

                </div>

            </form>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.body.setAttribute('data-provider', 'provider.staffs');
    });
</script>
<script src="{{ asset('assets/plugins/toastr/toastr.min.js') }}"></script>
<script src="{{ asset('front/js/staff.js') }}"></script>
<script src="{{ asset('js/script.js') }}"></script>
<script src="{{ asset('front/js/intlTelInput.min.js') }}"></script>
<script>
    $(document).ready(function() {
        // Initialize international phone input
        var input = document.querySelector(".staff_phone_number");
        var iti = window.intlTelInput(input, {
            utilsScript: "{{ asset('front/js/utils.js') }}",
            preferredCountries: ['us', 'gb', 'ca'],
            separateDialCode: true
        });
        
        // Handle Continue button click - validate information form
        $("#info_continue_btn").on("click", function(e) {
            e.preventDefault();
            if (validateInformationForm()) {
                // Switch to availability tab
                $("#information_form").removeClass("active");
                $("#availability_form").addClass("active");
                $(".add-wizard li:first-child .nav-link").removeClass("active");
                $(".add-wizard li:last-child .nav-link").addClass("active");
            }
        });

        // Handle back button click
        $(".prev-btn").on("click", function(e) {
            e.preventDefault();
            $("#availability_form").removeClass("active");
            $("#information_form").addClass("active");
            $(".add-wizard li:last-child .nav-link").removeClass("active");
            $(".add-wizard li:first-child .nav-link").addClass("active");
        });

        // Handle form submission - validate both forms
        $("#staff_save_btn").on("click", function(e) {
            e.preventDefault();
            
            // Get the full international phone number
            var fullNumber = iti.getNumber();
            $("#intl_phone_number").val(fullNumber);
            
            // Validate both forms
            if (validateInformationForm() && validateAvailabilityForm()) {
                // Submit the form
                $("#providerAddStaffForm").submit();
            }
        });

        // Validation function for information form
        function validateInformationForm() {
            var isValid = true;
            
            // Required fields validation
            var requiredFields = ["first_name", "last_name", "email", "user_name", "shop_id", "role_id", "country", "state", "city", "postal_code"];
            
            requiredFields.forEach(function(field) {
                var fieldElement = $("#" + field);
                if (fieldElement.val() === "" || fieldElement.val() === null) {
                    fieldElement.addClass("is-invalid");
                    isValid = false;
                    toastr.error(field.replace("_", " ") + " is required");
                } else {
                    fieldElement.removeClass("is-invalid");
                }
            });
            
            // Email validation
            var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if ($("#email").val() !== "" && !emailRegex.test($("#email").val())) {
                $("#email").addClass("is-invalid");
                toastr.error("Please enter a valid email address");
                isValid = false;
            }
            
            // Phone validation
            if (!iti.isValidNumber()) {
                $("#phone_number").addClass("is-invalid");
                toastr.error("Please enter a valid phone number");
                isValid = false;
            } else {
                $("#phone_number").removeClass("is-invalid");
            }
            
            return isValid;
        }

        // Validation function for availability form
        function validateAvailabilityForm() {
            var isValid = true;
            var atLeastOneDaySelected = false;
            
            // Check if at least one day is selected
            $(".form-check-input[data-day]").each(function() {
                if ($(this).is(":checked")) {
                    atLeastOneDaySelected = true;
                    var day = $(this).data("day");
                    
                    // Validate start and end times for selected days
                    var startTime = $("#" + day + "_start").val();
                    var endTime = $("#" + day + "_end").val();
                    
                    if (startTime === "" || endTime === "") {
                        $("#" + day + "_start").addClass("is-invalid");
                        $("#" + day + "_end").addClass("is-invalid");
                        toastr.error("Please select both start and end times for " + day);
                        isValid = false;
                    } else {
                        $("#" + day + "_start").removeClass("is-invalid");
                        $("#" + day + "_end").removeClass("is-invalid");
                    }
                }
            });
            
            if (!atLeastOneDaySelected) {
                toastr.error("Please select at least one working day");
                isValid = false;
            }
            
            return isValid;
        }
    });
</script>
@endpush