@extends('frontend.theme_2.app')
@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('How It Works') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('How It Works') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <div class="content">
        <div class="how-it-works-sec bg-white">
            <section class="book-section section">
                <div class="container">
                    <div class="row align-items-center row-gap-4">
                        <div class="col-lg-6 col-md-8 mx-auto">
                            <div class="book-img">
                                <img src="frontend/assets/img/about/about-01.jpg" alt="about" class="img-fluid about-01">
                                <img src="frontend/assets/img/about/about-02.jpg" alt="about" class="img-fluid about-02">
                                <img src="frontend/assets/img/icons/star-01.svg" alt="icon" class="img-fluid book-bg-01">
                                <img src="frontend/assets/img/icons/star-02.svg" alt="icon" class="img-fluid book-bg-02">
                            </div>
                        </div>
                        <div class="col-lg-6">

                            <!-- Section Header -->
                            <div class="section-header aos" data-aos="fade-down">
                                <h2 class="title"><img src="frontend/assets/img/icons/footer-icon.svg" alt="icon" class="img-fluid me-3"> Complete Your Booking in <span class="text-secondary text-decoration-underline">3 Steps</span></h2>
                                <p>From discovery to doorstep, our platform makes booking services easy. </p>
                            </div>
                            <!-- Section Header End -->

                            <!-- Booking Steps -->
                            <div class="step-list">
                                <div class="step-item d-flex align-items-center gap-3">
                                    <span class="avatar avatar-xl me-1">
                                        <i class="isax isax-search-status-15"></i>
                                    </span>
                                    <div>
                                        <h6 class="mb-2">Browse &amp; Discover</h6>
                                        <p>Explore a wide range of trusted service providers across categories all in one place.</p>
                                    </div>
                                    <span class="step-count">01</span>
                                </div>
                                <div class="step-item d-flex align-items-center gap-3">
                                    <span class="avatar avatar-xl me-1">
                                        <i class="isax isax-calendar-tick5"></i>
                                    </span>
                                    <div>
                                        <h6 class="mb-2">Book Instantly</h6>
                                        <p>Select your preferred time slot, enter your location, and confirm your booking in just a few clicks.</p>
                                    </div>
                                    <span class="step-count">02</span>
                                </div>
                                <div class="step-item d-flex align-items-center gap-3">
                                    <span class="avatar avatar-xl me-1">
                                        <i class="isax isax-money-send5"></i>
                                    </span>
                                    <div>
                                        <h6 class="mb-2">Pay &amp; Review</h6>
                                        <p>Secure online payments and flexible options. Rate your experience to help others informed choices.</p>
                                    </div>
                                    <span class="step-count">03</span>
                                </div>
                            </div>
                            <!-- Booking Steps End -->

                        </div>
                    </div>
                </div>
                <img src="frontend/assets/img/bg/about-01.png" alt="shape" class="about-bg">
            </section>
        </div>
    </div>
</div>
@endsection