<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>

    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>
        {{ isset($data['seo_title']) ? $data['seo_title'] . ' || ' : '' }}
        @yield('title', $companyName)
    </title>
	<meta name="description" content="{{ isset($data['seo_description']) ? $data['seo_description'] : config('app.name') }}">
	<meta name="keywords" content="{{ isset($data['seo_tag']) ? $data['seo_tag'] : '' }}">

	<!-- Open Graph Tags (for social sharing) -->
	<meta property="og:title" content="{{ isset($og_title) ? $og_title : config('app.name') }}">
	<meta property="og:description" content="{{ isset($og_description) ? $og_description : '' }}">
	<meta property="og:image" content="{{ isset($og_image) ? asset($og_image) : asset('frontend/assets/img/logo.svg') }}">
	<meta property="og:url" content="{{ url()->current() }}">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $dynamicFavicon }}">
     <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">


    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ asset('frontend/assets/img/apple-icon.png') }}">
    @php
        $isRTL = isRTL(app()->getLocale());
    @endphp
    @include('frontend.theme_2.partials.styles')
    @stack('styles')
</head>

<body data-theme="{{ $theme ?? 1 }}" data-provider="{{ Route::currentRouteName() }}" data-dir="{{ $isRTL ? 'rtl' : 'ltr' }}" data-authid="{{ Auth::id() }}" data-show_more="{{ __('show_more') }}" data-show_less="{{ __('show_less') }}" data-currency="{{ getDefaultCurrencySymbol() }}">

    <!-- Page Loader -->

    <!-- Begin Wrapper -->
    <div class="main-wrapper">
        @include('cookie.cookie-consent.index')
        @include('frontend.theme_2.partials.header')

        @yield('content')
        @include('frontend.toast')
        <!-- Start Footer -->
        @include('frontend.theme_2.partials.footer')
        <!-- End Footer -->

    </div>
    <!-- End Wrapper -->
    @include('frontend.theme_2.partials.scripts')
    @stack('scripts')
</body>

</html>