<footer class="footer footer-one">
    @include('frontend.toast')
    <div class="container">
        <div class="newsletter-subscribe bg-secondary">
            <form id="newsletterForm" autocomplete="off">
                <div class="news-content">
                    <h2>{{ __('subscribe_header') }}</h2>
                    <div class="form-field position-relative" data-aos="fade-up" data-aos-delay="250">
                        <input type="email" name="subscriber_email" id="subscriber_email" class="form-control" placeholder="{{ __('enter_email_address')}}">
                        <button type="submit" class="btn btn-dark subscribe-btn btn-subscribe submitbtn" data-subscribe="{{ __('subscribe') }}">{{ __('subscribe') }}</button>
                    </div>
                    <span class="text-danger error-text" id="subscriber_email_error" data-required="{{ __('email_required')}}" data-valid="{{ __('valid_email')}}"></span>
                </div>
            </form>
            <img src="{{ asset('frontend/assets/img/bg/newsletter-shape-01.svg') }}" alt="shape" class="newsletter-bg-01">
            <img src="{{ asset('frontend/assets/img/bg/newsletter-shape-02.svg') }}" alt="shape" class="newsletter-bg-02">
        </div>
    </div>
    <!-- Footer Top -->
    <div class="footer-top">
        <div class="container">
            <div class="row row-gap-4 row-cols-xl-5">
                @if (!empty($footerList))
                    @foreach ($footerList as $footerGroup)
                        @foreach ($footerGroup as $footer)
                            @if (!empty($footer['title']) && !empty($footer['footer_content']))
                                <div class="col-xl col-lg-4 col-sm-6">

                                    <div class="footer-widget">
                                        <h6 class="footer-title">{{ $footer['title'] }}</h5>
                                        <ul class="footer-menu">{!! $footer['footer_content'] !!}</ul>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endforeach
                @endif

                <div class="col-lg-4 col-md-6">
                    <div class="footer-widget">
                        <h6 class="footer-title">{{ __('contact_us') }}</h6>
                        <div class="footer-contact">
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('address') }}</h6>
                                <p>{{ $company_address_line }}</p>
                            </div>
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('phone_number') }}</h6>
                                <p>{{ $companyPhoneNumber }}</p>
                            </div>
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('email_address') }}</h6>
                                <p><a href="mailto:info@example.com" class="text-white">{{ $companyEmail }}</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End -->

    <!-- Footer Bottom -->
    <div class="footer-bottom">
        <div class="container">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div class="copyright">
                    <p>{!! $copyRight ?? __('copyrights') . ' © ' . date('Y') . ' ' . $appName . '. ' . __('all_rights_reserved') . '.' !!}</p>
                </div>
                <div class="policy-link">
                    <a href="/terms-conditions">{{ __('terms_and_conditions') }}</a>
                    <a href="/privacy-policy">{{ __('privacy_policy') }}</a>
                </div>
                <div class="social-icon">
                    @foreach($socialLinks as $link)
                        <a href="{{ $link->link }}" target="_blank">
                            <i class="fab {{ $link->icon }} text-primary"></i>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Bottom End -->

    <img src="{{ asset('frontend/assets/img/bg/footer-bg-01.svg') }}" alt="icon" class="footer-bg-01">
    <img src="{{ asset('frontend/assets/img/bg/footer-bg-02.svg') }}" alt="icon" class="footer-bg-02">
    <img src="{{ asset('frontend/assets/img/bg/footer-bg-03.svg') }}" alt="icon" class="footer-bg-03">

</footer>