@extends('frontend.theme_2.app')

@section('title', $shop->shop_name ?? 'Shop Details')

@section('content')
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items">{!! $data['submenu'] ?? __('shops') !!}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{ $data['header'] }}</h1>
        </div>
    </div>
    <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>

<div class="content">
    <div class="container">
        <input type="hidden" id="shop_id" value="{{ $shop->id }}">
        <div class="card">
            <div class="card-body d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div class="d-flex align-items-center gap-3 flex-wrap">
                    <div class="avatar avatar-xxl">
                        <img
                            src="{{ ($shop->shop_logo && file_exists(storage_path('app/public/' . $shop->shop_logo))) ? asset('storage/' . $shop->shop_logo) : asset('assets/img/default-image.png') }}"
                            class="img-fluid w-100 rounded-circle"
                            alt="{{ $shop->shop_name }}">
                    </div>
                    <h3 class="mb-0">
                        {{ $shop->shop_name }}
                        <span class="mt-2 d-flex align-items-center gap-2 fs-14 fw-normal text-body">
                            <i class="isax isax-location"></i> {{ $shop->address }}, {{ $shop->cityRelation->name ?? '' }}, {{ $shop->countryRelation->name ?? '' }}
                        </span>
                    </h3>
                </div>
                @php
                $ratingValue = $shop->ratings_avg_rating ?? 0;
                @endphp

                <div class="d-flex align-items-center justify-content-center fs-14 mb-1">

                    @php
                    $rating = $shop->ratings_avg_rating ?? 0;
                    $fullStars = floor($rating);
                    $halfStar = $rating - $fullStars >= 0.5;
                    $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                    @endphp
                    @for ($i = 0; $i < $fullStars; $i++)
                        <i class="fa-solid fa-star text-warning"></i>
                        @endfor
                        @if ($halfStar)
                        <i class="fa-solid fa-star-half-stroke text-warning"></i>
                        @endif
                        @for ($i = 0; $i < $emptyStars; $i++)
                            <i class="fa-regular fa-star text-warning"></i>
                            @endfor
                            <p class="fs-14 ms-2 mb-0">{{ number_format($rating, 1) }} (<span class="total_reviews"></span>)</p>

                </div>
            </div>
        </div>
        <div class="row row-gap-3">
            <div class="col-lg-8">
                @if(!empty($shop->gallery))
                <div class="service-wrap card mb-4 shadow-none border-0 shadow-sm">
                    <div class="card-body p-0">
                        <div class="slider-wrap vertical-slider vertical-slider-two d-flex align-items-center">
                            <div class="slider-nav nav-center" id="small-img">
                                @foreach($shop->gallery as $image)
                                <div>
                                    @php
                                    $galleryImagePath = 'storage/' . $image;
                                    $defaultImagePath = 'assets/img/default-image.png';
                                    @endphp
                                    <a href="javascript:;"><img
                                            src="{{ file_exists(public_path($galleryImagePath)) ? asset($galleryImagePath) : asset($defaultImagePath) }}"
                                            class="img-fluid rounded"
                                            alt="gallery thumbnail"></a>
                                </div>
                                @endforeach
                            </div>
                            <div class="slider-for nav-center p-4" id="large-img">
                                @foreach($shop->gallery as $image)
                                <div class="service-img">
                                    @php
                                    $galleryImagePath = 'storage/' . $image;
                                    $defaultImagePath = 'assets/img/default-image.png';
                                    @endphp
                                    <img src="{{ file_exists(public_path($galleryImagePath)) ? asset($galleryImagePath) : asset($defaultImagePath) }}" class="img-fluid" alt="gallery image">
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <ul class="nav nav-tabs nav-bordered mb-4">
                    <li class="nav-item"><a href="#overview" data-bs-toggle="tab" class="nav-link active"><span>Overview</span></a></li>
                    <li class="nav-item"><a href="#products" data-bs-toggle="tab" class="nav-link"><span>Products</span></a></li>
                    <li class="nav-item"><a href="#services" data-bs-toggle="tab" class="nav-link"><span>Services</span></a></li>
                    <li class="nav-item"><a href="#reviews" data-bs-toggle="tab" class="nav-link"><span>Reviews</span></a></li>
                </ul>

                <div class="tab-content">
                    <!-- 1st tab -->
                    <div class="tab-pane active" id="overview">
                        <h5 class="mb-4">Overview</h5>
                        <p>{!! nl2br(e($shop->description)) !!}</p>
                    </div>
                    <!-- 2nd tab -->
                    <div class="tab-pane" id="products">
                        <h5 class="mb-4">Products Offered</h5>
                        <div class="row row-gap-4 justify-content-center">
                            @forelse($actualProducts as $product)
                            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 d-flex">
                                <div class="product-item card rounded mb-0 overflow-hidden flex-fill">
                                    <a href="{{ route('productdetail', $product->slug) }}" class="product-img-link">
                                        @php
                                        $productImagePath = $product->product_image_url ?? null;
                                        $fullPath = null;

                                        if ($productImagePath) {
                                        $directory = dirname($productImagePath);
                                        $filename = basename($productImagePath);

                                        $modifiedPath = $directory . '/fixed/' . $filename;

                                        $fullPath = 'storage/' . $modifiedPath;
                                        }

                                        $defaultImagePath = 'assets/img/default-image.png';
                                        @endphp
                                        <div class="product-img position-relative">
                                            <img src="{{ ($fullPath && file_exists(public_path($fullPath))) ? asset($fullPath) : asset($defaultImagePath) }}" class="img-fluid w-100" alt="{{ $product->source_name }}">
                                            <div class="avatar user-avatar position-absolute bottom-0 left-0">
                                                <img
                                                    src="{{ ($shop->shop_logo && file_exists(storage_path('app/public/' . $shop->shop_logo))) ? asset('storage/' . $shop->shop_logo) : asset('assets/img/default-image.png') }}"
                                                    class="rounded-circle"
                                                    alt="{{ $shop->shop_name }}">
                                            </div>
                                            <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                                                <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white frontend-list favourite" data-product-id="{{$product->id}}" data-type="products"><i class="isax isax-heart"></i></a>
                                                <a href="{{ route('productdetail', $product->slug) }}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="product-content card-body">
                                        <div class="product-info mb-3">
                                            <div class="d-flex align-items-center flex-wrap gap-2 mb-2">

                                                @if ($product->ratings_count > 0)

                                                <div class="d-flex align-items-center fs-14">
                                                    @php
                                                    $rating = round($product->avg_rating * 2) / 2;
                                                    @endphp

                                                    @for ($i = 1; $i <= 5; $i++)
                                                        @if ($i <=$rating)
                                                        <i class="fa-solid fa-star text-warning"></i>
                                                        @elseif ($i - 0.5 == $rating)
                                                        <i class="fa-solid fa-star-half-stroke text-warning"></i>
                                                        @else
                                                        <i class="fa-regular fa-star text-warning"></i>
                                                        @endif
                                                        @endfor
                                                </div>

                                                <p class="fs-14 text-body mb-0">
                                                    {{ number_format($product->avg_rating, 1) }}
                                                    ({{ $product->ratings_count }} {{ $product->ratings_count == 1 ? 'Review' : 'Reviews' }})
                                                </p>

                                                @else
                                                <div class="d-flex align-items-center fs-14">
                                                    @for ($i = 1; $i <= 5; $i++)
                                                        <i class="fa-regular fa-star text-warning"></i>
                                                        @endfor
                                                </div>
                                                <p class="fs-14 text-body mb-0">0.0 (0 Reviews)</p>
                                                @endif

                                            </div>
                                            <h6 class="mb-0"><a href="{{ route('productdetail', $product->slug) }}" class="text-dark">{{ $product->source_name }}</a></h6>
                                        </div>
                                        <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                            <h6 class="mb-0">{{ $currency_code ?? '$' }}{{ $product->source_price }}</h6>
                                            <div class="btn-icon d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                                <a href="{{ route('productdetail', $product->slug) }}" class="btn btn-icon btn-dark"><i class="isax isax-shopping-cart													"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @empty
                            <p class="text-center">No products available from this shop yet.</p>
                            @endforelse
                        </div>
                    </div>
                    <!-- 3rd tab -->
                    <div class="tab-pane" id="services">
                        <h5 class="mb-4">Services Provided</h5>
                        <div class="row row-gap-4 justify-content-center">
                            @forelse($services as $service)
                            <div class="col-xl-6 col-lg-6 col-md-6 d-flex">
                                <div class="service-item flex-fill mb-0 overflow-hidden">
                                    <div class="service-img position-relative overflow-hidden">

                                        <a href="{{ route('servicedetail', $service->slug) }}">
                                            @php
                                            $serviceImagePath = $service->product_image_url ?? null;
                                            $fullPath = null;
                                            if ($serviceImagePath) {
                                            $directory = dirname($serviceImagePath);
                                            $filename = basename($serviceImagePath);
                                            $modifiedPath = $directory . '/fixed/' . $filename;
                                            $fullPath = 'storage/' . $modifiedPath;
                                            }
                                            $defaultImagePath = 'assets/img/default-image.png';
                                            @endphp
                                            <img class="img-fluid" src="{{ ($fullPath && file_exists(public_path($fullPath))) ? asset($fullPath) : asset($defaultImagePath) }}" alt="{{ $service->source_name }}">
                                        </a>

                                        <div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
                                            <span class="badge bg-secondary">
                                                {{ $service->category_name ?? 'Service' }}
                                            </span>
                                        </div>

                                        <a href="javascript:void(0)" class="favourite frontend-list" data-product-id="{{$service->id}}" data-type="services" aria-label="Add to favourites">
                                            <i class="isax isax-heart"></i>
                                        </a>
                                    </div>
                                    <div class="service-content">
                                        <h6 class="title">
                                            <a href="{{ route('servicedetail', $service->slug) }}">{{ $service->source_name }}</a>
                                        </h6>
                                        <div class="d-flex align-items-center justify-content-between flex-wrap flex-wrap gap-1">
                                            <div class="d-flex align-items-center">
                                                <a href="{{ route('servicedetail', $service->slug) }}" class="avatar me-2">
                                                    <img src="{{ ($shop->shop_logo && file_exists(storage_path('app/public/' . $shop->shop_logo))) ? asset('storage/' . $shop->shop_logo) : asset('assets/img/default-image.png') }}" alt="{{ $shop->shop_name }}" class="rounded-circle border">
                                                </a>
                                                <div>
                                                    <h6 class="fs-16 fw-semibold mb-1"><a href="{{ route('servicedetail', $service->slug) }}">{{ $shop->shop_name }}</a></h6>

                                                    @if ($service->ratings_count > 0)
                                                    <p class="fs-14 mb-0"> <i class="fa-solid fa-star text-warning"></i>
                                                        {{ number_format($service->avg_rating, 1) }}
                                                        ({{ $service->ratings_count }} {{ $service->ratings_count == 1 ? 'Review' : 'Reviews' }})
                                                    </p>
                                                    @else
                                                    <p class="fs-14 mb-0"><i class="fa-regular fa-star text-warning"></i> 0.0 (0 Reviews)</p>
                                                    @endif

                                                </div>
                                            </div>
                                            <div>
                                                <div>
                                                    <p class="mb-1 fs-14">Starts From </p>
                                                    <h6 class="mb-0 text-end">{{ $currency_code ?? '$' }}{{ $service->source_price }}</h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @empty
                            <div class="col-12">
                                <p class="text-center">No services found for this shop.</p>
                            </div>
                            @endforelse
                        </div>
                    </div>
                    <!-- 4rd tab -->
                    <div class="tab-pane" id="reviews">
                        <!-- start row -->
                        <div class="section-header mb-4">
                            <h5 class="title fs-20 mb-0"><span class="total_reviews"></span> {{ $shop->shop_name ?  __('for') . ' ' . $shop->shop_name : ''   }}</h5>
                        </div>
                        <div class="row gy-4 mb-4">
                            <div class="col-lg-6 d-flex">
                                <div class="p-4 bg-light rounded text-center d-flex align-items-center justify-content-center flex-column flex-fill border">
                                    <h6 class="mb-4 fs-16 fw-medium">{{ __('Customer Reviews & Ratings') }}</h6>
                                    <div class="d-flex align-items-center justify-content-center gap-1 mb-2 star_icons">
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                    </div>
                                    <div class="mb-3">
                                        <h2 class="mb-0"><span class="average_ratings">0.0</span> / 5.0</h2>
                                    </div>
                                    <p class="mb-0 fs-14">{{ __('basedon') }} <span class="total_reviews">0 {{ __('review') }}</span></p>
                                </div>
                            </div> <!-- end col -->

                            <div class="col-lg-6 d-flex">
                                <div class="card shadow-none review-progress flex-fill mb-0">
                                    <div class="card-body d-flex flex-column justify-content-center">

                                        <!-- Progress 1 -->
                                        <div class="progress-lvl mb-2">
                                            <p class="fw-normal text-body text-start">5 {{ __('Star Ratings') }}</p>
                                            <div class="progress">
                                                <div class="progress-bar bg-warning five-star" id="5_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <p class="fw-normal text-body text-end" id="5_star_count">0</p>
                                        </div>

                                        <!-- Progress 2 -->
                                        <div class="progress-lvl mb-2">
                                            <p class="fw-normal text-body">4 {{ __('Star Ratings') }}</p>
                                            <div class="progress">
                                                <div class="progress-bar bg-warning" id="4_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <p class="fw-normal text-body text-end" id="4_star_count">0</p>
                                        </div>

                                        <!-- Progress 3 -->
                                        <div class="progress-lvl mb-2">
                                            <p class="fw-normal text-body text-start">3 {{ __('Star Ratings') }}</p>
                                            <div class="progress">
                                                <div class="progress-bar bg-warning" id="3_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <p class="fw-normal text-body text-end" id="3_star_count">0</p>
                                        </div>

                                        <!-- Progress 4 -->
                                        <div class="progress-lvl mb-2">
                                            <p class="fw-normal text-body text-start">2 {{ __('Star Ratings') }}</p>
                                            <div class="progress">
                                                <div class="progress-bar bg-warning" id="2_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <p class="fw-normal text-body text-end" id="2_star_count">0</p>
                                        </div>

                                        <!-- Progress 5 -->
                                        <div class="progress-lvl mb-0">
                                            <p class="fw-normal mb-0 text-body text-start">1 {{ __('Star Ratings') }}</p>
                                            <div class="progress">
                                                <div class="progress-bar bg-warning" id="1_star_progress" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <p class="fw-normal mb-0 text-body text-end" id="1_star_count">0</p>
                                        </div>
                                    </div> <!-- end card -->
                                </div> <!-- end col -->
                            </div>
                        </div>
                        <!-- end row -->
                        <!-- start review item-two -->
                        <div id="review_list_main_container">
                            <div id="review_list_container">
                            </div>
                            <div class="d-flex align-items-center justify-content-center mt-3 mb-3">
                                <button type="button" class="btn btn-dark d-inline-flex align-items-center load-more-reviews-btn d-none"><i class="isax isax-rotate-left me-1"></i>{{ __('load_more') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="mb-3 pb-3 border-bottom">Business Hours</h5>
                        @php
                        $allDays = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];

                        $workingHours = json_decode($shop->working_day, true) ?? [];
                        @endphp

                        @foreach($allDays as $day)
                        @php
                        $dayKey = strtolower($day);
                        @endphp
                        <p class="mb-3 d-flex align-items-center justify-content-between gap-2 text-dark fw-semibold">
                            <span>{{ $day }}</span>

                            @if(isset($workingHours[$dayKey]) && !empty($workingHours[$dayKey]['start_time']) && !empty($workingHours[$dayKey]['end_time']))
                            <span class="fw-normal text-body">
                                {{ \Carbon\Carbon::parse($workingHours[$dayKey]['start_time'])->format('h:i A') }} - {{ \Carbon\Carbon::parse($workingHours[$dayKey]['end_time'])->format('h:i A') }}
                            </span>
                            @else
                            <span class="fw-normal text-danger">Closed</span>
                            @endif
                        </p>
                        @endforeach
                    </div>
                </div>

                @php
                $imageMap = [
                'whatsapp' => 'assets/img/social/social-img-4.svg',
                'facebook' => 'assets/img/social/social-img-1.svg',
                'instagram' => 'assets/img/social/social-img-2.svg',
                'twitter' => 'assets/img/social/social-img-3.svg',
                'telegram' => 'assets/img/social/social-img-5.svg',
                'linkedin' => 'assets/img/social/social-img-6.svg',
                ];
                @endphp

                <div class="card">
                    <div class="card-body">
                        <h5 class="mb-3 pb-3 border-bottom">Social Profiles</h5>
                        <div class="d-flex align-items-center gap-3 social-icon">

                            @foreach ($social_link as $item)
                            @php
                            $platformKey = strtolower($item->platform_name);
                            if ($platformKey === 'whatapp') {
                            $platformKey = 'whatsapp';
                            }
                            @endphp

                            @if (array_key_exists($platformKey, $imageMap))
                            <a href="{{ $item->link }}" target="_blank" rel="noopener noreferrer">
                                <img src="{{ asset($imageMap[$platformKey]) }}" alt="{{ $item->platform_name }}" class="img-fluid">
                            </a>
                            @endif
                            @endforeach

                        </div>
                    </div>
                </div>

                <div class="card service-provider-card mb-0">
                    <div class="card-body">
                        <div class="mb-3 pb-3 border-bottom d-flex align-items-center justify-content-between flex-wrap gap-2">
                            <h5 class="mb-0">Owner Details</h5>
                        </div>

                        <div class="mb-3 pb-3 border-bottom d-flex align-items-center gap-2 d-flex align-items-center justify-content-between gap-2 flex-wrap">
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar avatar-xl">
                                    @php
                                    $ownerPhotoPath = $shop->owner->profile_photo_path ?? null;
                                    $defaultOwnerPhoto = 'assets/img/profile-default.png';
                                    @endphp
                                    <img src="{{ ($ownerPhotoPath && file_exists(public_path($ownerPhotoPath))) ? asset($ownerPhotoPath) : asset($defaultOwnerPhoto) }}" alt="user" class="img-fluid rounded-circle">
                                </div>
                                <div>
                                    <h6 class="mb-1">{{ ucfirst($shop->owner_name) ?? 'N/A' }}</h6>
                                    <p class="mb-0">Shop Since : {{ $shop->created_at?->format('j F Y') ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
                            <h6 class="mb-0 fs-16 d-flex align-items-center gap-2"><i class="isax isax-sms fs-14"></i> Email</h6>
                            <p class="mb-0 text-body"><a href="mailto:{{ $shop->email }}">{{ $shop->email }}</a></p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
                            <h6 class="mb-0 fs-16 d-flex align-items-center gap-2"><i class="isax isax-call fs-14"></i> Phone</h6>
                            <a href="tel:{{ $shop->phone }}">
                                <p class="mb-0 text-body">{{ $shop->phone }}</p>
                            </a>
                        </div>
                        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
                            <h6 class="mb-0 fs-16 d-flex align-items-center gap-2"><i class="isax isax-location fs-14"></i> Address</h6>
                            <p class="mb-0 text-body text-end">{{ ucfirst($shop->address) }}</p>
                        </div>
                        @if(!empty($full_address))
                        @php
                        $mapQuery = urlencode($full_address);
                        @endphp
                        <div class="custom-map position-relative custom-padding w-100 mb-3">
                            <iframe
                                class="w-100 rounded border-0"
                                style="height: 250px;"
                                src="https://www.google.com/maps/embed/v1/place?key={{ env('GOOGLE_MAPS_API_KEY') }}&q={{ $mapQuery }}"
                                allowfullscreen=""
                                loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"
                                title="Shop Location Map">
                            </iframe>
                            <a href="https://www.google.com/maps/search/?api=1&query={{ $mapQuery }}" target="_blank" class="btn btn-sm btn-light position-absolute">View Location</a>
                        </div>
                        @endif
                        <a href="tel:{{ $shop->phone }}" class="btn btn-secondary w-100 d-flex align-items-center justify-content-center gap-2"><i class="isax isax-call-calling"></i>Contact Owner</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/shop-details.js') }}"></script>
@endpush