@forelse ($shops as $shop)
<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 d-flex">
    <div class="card position-relative mb-0 flex-fill">
        <div class="card-body text-center">
            <div class="text-center position-relative z-1">
                <a href="{{ url('shops/' . $shop->slug) }}">
                <div class="avatar avatar-xxxl mb-4">
                    <img src="{{ $shop->shop_logo ? asset('storage/'.$shop->shop_logo) : asset('assets/img/default-image.png') }}" class="img-fluid w-100 rounded-circle" alt="{{ $shop->shop_name }}">
                </div>
                </a>
            </div>
            <div class="d-flex align-items-center justify-content-center fs-14 mb-3">
                @php
                $rating = $shop->ratings_avg_rating ?? 0;
                $fullStars = floor($rating);
                $halfStar = $rating - $fullStars >= 0.5;
                $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                @endphp
                @for ($i = 0; $i < $fullStars; $i++)
                    <i class="fa-solid fa-star text-warning"></i>
                    @endfor
                    @if ($halfStar)
                    <i class="fa-solid fa-star-half-stroke text-warning"></i>
                    @endif
                    @for ($i = 0; $i < $emptyStars; $i++)
                        <i class="fa-regular fa-star text-warning"></i>
                        @endfor
                        <p class="fs-14 ms-2 mb-0">{{ number_format($rating, 1) }}</p>
            </div>
            <h5 class="d-flex align-items-center justify-content-center gap-2 mb-2 text-center">
                <a href="{{ url('shops/' . $shop->slug) }}">{{ $shop->shop_name }}</a>
                @if($shop->is_verified)
                <i class="isax isax-tick-circle5 text-success fs-16 me-1" title="Verified"></i>
                @endif
            </h5>
            <p class="d-flex align-items-center justify-content-center gap-2 fs-14 text-body pb-3 mb-3 border-bottom text-center">
                <i class="isax isax-location text-dark"></i>{{ $shop->stateRelation->name ?? 'N/A' }}, {{ $shop->countryRelation->name ?? 'N/A' }}
            </p>
            <div class="d-flex justify-content-center gap-5">
                <h6 class="mb-0 d-flex justify-content-center flex-column gap-2">
                    {{ $shop->services_count ?? 0 }}<span class="fw-normal text-body fs-14">{{__('services') }}</span>
                </h6>
                <h6 class="mb-0 d-flex justify-content-center flex-column gap-2">
                    {{ $shop->actual_products_count ?? 0 }}<span class="fw-normal text-body fs-14">{{__('products') }}</span>
                </h6>
            </div>
            <img src="{{ asset('assets/img/bg/shop-bg.png') }}" alt="" class="img-fluid w-100 position-absolute top-0 start-0">
        </div>
    </div>
</div>
@empty
<div class="col-12">
    <div class="alert alert-info text-center">
        <h4>{{__('no_shops_found') }}</h4>
        <p>{{__('try_adjusting_your_search_or_filter_criteria') }}.</p>
    </div>
</div>
@endforelse