<div class="row row-gap-4">
    @forelse($shops as $shop)
        <div class="col-lg-4 col-md-6">
            <div class="shop-item">
                <div class="shop-image">
                    @if($shop->shop_logo)
                        <img src="{{ asset('storage/' . $shop->shop_logo) }}" alt="{{ $shop->shop_name }}" class="img-fluid">
                    @else
                        <img src="{{ asset('frontend/assets/img/shop/shop-01.jpg') }}" alt="{{ $shop->shop_name }}" class="img-fluid">
                    @endif
                    
                    <!-- Rating Badge -->
                    <div class="rating-badge">
                        <span class="rating-text">4.5</span>
                        <i class="isax isax-star text-warning"></i>
                    </div>
                </div>
                
                <div class="shop-content">
                    <h5 class="shop-title">
                        <a href="{{ route('frontend.shops.show', 'shop-' . $shop->id) }}" class="text-decoration-none">
                            {{ $shop->shop_name }}
                        </a>
                    </h5>
                    
                    <p class="shop-location text-muted mb-2">
                        <i class="isax isax-location me-1"></i>
                        @if($shop->city && $shop->state)
                            {{ $shop->city }}, {{ $shop->state }}
                        @elseif($shop->city)
                            {{ $shop->city }}
                        @elseif($shop->state)
                            {{ $shop->state }}
                        @elseif($shop->country)
                            {{ $shop->country }}
                        @else
                            Location not specified
                        @endif
                    </p>
                    
                    <div class="shop-stats d-flex justify-content-between align-items-center">
                        <div class="stat-item">
                            <span class="stat-number">{{ $shop->services_count ?? 15 }}</span>
                            <span class="stat-label">Services</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">{{ $shop->products_count ?? 18 }}</span>
                            <span class="stat-label">Products</span>
                        </div>
                    </div>
                    
                    <div class="shop-actions mt-3">
                        <a href="{{ route('frontend.shops.show', 'shop-' . $shop->id) }}" class="btn btn-primary btn-sm w-100">
                            View Details
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @empty
        <div class="col-12">
            <div class="text-center py-5">
                <div class="empty-state">
                    <i class="isax isax-shop text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">No shops found</h5>
                    <p class="text-muted">Try adjusting your filters or search criteria</p>
                </div>
            </div>
        </div>
    @endforelse
</div>


