@extends('frontend.theme_2.app')

@section('title', 'Our Shops')

@push('styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/ion-rangeslider/css/ion.rangeSlider.min.css') }}">
@endpush

@section('content')
<div class="breadcrumb-bar">
    <div class="container">
        <div class="breadcrumb-item">
            <nav aria-label="breadcrumb" class="page-breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-items">{!! $data['menu'] ?? '<a href="' . url('/') . '">' . __('Home') . '</a>' !!}</li>
                    <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                    <li class="breadcrumb-items active" aria-current="page">{{$data['submenu'] ??  __('shops') }}</li>
                </ol>
            </nav>
            <h1 class="breadcrumb-title">{{$data['header'] ??  __('shops') }}</h1>
        </div>
    </div>
    <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
    <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>

<div class="content">
    <div class="container">

        <div class="sub-head-item border-bottom border-color d-flex align-items-center justify-content-between flex-wrap gap-2 pb-4 mb-4">
            <p class="sub-head mb-0" id="result-count">
                @if($shops->total() > 0)
                {{__('showing') }} {{ $shops->firstItem() }} – {{ $shops->lastItem() }} of {{ $shops->total() }} {{__('results') }}
                @else
                 {{__('showing') }} 0  {{__('results') }}
                @endif
            </p>
            <div class="filter-item d-flex align-items-center justify-content-between flex-wrap gap-3">
                <div class="dropdown d-flex align-items-center gap-2">
                    <p class="fs-14 fw-medium mb-0">{{__('sort_by') }} : </p>
                    <a href="javascript:void(0);" class="dropdown-toggle btn border border-color d-inline-flex align-items-center text-dark fw-normal" data-bs-toggle="dropdown" aria-expanded="false" id="sort-by-label">
                        {{__('recent_listing') }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" id="sort-by-options">
                        <li><a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="recent">{{__('recent_listing') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="newest">{{__('newest') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item rounded-1" data-value="oldest">{{__('oldest') }}</a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3">
                <form id="filter-form">
                    <input type="hidden" name="sort_by" id="sort_by_input" value="recent">
                    <input type="hidden" name="page" value="1">
                    <div class="product-sidebar card">
                        <div class="product-sidebar-item card-body">
                            <div class="filter-items">
                                <div class="filter-body">
                                    <div class="filter-set mb-4 pb-4 border-bottom">
                                        <h6 class="mb-3">{{__('search') }}</h6>
                                        <div class="input-group">
                                            <input type="text" name="search" class="form-control" placeholder="{{__('shop_name_or_owner') }}..." aria-label="Search">
                                        </div>
                                    </div>

                                    @if(isset($locations) && $locations->count() > 0)
                                    <div class="filter-set mb-4 pb-4 border-bottom">
                                        <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#location-filter" role="button">
                                            <h6 class="mb-0 d-flex align-items-center">{{__('location') }}</h6>
                                            <i class="isax isax-arrow-down-1"></i>
                                        </div>
                                        <div id="location-filter" class="card-collapse collapse show mt-3">
                                            @foreach ($locations as $location)
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0" name="locations[]" type="checkbox" value="{{ $location->id }}" id="loc_{{ $loop->index }}">
                                                <label class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100" for="loc_{{ $loop->index }}">
                                                    {{ $location->name }} <span>({{ $location->total }})</span>
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    @endif

                                    @if(isset($vendors) && $vendors->count() > 0)
                                    <div class="filter-set mb-4 pb-4 border-bottom">
                                        <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#vendor-filter" role="button">
                                            <h6 class="mb-0 d-flex align-items-center">{{__('vendor') }}</h6>
                                            <i class="isax isax-arrow-down-1"></i>
                                        </div>
                                        <div id="vendor-filter" class="card-collapse collapse show mt-3">
                                            @foreach ($vendors as $vendor)
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0" name="vendors[]" type="checkbox" value="{{ $vendor->id }}" id="ven_{{ $loop->index }}">
                                                <label class="form-check-label ms-2 d-flex align-items-center justify-content-between w-100" for="ven_{{ $loop->index }}">
                                                    {{ $vendor->name }} <span>({{ $vendor->total }})</span>
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    @endif

                                    <div class="filter-set mb-4 pb-4 border-bottom">
                                        <div class="d-flex justify-content-between w-100 filter-search-head" data-bs-toggle="collapse" data-bs-target="#reviews-filter" role="button">
                                            <h6 class="mb-0 d-flex align-items-center">{{__('reviews') }}</h6>
                                            <i class="isax isax-arrow-down-1"></i>
                                        </div>
                                        <div id="reviews-filter" class="card-collapse collapse show mt-3">
                                            @for ($i = 5; $i >= 1; $i--)
                                            <div class="form-check d-flex align-items-center ps-0 mb-2">
                                                <input class="form-check-input ms-0 mt-0" name="reviews[]" type="checkbox" value="{{ $i }}" id="star_{{ $i }}">
                                                <label class="form-check-label ms-2 d-flex align-items-center flex-xl-nowrap flex-wrap gap-2" for="star_{{ $i }}">
                                                    <span class="review-star mb-0 d-flex align-items-center gap-1">
                                                        @for ($s = 0; $s < $i; $s++) <i class="fa-solid fa-star text-warning"></i> @endfor
                                                            @for ($s = 0; $s < 5 - $i; $s++) <i class="fa-regular fa-star text-warning"></i> @endfor
                                                    </span>
                                                    <span class="ms-2 mb-0"> {{ $i }} {{__('star') }} </span>
                                                </label>
                                            </div>
                                            @endfor
                                        </div>
                                    </div>
                                </div>
                                <div class="filter-footer d-flex align-items-center justify-content-between gap-2">
                                    <button type="reset" id="reset-filter-btn" class="btn btn-light w-100">{{__('reset') }}</button>
                                    <button type="submit" id="apply-filter-btn" class="btn btn-secondary w-100">{{__('apply') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-9">
                <div class="row row-gap-4 justify-content-center" id="shops-grid">
                    @include('frontend.shops.partials.shop_items', ['shops' => $shops])
                </div>
                <div class="text-center mt-5" id="load-more-container">
                    @if($shops->hasMorePages())
                    <button id="load-more-btn" class="btn btn-dark d-inline-flex align-items-center gap-2">
                        <i class="isax isax-rotate-left"></i>{{__('load_more') }}
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/shops.min.js') }}"></script>
@endpush