<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>

	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ __('register') . ' || ' . $companyName }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="keywords" content="">
	<meta name="author" content="Dreams Technologies">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $dynamicFavicon }}">

	<!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ $dynamicFavicon }}">

	@php
        $isRTL = isRTL(app()->getLocale());
    @endphp

   	@if ($isRTL)
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.rtl.min.css') }}">
    @else
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.min.css') }}">
    @endif
    <!-- Iconsax CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/iconsax/iconsax.css') }}">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/fontawesome/css/all.min.css') }}">

    @if ($isRTL)
        <!-- Main RTL CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style-rtl.css') }}">
    @else
        <!-- Main CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style.css') }}">
    @endif

    <!-- Custom Style CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/custom/custom-style.css') }}">

</head>

<body>
	<!-- Begin Wrapper -->
	<div class="main-wrapper">

        <!-- Start Content -->
		<div class="container-fuild">
			<div class="w-100 overflow-hidden position-relative flex-wrap d-block vh-100 login-wrap py-4">

				<!-- start row -->
				<div class="row justify-content-center align-items-center vh-100 overflow-auto flex-wrap">

					<div class="col-md-8 col-lg-6 col-xl-4 mx-auto">
						<form action="javascript:void(0);" id="userRegisterForm" class="d-flex justify-content-center align-items-center" autocomplete="off">
							<div class="d-flex flex-column justify-content-center p-4 flex-fill bg-light border">
								<div class="login-logo mx-auto text-center">
									<a href="{{ route('home') }}">
										<img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo">
									</a>
								</div>
								<div>
									<div class="text-center">
										<h4>{{ __('join_professional') }}</h4>
									</div>
									<div class="d-flex align-items-center justify-content-center gap-3 flex-wrap mb-3">
										<div class="form-check">
											<input class="form-check-input user-role-change" type="radio" name="radioDefault" id="provider" value="2" checked>
											<label class="form-check-label" for="provider">
												{{ __('join_as_provider') }}
											</label>
										</div>
										<div class="form-check">
											<input class="form-check-input user-role-change" type="radio" name="radioDefault" value="3" id="user">
											<label class="form-check-label" for="user">
												{{ __('join_as_user') }}
											</label>
										</div>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('first_name') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat">
											<span class="input-group-text">
												<i class="isax isax-user text-dark"></i>
											</span>
											<input type="text" name="first_name" id="first_name" class="form-control" placeholder="{{ __('enter_first_name') }}" autocomplete="off" readonly onfocus="this.removeAttribute('readonly');" maxlength="100">
										</div>
										<span id="first_name_error" class="text-danger error-text"></span>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('last_name') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat">
											<span class="input-group-text">
												<i class="isax isax-user text-dark"></i>
											</span>
											<input type="text" name="last_name" id="last_name" class="form-control" placeholder="{{ __('enter_last_name') }}" autocomplete="off" readonly onfocus="this.removeAttribute('readonly');" maxlength="100">
										</div>
										<span id="last_name_error" class="text-danger error-text"></span>
									</div>
									<div class="mb-3">
										<input type="hidden" name="user_type" id="user_type" value="2">
										<label class="form-label">{{ __('user_name') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat">
											<span class="input-group-text">
												<i class="isax isax-user text-dark"></i>
											</span>
											<input type="text" name="name" id="name" class="form-control" placeholder="{{ __('enter_user_name') }}" autocomplete="off" readonly onfocus="this.removeAttribute('readonly');" maxlength="100">
										</div>
										<span id="name_error" class="text-danger error-text"></span>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('email') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat">
											<span class="input-group-text">
												<i class="isax isax-sms text-dark"></i>
											</span>
											<input type="email" name="email" id="email" class="form-control" placeholder="Enter Email Address" autocomplete="off" readonly onfocus="this.removeAttribute('readonly');" maxlength="100">
										</div>
										<span id="email_error" class="text-danger error-text"></span>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('password') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat pass-group">
											<span class="input-group-text">
												<i class="isax isax-lock text-dark"></i>
											</span>
											<input type="password" name="password" id="password" class="form-control pass-input" placeholder="**********" autocomplete="off">
											<span class="input-group-text toggle-password">
												<i class="isax isax-eye-slash text-dark"></i>
											</span>
										</div>
										<span id="password_error" class="text-danger error-text"></span>
									</div>
									<div class="mb-3">
										<label class="form-label">{{ __('confirm_password') }} <span class="text-danger">*</span></label>
										<div class="input-group input-group-flat pass-group">
											<span class="input-group-text">
												<i class="isax isax-lock text-dark"></i>
											</span>
											<input type="password" name="confirm_password" id="confirm_password" class="form-control pass-input" placeholder="**********" autocomplete="off">
											<span class="input-group-text toggle-password">
												<i class="isax isax-eye-slash text-dark"></i>
											</span>
										</div>
										<span id="confirm_password_error" class="text-danger error-text"></span>
									</div>
                                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-4">
                                        <div class="form-check form-check-md mb-0">
                                        	<input class="form-check-input" name="remember_me" id="remember_me" type="checkbox">
                                            <label for="remember_me" class="form-check-label mt-0 text">{{ __('i_agree_with') }} <a href="/terms-conditions" class="link-secondary">{{ __('terms_and_conditions') }}</a></label>
                                        </div>
                                        <span id="remember_me_error" class="text-danger error-text"></span>
                                    </div>
									<div class="mb-4">
										<button type="submit" class="btn btn-secondary w-100" id="register">{{ __('signup') }}</button>
									</div>

									<div class="text-center">
										<p class="mb-0 pt-1">{{ __('dont_have_an_account') }} <a href="/user/login" class="link-secondary">{{ __('signin') }}</a></p>
									</div>
								</div>
							</div>
						</form>
					</div><!-- end col -->

				</div>
				<!-- end row -->

			</div>
		</div>
		<!-- End Content -->
		@include('frontend.toast')
    </div>
	<!-- End Wrapper -->

	<script src="{{ asset('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

    @stack('plugins')

    @if ($isRTL)
        <script src="{{ asset('frontend/assets/js/script-rtl.js') }}"></script>
    @else
        <script src="{{ asset('frontend/assets/js/script.js') }}"></script>
    @endif

    <!-- jQuery validation -->
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation-additional-methods.min.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('frontend/assets/js/lang_script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/custom-script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/register.js') }}"></script>

</body>

</html>