<header class="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg header-nav">
            <div class="navbar-header">
                <a href="{{ url('/') }}" class="navbar-brand logo">
                    <img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo">
                </a>
                <a href="index.html" class="navbar-brand logo-white">
                    <img src="{{ $dynamicDarkLogo }}" class="img-fluid" alt="Logo-white">
                </a>
                <div id="mobile_btn">
                    <i class="isax isax-menu-1"></i>
                </div>
            </div>
            <div class="menu-wrapper">
                <div class="menu-overlay"></div>
                <div class="main-menu-wrapper">
                    <div>
                        <div class="menu-header">
                            <a href="{{ url('/') }}" class="menu-logo">
                                <img src="{{ $logo ?? asset('frontend/assets/img/logo.svg') }}" class="img-fluid logo" alt="Logo">
                                <img src="{{ $logowhite ?? asset('frontend/assets/img/logo-white.svg') }}" class="img-fluid logo-white" alt="Logo-white">
                            </a>
                            <div class="d-flex align-items-center gap-3">
                                @if (Auth::check() && Auth::user()->user_type == 2)
                                <a href="{{ route('provider.profile') }}" class="avatar avatar-md">
                                    <img src="{{ getProfileImage() }}" class="img-fluid rounded-circle" alt="vendor">
                                </a>
                                @endif
                                <div id="menu_close" class="menu-close">
                                    <i class="isax isax-close-circle"></i>
                                </div>
                            </div>
                        </div>
                        <ul class="main-nav">
                            @foreach($menuList as $menu)
                                @foreach($menu['menus'] as $item)
                                    @php
                                        $rawLink = trim($item['url']);
                                        $isFullUrl = filter_var($rawLink, FILTER_VALIDATE_URL);
                                        $menuLink = $isFullUrl ? rtrim($rawLink, '/') : rtrim(url($rawLink), '/');
                                        $isHome = $item['url'] == '/';
                                        $currentUrl = rtrim(Request::url(), '/');
                                        $active = '';

                                        if (
                                            $currentUrl == $menuLink ||
                                            (Str::contains($menuLink, 'services') && Str::contains($currentUrl, 'servicedetails')) ||
                                            (Str::contains($menuLink, 'shops') && Str::contains($currentUrl, 'shop-details')) ||
                                            (Str::contains($menuLink, 'products') && Str::contains($currentUrl, 'product-details'))
                                        ) {
                                            $active = 'active';
                                        }

                                        if ($isHome && request()->routeIs(['home', 'theme'])) {
                                            $active = 'active';
                                        }
                                    @endphp
                                    @if(!empty($item['submenus']))
                                        <li class="nav-item has-submenu active">
                                            <a class="nav-link" href="#!">
                                                {{ $item['name'] }} <i class="fas fa-chevron-down"></i>
                                            </a>
                                            <ul class="submenu">
                                                @foreach($item['submenus'] as $submenu)
                                                <li>
                                                    <a href="{{ route('dynamic.page', ['slug' => $submenu['url']]) }}"
                                                        target="{{ $submenu['target'] }}">
                                                        {{ $submenu['name'] }}
                                                    </a>
                                                </li>
                                                @endforeach
                                            </ul>
                                        </li>
                                    @else
                                    <li class="{{ $active }}">
                                        <a href="{{ route('dynamic.page', ['slug' => $item['url']]) }}"
                                            target="{{ $item['target'] }}">
                                            {{ $item['name'] }}
                                        </a>
                                    </li>
                                    @endif
                                @endforeach
                            @endforeach
                        </ul>
                        <div class="menu-contact">
                            <h4>{{ __('contact_us') }}</h4>
                            <div class="d-flex align-items-center mb-3">
                                <i class="isax isax-call"></i>
                                <div>
                                    <h6 class="fs-14 fw-semibold mb-1">{{ __('phone_number') }}</h6>
                                    <p>{{ $companyPhoneNumber }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <i class="isax isax-sms"></i>
                                <div>
                                    <h6 class="fs-14 fw-semibold mb-1">{{ __('email_address') }}</h6>
                                    <p>{{ $companyEmail }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="isax isax-location"></i>
                                <div>
                                    <h6 class="fs-14 fw-semibold mb-1">{{ __('location') }}</h6>
                                    <p>{{ $company_address_line }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="nav header-items">
                <div class="dropdown topbar-lang">
                    <a href="#" data-bs-toggle="dropdown">
                        <img src="{{ asset('/frontend/assets/img/flags/' . app()->getLocale() . '.svg') }}" alt="language" height="16">
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        @if ($allLanguages)
                        @foreach ($allLanguages as $language)
                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center change-user-language" data-id="{{ $language->id }}" data-language_code="{{ $language->code }}">
                                <img src="{{ asset('/frontend/assets/img/flags/' . $language->code . '.svg') }}" alt="english" class="me-2" height="16">{{ $language->name }}
                            </a>
                        @endforeach
                        @endif
                    </div>
                </div>

                @if(Auth::check())
                    <div class="dropdown topbar-profile d-flex">
                        <a href="javascript:void(0);" class="avatar" data-bs-toggle="dropdown">
                            <img src="{{ getProfileImage() }}" alt="user" class="img-fluid rounded-circle">
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <!-- Item-->
                            <a href="{{ Auth::user()->user_type == 2? url('provider/dashboard') : route('user.dashboard') }}" class="dropdown-item d-inline-flex align-items-center">
                                <i class="isax isax-menu me-2"></i>{{ __('dashboard') }}
                            </a>
                            <!-- Item-->
                            <a href="{{ Auth::user()->user_type == 2? url('/vendor-booking-list') : route('customer.myorders.products') }}" class="dropdown-item d-inline-flex align-items-center">
                                <i class="isax isax-shopping-cart me-2"></i>{{ __('orders') }}
                            </a>
                            <hr class="dropdown-divider">
                            <!-- Item-->
                            <a href="{{ Auth::user()->user_type == 2? url('provider/profile') : route('customer.profile') }}" class="dropdown-item d-inline-flex align-items-center">
                                <i class="isax isax-setting-2 me-2"></i>{{ __('settings') }}
                            </a>
                            <a href="/logout" class="dropdown-item d-inline-flex align-items-center">
                                <i class="isax isax-logout-1 me-2"></i>{{ __('logout') }}
                            </a>
                        </div>
                    </div>
                @else
                    <a href="/user/login" class="btn btn-dark btn-md d-inline-flex align-items-center"><i class="isax isax-lock me-1"></i>{{ __('signin') }}</a>
                    <a href="/user/register" class="btn btn-secondary btn-md"><i class="isax isax-user me-1"></i>{{ __('signup') }}</a>
                @endif
            </div>
        </nav>
    </div>
</header>