<footer class="footer footer-two">

    <!-- Footer Top -->
    <div class="footer-top">
        <div class="container">
            <div class="row row-gap-4 row-cols-xl-5">
                @if (!empty($footerList))
                    @foreach ($footerList as $footerGroup)
                        @foreach ($footerGroup as $footer)
                            @if (!empty($footer['title']) && !empty($footer['footer_content']))
                                <div class="col-xl col-lg-4 col-sm-6">

                                    <div class="footer-widget">
                                        <h6 class="footer-title">{{ $footer['title'] }}</h5>
                                        <ul class="footer-menu">{!! $footer['footer_content'] !!}</ul>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endforeach
                @endif

                <div class="col-lg-4 col-md-6">
                    <div class="footer-widget">
                        <h6 class="footer-title">{{ __('contact_us') }}</h6>
                        <div class="footer-contact">
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('address') }}</h6>
                                <p>{{ $company_address_line }}</p>
                            </div>
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('phone_number') }}</h6>
                                <p>{{ $companyPhoneNumber }}</p>
                            </div>
                            <div>
                                <h6 class="fs-14 mb-1">{{ __('email_address') }}</h6>
                                <p><a href="mailto:info@example.com" class="text-white">{{ $companyEmail }}</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End -->

    <!-- Footer Bottom -->
    <div class="footer-bottom">
        <div class="container">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div class="copyright">
                    <p>{!! $copyRight ?? __('copyrights') . ' © ' . date('Y') . ' ' . $appName . '. ' . __('all_rights_reserved') . '.' !!}</p>
                </div>
                <div class="policy-link">
                    <a href="/terms-conditions">{{ __('terms_and_conditions') }}</a>
                    <a href="/privacy-policy">{{ __('privacy_policy') }}</a>
                </div>
                <div class="social-icon">
                    @foreach($socialLinks as $link)
                        <a href="{{ $link->link }}" target="_blank">
                            <i class="fab {{ $link->icon }} text-primary"></i>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Bottom End -->

    <img src="{{ asset('frontend/assets/img/bg/footer-bg-01.svg') }}" alt="icon" class="footer-bg-01">
    <img src="{{ asset('frontend/assets/img/bg/footer-bg-02.svg') }}" alt="icon" class="footer-bg-02">
    <img src="{{ asset('frontend/assets/img/bg/footer-bg-03.svg') }}" alt="icon" class="footer-bg-03">

    <div id="language-settings" data-language-id="{{ getLanguageId(app()->getLocale()) }}"></div>
    <div id="datatable_data" data-length_menu="{{ __('lengthMenu') }}" data-info="{{ __('info') }}"
        data-info_empty="{{ __('infoEmpty') }}" data-info_filter="{{ __('infoFiltered') }}"
        data-search="{{ __('search') }}" data-zero_records="{{ __('zeroRecords') }}"
        data-first="{{ __('first') }}" data-last="{{ __('last') }}" data-next="{{ __('next') }}"
        data-prev="{{ __('previous') }}"></div>

</footer>