<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('reset_password_title') . ' || ' . $companyName }}</title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Dreams Technologies">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $dynamicFavicon }}">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ $dynamicFavicon }}">

    @php
        $isRTL = isRTL(app()->getLocale());
    @endphp

    @if ($isRTL)
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.rtl.min.css') }}">
    @else
        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/bootstrap.min.css') }}">
    @endif
    <!-- Iconsax CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/iconsax/iconsax.css') }}">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/plugins/fontawesome/css/all.min.css') }}">

    @if ($isRTL)
        <!-- Main RTL CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style-rtl.css') }}">
    @else
        <!-- Main CSS -->
        <link rel="stylesheet" href="{{ asset('frontend/assets/css/style.css') }}">
    @endif

    <!-- Custom Style CSS -->
    <link rel="stylesheet" href="{{ asset('frontend/assets/css/custom/custom-style.css') }}">
</head>
<body>
    <!-- Main Wrapper -->
    <!-- Begin Wrapper -->
    <div class="main-wrapper">

        <!-- Start Content -->
        <div class="container-fuild">
            <div class="w-100 overflow-hidden position-relative flex-wrap d-block vh-100 login-wrap py-4">

                <!-- start row -->
                <div class="row justify-content-center align-items-center vh-100 overflow-auto flex-wrap">

                    <div class="col-md-8 col-lg-6 col-xl-4 mx-auto">
                        <form action="" id="changePasswordForm" class="d-flex justify-content-center align-items-center">
                            @csrf
                            <div class="d-flex flex-column justify-content-center p-4 flex-fill bg-light border">
                                <div class="login-logo mx-auto text-center">
                                    <a href="{{ route('home') }}">
                                        <img src="{{ $dynamicLogo }}" class="img-fluid" alt="Logo">
                                    </a>
                                </div>
                                <div>
                                    <div class="text-center">
                                        <h4>{{ __('reset_password') }}</h4>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">{{ __('new_passowrd') }} <span class="text-danger">*</span></label>
                                        <div class="input-group input-group-flat pass-group">
                                            <span class="input-group-text">
                                                <i class="isax isax-lock text-dark"></i>
                                            </span>
                                            <input type="password" id="new_password" name="new_password" class="form-control pass-input" placeholder="**********">
                                            <span class="input-group-text toggle-password">
                                                <i class="isax isax-eye-slash text-dark"></i>
                                            </span>
                                        </div>
                                        <span id="new_password_error" class="text-danger error-text"></span>
                                    </div>
                                    <div class="mb-4">
                                        <label class="form-label">{{ __('confirm_password') }} <span class="text-danger">*</span></label>
                                        <div class="input-group input-group-flat pass-group">
                                            <span class="input-group-text">
                                                <i class="isax isax-lock text-dark"></i>
                                            </span>
                                            <input type="password" id="confirm_password" name="confirm_password" class="form-control pass-input" placeholder="**********">
                                            <span class="input-group-text toggle-password">
                                                <i class="isax isax-eye-slash text-dark"></i>
                                            </span>
                                        </div>
                                        <span id="confirm_password_error" class="text-danger error-text"></span>
                                    </div>
                                    <div class="mb-0">
                                        <button type="submit" class="btn btn-secondary w-100" id="reset_password">{{ __('change_password') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @include('frontend.toast')

    </div>
    <!-- /Main Wrapper -->

    <!-- jQuery -->
    <script src="{{ asset('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- jQuery validation -->
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/jquery/jquery-validation-additional-methods.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>
     <!-- Custom JS -->
    <script src="{{ asset('frontend/assets/js/lang_script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/custom-script.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/custom/reset-password.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/script.js') }}"></script>
</body>
</html>
