@extends('frontend.provider.app')

@section('seo_title', 'My Product Orders')

@push('styles')
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href=" {{ asset('frontend/assets/plugins/datatables/datatables.min.css') }}">
@endpush

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('booking orders')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('booking orders')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
                        <h4 class="mb-0">{{__('my product orders')}}</h4>
                    </div>

                    <ul class="nav nav-tabs nav-solid-primary mb-4 wishlist-tab">
                        <li class="nav-item">
                            <a class="nav-link status-tab active" href="javascript:void(0);" data-status="new">{{__('new_orders')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="confirmed">{{__('confirmed_orders')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="shipped">{{__('shipped_orders')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="delivered">{{__('delivered_orders')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="cancelled">{{__('cancelled_orders')}}</a>
                        </li>
                    </ul>

                    <div class="card mb-0">
                        <div class="card-body">
                            <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-3">
                                <h5 class="mb-0">{{__('new_orders')}}</h5>
                                <div class="d-flex align-items-center flex-wrap gap-2">
                                    <div class="input-icon input-icon-start position-relative">
                                        <span class="input-icon-addon text-dark px-2"><i class="isax isax-search-normal-1"></i></span>
                                        {{-- Add ID to the search input --}}
                                        <input type="text" id="searchInput" class="form-control form-control-sm" placeholder="Search">
                                    </div>
                                    <div class="dropdown">
                                        {{-- Add ID to the dropdown anchor --}}
                                        <a href="javascript:void(0);"
                                            id="selectedProduct"
                                            class="btn btn-white btn-sm fs-14 fw-normal dropdown-toggle"
                                            data-bs-toggle="dropdown"
                                            aria-expanded="false"
                                            data-id=""> {{-- Add an empty data-id attribute --}}
                                            {{__('all_products')}}
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            {{-- Add a "All Products" option to clear the filter --}}
                                            <li><a class="dropdown-item fs-14 product-option" href="javascript:void(0);" data-id="">{{__('all_products')}}</a></li>
                                            @foreach ($products as $product)
                                            <li>
                                                {{-- Use data-id instead of data-value --}}
                                                <a class="dropdown-item fs-14 product-option" href="javascript:void(0);" data-id="{{ $product->id }}">
                                                    {{ $product->source_name }} {{-- Changed from source_name to name --}}
                                                </a>
                                            </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive table-nowrap">
                                <table class="table border mb-0">
                                    <thead>
                                        <tr>
                                            <th>{{__('order_id')}}</th>
                                            <th>{{__('Booking Date')}}</th>
                                            <th>{{__('Product')}}</th>
                                            <th>{{__('Amount')}}</th>
                                            <th>{{__('payment_method')}}</th>
                                            <th>{{__('Customer')}}</th>
                                            <th>{{__('Quantity')}}</th>
                                            <th id="cancelled-by" hidden>{{__('Cancelled by')}}</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody id="orders-table-body">
                                        <tr>
                                            <td colspan="8" class="text-center">{{__('loading')}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="service_accept">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="d-flex align-items-center justify-content-center">
                    <span class="avatar avatar-lg bg-soft-success text-success rounded-circle mb-3">
                        <i class="isax isax-tick-circle fs-16"></i>
                    </span>
                </div>
                <div class="text-center">
                    <h6 class="mb-1">{{__('Accept Order')}}</h6>
                    <p class="mb-3">{{__('Are you sure you want to accept this product order?')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-center">
                    <a href="javascript:void(0);" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</a>
                    <a href="javascript:void(0);" id="confirmAcceptBtn" class="btn btn-secondary w-100">{{__('Accept')}}</a>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="service_reject" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div>
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
                            <i class="isax isax-close-circle"></i>
                        </span>
                        <h6 class="mb-1">{{__('Are you Sure')}}?</h6>
                        <p class="mb-0">{{__('Do you want to cancel this order?')}}</p>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{__('reason_for_cancellation')}}</label>
                        <textarea id="cancellationReasonText" class="form-control" rows="3" placeholder="Please provide a reason for cancelling the order..."></textarea>
                    </div>
                    <div class="d-flex align-items-center">
                        <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="button" id="confirmRejectBtn" class="btn btn-secondary w-100">{{__('Submit Cancellation')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="service_shipped" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div>
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-info text-info fs-16 mb-3">
                            <i class="isax isax-truck-tick"></i>
                        </span>
                        <h6 class="mb-1">{{__('Confirm Shipment')}}</h6>
                        <p class="mb-0">{{__('Are you sure you want to mark this order as shipped?')}}</p>
                    </div>
                    <div class="d-flex align-items-center">
                        <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="button" id="confirmShipBtn" class="btn btn-secondary w-100">{{__('Yes, Mark as Shipped')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="view_details" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between">
                <h5 class="modal-title mb-0">{{ __('order_summary') }}<span class="badge badge-sm badge-soft-purple ms-2" id="order_id"></span></h5>
                <button type="button" class="btn-close custom-btn-close opacity-100 bg-transparent" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>

<div id="service_delivered" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div>
                    <div class="text-center mb-3">
                        <span class="avatar avatar-lg avatar-rounded bg-soft-success text-success fs-16 mb-3">
                            <i class="isax isax-box-tick"></i>
                        </span>
                        <h6 class="mb-1">{{__('Confirm Delivery')}}</h6>
                        <p class="mb-0">{{__('Are you sure you want to mark this order as delivered?')}}</p>
                        <div class="mb-4 mt-3 show_payment_status d-none">
                            <label class="form-label">{{ __('payment_status') }}<span class="text-danger ms-1">*</span></label>
                            <select class="form-control select" name="payment_status" id="payment_status">
                                <option value="2">{{__('paid')}}</option>
                                <option value="1">{{__('unpaid')}}</option>
                            </select>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                        <button type="button" id="confirmDeliveredBtn" class="btn btn-secondary w-100">{{__('Yes, Mark as Delivered')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
{{-- Datatables scripts --}}
<script src="{{ asset('frontend/assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('frontend/assets/plugins/datatables/datatables.min.js') }}"></script>

<script>
    $(document).ready(function() {

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        const debounce = (func, delay) => {
            let timeoutId;
            return (...args) => {
                clearTimeout(timeoutId);
                timeoutId = setTimeout(() => {
                    func.apply(this, args);
                }, delay);
            };
        };

        function fetchOrders(page = 1) {
            let status = $('.status-tab.active').data('status');
            let searchQuery = $('#searchInput').val();
            let productId = $('#selectedProduct').data('id');

            let statusText = $('.status-tab.active').text();
            $('#orders-title').text(statusText);

            if (status === 'cancelled') {
                $('th#cancelled-by').removeAttr('hidden');
            } else {
                $('th#cancelled-by').attr('hidden', true);
            }

            // 3. Perform AJAX call
            $.ajax({
                url: "{{ route('vendor.booking.list.data') }}?page=" + page,
                type: 'GET',
                data: {
                    status: status,
                    search: searchQuery,
                    product_id: productId
                },
                beforeSend: function() {
                    $('#orders-table-body').html('<tr><td colspan="8" class="text-center">Loading...</td></tr>');
                },
                success: function(response) {
                    $('#orders-table-body').html(response);
                    // Update header visibility after content is loaded
                    if (status === 'cancelled') {
                        $('.cancelled-by-col').show();
                    } else {
                        $('.cancelled-by-col').hide();
                    }
                },
                error: function(xhr) {
                    $('#orders-table-body').html('<tr><td colspan="8" class="text-center">Failed to load data.</td></tr>');
                }
            });
        }

        // --- EVENT HANDLERS ---

        // 1. Tab Clicks
        $('.status-tab').on('click', function(e) {
            e.preventDefault();
            $('.status-tab').removeClass('active');
            $(this).addClass('active');
            fetchOrders(); // Fetch data for the new tab
        });

        // 2. Search Input (with debounce)
        $('#searchInput').on('keyup', debounce(function() {
            fetchOrders(); // Fetch data with the search term
        }, 500));

        // 3. Product Filter Dropdown
        $('.product-option').on('click', function(e) {
            e.preventDefault();
            let selectedText = $(this).text();
            let selectedId = $(this).data('id');

            // Update the main dropdown button's text and data-id
            $('#selectedProduct').text(selectedText).data('id', selectedId);

            fetchOrders(); // Fetch data with the new product filter
        });

        // 4. Pagination Links (using event delegation)
        $(document).on('click', '.pagination a', function(e) {
            e.preventDefault();
            let page = $(this).attr('href').split('page=')[1];
            fetchOrders(page);
        });

        // --- INITIAL DATA LOAD ---
        fetchOrders();


        // --- ALL THE LOGIC FOR STATUS UPDATE MODALS REMAINS UNCHANGED ---
        let bookingProductIdToUpdate;
        let codPaymentStatus = null;
        $(document).on('click', '.action-accept, .action-reject, .action-ship', function() {
            bookingProductIdToUpdate = $(this).data('id');
        });

        $(document).on('click', '.action-delivered', function() {
            bookingProductIdToUpdate = $(this).data('id');
            $("#payment_status").val($(this).data('cod_payment_status')).trigger('change');
            let paymentType = $(this).data('payment_type');
            if (paymentType == 5) {
                codPaymentStatus = 2;
                $(".show_payment_status").removeClass("d-none");
            } else {
                codPaymentStatus = 1;
                $(".show_payment_status").addClass("d-none");
            }
        });

        $('#confirmAcceptBtn').on('click', function() {
            if (!bookingProductIdToUpdate) return;
            updateStatus(bookingProductIdToUpdate, 2);
        });
        $('#confirmRejectBtn').on('click', function() {
            if (!bookingProductIdToUpdate) return;
            const reason = $('#cancellationReasonText').val();
            if (reason.trim() === '') {
                showToast('error', 'Please provide a reason.');
                return;
            }
            updateStatus(bookingProductIdToUpdate, 5, reason);
        });
        $('#confirmShipBtn').on('click', function() {
            if (!bookingProductIdToUpdate) return;
            updateStatus(bookingProductIdToUpdate, 3);
        });
        $('#confirmDeliveredBtn').on('click', function() {
            if (!bookingProductIdToUpdate) return;
            updateStatus(bookingProductIdToUpdate, 4);
        });

        function updateStatus(id, status, reason = null) {
            let url = `/vendor-booking/update-status/${id}`;
            let data = {
                status: status,
                payment_status: codPaymentStatus,
            };
            if (reason) data.reason = reason;

            // Select the button based on status
            let btn;
            if (status === 2) btn = $('#confirmAcceptBtn');
            if (status === 3) btn = $('#confirmShipBtn');
            if (status === 4) btn = $('#confirmDeliveredBtn');
            if (status === 5) btn = $('#confirmRejectBtn');

            // Store original button text to restore later
            let originalText = btn.html();

            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                beforeSend: function () {
                    // Disable button and show spinner
                    btn.attr('disabled', true).html(
                        '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span> Processing...'
                    );
                },
                success: function(response) {
                    btn.attr('disabled', false).html(originalText); // restore button text

                    if (response.success) {
                        if (status === 2) $('#service_accept').modal('hide');
                        if (status === 3) $('#service_shipped').modal('hide');
                        if (status === 4) $('#service_delivered').modal('hide');
                        if (status === 5) $('#service_reject').modal('hide');

                        $('tr[data-id="' + id + '"]').fadeOut('slow', function() {
                            $(this).remove();
                        });
                    }
                },
                error: function(xhr) {
                    btn.attr('disabled', false).html(originalText); // restore button text
                    showToast('error', 'An error occurred.');
                }
            });
        }

        // View details modal
        $(document).on('click', '.view-details', function () {
            let orderId = $(this).data('id');

            $('#view_details .modal-body').html(`
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">${_l('loading')}</span>
                    </div>
                    <p class="mt-2">Fetching order details...</p>
                </div>
            `);

            $.ajax({
                url: '/customer/products/get-order-details',
                type: 'GET',
                data: { id: orderId },
                success: function (res) {
                    $('#order_id').html(res.order_id);
                    $('#view_details .modal-body').html(res.html);
                },
                error: function () {
                    $('#view_details .modal-body').html(`
                        <div class="alert alert-danger mb-0">
                            Failed to fetch details. Please try again.
                        </div>
                    `);
                }
            });
        });
    });
</script>
@endpush