@extends('frontend.provider.app')

@section('seo_title', 'My Service Bookings')

@push('styles')
{{-- You can add specific styles if needed --}}
@endpush

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="index.html">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('Service Bookings')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('My Service Bookings')}}</h1>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <ul class="nav nav-tabs nav-solid-primary mb-4 wishlist-tab">
                        <li class="nav-item">
                            <a class="nav-link status-tab active" href="javascript:void(0);" data-status="new">{{__('New Bookings')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="ongoing">{{__('Ongoing')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="completed">{{__('Completed')}}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link status-tab" href="javascript:void(0);" data-status="cancelled">Cancelled</a>
                        </li>
                    </ul>

                    <div class="card mb-0">
                        <div class="card-body">
                            <div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-3">
                                <h5 class="mb-0" id="booking-list-title">{{__('New Bookings')}}</h5>
                                <div class="d-flex align-items-center flex-wrap gap-2">
                                    <div class="input-icon input-icon-start position-relative">
                                        <span class="input-icon-addon text-dark px-2"><i class="isax isax-search-normal-1"></i></span>
                                        <input type="text" id="searchInput" class="form-control form-control-sm" placeholder="Search by ID, Service, Customer...">
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);"
                                            id="selectedService"
                                            class="btn btn-white btn-sm fs-14 fw-normal dropdown-toggle"
                                            data-bs-toggle="dropdown"
                                            aria-expanded="false"
                                            data-name="">
                                            {{__('All Services')}}
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item fs-14 service-option" href="javascript:void(0);" data-name="">{{__('All Services')}}</a></li>
                                            @foreach ($services as $service)
                                            <li>
                                                <a class="dropdown-item fs-14 service-option" href="javascript:void(0);" data-name="{{ $service->source_name }}">
                                                    {{ $service->source_name }}
                                                </a>
                                            </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive table-nowrap">
                                <table class="table border mb-0">
                                    <thead>
                                        <tr>
                                            <th>{{__('ID')}}</th>
                                            <th>{{__('Booking Date')}}</th>
                                            <th>{{__('Service')}}</th>
                                            <th>{{__('Amount')}}</th>
                                            <th>{{__('payment_method')}}</th>
                                            <th>{{__('Customer')}}</th>
                                            <th>{{__('Service Date')}}</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody id="service-bookings-table-body">
                                        <tr>
                                            <td colspan="7" class="text-center">{{__('Loading')}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="acceptBookingModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                 <span class="avatar avatar-lg bg-soft-success text-success rounded-circle mb-3">
                    <i class="isax isax-tick-circle fs-16"></i>
                </span>
                <h6 class="mb-1">{{__('Accept Booking')}}</h6>
                <p class="mb-3">{{__('Are you sure you want to accept this booking and move it to "Ongoing"?')}}</p>
                <div class="d-flex align-items-center justify-content-center">
                    <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="button" id="confirmAcceptBtn" class="btn btn-secondary w-100">{{__('Accept')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="cancelBookingModal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="text-center mb-3">
                    <span class="avatar avatar-lg avatar-rounded bg-soft-danger text-danger fs-16 mb-3">
                        <i class="isax isax-close-circle"></i>
                    </span>
                    <h6 class="mb-1">{{__('Are You Sure?')}}</h6>
                    <p class="mb-0">{{__('Do you want to cancel this booking?')}}</p>
                </div>
                <div class="mb-3">
                    <label class="form-label">{{__('Reason for Cancellation')}}</label>
                    <textarea id="cancellationReasonText" class="form-control" rows="3" placeholder="Please provide a reason for cancellation..."></textarea>
                </div>
                <div class="d-flex align-items-center">
                    <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Close')}}</button>
                    <button type="button" id="confirmCancelBtn" class="btn btn-secondary w-100">{{__('Submit Cancellation')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="completeBookingModal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                 <span class="avatar avatar-lg avatar-rounded bg-soft-success text-success fs-16 mb-3">
                    <i class="isax isax-task-square"></i>
                </span>
                <h6 class="mb-1">{{__('Complete Booking')}}</h6>
                <p class="mb-0">{{__('Are you sure you want to mark this booking as completed?')}}</p>
                <div class="mb-4 mt-3 show_payment_status d-none">
                    <label class="form-label">{{ __('payment_status') }}<span class="text-danger ms-1">*</span></label>
                    <select class="form-control select" name="payment_status" id="payment_status">
                        <option value="2">{{__('paid')}}</option>
                        <option value="1">{{__('unpaid')}}</option>
                    </select>
                </div>
                <div class="d-flex align-items-center justify-content-center mt-3">
                    <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="button" id="confirmCompleteBtn" class="btn btn-secondary w-100">{{__('Yes, Mark as Completed')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="view_details" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-between">
                <h5 class="modal-title mb-0">{{ __('booking_summary') }}<span class="badge badge-sm badge-soft-purple ms-2" id="order_id"></span></h5>
                <button type="button" class="btn-close custom-btn-close opacity-100 bg-transparent" data-bs-dismiss="modal" aria-label="Close"><i class="isax isax-close-circle"></i></button>
            </div>

            <div class="modal-body">
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $.ajaxSetup({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') }
        });

        const debounce = (func, delay) => {
            let timeoutId;
            return (...args) => {
                clearTimeout(timeoutId);
                timeoutId = setTimeout(() => { func.apply(this, args); }, delay);
            };
        };

        function fetchBookings(page = 1) {
            let status = $('.status-tab.active').data('status');
            let searchQuery = $('#searchInput').val();
            let serviceName = $('#selectedService').data('name');

            let statusText = $('.status-tab.active').text();
            $('#booking-list-title').text(statusText);

            $.ajax({
                url: "{{ route('vendor.service.data') }}?page=" + page,
                type: 'GET',
                data: {
                    status: status,
                    search: searchQuery,
                    service_name: serviceName
                },
                beforeSend: function() {
                    $('#service-bookings-table-body').html('<tr><td colspan="7" class="text-center">Loading...</td></tr>');
                },
                success: function(response) {
                    $('#service-bookings-table-body').html(response);
                },
                error: function(xhr) {
                    $('#service-bookings-table-body').html('<tr><td colspan="7" class="text-center">Failed to load data.</td></tr>');
                    console.error(xhr.responseText);
                }
            });
        }

        // --- EVENT HANDLERS ---
        $('.status-tab').on('click', function(e) {
            e.preventDefault();
            $('.status-tab').removeClass('active');
            $(this).addClass('active');
            fetchBookings();
        });

        $('#searchInput').on('keyup', debounce(function() {
            fetchBookings();
        }, 500));

        $('.service-option').on('click', function(e) {
            e.preventDefault();
            $('#selectedService').text($(this).text()).data('name', $(this).data('name'));
            fetchBookings();
        });

        $(document).on('click', '.pagination a', function(e) {
            e.preventDefault();
            let page = $(this).attr('href').split('page=')[1];
            fetchBookings(page);
        });

        // --- INITIAL DATA LOAD ---
        fetchBookings();

        // --- STATUS UPDATE MODAL LOGIC ---
        let bookingIdToUpdate;
        let paymentType = null;
        $(document).on('click', '.action-accept, .action-cancel, .action-complete', function() {
            bookingIdToUpdate = $(this).data('id');
            $('#payment_status').val($(this).data('payment_status')).trigger('change');
            paymentType = $(this).data('payment_type');
            if (paymentType == 5) {
                $(".show_payment_status").removeClass("d-none");
            } else {
                $(".show_payment_status").addClass("d-none");
            }
        });

        $('#confirmAcceptBtn').on('click', function() {
            updateBookingStatus(bookingIdToUpdate, 2); // 2 for Ongoing
        });

        $('#confirmCancelBtn').on('click', function() {
            const reason = $('#cancellationReasonText').val();
            // You can add validation for reason if needed
            updateBookingStatus(bookingIdToUpdate, 3, reason); // 3 for Cancelled
        });

        $('#confirmCompleteBtn').on('click', function() {
            updateBookingStatus(bookingIdToUpdate, 5); // 5 for Completed
        });

        function updateBookingStatus(id, status, reason = null) {
            if (!id) return;

            let url = `/vendor/service-bookings/update-status/${id}`;
            let data = {
                status: status,
                payment_status: $('#payment_status').val(),
                _token: '{{ csrf_token() }}'
            };
            if (reason) data.reason = reason;

            let btn;
            if (status === 2) btn = $('#confirmAcceptBtn');
            if (status === 3) btn = $('#confirmCancelBtn');
            if (status === 5) btn = $('#confirmCompleteBtn');

            // Store original button text to restore later
            let originalText = btn.html();

            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                beforeSend: function () {
                    // Disable button and show spinner
                    btn.attr('disabled', true).html(
                        '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span> Processing...'
                    );
                },
                success: function(response) {
                    btn.attr('disabled', false).html(originalText);
                    if (response.success) {
                        // Hide all modals
                        $('.modal').modal('hide');
                        // Fade out the row and remove it for a smooth UX
                        $('tr[data-id="' + id + '"]').fadeOut('slow', function() {
                            $(this).remove();
                            // Optional: Show a message if the table becomes empty
                            if ($('#service-bookings-table-body tr').length === 0) {
                                fetchBookings(); // Refresh to show the empty message
                            }
                        });
                    } else {
                         alert(response.message || 'An error occurred.');
                    }
                },
                error: function(xhr) {
                    alert('An error occurred while updating the status.');
                    console.error(xhr.responseText);
                }
            });
        }
        $(document).on('click', '.view-details', function () {
        let orderId = $(this).data('id');

        // Show loader while fetching
        $('#view_details .modal-body').html(`
            <div class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <p class="mt-2">Fetching order details...</p>
            </div>
        `);

        $('#view_details').modal('show');

        // Fetch details via AJAX
        $.ajax({
            url: '/customer/products/get-booking-details',   // <-- your controller route
            type: 'GET',
            data: { id: orderId },
            success: function (res) {
                // Inject HTML response into modal
                $('#order_id').html(res.order_id);
                $('#view_details .modal-body').html(res.html);
            },
            error: function () {
                $('#view_details .modal-body').html(`
                    <div class="alert alert-danger mb-0">
                        Failed to fetch details. Please try again.
                    </div>
                `);
            }
        });
    });
    });
</script>
@endpush