@forelse ($bookings as $booking)

@php
    $image = ($booking->user_profile_image && file_exists(public_path('storage/profile/' . $booking->user_profile_image)))
        ? asset('storage/profile/' . $booking->user_profile_image)
        : asset('assets/img/profile-default.png');

    $productImage = optional($booking->product->image)->source_Values
    ? asset('storage/' . $booking->product->image->source_Values)
    : asset('img/default-image.png');

@endphp

<tr data-id="{{ $booking->id }}">
    <td>
        <a href="javascript:void(0);">{{ $booking->order_id ?? 'N/A' }}</a>
    </td>
    <td>
        {{ \Carbon\Carbon::parse($booking->created_at)->format('d M Y') }}
    </td>
    <td>
        <div class="d-flex align-items-center">
            <a href="#" class="avatar avatar-sm me-2">
                <img src="{{ $productImage }}"
                     alt="service" class="img-fluid">
            </a>
            <div>
                {{-- CORRECTED: Access source_name through the product relationship --}}
                <h6 class="fs-14 fw-medium mb-0"><a href="#">{{ $booking->product->source_name ?? 'N/A' }}</a></h6>
            </div>
        </div>
    </td>
    <td>{{ $currency }}{{ number_format($booking->service_amount, 2) }}</td>
    <td>{{ $booking->payment_type_label ?? '-' }}</td>
    <td>
        @if ($booking->user)
        <div class="d-flex align-items-center">
            <a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
                <img src="{{ $image }}" alt="customer" class="img-fluid">
            </a>
            <div>
                <h6 class="fs-14 fw-medium mb-0"><a href="javascript:void(0);">{{ $booking->user->name ?? $booking->first_name }}</a></h6>
            </div>
        </div>
        @else
        <span>{{ $booking->first_name }} (Guest)</span>
        @endif
    </td>
    <td>
        {{ $booking->booking_date ? \Carbon\Carbon::parse($booking->booking_date)->format('d M Y') : 'N/A' }}
    </td>
    <td>
        {{-- Action buttons remain the same --}}
        <div class="d-flex align-items-center justify-content-end gap-2">
            @if ($currentStatusKey == 'new')
                <a href="javascript:void(0);"
                    class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details"
                    data-id="{{ $booking->id }}"
                    data-bs-toggle="modal"
                    data-bs-target="#view_details">
                    <i class="isax isax-eye"></i>
                </a>
                <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-accept" data-id="{{ $booking->id }}" data-payment_status="{{ $booking->payment_status }}" data-payment_type="{{ $booking->payment_type }}" data-bs-toggle="modal" data-bs-target="#acceptBookingModal" title="Accept Booking">
                    <i class="isax isax-tick-circle"></i>
                </a>
                <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-cancel" data-id="{{ $booking->id }}" data-payment_status="{{ $booking->payment_status }}" data-payment_type="{{ $booking->payment_type }}" data-bs-toggle="modal" data-bs-target="#cancelBookingModal" title="Cancel Booking">
                    <i class="isax isax-close-circle"></i>
                </a>
            @elseif ($currentStatusKey == 'ongoing')
                <a href="javascript:void(0);"
                    class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details"
                    data-id="{{ $booking->id }}"
                    data-bs-toggle="modal"
                    data-bs-target="#view_details">
                    <i class="isax isax-eye"></i>
                </a>
                 <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-complete" data-id="{{ $booking->id }}" data-payment_status="{{ $booking->payment_status }}" data-payment_type="{{ $booking->payment_type }}" data-bs-toggle="modal" data-bs-target="#completeBookingModal" title="Mark as Completed">
                    <i class="isax isax-task-square"></i>
                </a>
                <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-cancel" data-id="{{ $booking->id }}" data-payment_status="{{ $booking->payment_status }}" data-payment_type="{{ $booking->payment_type }}" data-bs-toggle="modal" data-bs-target="#cancelBookingModal" title="Cancel Booking">
                    <i class="isax isax-close-circle"></i>
                </a>
            @elseif ($currentStatusKey == 'completed')
                <a href="javascript:void(0);"
                    class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details"
                    data-id="{{ $booking->id }}"
                    data-bs-toggle="modal"
                    data-bs-target="#view_details">
                    <i class="isax isax-eye"></i>
                </a>
            @elseif ($currentStatusKey == 'cancelled')
                <a href="javascript:void(0);"
                    class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details"
                    data-id="{{ $booking->id }}"
                    data-bs-toggle="modal"
                    data-bs-target="#view_details">
                    <i class="isax isax-eye"></i>
                </a>
            @endif
        </div>
    </td>
</tr>
@empty
<tr>
    <td colspan="7" class="text-center">{{ __('no_bookings_found_for_this_status') }}</td>
</tr>
@endforelse

@if ($bookings->hasPages())
    <tr>
        <td colspan="7">
            <div class="mt-2">
                {{ $bookings->links('pagination::bootstrap-5') }}
            </div>
        </td>
    </tr>
@endif