@forelse ($bookingProducts as $productOrder)
@php

    $image = ($productOrder->user_profile_image && file_exists(public_path('storage/profile/' . $productOrder->user_profile_image)))
        ? asset('storage/profile/' . $productOrder->user_profile_image)
        : asset('assets/img/profile-default.png');

    $productImage = $productOrder->product->image->source_Values
        ? asset('storage/' . $productOrder->product->image->source_Values)
        : asset('img/default-image.png');
@endphp
<tr data-id="{{ $productOrder->id }}">

    <td>
        <a href="javascript:void(0);">{{ $productOrder->booking->order_id ?? 'N/A' }}</a>
    </td>
    <td>
        {{ $productOrder->booking ? \Carbon\Carbon::parse($productOrder->booking->created_at)->format('d M Y') : 'N/A' }}
    </td>
    <td>
        <div class="d-flex align-items-center">
            {{-- ADD THE IMAGE ELEMENT HERE --}}
            <a href="#" class="avatar avatar-sm me-2">
                <img
                    src="{{ $productImage }}"
                    alt="product"
                    class="img-fluid">
            </a>
            <div>
                <h6 class="fs-14 fw-medium mb-0"><a href="#">{{ $productOrder->product_name }}</a></h6>
            </div>
        </div>
    </td>
    <td>{{ $currency }}{{ number_format($productOrder->gross_total, 2) }}</td>
    <td>{{ $productOrder->payment_type_label ?? '-' }}</td>
    <td>
        @if ($productOrder->user)
        <div class="d-flex align-items-center">
            <a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
                <img src="{{ $image }}" alt="customer" class="img-fluid">
            </a>
            <div>
                <h6 class="fs-14 fw-medium mb-0"><a href="javascript:void(0);">{{ ucfirst($productOrder->user->name ?? $productOrder->booking->first_name) }}</a></h6>
            </div>
        </div>
        @else
        <span>Guest User</span>
        @endif
    </td>
    <td>{{ $productOrder->quantity }}</td>

    @if ($currentStatusKey == 'cancelled')
    <td>By You</td>
    @endif

    <td>
        @if ($currentStatusKey == 'new')
        <div class="d-flex align-items-center justify-content-end gap-2">
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details" data-bs-toggle="modal" data-id="{{ $productOrder->id }}" data-bs-target="#view_details"><i class="isax isax-eye"></i></a>
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-accept" data-id="{{ $productOrder->id }}" data-bs-toggle="modal" data-bs-target="#service_accept">
                <i class="isax isax-tick-circle"></i>
            </a>
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-reject" data-id="{{ $productOrder->id }}" data-bs-toggle="modal" data-bs-target="#service_reject">
                <i class="isax isax-close-circle"></i>
            </a>
        </div>
        @endif
        @if ($currentStatusKey == 'confirmed')
        <div class="d-flex align-items-center justify-content-end gap-2">
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details" data-bs-toggle="modal" data-id="{{ $productOrder->id }}" data-bs-target="#view_details"><i class="isax isax-eye"></i></a>
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-ship" data-id="{{ $productOrder->id }}" data-bs-toggle="modal" data-bs-target="#service_shipped">
                <i class="isax isax-truck-tick"></i>
            </a>
        </div>
        @endif
        @if ($currentStatusKey == 'shipped')
        <div class="d-flex align-items-center justify-content-end gap-2">
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details" data-bs-toggle="modal" data-id="{{ $productOrder->id }}" data-bs-target="#view_details"><i class="isax isax-eye"></i></a>
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 action-delivered" data-id="{{ $productOrder->id }}" data-cod_payment_status="{{ $productOrder->cod_payment_status }}" data-payment_type="{{ $productOrder->booking->payment_type }}" data-bs-toggle="modal" data-bs-target="#service_delivered">
                <i class="isax isax-box-tick"></i>
            </a>
        </div>
        @endif
        @if ($currentStatusKey == 'delivered')
        <div class="d-flex align-items-center justify-content-end gap-2">
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details" data-bs-toggle="modal" data-id="{{ $productOrder->id }}" data-bs-target="#view_details"><i class="isax isax-eye"></i></a>
        </div>
        @endif
        @if ($currentStatusKey == 'cancelled')
        <div class="d-flex align-items-center justify-content-end gap-2">
            <a href="#" class="btn btn-icon btn-md btn-white rounded-circle fs-16 view-details" data-bs-toggle="modal" data-id="{{ $productOrder->id }}" data-bs-target="#view_details"><i class="isax isax-eye"></i></a>
        </div>
        @endif
    </td>

</tr>
@empty
<tr>
    <td colspan="7" class="text-center">{{ __('no_order_found') }}</td>
</tr>
@endforelse


@if ($bookingProducts->hasPages())
    <tr>
        <td colspan="8">
            <div class="mt-2">
                {{ $bookingProducts->links('pagination::bootstrap-5') }}
            </div>
        </td>
    </tr>
@endif