<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>

	<!-- Meta Tags -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>{{ __('invoice') . ' || ' . $companyName }}</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="Craftesty is a Bootstrap-based template for hair salons, beauty spas, and wellness centers. Includes an admin dashboard for managing appointments, staff, services, and clients.">
	<meta name="keywords" content="salon template, hair salon, beauty spa, wellness center, appointment booking, salon admin dashboard, Bootstrap template, Dream Salon">
	<meta name="author" content="Dreams Technologies">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ public_path('frontend/assets/img/favicon.png') }}">

   	<!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ public_path('frontend/assets/img/apple-icon.png') }}">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ public_path('frontend/assets/css/bootstrap.min.css') }}">

    <!-- Daterangepikcer CSS -->
	<link rel="stylesheet" href="{{ public_path('frontend/assets/plugins/daterangepicker/daterangepicker.css') }}">

	<!-- Aos CSS -->
	<link rel="stylesheet" href="{{ public_path('frontend/assets/css/aos.css') }}">

    <!-- Main CSS -->
    <link rel="stylesheet" href="{{ public_path('frontend/assets/css/style.css') }}">

</head>

<body>

	<!-- Begin Wrapper -->
	<div class="main-wrapper">

		<div class="page-wrapper">

            <!-- Start Content -->
            <div class="content">
                <div class="container">

					<!-- start row -->
					<div class="row">

						<div class="col-lg-9 mx-auto">
							<div class="card mb-4" id="invoiceContent">
								<div class="card-body">
									<!-- Items -->
									<div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 border-bottom pb-3 mb-3">
										<div>
											<img src="{{ $logoPath }}" width="170" alt="logo" class="invoice-logo mb-2">
											<p class="fs-14 mb-0">{{ $company_address_line ?? '-'}}</p>
										</div>
										<h3 class="mb-0">{{ __('order_invoice') }}</h3>
									</div>
									<div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 border-bottom pb-3 mb-3">
										<div>
											<p class="fw-semibold text-secondary mb-0">#{{ $order->order_id }}</p>
											<p class="fs-14 mb-0">{{ __('create_date') }} : <span class="text-dark">{{ \Carbon\Carbon::parse($order->created_at)->format('d M Y') }}</span></p>
											<p class="fs-14 mb-0">{{ __('due_date') }} : <span class="text-dark">{{ \Carbon\Carbon::parse($order->created_at)->addDays(7)->format('d M Y') }}</span></p>
										</div>
										<div class="text-end">
											<p class="fw-semibold text-dark">{{ __('payment_status') }}</p>
											@if($order->type == 'product' && $order->payment_type == 5)
												@php
													$codPaymentStatus = $order->bookingProducts[0]->cod_payment_status;
												@endphp
												<span class="badge {{ $codPaymentStatus == 1 ? 'bg-info' : ($codPaymentStatus == 2? 'bg-success' : 'bg-warning') }} fs-12">
													<i class="isax isax-tick-circle me-1"></i>{{ $codPaymentStatus == 1 ?  __('unpaid')  : ( $codPaymentStatus == 2 ?  __('paid')  :  __('refund') ) }}
												</span>
											@else
												<span class="badge {{ $order->payment_status == 1 ? 'bg-info' : ($order->payment_status == 2? 'bg-success' : 'bg-warning') }} fs-12">
													<i class="isax isax-tick-circle me-1"></i>{{ $order->payment_status == 1 ?  __('unpaid')  : ( $order->payment_status == 2 ?  __('paid')  :  __('refund') ) }}
												</span>
											@endif
										</div>
									</div>
									<div class="pb-3 border-1 border-bottom mb-4">
										<!-- start row -->
										<div class="row gy-3">
											<div class="col-lg-4">
												<h5 class="mb-2 fs-16 fw-bold">{{ __('billing_address') }}</h5>
												<p class="text-body fs-14 mb-1">{{ $order->first_name }} {{ $order->last_name }}</p>
												<p class="text-body fs-14 mb-1">{{ $order->user_address }}</span> </p>
												<p class="text-body fs-14 mb-0">{{ __('Phone') }} : {{ $order->user_phone }} </p>
											</div> <!-- end col -->
											<div class="col-lg-4">
												<h5 class="mb-2 fs-16 fw-bold">{{ __('shipping_address') }}</h5>
												<p class="fs-14 mb-1">{{ $order->shipping_user_first_name ?? $order->first_name }} {{ $order->shipping_user_last_name ?? $order->last_name }}</p>
												<p class="fs-14 mb-1 pe-5">
													<span class="fs-14">{{ $order->shipping_user_address ?? $order->user_address }}</span>
												</p>
												<p class="fs-14 mb-0">{{ __('Phone') }}: {{ $order->shipping_user_phone ?? $order->user_phone }}</p>
											</div>  <!-- end col -->
											<div class="col-lg-4">
												<h5 class="mb-2 fs-16 fw-bold">{{ __('vendor_details') }}</h5>
												<p  class="fs-14 mb-1">{{ $order->bookingProducts[0]->product->shop->shop_name ?? '-'}} </p>
												<p class="fs-14 mb-1">{{ $order->bookingProducts[0]->vendorInfo[0]->userDetail->user_city->name ?? ''}} {{ $order->bookingProducts[0]->vendorInfo[0]->userDetail->user_state->name ?? ''}} , {{ $order->bookingProducts[0]->vendorInfo[0]->userDetail->user_country->name ?? ''}}</p>
												<p class="fs-14 mb-0">{{ __('Phone') }}: {{ $order->bookingProducts[0]->vendorInfo[0]->phone_number ?? '-'}} </p>
											</div> <!-- end col -->
										</div>
										<!-- end row -->
									</div>
									<!-- Items -->
									<div class="mb-4">
										<h6 class="mb-3 fs-16 fw-bold">{{ __('invoice_for') }} : {{ __('order_summary') }}</h6>
										<div>
											<!-- Table List -->
											<div class="table-responsive">
												<table class="table table-nowrap border">
													<thead class="thead-light">
														<tr>
															<th>#</th>
															<th>{{ __('item') }}</th>
															<th>{{ __('rate_item') }}</th>
															<th>{{ __('qty') }}</th>
															<th>{{ __('total') }}</th>
														</tr>
													</thead>
													<tbody>
														@if(!empty($items))
															@foreach($items ?? [] as $key => $item)
																<tr>
																	<td>{{ $key + 1 }}</td>
																	<td><p class="fw-semibold text-dark">{{ $item['product_name'] ?? 'N/A' }}</p></td>
																	<td>{{ $currencySymbol }}{{ number_format($item['price'], 2) }}</td>
																	<td>{{ $item['quantity'] ?? 1 }}</td>
																	<td>{{ $currencySymbol }}{{ number_format(($item['price'] * ($item['quantity'] ?? 1)), 2) }}</td>
																</tr>
															@endforeach
														@else
															@foreach($order->bookingProducts ?? [] as $key => $item)
																<tr>
																	<td>{{ $key + 1 }}</td>
																	<td><p class="fw-semibold text-dark">{{ $item->product_name ?? 'N/A' }}</p></td>
																	<td>{{ $currencySymbol }}{{ number_format($item->price, 2) }}</td>
																	<td>{{ $item->quantity ?? 1 }}</td>
																	<td>{{ $currencySymbol }}{{ number_format(($item->price * ($item->quantity ?? 1)), 2) }}</td>
																</tr>
															@endforeach
														@endif


													</tbody>
												</table>
											</div>
											<!-- /Table List -->
										</div>
									</div>
									<!-- etart row -->
									<div class="pb-3 mb-3 border-bottom">
										<div class="row gy-3">
											<div class="col-lg-6">
												<div>
													<h6 class="mb-2 fs-16 fw-bold">{{ __('terms_and_conditions') }}</h6>
													<p class="fs-14 mb-1">{{ __('terms_and_conditions_1') }}</p>
													<p class="fs-14 mb-3">{{ __('terms_and_conditions_2') }}</p>

													<h6 class="mb-2 fs-16 fw-bold">{{ __('notes') }}</h6>
													<p class="fs-14 mb-0">{{ __('notes_content') }}</p>
												</div>
											</div> <!-- end col -->
											<div class="col-lg-6">
												<div>
													<div class="d-flex align-items-center justify-content-between mx-auto mb-2">
														<p class="fs-14 mb-0 fw-medium">{{ __('subtotal') }}</p>
														<p class="fs-14 fw-medium">{{ $currencySymbol }}{{ number_format($order->service_amount, 2) }}</p>
													</div>
													<div class="d-flex align-items-center justify-content-between mx-auto mb-2">
														<p class="fs-14 mb-0">{{ __('Coupon') }}</p>
														<p class="fs-14 fw-medium">- {{ $currencySymbol }}{{ number_format($order->total_coupon_discount_amount ?? 0, 2) }}</p>
													</div>
													<div class="d-flex align-items-center justify-content-between mx-auto border-bottom pb-3 mb-3">
														<p class="fs-14 mb-0">{{ __('tax') }}</p>
														<p class="fs-14 fw-medium">{{ $currencySymbol }}{{ number_format($order->amount_tax ?? 0, 2) }}</p>
													</div>
													<div class="d-flex align-items-center justify-content-between mx-auto mb-2">
														<h6 class="fw-bold">{{ __('total') }} </h6>
														<h6 class="fw-bold">{{ $currencySymbol }}{{ number_format($order->total_amount, 2) }}</h6>
													</div>
												</div>
											</div> <!-- end col -->
										</div>
									</div>
									<!-- end row -->
									<!-- Items -->
									<div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
										<div>
											<p class="fw-semibold text-dark mb-0">{{ __('thanks_message_invoice') }}</p>
										</div>
										<div>
											<img src="{{ public_path('frontend/assets/img/icons/signature-img.svg') }}" alt="signature-img" class="img-fluid mode-img">
											<p class="mb-0">{{ ucfirst(__('for')) }} {{ $companyName }}</p>
										</div>
									</div>
								</div>
							</div>

						</div>

					</div>
                </div>
            </div>
            <!-- End Content -->

        </div>
        <!-- ========================
            End Page Content
        ========================= -->

	</div>
	<!-- End Wrapper -->

    <!-- jQuery -->
    <script src="{{ public_path('frontend/assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ public_path('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>

	<!-- Aos JS -->
	<script src="{{ public_path('frontend/assets/js/aos.js') }}"></script>

    <!-- Daterangepikcer JS -->
	<script src="{{ public_path('frontend/assets/js/moment.min.js') }}"></script>
	<script src="{{ public_path('frontend/assets/plugins/daterangepicker/daterangepicker.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ public_path('frontend/assets/js/script.js') }}"></script>

</body>
</html>