@extends('frontend.provider.app')

@section('title', 'Vendor Dashboard')

@section('content')

<!-- Start Breadscrumb -->
<div class="breadcrumb-bar">
	<div class="container">
		<div class="breadcrumb-item">
			<nav aria-label="breadcrumb" class="page-breadcrumb">
				<ol class="breadcrumb">
					<li class="breadcrumb-items"><a href="index.html">{{ __('home') }}</a></li>
					<li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
					<li class="breadcrumb-items active" aria-current="page">{{ __('Dashboard') }}</li>
				</ol>
			</nav>
			<h1 class="breadcrumb-title">{{ __('Dashboard') }}</h1>
		</div>
	</div>
	<img src="/frontend/assetsimg/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
	<img src="/frontend/assetsimg/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
	<img src="/frontend/assetsimg/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
	<img src="/frontend/assetsimg/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
	<img src="/frontend/assetsimg/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
</div>
<!-- End Breadscrumb -->

<!-- Start Content -->
<div class="content">
	<div class="container">

		<!-- start row -->
		<div class="row">
			@include('frontend.pages.vendor.sidemenu')

			<div class="col-xl-9 col-lg-8">

				<!-- Page Header -->
				<div class="d-flex align-items-center justify-content-between flex-wrap gap-3 border-bottom pb-4 mb-4">
					<h4 class="mb-0">{{ __('Dashboard') }}</h4>
					<div class="d-flex align-items-center flex-wrap gap-2">
						<div id="reportrange" class="reportrange-picker d-flex align-items-center">
							<i class="isax isax-calendar-edit fs-14 me-1"></i><span class="reportrange-picker-field">1 Aug 25 - 31 Aug 25</span><i class="isax isax-arrow-down-14 ms-2"></i>
						</div>
						<div class="dropdown">
							<a href="javascript:void(0);" class="btn btn-white btn-sm fs-14 fw-normal dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
								Mec Repair Service
							</a>
							<ul class="dropdown-menu dropdown-menu-end">
								<li><a class="dropdown-item fs-14" href="javascript:void(0);">Mec Repair Service</a></li>
								<li><a class="dropdown-item fs-14" href="javascript:void(0);">Pixel & Pen Creative</a></li>
								<li><a class="dropdown-item fs-14" href="javascript:void(0);">Innovate AI Solution</a></li>
							</ul>
						</div>
					</div>
				</div>
				<!-- End Page Header -->

				<!-- start row -->
				<div class="row justify-content-center">

					<div class="col-xl-4 col-lg-6 col-md-6 d-flex">
						<div class="dashboard-item w-100">
							<div class="avatar avatar-lg bg-soft-pink text-pink mb-2">
								<i class="isax isax-money-send5 fs-24"></i>
							</div>
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
								<div>
									<h6 class="mb-1 fs-16 fw-medium text-body">{{__('Completed Bookings')}}</h6>
									<h3 class="d-inline-flex align-items-center flex-wrap mb-0">152 <span class="badge badge-xs badge-soft-danger d-inline-flex align-items-center mx-1"><i class="isax isax-trend-down me-1"></i>2%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
								</div>
							</div>
						</div>
					</div> <!-- end col -->

					<div class="col-xl-4 col-lg-6 col-md-6 d-flex">
						<div class="dashboard-item w-100">
							<div class="avatar avatar-lg bg-soft-orange text-orange mb-2">
								<i class="isax isax-box fs-24"></i>
							</div>
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
								<div>
									<h6 class="mb-1 fs-16 fw-medium text-body">{{__('Total Sales')}}</h6>
									<h3 class="d-inline-flex align-items-center flex-wrap mb-0">250 <span class="badge badge-xs badge-soft-success d-inline-flex align-items-center mx-1"><i class="isax isax-trend-up me-1"></i>5%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
								</div>
							</div>
						</div>
					</div> <!-- end col -->

					<div class="col-xl-4 col-lg-6 col-md-6 d-flex">
						<div class="dashboard-item w-100">
							<div class="avatar avatar-lg bg-soft-cyan text-cyan mb-2">
								<i class="isax isax-dollar-circle fs-24"></i>
							</div>
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
								<div>
									<h6 class="mb-1 fs-16 fw-medium text-body">{{__('Total_Earnings')}}</h6>
									<h3 class="d-inline-flex align-items-center flex-wrap mb-0">$25K <span class="badge badge-xs badge-soft-success d-inline-flex align-items-center mx-1"><i class="isax isax-trend-up me-1"></i>5%</span> <span class="fs-13 fw-normal">{{__('from last month')}}</span></h3>
								</div>
							</div>
						</div>
					</div> <!-- end col -->

				</div>
				<!-- end row -->

				<!-- start row -->
				<div class="row">

					<!-- Products -->
					<div class="col-xl-5">
						<div class="card">
							<div class="card-body pb-1">
								<div class="sub-header">
									<h5 class="mb-0">{{__('Recently Selled Products')}}</h5>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="product-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/products/product-21.jpg" alt="shop" class="img-fluid">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="product-details.html">Hydraulic Car Jack</a></h6>
											<p class="fs-13 text-truncate mb-0">Equipments</p>
										</div>
									</div>
									<div>
										<h6 class="fs-16 fw-semibold mb-0">$35</h6>
										<p class="fs-13 mb-0">Price</p>
									</div>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="product-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/products/product-22.jpg" alt="shop" class="img-fluid">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="product-details.html">Brake Pads Set</a></h6>
											<p class="fs-13 text-truncate mb-0">Brake System</p>
										</div>
									</div>
									<div>
										<h6 class="fs-16 fw-semibold mb-0">$40</h6>
										<p class="fs-13 mb-0">Price</p>
									</div>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="product-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/products/product-23.jpg" alt="shop" class="img-fluid">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="product-details.html">Clutch Plate Kit</a></h6>
											<p class="fs-13 text-truncate mb-0">Components</p>
										</div>
									</div>
									<div>
										<h6 class="fs-16 fw-semibold mb-0">$30</h6>
										<p class="fs-13 mb-0">Price</p>
									</div>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="product-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/products/product-24.jpg" alt="shop" class="img-fluid">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="product-details.html">Air Filter Element</a></h6>
											<p class="fs-13 text-truncate mb-0">Engine</p>
										</div>
									</div>
									<div>
										<h6 class="fs-16 fw-semibold mb-0">$35</h6>
										<p class="fs-13 mb-0">Price</p>
									</div>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="product-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/products/product-25.jpg" alt="shop" class="img-fluid">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="product-details.html">Headlight Bulb</a></h6>
											<p class="fs-13 text-truncate mb-0">Electrical</p>
										</div>
									</div>
									<div>
										<h6 class="fs-16 fw-semibold mb-0">$20</h6>
										<p class="fs-13 mb-0">Price</p>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- Products End -->

					<!-- Recent Booking -->
					<div class="col-xl-7">
						<div class="card">
							<div class="card-body pb-0">
								<div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2 mb-0">
									<h5 class="mb-0">{{__('Total Bookings')}}</h5>
									<p class="fs-13 d-inline-flex align-items-center"><i class="fa-solid fa-square fs-12 text-primary me-1"></i>Bookings</p>
								</div>
								<div id="booking-chart"></div>
							</div>
						</div>
					</div>
					<!-- Recent Booking End -->

				</div>
				<!-- end row -->

				<!-- start row -->
				<div class="row">

					<!-- Recent Booking -->
					<div class="col-xl-6">
						<div class="card">
							<div class="card-body pb-1">
								<div class="sub-header d-flex align-items-center justify-content-between flex-wrap gap-2">
									<h5 class="mb-0">{{__('Highly Booked Categories')}}</h5>
								</div>
								<div class="progress-stacked progress-lg mb-4">
									<div class="progress-bar bg-danger" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-primary" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-secondary" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-orange" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-info" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-pink" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
									<div class="progress-bar bg-teal" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-teal me-2"></i>Maintenance</p>
									<span class="badge badge-sm badge-soft-teal">1100</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-pink me-2"></i>Electrical</p>
									<span class="badge badge-sm badge-soft-pink">800</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-info me-2"></i>Suspension</p>
									<span class="badge badge-sm badge-soft-info">800</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-orange me-2"></i>Body Care</p>
									<span class="badge badge-sm badge-soft-orange">550</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-secondary me-2"></i>Engine Care</p>
									<span class="badge badge-sm badge-soft-secondary">550</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-primary me-2"></i>Car Service</p>
									<span class="badge badge-sm badge-soft-primary">210</span>
								</div>
								<div class="d-flex align-items-center justify-content-between gap-2 mb-3">
									<p class="d-inline-flex align-items-center mb-0"><i class="fa-solid fa-circle fs-8 text-danger me-2"></i>Brake System</p>
									<span class="badge badge-sm badge-soft-danger">170</span>
								</div>
							</div>
						</div>
					</div>
					<!-- Recent Booking End -->

					<!-- Recent Services -->
					<div class="col-xl-6">
						<div class="card">
							<div class="card-body pb-1">
								<div class="sub-header">
									<h5 class="mb-0">{{__('Recently Booking Services')}}</h5>
								</div>
								<div class="d-flex align-items-sm-center justify-content-sm-between flex-sm-row flex-column gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="service-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/service/service-31.jpg" alt="product" class="avatar avatar-lg">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="service-details.html">Clutch Repair & Replacement</a></h6>
											<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
												<p class="fs-13 mb-0"><a href="javascript:void(0);" class="link-body">#INV0016</a></p>
												<p class="fs-13 mb-0">Samuel Rodriquez</p>
											</div>
										</div>
									</div>
									<div class="text-sm-end">
										<h6 class="fs-14 fw-semibold mb-1">20 Jul 2025</h6>
										<p class="fs-13 mb-0">Date</p>
									</div>
								</div>
								<div class="d-flex align-items-sm-center justify-content-sm-between flex-sm-row flex-column gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="service-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/service/service-32.jpg" alt="product" class="avatar avatar-lg">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="service-details.html">Battery Replacement Service</a></h6>
											<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
												<p class="fs-13 mb-0"><a href="javascript:void(0);" class="link-body">#INV0015</a></p>
												<p class="fs-13 mb-0">Margaret Brown</p>
											</div>
										</div>
									</div>
									<div class="text-sm-end">
										<h6 class="fs-14 fw-semibold mb-1">16 Jul 2025</h6>
										<p class="fs-13 mb-0">Date</p>
									</div>
								</div>
								<div class="d-flex align-items-sm-center justify-content-sm-between flex-sm-row flex-column gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="service-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/service/service-33.jpg" alt="product" class="avatar avatar-lg">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="service-details.html">Car Noise Inspection Service</a></h6>
											<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
												<p class="fs-13 mb-0"><a href="javascript:void(0);" class="link-body">#INV0014</a></p>
												<p class="fs-13 mb-0">Richard Perez</p>
											</div>
										</div>
									</div>
									<div class="text-sm-end">
										<h6 class="fs-14 fw-semibold mb-0">04 Jul 2025</h6>
										<p class="fs-13 mb-0">Date</p>
									</div>
								</div>
								<div class="d-flex align-items-sm-center justify-content-sm-between flex-sm-row flex-column gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="service-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/service/service-34.jpg" alt="product" class="avatar avatar-lg">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="service-details.html">Suspension Check & Repair</a></h6>
											<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
												<p class="fs-13 mb-0"><a href="javascript:void(0);" class="link-body">#INV0013</a></p>
												<p class="fs-13 mb-0">Reena Patel</p>
											</div>
										</div>
									</div>
									<div class="text-sm-end">
										<h6 class="fs-14 fw-semibold mb-1">26 Jun 2025</h6>
										<p class="fs-13 mb-0">Date</p>
									</div>
								</div>
								<div class="d-flex align-items-sm-center justify-content-sm-between flex-sm-row flex-column gap-2 mb-3">
									<div class="d-flex align-items-center overflow-hidden">
										<a href="service-details.html" class="avatar avatar-lg flex-shrink-0 me-2">
											<img src="/frontend/assetsimg/service/service-35.jpg" alt="product" class="avatar avatar-lg">
										</a>
										<div class="flex-grow-1 overflow-hidden">
											<h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="service-details.html">Car AC Repair Service</a></h6>
											<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
												<p class="fs-13 mb-0"><a href="javascript:void(0);" class="link-body">#INV0012</a></p>
												<p class="fs-13 mb-0">John Robinson</p>
											</div>
										</div>
									</div>
									<div class="text-sm-end">
										<h6 class="fs-14 fw-semibold mb-1">15 Jun 2025</h6>
										<p class="fs-13 mb-0">Date</p>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- Recent Services End -->

				</div>

				<!-- Start Table -->
				<div class="card mb-0">
					<div class="card-body">
						<div class="sub-header">
							<h5 class="mb-0">{{__('total_transactions')}}</h5>
						</div>
						<div class="table-responsive table-nowrap">
							<table class="table border mb-0">
								<thead>
									<tr>
										<th>{{__('invoice_id')}}</th>
										<th>{{__('Customer')}}</th>
										<th>{{__('Description')}}</th>
										<th>{{__('amount_paid')}}</th>
										<th>{{__('Payment Method')}}</th>
										<th>{{__('payment_date')}}</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td><a href="javascript:void(0);">#INV0016</a></td>
										<td>
											<div class="d-flex align-items-center">
												<a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
													<img src="/frontend/assetsimg/users/user-15.jpg" alt="user" class="img-fluid">
												</a>
												<div>
													<p class="fs-14 mb-0"><a href="javascript:void(0);">Samuel Rodriquez</a></p>
												</div>
											</div>
										</td>
										<td>Booked Battery Replacement Service</td>
										<td>$300</td>
										<td>Paypal</td>
										<td>30 Apr 2025</td>
									</tr>
									<tr>
										<td><a href="javascript:void(0);">#INV0015</a></td>
										<td>
											<div class="d-flex align-items-center">
												<a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
													<img src="/frontend/assetsimg/users/user-19.jpg" alt="user" class="img-fluid">
												</a>
												<div>
													<p class="fs-14 mb-0"><a href="javascript:void(0);">Margaret Brown</a></p>
												</div>
											</div>
										</td>
										<td>Purchase of School Stationery Kit</td>
										<td>$500</td>
										<td>Stripe</td>
										<td>16 Apr 2025</td>
									</tr>
									<tr>
										<td><a href="javascript:void(0);">#INV0014</a></td>
										<td>
											<div class="d-flex align-items-center">
												<a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
													<img src="/frontend/assetsimg/users/user-16.jpg" alt="user" class="img-fluid">
												</a>
												<div>
													<p class="fs-14 mb-0"><a href="javascript:void(0);">Richard Perez</a></p>
												</div>
											</div>
										</td>
										<td>Service for Chatbot Integration</td>
										<td>$900</td>
										<td>Bank Transfer</td>
										<td>25 Mar 2025</td>
									</tr>
									<tr>
										<td><a href="javascript:void(0);">#INV0013</a></td>
										<td>
											<div class="d-flex align-items-center">
												<a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
													<img src="/frontend/assetsimg/users/user-17.jpg" alt="user" class="img-fluid">
												</a>
												<div>
													<p class="fs-14 mb-0"><a href="javascript:void(0);">Susan rese</a></p>
												</div>
											</div>
										</td>
										<td>Purchase of new tires</td>
										<td>$700</td>
										<td>Paypal</td>
										<td>08 Mar 2025</td>
									</tr>
									<tr>
										<td><a href="javascript:void(0);">#INV0012</a></td>
										<td>
											<div class="d-flex align-items-center">
												<a href="javascript:void(0);" class="avatar avatar-sm avatar-rounded me-2">
													<img src="/frontend/assetsimg/users/user-18.jpg" alt="user" class="img-fluid">
												</a>
												<div>
													<p class="fs-14 mb-0"><a href="javascript:void(0);">John Robinson</a></p>
												</div>
											</div>
										</td>
										<td>Service for Buffet Food Arrangement</td>
										<td>$250</td>
										<td>Stripe</td>
										<td>24 Feb 2025</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<!-- End Table -->

			</div>

		</div>

	</div>
</div>
<!-- End Content -->

</div>
<!-- ========================
            End Page Content
        ========================= -->
@endsection
@push('scripts')
@endpush